/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.partition.Ownership;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VersionedOwnership
extends Ownership {
    @JsonbProperty(value="version")
    protected int m_nVersion;

    public VersionedOwnership() {
    }

    public VersionedOwnership(int cBackups, int nVersion) {
        super(cBackups);
        this.m_nVersion = nVersion;
    }

    public VersionedOwnership(VersionedOwnership that) {
        super(that);
        this.m_nVersion = that.m_nVersion;
    }

    public int getVersion() {
        return this.m_nVersion;
    }

    public void setVersion(int nVersion) {
        this.m_nVersion = nVersion;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + ", Version=" + this.m_nVersion;
    }

    @Override
    public Object clone() {
        VersionedOwnership that = (VersionedOwnership)super.clone();
        that.m_nVersion = this.m_nVersion;
        return that;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof VersionedOwnership) {
            VersionedOwnership that = (VersionedOwnership)o;
            return super.equals(that) && that.m_nVersion == this.m_nVersion;
        }
        return false;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_nVersion = in.readInt();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.m_nVersion);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_nVersion = in.readInt(5);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeInt(5, this.m_nVersion);
    }
}

