/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.net.management.annotation.Description;
import com.tangosol.net.management.annotation.MetricsScope;
import com.tangosol.net.management.annotation.MetricsTag;
import com.tangosol.net.management.annotation.MetricsValue;
import com.tangosol.net.management.annotation.Notification;
import com.tangosol.net.metrics.MBeanMetric;
import java.util.Date;

@MetricsScope(value=MBeanMetric.Scope.VENDOR)
@Description(value="Describes the SimpleAssignmentStrategy and the current state of partition distribution for the corresponding PartitionedService.")
@Notification(description="DistributionCoordinator notifications.", types={"partition.lost"})
public interface SimpleStrategyMBean {
    public static final String NOTIFY_LOST = "partition.lost";

    @Description(value="The name of the partition assignment strategy in use.")
    public String getStrategyName();

    @Description(value="The last time a distribution analysis was performed.")
    public Date getLastAnalysisTime();

    @Description(value="The member id of the service node that is the ownership distribution coordinator.")
    @MetricsTag(value="coordinatorId")
    public int getCoordinatorId();

    @Description(value="The configured number of partitions for the service.")
    public int getPartitionCount();

    @Description(value="The configured number of partition backups to be maintained by the service.")
    public int getBackupCount();

    @Description(value="The number of storage-enabled nodes running this service.")
    @MetricsValue
    public int getServiceNodeCount();

    @Description(value="The number of machines that host storage-enabled nodes running this service.")
    @MetricsValue
    public int getServiceMachineCount();

    @Description(value="The number of racks that host storage-enabled nodes running this service.")
    @MetricsValue
    public int getServiceRackCount();

    @Description(value="The number of sites that host storage-enabled nodes running this service.")
    @MetricsValue
    public int getServiceSiteCount();

    @Description(value="The High Availability status for this service. The values of MACHINE-SAFE, RACK-SAFE and SITE-SAFE mean that all the cluster nodes running on any given machine, rack, or site respectively could be stopped at once without any data loss. The value of NODE-SAFE means that any cluster node could be stopped without data loss. The value of ENDANGERED indicates that abnormal termination of any cluster node that runs this service could cause data loss.")
    public String getHAStatus();

    @Description(value="The High Availability status for this service. The value of 3 (MACHINE_SAFE), of 4 (RACK_SAFE) and 5 (SITE_SAFE) mean that all the cluster nodes running on any given machine, rack, or site respectively could be stopped at once without any data loss. The value of 2 (NODE_SAFE) means that any cluster node could be stopped without data loss. The value of 1 (ENDANGERED) indicates that abnormal termination of any cluster node that runs this service could cause data loss.")
    @MetricsValue
    public int getHAStatusCode();

    @Description(value="The High Availability status that this strategy attempts to achieve. Values are the same as for the HAStatus attribute.")
    public String getHATarget();

    @Description(value="The number of backup partitions per storage-enabled service member that this strategy will currently attempt to maintain.")
    public int getFairShareBackup();

    @Description(value="The number of primary partitions per storage-enabled service member that this strategy will currently attempt to maintain.")
    public int getFairSharePrimary();

    @Description(value="The number of partition transfers that remain to be completed before the service achieves the goals set by this strategy.")
    @MetricsValue
    public int getRemainingDistributionCount();

    @Description(value="The average partition storage size in kilobytes.")
    @MetricsValue
    public long getAveragePartitionSizeKB();

    @Description(value="The maximum partition storage size in kilobytes.")
    @MetricsValue
    public long getMaxPartitionSizeKB();

    @Description(value="The average node storage size in kilobytes.")
    @MetricsValue
    public long getAverageStorageSizeKB();

    @Description(value="The maximum node storage size in kilobytes.")
    @MetricsValue
    public long getMaxStorageSizeKB();

    @Description(value="The node ID with the maximum node storage size.")
    @MetricsValue
    public int getMaxLoadNodeId();

    @Description(value="Report partitions that remain to be transferred to achieve the goals set by this strategy. If fVerbose parameter is set to true, the report includes details for each scheduled transfer.")
    public String reportScheduledDistributions(@Description(value="fVerbose") boolean var1);

    public static enum HAStatus {
        ORPHANED,
        ENDANGERED,
        NODE_SAFE,
        MACHINE_SAFE,
        RACK_SAFE,
        SITE_SAFE;


        public int getCode() {
            return this.ordinal();
        }
    }
}

