/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class PartitionStatistics
implements ExternalizableLite {
    protected int m_nPartition;
    protected long m_ldtLastTransfer;
    protected long m_ldtSampleStart;
    protected long m_cSampleMillis;
    protected long m_cbStorageDirect;
    protected AtomicLong m_cbStorageIndirect = new AtomicLong();
    protected long m_cRequests;
    protected long m_cExecutionTime;
    protected long m_cWaitTime;

    public PartitionStatistics() {
    }

    public PartitionStatistics(int nPartition, long ldtArrived) {
        this.m_nPartition = nPartition;
        this.m_ldtLastTransfer = ldtArrived;
        this.reset();
    }

    public PartitionStatistics copyFrom(PartitionStatistics stats) {
        this.m_nPartition = stats.getPartition();
        this.m_ldtLastTransfer = stats.getLastTransferTime();
        this.m_cExecutionTime = stats.getTaskExecutionTime();
        this.m_cWaitTime = stats.getTaskWaitTime();
        this.m_cRequests = stats.getRequestCount();
        this.m_ldtSampleStart = stats.getSampleStartTime();
        this.m_cSampleMillis = stats.getSampleDuration();
        this.m_cbStorageDirect = stats.getDirectStorageSize();
        this.m_cbStorageIndirect.set(stats.getIndirectStorageSize());
        return this;
    }

    public void recordRequest(long cWaitMillis, long cExecMillis) {
        this.m_cExecutionTime += cExecMillis;
        this.m_cWaitTime += cWaitMillis;
        ++this.m_cRequests;
    }

    public void adjustIndirectStorageSize(long cbDelta) {
        this.m_cbStorageIndirect.addAndGet(cbDelta);
    }

    public PartitionStatistics setDirectStorageSize(long cb) {
        this.m_cbStorageDirect = cb;
        this.m_cSampleMillis = Base.getSafeTimeMillis() - this.m_ldtSampleStart;
        return this;
    }

    public void reset() {
        this.m_ldtSampleStart = Base.getLastSafeTimeMillis();
        this.m_cSampleMillis = 0L;
        this.m_cRequests = 0L;
        this.m_cExecutionTime = 0L;
        this.m_cWaitTime = 0L;
    }

    public int getPartition() {
        return this.m_nPartition;
    }

    public long getLastTransferTime() {
        return this.m_ldtLastTransfer;
    }

    public long getTaskExecutionTime() {
        return this.m_cExecutionTime;
    }

    public long getTaskWaitTime() {
        return this.m_cWaitTime;
    }

    public long getRequestCount() {
        return this.m_cRequests;
    }

    protected long getDirectStorageSize() {
        return this.m_cbStorageDirect;
    }

    protected long getIndirectStorageSize() {
        return this.m_cbStorageIndirect.get();
    }

    public long getStorageSize() {
        return this.m_cbStorageDirect + this.m_cbStorageIndirect.get();
    }

    public long getSampleStartTime() {
        return this.m_ldtSampleStart;
    }

    public long getSampleDuration() {
        return this.m_cSampleMillis;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nPartition = ExternalizableHelper.readInt(in);
        this.m_ldtLastTransfer = ExternalizableHelper.readLong(in);
        this.m_ldtSampleStart = ExternalizableHelper.readLong(in);
        this.m_cSampleMillis = ExternalizableHelper.readLong(in);
        this.m_cRequests = ExternalizableHelper.readLong(in);
        this.m_cExecutionTime = ExternalizableHelper.readLong(in);
        this.m_cWaitTime = ExternalizableHelper.readLong(in);
        this.m_cbStorageDirect = ExternalizableHelper.readLong(in);
        this.m_cbStorageIndirect.set(ExternalizableHelper.readLong(in));
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt(out, this.m_nPartition);
        ExternalizableHelper.writeLong(out, this.m_ldtLastTransfer);
        ExternalizableHelper.writeLong(out, this.m_ldtSampleStart);
        ExternalizableHelper.writeLong(out, this.m_cSampleMillis);
        ExternalizableHelper.writeLong(out, this.m_cRequests);
        ExternalizableHelper.writeLong(out, this.m_cExecutionTime);
        ExternalizableHelper.writeLong(out, this.m_cWaitTime);
        ExternalizableHelper.writeLong(out, this.m_cbStorageDirect);
        ExternalizableHelper.writeLong(out, this.m_cbStorageIndirect.get());
    }

    public String toString() {
        return "PartitionStatistics{" + this.getDescription() + "}";
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionId=").append(this.getPartition()).append(", ").append("LastTransferTime=\"").append(Base.formatDateTime(this.getLastTransferTime())).append("\", ").append("SampleStartTime=\"").append(Base.formatDateTime(this.getSampleStartTime())).append("\", ").append("SampleDuration=").append(this.getSampleDuration()).append(", ").append("StorageSize=").append(this.getStorageSize()).append(", ").append("RequestCount=").append(this.getRequestCount()).append(", ").append("TaskExecutionTime=").append(this.getTaskExecutionTime()).append(", ").append("TaskWaitTime=").append(this.getTaskWaitTime());
        return sb.toString();
    }
}

