/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.oracle.coherence.common.base.Assertions;
import com.oracle.coherence.common.base.Randoms;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class PartitionSet
implements ExternalizableLite,
PortableObject,
Iterable<Integer> {
    protected static final int MARKED_NONE = 0;
    protected static final int MARKED_FEW = 1;
    protected static final int MARKED_MANY = 2;
    protected static final int MARKED_ALL = 3;
    @JsonbProperty(value="partitionCount")
    private int m_cPartitions;
    @JsonbProperty(value="bits")
    private long[] m_alBits;
    @JsonbProperty(value="tailMask")
    private long m_lTailMask;
    @JsonbProperty(value="markedCount")
    private int m_cMarked;

    public PartitionSet() {
    }

    public PartitionSet(int cPartitions) {
        Assertions.azzert(cPartitions > 0);
        this.m_cPartitions = cPartitions;
        this.m_alBits = new long[cPartitions + 63 >>> 6];
        this.m_lTailMask = -1L >>> 64 - (cPartitions & 0x3F);
        this.m_cMarked = 0;
    }

    public PartitionSet(int cPartitions, int nPartition) {
        this(cPartitions);
        this.add(nPartition);
    }

    public PartitionSet(int cPartitions, Collection<? extends Integer> colPartitions) {
        this(cPartitions);
        colPartitions.forEach(this::add);
    }

    public PartitionSet(int cPartitions, int ... aiPartitions) {
        this(cPartitions);
        if (aiPartitions != null) {
            for (int nPart : aiPartitions) {
                this.add(nPart);
            }
        }
    }

    public PartitionSet(PartitionSet partitions) {
        this.m_cPartitions = partitions.m_cPartitions;
        this.m_alBits = (long[])partitions.m_alBits.clone();
        this.m_lTailMask = partitions.m_lTailMask;
        this.m_cMarked = partitions.m_cMarked;
    }

    public boolean add(int nPartition) {
        if (nPartition < 0 || nPartition >= this.m_cPartitions) {
            throw new IndexOutOfBoundsException(nPartition + " not in [0, " + this.m_cPartitions + ")");
        }
        long[] alBits = this.m_alBits;
        int iLong = nPartition >>> 6;
        long lBits = alBits[iLong];
        long lMask = 1L << (nPartition & 0x3F);
        if ((lBits & lMask) == 0L) {
            alBits[iLong] = lBits | lMask;
            int cMarked = this.m_cMarked;
            if (cMarked >= 0) {
                this.m_cMarked = cMarked + 1;
            }
            return true;
        }
        return false;
    }

    public boolean add(PartitionSet partitions) {
        int cPartitions = this.m_cPartitions;
        Assertions.azzert(cPartitions == partitions.m_cPartitions);
        long[] alBitsThis = this.m_alBits;
        long[] alBitsThat = partitions.m_alBits;
        boolean fResult = true;
        int c = alBitsThis.length;
        for (int i = 0; i < c; ++i) {
            long lBitsThis = alBitsThis[i];
            long lBitsThat = alBitsThat[i];
            fResult &= (lBitsThis & lBitsThat) == 0L;
            alBitsThis[i] = lBitsThis | lBitsThat;
        }
        this.m_cMarked = -1;
        return fResult;
    }

    public boolean remove(int nPartition) {
        if (nPartition < 0 || nPartition >= this.m_cPartitions) {
            throw new IndexOutOfBoundsException(nPartition + " not in [0, " + this.m_cPartitions + ")");
        }
        long[] alBits = this.m_alBits;
        int iLong = nPartition >>> 6;
        long lBits = alBits[iLong];
        long lMask = 1L << (nPartition & 0x3F);
        if ((lBits & lMask) != 0L) {
            alBits[iLong] = lBits & (lMask ^ 0xFFFFFFFFFFFFFFFFL);
            int cMarked = this.m_cMarked;
            if (cMarked >= 0) {
                this.m_cMarked = cMarked - 1;
            }
            return true;
        }
        return false;
    }

    public int removeNext(int nPartition) {
        int nNext = this.next(nPartition);
        if (nNext == -1 && nPartition > 0) {
            nNext = this.next(0);
        }
        if (nNext >= 0) {
            this.remove(nNext);
        }
        return nNext;
    }

    public boolean remove(PartitionSet partitions) {
        int cPartitions = this.m_cPartitions;
        Assertions.azzert(cPartitions == partitions.m_cPartitions);
        long[] alBitsThis = this.m_alBits;
        long[] alBitsThat = partitions.m_alBits;
        boolean fResult = true;
        int c = alBitsThis.length;
        for (int i = 0; i < c; ++i) {
            long lBitsThis = alBitsThis[i];
            long lBitsThat = alBitsThat[i];
            fResult &= (lBitsThis & lBitsThat) == lBitsThat;
            alBitsThis[i] = lBitsThis & (lBitsThat ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.m_cMarked = -1;
        return fResult;
    }

    public boolean retain(PartitionSet partitions) {
        int cPartitions = this.m_cPartitions;
        Assertions.azzert(cPartitions == partitions.m_cPartitions);
        long[] alBitsThis = this.m_alBits;
        long[] alBitsThat = partitions.m_alBits;
        boolean fResult = false;
        int c = alBitsThis.length;
        for (int i = 0; i < c; ++i) {
            long lBitsThis = alBitsThis[i];
            long lBitsThat = alBitsThat[i];
            long lIntrsctn = lBitsThis & lBitsThat;
            if (lIntrsctn == lBitsThis) continue;
            alBitsThis[i] = lIntrsctn;
            fResult = true;
        }
        if (fResult) {
            this.m_cMarked = -1;
        }
        return fResult;
    }

    public boolean contains(int nPartition) {
        if (nPartition < 0 || nPartition >= this.m_cPartitions) {
            throw new IndexOutOfBoundsException(nPartition + " not in [0, " + this.m_cPartitions + ")");
        }
        int iLong = nPartition >>> 6;
        long lBits = this.m_alBits[iLong];
        long lMask = 1L << (nPartition & 0x3F);
        return (lBits & lMask) != 0L;
    }

    public boolean contains(PartitionSet partitions) {
        int cPartitions = this.m_cPartitions;
        Assertions.azzert(cPartitions == partitions.m_cPartitions);
        long[] alBitsThis = this.m_alBits;
        long[] alBitsThat = partitions.m_alBits;
        int c = alBitsThis.length;
        for (int i = 0; i < c; ++i) {
            long lBitsThis = alBitsThis[i];
            long lBitsThat = alBitsThat[i];
            long lIntrsctn = lBitsThis & lBitsThat;
            if (lIntrsctn == lBitsThat) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(PartitionSet partitions) {
        int cPartitions = this.m_cPartitions;
        Assertions.azzert(cPartitions == partitions.m_cPartitions);
        long[] alBitsThis = this.m_alBits;
        long[] alBitsThat = partitions.m_alBits;
        int c = alBitsThis.length;
        for (int i = 0; i < c; ++i) {
            long lBitsThis = alBitsThis[i];
            long lBitsThat = alBitsThat[i];
            long lIntrsctn = lBitsThis & lBitsThat;
            if (lIntrsctn == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        int cMarked = this.m_cMarked;
        if (cMarked >= 0) {
            return cMarked == 0;
        }
        long[] alBits = this.m_alBits;
        int c = alBits.length;
        for (int i = 0; i < c; ++i) {
            if (alBits[i] == 0L) continue;
            return false;
        }
        this.m_cMarked = 0;
        return true;
    }

    public boolean isFull() {
        return this.cardinality() == this.getPartitionCount();
    }

    public PartitionSet clear() {
        long[] alBits = this.m_alBits;
        int c = alBits.length;
        for (int i = 0; i < c; ++i) {
            alBits[i] = 0L;
        }
        this.m_cMarked = 0;
        return this;
    }

    public PartitionSet fill() {
        long[] alBits = this.m_alBits;
        int iLast = alBits.length - 1;
        for (int i = 0; i < iLast; ++i) {
            alBits[i] = -1L;
        }
        alBits[iLast] = this.m_lTailMask;
        this.m_cMarked = this.m_cPartitions;
        return this;
    }

    public PartitionSet invert() {
        long[] alBits = this.m_alBits;
        int iLast = alBits.length - 1;
        for (int i = 0; i <= iLast; ++i) {
            alBits[i] = alBits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n = iLast;
        alBits[n] = alBits[n] & this.m_lTailMask;
        int cMarked = this.m_cMarked;
        if (cMarked >= 0) {
            this.m_cMarked = this.m_cPartitions - cMarked;
        }
        return this;
    }

    public int first() {
        return this.next(0);
    }

    public int next(int nPartition) {
        int cPartitions = this.m_cPartitions;
        if (nPartition < 0 || nPartition > cPartitions) {
            throw new IndexOutOfBoundsException(nPartition + " not in [0, " + cPartitions + ")");
        }
        if (nPartition == cPartitions || this.m_cMarked == 0) {
            return -1;
        }
        long[] alBits = this.m_alBits;
        int iLong = nPartition >>> 6;
        int ofBit = nPartition & 0x3F;
        long lBits = alBits[iLong] >>> ofBit;
        if (lBits == 0L) {
            ofBit = 0;
            int iLast = alBits.length - 1;
            while (lBits == 0L && iLong < iLast) {
                lBits = alBits[++iLong];
            }
            if (lBits == 0L) {
                return -1;
            }
        }
        return (iLong << 6) + ofBit + Long.numberOfTrailingZeros(lBits);
    }

    public int cardinality() {
        int cMarked = this.m_cMarked;
        if (cMarked < 0) {
            cMarked = 0;
            long[] alBits = this.m_alBits;
            int c = alBits.length;
            for (int i = 0; i < c; ++i) {
                cMarked += Long.bitCount(alBits[i]);
            }
            this.m_cMarked = cMarked;
        }
        return cMarked;
    }

    public int[] toArray() {
        int cPids = this.cardinality();
        int[] anPid = new int[cPids];
        int i = this.next(0);
        int c = 0;
        while (i >= 0) {
            anPid[c++] = i;
            i = this.next(i + 1);
        }
        return anPid;
    }

    public int rnd() {
        int cPids = this.cardinality();
        if (cPids == 0) {
            return -1;
        }
        int nPid = this.next(0);
        int cSkip = Randoms.getRandom().nextInt(cPids);
        while (cSkip-- > 0) {
            nPid = this.next(nPid + 1);
        }
        return nPid;
    }

    public PartitionSet split() {
        int cPids = this.cardinality() / 2;
        if (cPids == 0) {
            return null;
        }
        PartitionSet parts = new PartitionSet(this.m_cPartitions);
        int i = this.next(0);
        for (int c = 0; c < cPids; ++c) {
            parts.add(i);
            this.remove(i);
            i = this.next(i + 1);
        }
        return parts;
    }

    public static PartitionSet union(PartitionSet partsA, PartitionSet partsB) {
        if (partsA == null) {
            return partsB;
        }
        if (partsB == null) {
            return partsA;
        }
        partsA.add(partsB);
        return partsA;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator(){
            private volatile int m_current = -1;

            @Override
            public boolean hasNext() {
                return PartitionSet.this.next(this.m_current + 1) != -1;
            }

            public Integer next() {
                this.m_current = this.m_current == -1 ? PartitionSet.this.first() : PartitionSet.this.next(this.m_current + 1);
                return this.m_current;
            }
        };
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int cPartitions = in.readUnsignedShort();
        int cLongs = cPartitions + 63 >>> 6;
        long[] alBits = new long[cLongs];
        this.m_cPartitions = cPartitions;
        this.m_alBits = alBits;
        this.m_lTailMask = -1L >>> 64 - (cPartitions & 0x3F);
        this.m_cMarked = 0;
        int nFormat = in.readUnsignedByte();
        switch (nFormat) {
            case 0: {
                break;
            }
            case 1: {
                int cSkip;
                int iLast = 0;
                while ((cSkip = ExternalizableHelper.readInt(in)) >= 0) {
                    this.add(iLast += cSkip);
                }
                break;
            }
            case 2: {
                int cMarked = 0;
                for (int i = 0; i < cLongs; ++i) {
                    long lBits;
                    alBits[i] = lBits = in.readLong();
                    cMarked += Long.bitCount(lBits);
                }
                this.m_cMarked = cMarked;
                break;
            }
            case 3: {
                this.fill();
                break;
            }
            default: {
                throw new IOException("stream corrupted; format=" + nFormat);
            }
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        int cPartitions = this.m_cPartitions;
        out.writeShort(cPartitions);
        int cMarked = this.cardinality();
        if (cMarked == 0) {
            out.writeByte(0);
        } else if (cMarked == cPartitions) {
            out.writeByte(3);
        } else if (cMarked < cPartitions >>> 5) {
            out.writeByte(1);
            int iLast = 0;
            int iCurr = this.next(0);
            while (iCurr >= 0) {
                ExternalizableHelper.writeInt(out, iCurr - iLast);
                iLast = iCurr;
                iCurr = this.next(iCurr + 1);
            }
            ExternalizableHelper.writeInt(out, -1);
        } else {
            out.writeByte(2);
            long[] alBits = this.m_alBits;
            int c = alBits.length;
            for (int i = 0; i < c; ++i) {
                out.writeLong(alBits[i]);
            }
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        int cPartitions = in.readInt(0);
        int nFormat = in.readInt(1);
        int cLongs = cPartitions + 63 >>> 6;
        long[] alBits = nFormat == 2 ? in.readLongArray(3) : new long[cLongs];
        this.m_cPartitions = cPartitions;
        this.m_alBits = alBits;
        this.m_lTailMask = -1L >>> 64 - (cPartitions & 0x3F);
        this.m_cMarked = -1;
        switch (nFormat) {
            case 0: {
                this.m_cMarked = 0;
                break;
            }
            case 1: {
                int[] acSkip = in.readIntArray(2);
                int cSkips = acSkip.length;
                int iLast = 0;
                for (int i = 0; i < cSkips; ++i) {
                    this.add(iLast += acSkip[i]);
                }
                this.m_cMarked = cSkips;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.fill();
                break;
            }
            default: {
                throw new IOException("stream corrupted; format=" + nFormat);
            }
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        int cPartitions = this.m_cPartitions;
        out.writeInt(0, cPartitions);
        int cMarked = this.cardinality();
        if (cMarked == 0) {
            out.writeInt(1, 0);
        } else if (cMarked == cPartitions) {
            out.writeInt(1, 3);
        } else if (cMarked < cPartitions >>> 5) {
            out.writeInt(1, 1);
            int[] an = this.toArray();
            for (int i = an.length - 1; i > 0; --i) {
                int n = i;
                an[n] = an[n] - an[i - 1];
            }
            out.writeIntArray(2, an);
        } else {
            out.writeInt(1, 2);
            out.writeLongArray(3, this.m_alBits);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PartitionSet) {
            if (o == this) {
                return true;
            }
            PartitionSet that = (PartitionSet)o;
            if (this.m_cPartitions == that.m_cPartitions) {
                int cMarkedThis = this.m_cMarked;
                int cMarkedThat = that.m_cMarked;
                if (cMarkedThis != cMarkedThat && cMarkedThis >= 0 && cMarkedThat >= 0) {
                    return false;
                }
                long[] alBitsThis = this.m_alBits;
                long[] alBitsThat = that.m_alBits;
                int c = alBitsThis.length;
                for (int i = 0; i < c; ++i) {
                    if (alBitsThis[i] == alBitsThat[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 7 + Arrays.hashCode(this.m_alBits) + this.m_cPartitions + this.m_cMarked;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean fVerbose) {
        StringBuilder sb = new StringBuilder();
        boolean fAppend = false;
        int cRange = 0;
        int iPrev = -1;
        if (fVerbose) {
            sb.append("PartitionSet{");
        }
        int iPid = this.next(0);
        while (iPid >= 0) {
            if (iPid == iPrev + 1 && iPrev >= 0) {
                ++cRange;
            } else {
                if (cRange > 0) {
                    sb.append(cRange > 1 ? ".." : ", ").append(iPrev);
                    cRange = 0;
                }
                if (fAppend) {
                    sb.append(", ");
                } else {
                    fAppend = true;
                }
                sb.append(iPid);
            }
            iPrev = iPid;
            iPid = this.next(iPid + 1);
        }
        if (cRange > 0) {
            sb.append(cRange > 1 ? ".." : ", ").append(iPrev);
        }
        if (fVerbose) {
            sb.append('}');
        }
        return sb.toString();
    }

    public int getPartitionCount() {
        return this.m_cPartitions;
    }
}

