/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.net.Action;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.CacheService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Service;
import com.tangosol.util.Base;

public class FailoverAccessPolicy
implements ActionPolicy {
    public static final int STATE_SAFE = 0;
    public static final int STATE_UNKNOWN = 1;
    public static final int STATE_ENDANGERED = 2;
    public long m_cThresholdMillis;
    public long m_cLimitMillis;
    public long m_cMaxDelayMillis;
    public int m_nState = 0;
    public long m_ldtEndangered = 0L;
    protected PartitionedService m_service;

    public FailoverAccessPolicy() {
        this(5000L, 60000L, 5000L);
    }

    public FailoverAccessPolicy(long cThresholdMillis, long cLimitMillis, long cMaxDelayMillis) {
        if (cThresholdMillis > cLimitMillis) {
            throw new IllegalArgumentException("The endangered threshold value must be less than or equal to the endangered limit");
        }
        if (cMaxDelayMillis <= 0L) {
            throw new IllegalArgumentException("The max-delay value must be positive");
        }
        this.m_cThresholdMillis = cThresholdMillis;
        this.m_cLimitMillis = cLimitMillis;
        this.m_cMaxDelayMillis = cMaxDelayMillis;
    }

    public int getState() {
        return this.m_nState;
    }

    protected synchronized void setState(int nState) {
        this.m_nState = nState;
    }

    @Override
    public void init(Service service) {
        Base.azzert(service instanceof PartitionedService, "This ActionPolicy may only be used with PartitionedService");
        service.addMemberListener(new MembershipListener());
        this.m_service = (PartitionedService)service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAllowed(Service service, Action action) {
        if (action != CacheService.CacheAction.READ && action != CacheService.CacheAction.WRITE || this.getState() == 0) {
            return true;
        }
        FailoverAccessPolicy failoverAccessPolicy = this;
        synchronized (failoverAccessPolicy) {
            if (this.checkEndangered()) {
                try {
                    long cWaitMillis;
                    long ldtNow = Base.getSafeTimeMillis();
                    long cMillisEndangered = ldtNow - this.m_ldtEndangered;
                    if (cMillisEndangered > this.m_cThresholdMillis && (cWaitMillis = this.calculateWaitTime(cMillisEndangered)) > 0L) {
                        Blocking.wait(this, cWaitMillis);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.getState() == 2) {
                    this.setState(1);
                    this.notifyAll();
                }
            }
        }
        return true;
    }

    protected long calculateWaitTime(long cMillisEndangered) {
        int cScale = 1000;
        long cWait = (long)((double)this.m_cMaxDelayMillis * Math.min(Math.log((float)cMillisEndangered / (float)cScale) / Math.log(this.m_cLimitMillis / (long)cScale), 1.0));
        return cWait;
    }

    protected boolean checkEndangered() {
        int nState = this.getState();
        switch (nState) {
            case 0: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        PartitionedService service = this.m_service;
        int cPartitions = service.getPartitionCount();
        int cBackups = service.getBackupCount();
        for (int iPart = 0; iPart < cPartitions; ++iPart) {
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                if (service.getBackupOwner(iPart, iStore) != null) continue;
                if (this.m_ldtEndangered == 0L) {
                    this.m_ldtEndangered = Base.getSafeTimeMillis();
                }
                this.setState(2);
                return true;
            }
        }
        this.m_ldtEndangered = 0L;
        this.setState(0);
        return false;
    }

    protected class MembershipListener
    implements MemberListener {
        protected MembershipListener() {
        }

        @Override
        public void memberJoined(MemberEvent evt) {
        }

        @Override
        public void memberLeaving(MemberEvent evt) {
        }

        @Override
        public void memberLeft(MemberEvent evt) {
            FailoverAccessPolicy.this.setState(1);
        }
    }
}

