/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.partition.VersionedPartitions;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.PrimitiveSparseArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DefaultVersionedPartitions
implements VersionedPartitions,
ExternalizableLite,
PortableObject {
    protected PrimitiveSparseArray m_laVersions;

    public DefaultVersionedPartitions() {
        this((PrimitiveSparseArray)null);
    }

    public DefaultVersionedPartitions(VersionedPartitions versions) {
        this((PrimitiveSparseArray)null);
        VersionedPartitions.VersionedIterator iter = versions.iterator();
        while (iter.hasNext()) {
            long lVersion = iter.nextVersion();
            this.setPartitionVersion(iter.getPartition(), lVersion);
        }
    }

    protected DefaultVersionedPartitions(PrimitiveSparseArray laVersions) {
        this.m_laVersions = laVersions == null ? new PrimitiveSparseArray() : null;
    }

    @Override
    public VersionedPartitions.Iterator<Integer> getPartitions() {
        return new VersionedPartitions.Iterator<Integer>(){
            final PrimitiveSparseArray.Iterator m_iter;
            {
                this.m_iter = DefaultVersionedPartitions.this.m_laVersions.iterator();
            }

            @Override
            public int getPartition() {
                return (int)this.m_iter.getIndex();
            }

            @Override
            public int nextPartition() {
                this.m_iter.nextPrimitive();
                return (int)this.m_iter.getIndex();
            }

            @Override
            public boolean hasNext() {
                return this.m_iter.hasNext();
            }

            @Override
            public Integer next() {
                return ((Long)this.m_iter.next()).intValue();
            }
        };
    }

    @Override
    public long getVersion(int iPartition) {
        PrimitiveSparseArray laVersions = this.m_laVersions;
        if (!laVersions.exists(iPartition)) {
            return 0L;
        }
        return laVersions.getPrimitive(iPartition);
    }

    @Override
    public VersionedPartitions.VersionedIterator iterator() {
        return new VersionedPartitions.VersionedIterator(){
            final PrimitiveSparseArray.Iterator f_iter;
            {
                this.f_iter = DefaultVersionedPartitions.this.m_laVersions.iterator();
            }

            @Override
            public int getPartition() {
                return (int)this.f_iter.getIndex();
            }

            @Override
            public int nextPartition() {
                this.f_iter.nextPrimitive();
                return (int)this.f_iter.getIndex();
            }

            @Override
            public long getVersion() {
                return this.f_iter.getPrimitiveValue();
            }

            @Override
            public long nextVersion() {
                return this.f_iter.nextPrimitive();
            }

            @Override
            public boolean hasNext() {
                return this.f_iter.hasNext();
            }

            @Override
            public Long next() {
                return (Long)this.f_iter.next();
            }
        };
    }

    public DefaultVersionedPartitions setPartitionVersion(int iPart, long lVersion) {
        this.m_laVersions.setPrimitive(iPart, lVersion);
        return this;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass() && Base.equals(this.m_laVersions, ((DefaultVersionedPartitions)o).m_laVersions);
    }

    public int hashCode() {
        int nHash = this.m_laVersions.hashCode();
        return nHash << 4 | nHash >> 28 & 0xF;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName()).append("[");
        String sPrefix = "";
        VersionedPartitions.VersionedIterator iter = this.iterator();
        while (iter.hasNext()) {
            long lVersion = iter.nextVersion();
            sb.append(sPrefix).append(iter.getPartition()).append("->").append(lVersion);
            sPrefix = ",";
        }
        return sb.append("]").toString();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        PrimitiveSparseArray laVersions = this.m_laVersions = new PrimitiveSparseArray();
        for (int i = ExternalizableHelper.readInt(in); i > 0; --i) {
            laVersions.setPrimitive(ExternalizableHelper.readInt(in), ExternalizableHelper.readLong(in));
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        PrimitiveSparseArray laVersions = this.m_laVersions;
        int cSize = laVersions.getSize();
        ExternalizableHelper.writeInt(out, cSize);
        PrimitiveSparseArray.Iterator iter = laVersions.iterator();
        while (iter.hasNext()) {
            long lVersion = iter.nextPrimitive();
            ExternalizableHelper.writeInt(out, (int)iter.getIndex());
            ExternalizableHelper.writeLong(out, lVersion);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_laVersions = (PrimitiveSparseArray)in.readLongArray(0, new PrimitiveSparseArray());
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLongArray(0, this.m_laVersions);
    }
}

