/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.messaging;

import com.tangosol.net.messaging.AbstractMessage;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.messaging.Response;

public abstract class AbstractRequest
extends AbstractMessage
implements Request {
    private long m_lId;
    protected transient Request.Status m_status;
    protected transient Response m_response;

    @Override
    public void run() {
        Response response = this.ensureResponse();
        try {
            this.process(response);
        }
        catch (RuntimeException t) {
            response.setFailure(true);
            response.setResult(t);
        }
    }

    @Override
    public long getId() {
        return this.m_lId;
    }

    @Override
    public void setId(long lId) {
        this.m_lId = lId;
    }

    @Override
    public Request.Status getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(Request.Status status) {
        if (status == null) {
            throw new IllegalArgumentException("null status");
        }
        if (this.m_status != null) {
            throw new IllegalStateException();
        }
        this.m_status = status;
    }

    @Override
    public Response ensureResponse() {
        Response response = this.m_response;
        if (response == null) {
            Channel channel = this.getChannel();
            if (channel == null) {
                throw new IllegalStateException("null channel");
            }
            Protocol.MessageFactory factory = channel.getMessageFactory();
            if (factory == null) {
                throw new IllegalStateException("null factory");
            }
            response = this.m_response = this.instantiateResponse(factory);
        }
        return response;
    }

    protected abstract Response instantiateResponse(Protocol.MessageFactory var1);

    protected abstract void process(Response var1);
}

