/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.management;

import com.tangosol.internal.http.BaseHttpHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;

public interface MapJsonBodyHandler
extends BaseHttpHandler.BodyWriter<Map<String, Object>>,
Comparable<MapJsonBodyHandler> {
    public static final int DEFAULT_PRIORITY = 0;

    @Override
    public void write(Map<String, Object> var1, OutputStream var2);

    public Map<String, Object> readMap(InputStream var1);

    default public boolean isEnabled() {
        return true;
    }

    default public int getPriority() {
        return 0;
    }

    @Override
    default public int compareTo(MapJsonBodyHandler o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public static MapJsonBodyHandler ensureMapJsonBodyHandler() {
        ServiceLoader<MapJsonBodyHandler> loader = ServiceLoader.load(MapJsonBodyHandler.class);
        ArrayList<MapJsonBodyHandler> list = new ArrayList<MapJsonBodyHandler>();
        for (MapJsonBodyHandler handler : loader) {
            if (!handler.isEnabled()) continue;
            list.add(handler);
        }
        if (list.size() > 0) {
            list.sort(Comparator.naturalOrder());
            return (MapJsonBodyHandler)list.get(0);
        }
        throw new IllegalStateException("Cannot find an instance of " + String.valueOf(MapJsonBodyHandler.class) + " to load via the ServiceLoader. Add the coherence-json module to the classpath.");
    }
}

