/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.management;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.net.TcpSocketProvider;
import com.tangosol.internal.net.management.DefaultGatewayDependencies;
import com.tangosol.internal.net.management.GatewayDependencies;
import com.tangosol.internal.net.management.LegacyXmlGatewayHelper;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.internal.net.topic.impl.paged.management.PagedTopicModel;
import com.tangosol.internal.net.topic.impl.paged.management.SubscriberGroupModel;
import com.tangosol.internal.net.topic.impl.paged.management.SubscriberModel;
import com.tangosol.internal.net.topic.impl.paged.model.PagedTopicSubscription;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.statistics.PagedTopicStatistics;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PagedTopicService;
import com.tangosol.net.Service;
import com.tangosol.net.TopicService;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.net.management.AnnotatedStandardEmitterMBean;
import com.tangosol.net.management.MBeanReference;
import com.tangosol.net.management.MBeanServerFinder;
import com.tangosol.net.management.Registry;
import com.tangosol.net.management.ViewMBean;
import com.tangosol.net.management.ViewMBeanImpl;
import com.tangosol.net.management.annotation.Description;
import com.tangosol.net.management.annotation.Notification;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Paths;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMISocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.SimpleType;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public abstract class MBeanHelper
extends Base {
    private static GatewayDependencies s_deps;
    public static final Map<String, Class> SCALAR_TYPES;
    public static final Map<String, SimpleType> SCALAR_SIMPLETYPES;
    private static final String MANAGEABLE = "com.tangosol.coherence.component.manageable.";
    private static final Lock s_lockTopicSubscriberGroups;

    public static String getDefaultDomain() {
        return MBeanHelper.ensureGatewayDependencies().getDefaultDomain();
    }

    public static void checkReadOnly(String sOperation) {
        if (MBeanHelper.ensureGatewayDependencies().isReadOnly()) {
            throw new SecurityException("Operation is not allowed: " + sOperation);
        }
    }

    public static MBeanServer findMBeanServer() {
        return MBeanHelper.findMBeanServer(null);
    }

    public static MBeanServer findMBeanServer(String sDefaultDomain) {
        return MBeanHelper.findMBeanServer(sDefaultDomain, MBeanHelper.ensureGatewayDependencies());
    }

    public static MBeanServer findMBeanServer(String sDefaultDomain, GatewayDependencies deps) {
        try {
            Object server;
            MBeanServerFinder finder;
            if (sDefaultDomain == null || sDefaultDomain.isEmpty()) {
                sDefaultDomain = deps.getDefaultDomain();
            }
            if ((finder = deps.getMBeanServerFinder()) != null && (server = finder.findMBeanServer(sDefaultDomain)) != null) {
                return server;
            }
            for (MBeanServer server2 : MBeanServerFactory.findMBeanServer(null)) {
                if (sDefaultDomain != null && sDefaultDomain.length() != 0 && !server2.getDefaultDomain().equals(sDefaultDomain)) continue;
                return server2;
            }
            try {
                MBeanServer server2;
                Class<?> clzFactory = Class.forName("java.lang.management.ManagementFactory");
                server2 = (MBeanServer)ClassHelper.invokeStatic(clzFactory, "getPlatformMBeanServer", ClassHelper.VOID);
                if (sDefaultDomain == null || sDefaultDomain.length() == 0 || server2.getDefaultDomain().equals(sDefaultDomain)) {
                    return server2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return MBeanServerFactory.createMBeanServer(sDefaultDomain);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Failed to locate the server");
        }
    }

    public static JMXServiceURL findJMXServiceUrl(String sDefaultDomain, GatewayDependencies deps) {
        MBeanServerFinder finder;
        if (sDefaultDomain == null || sDefaultDomain.isEmpty()) {
            sDefaultDomain = deps.getDefaultDomain();
        }
        if ((finder = deps.getMBeanServerFinder()) != null) {
            return finder.findJMXServiceUrl(sDefaultDomain);
        }
        return null;
    }

    public static void registerQueryMBeans(String sMBeanServerDomain, String sQuery, String sPrefix, Registry registry) {
        if (((String)sPrefix).length() > 0) {
            sPrefix = (String)sPrefix + ",";
        }
        try {
            ObjectName onameQuery = new ObjectName(sQuery);
            MBeanServer mbs = MBeanHelper.findMBeanServer(sMBeanServerDomain);
            Set<ObjectName> setNames = mbs.queryNames(onameQuery, null);
            for (ObjectName oname : setNames) {
                String sSourceDomain = oname.getDomain();
                String sSourceName = oname.getKeyPropertyListString();
                String sTargetName = (String)sPrefix + "Domain=" + sSourceDomain + "," + sSourceName.replaceFirst("type=", "subType=");
                registry.register(registry.ensureGlobalName(sTargetName), new MBeanReference(oname, mbs));
            }
        }
        catch (MalformedObjectNameException e) {
            MBeanHelper.err("Ignoring failed registration request: " + String.valueOf(e) + "; " + MBeanHelper.getStackTrace(e));
        }
    }

    public static void registerCacheMBean(NamedCache cache, String sContext) {
        MBeanHelper.registerCacheMBean(cache.getCacheService(), cache.getCacheName(), sContext, cache);
    }

    public static void registerCacheMBean(CacheService service, String sCacheName, String sContext, Map map) {
        try {
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null) {
                Object sName = "type=Cache,service=" + service.getInfo().getServiceName() + ",name=" + sCacheName;
                sName = registry.ensureGlobalName((String)sName);
                sName = (String)sName + (String)(sContext == null ? "" : "," + sContext);
                registry.register((String)sName, map);
            }
        }
        catch (Throwable e) {
            Logger.warn("Failed to register cache \"" + sCacheName + "\"; " + String.valueOf(e));
        }
    }

    public static void registerViewMBean(ContinuousQueryCache cache) {
        MBeanHelper.registerViewMBean(cache.getCacheService(), cache);
    }

    public static void registerViewMBean(CacheService service, ContinuousQueryCache cache) {
        try {
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null) {
                Object sName = "type=View,service=" + service.getInfo().getServiceName() + ",name=" + cache.getCacheName();
                sName = registry.ensureGlobalName((String)sName);
                ViewMBeanImpl viewMBean = new ViewMBeanImpl(cache);
                registry.register((String)sName, new AnnotatedStandardEmitterMBean(viewMBean, ViewMBean.class));
            }
        }
        catch (Throwable e) {
            Logger.warn("Failed to register view \"" + cache.getCacheName() + "\"; " + String.valueOf(e));
        }
    }

    public static void unregisterViewMBean(NamedCache cache) {
        CacheService service = cache.getCacheService();
        MBeanHelper.unregisterViewMBean(service.getCluster(), service.getInfo().getServiceName(), cache.getCacheName());
    }

    public static void unregisterViewMBean(Cluster cluster, String sServiceName, String sCacheName) {
        try {
            Registry registry = cluster.getManagement();
            if (registry != null) {
                Object sName = "type=View,service=" + sServiceName + ",name=" + sCacheName;
                sName = registry.ensureGlobalName((String)sName);
                registry.unregister((String)sName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void unregisterCacheMBean(CacheService service, String sCacheName) {
        MBeanHelper.unregisterCacheMBean(service, sCacheName, null);
    }

    public static void unregisterCacheMBean(String sServiceName, String sCacheName, String sContext) {
        MBeanHelper.unregisterCacheMBean(CacheFactory.getCluster(), sServiceName, sCacheName, sContext);
    }

    public static void unregisterCacheMBean(CacheService service, String sCacheName, String sContext) {
        MBeanHelper.unregisterCacheMBean(service.getCluster(), service.getInfo().getServiceName(), sCacheName, sContext);
    }

    public static void unregisterCacheMBean(Cluster cluster, String sServiceName, String sCacheName, String sContext) {
        try {
            Registry registry = cluster.getManagement();
            if (registry != null) {
                Object sName = "type=Cache,service=" + sServiceName + ",name=" + sCacheName;
                sName = registry.ensureGlobalName((String)sName);
                sName = (String)sName + (String)(sContext == null ? "" : "," + sContext);
                registry.unregister((String)sName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void unregisterCacheMBean(String sCacheName, String sContext) {
        try {
            Cluster cluster = CacheFactory.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null) {
                Member member = cluster.getLocalMember();
                String sPattern = "type=Cache,name=" + sCacheName + (String)(member == null ? "" : ",nodeId=" + member.getId()) + (String)(sContext == null ? "" : "," + sContext);
                registry.unregister(sPattern);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void unregisterCacheMBean(NamedCache cache, String sContext) {
        MBeanHelper.unregisterCacheMBean(cache.getCacheService(), cache.getCacheName(), sContext);
    }

    public static void registerPagedTopicMBean(PagedTopicService service, String sTopicName) {
        try {
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            String sServiceName = service.getInfo().getServiceName();
            String sMBeanName = registry.ensureGlobalName(MBeanHelper.getTopicMBeanName(sServiceName, sTopicName));
            registry.register(sMBeanName, new PagedTopicModel(service, sTopicName));
        }
        catch (Throwable e) {
            Logger.warn("Failed to register topic \"" + sTopicName + "\"", e);
        }
    }

    public static void unregisterPagedTopicMBean(Service service, NamedTopic<?> topic) {
        MBeanHelper.unregisterPagedTopicMBean(service, topic.getName());
    }

    public static void unregisterPagedTopicMBean(Service service, String sTopicName) {
        try {
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            String sServiceName = service.getInfo().getServiceName();
            registry.unregister(registry.ensureGlobalName(MBeanHelper.getTopicMBeanName(sServiceName, sTopicName)));
            MBeanHelper.unregisterSubscriberGroupMBean(null, sTopicName, service);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getTopicMBeanName(NamedTopic<?> topic) {
        return MBeanHelper.getTopicMBeanName(topic.getTopicService().getInfo().getServiceName(), topic.getName());
    }

    public static String getTopicMBeanPattern(TopicService service) {
        return MBeanHelper.getTopicMBeanName(service.getInfo().getServiceName(), "*");
    }

    public static String getTopicMBeanPattern() {
        return MBeanHelper.getTopicMBeanName("*", "*");
    }

    private static String getTopicMBeanName(String sService, String sTopic) {
        return "type=PagedTopic,service=" + sService + ",name=" + sTopic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSubscriberGroupMBean(PagedTopicService service, PagedTopicSubscription subscription) {
        block7: {
            SubscriberGroupId id = subscription.getSubscriberGroupId();
            if (id.isAnonymous()) {
                return;
            }
            String sTopicName = subscription.getTopicName();
            try {
                String sName;
                Cluster cluster = service.getCluster();
                Registry registry = cluster.getManagement();
                if (registry == null || registry.isRegistered(sName = registry.ensureGlobalName(MBeanHelper.getSubscriberGroupMBeanName(id, sTopicName, service)))) break block7;
                s_lockTopicSubscriberGroups.lock();
                try {
                    if (!registry.isRegistered(sName)) {
                        PagedTopicStatistics statistics = service.getTopicStatistics(sTopicName);
                        Filter<?> filter = subscription.getFilter();
                        ValueExtractor<?, ?> extractor = subscription.getConverter();
                        registry.register(sName, new SubscriberGroupModel(statistics, id, filter, extractor, service));
                    }
                }
                finally {
                    s_lockTopicSubscriberGroups.unlock();
                }
            }
            catch (Throwable e) {
                Logger.warn("Failed to register subscriber group \"" + id.getGroupName() + "\" in topic \"" + sTopicName + "\"", e);
            }
        }
    }

    public static void unregisterSubscriberGroupMBean(PagedTopicService service, PagedTopicSubscription subscription) {
        String sTopicName = subscription.getTopicName();
        SubscriberGroupId groupId = subscription.getSubscriberGroupId();
        MBeanHelper.unregisterSubscriberGroupMBean(groupId, sTopicName, service);
    }

    private static void unregisterSubscriberGroupMBean(SubscriberGroupId id, String sTopicName, Service service) {
        try {
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            String sName = registry.ensureGlobalName(MBeanHelper.getSubscriberGroupMBeanName(id, sTopicName, service));
            registry.unregister(sName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getSubscriberGroupMBeanName(SubscriberGroupId id, String sTopicName, Service service) {
        String sGroupName = id == null ? "*" : id.getGroupName();
        return "type=PagedTopicSubscriberGroup,service=" + service.getInfo().getServiceName() + ",topic=" + sTopicName + ",name=" + sGroupName;
    }

    public static void registerSubscriberMBean(PagedTopicSubscriber<?> subscriber) {
        NamedTopic topic = subscriber.getNamedTopic();
        try {
            String sName;
            Service service = topic.getService();
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null && !registry.isRegistered(sName = registry.ensureGlobalName(MBeanHelper.getSubscriberMBeanName(subscriber)))) {
                registry.register(sName, new SubscriberModel(subscriber));
            }
        }
        catch (Throwable e) {
            Logger.warn("Failed to register subscriber \"" + subscriber.getId() + "\" in topic \"" + topic.getName() + "\"", e);
        }
    }

    public static void unregisterSubscriberMBean(PagedTopicSubscriber<?> subscriber) {
        try {
            Service service = subscriber.getNamedTopic().getService();
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            String sName = registry.ensureGlobalName(MBeanHelper.getSubscriberMBeanName(subscriber));
            registry.unregister(sName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getSubscriberMBeanName(PagedTopicSubscriber subscriber) {
        NamedTopic topic = subscriber.getNamedTopic();
        Service service = topic.getService();
        long nNodeId = service.getCluster().getLocalMember().getId();
        String sTopicName = topic.getName();
        String sGroup = subscriber.getSubscriberGroupId().getGroupName();
        String subType = subscriber.isAnonymous() ? "subType=Anonymous" : "subType=Durable";
        long nId = subscriber.getId();
        String sNode = "nodeId=" + nNodeId + ",";
        String sId = subscriber.isAnonymous() ? sNode + "id=" + nId : "group=" + sGroup + "," + sNode + "id=" + nId;
        return "type=PagedTopicSubscriber,service=" + service.getInfo().getServiceName() + ",topic=" + sTopicName + "," + subType + "," + sId;
    }

    public static String getSubscriberMBeanPattern(NamedTopic<?> topic, boolean fLocalOnly) {
        Service service = topic.getService();
        String sTopicName = topic.getName();
        int nNodeId = service.getCluster().getLocalMember().getId();
        Object sNode = fLocalOnly ? ",nodeId=" + nNodeId : "";
        return "type=PagedTopicSubscriber,service=" + service.getInfo().getServiceName() + ",topic=" + sTopicName + (String)sNode + ",*";
    }

    public static String getSubscriberMBeanPattern(NamedTopic<?> topic, SubscriberGroupId groupId, boolean fLocalOnly) {
        Service service = topic.getService();
        String sTopicName = topic.getName();
        int nNodeId = service.getCluster().getLocalMember().getId();
        Object sNode = fLocalOnly ? ",nodeId=" + nNodeId : "nodeId=*";
        String sGroup = groupId.getGroupName();
        String subType = groupId.isAnonymous() ? "subType=Anonymous" : "subType=Durable";
        String sId = groupId.isAnonymous() ? (String)sNode + ",id=" + sGroup : "group=" + sGroup + "," + (String)sNode + ",id=*";
        return "type=PagedTopicSubscriber,service=" + service.getInfo().getServiceName() + ",topic=" + sTopicName + "," + subType + "," + sId;
    }

    public static MBeanReference ensureSingletonMBean(String sName) {
        try {
            MBeanServer server = MBeanHelper.findMBeanServer();
            ObjectName name = new ObjectName("Coherence:type=" + sName);
            if (!server.isRegistered(name)) {
                Object oBean = Class.forName(MANAGEABLE + sName + "MBean").newInstance();
                server.registerMBean(oBean, name);
            }
            return new MBeanReference(name, server);
        }
        catch (Throwable e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static DynamicMBean createMapAdapterMbean(Map<String, String> mapDescr, Map<String, ?> mapValue) {
        try {
            DynamicMBean bean = (DynamicMBean)Class.forName("com.tangosol.coherence.component.manageable.MapAdapter").newInstance();
            ClassHelper.invoke(bean, "_initialize", new Object[]{mapDescr, mapValue});
            return bean;
        }
        catch (Throwable e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static JMXConnectorServer startRmiConnector(String sAddr, int nRegPort, int nConPort, MBeanServer mbs, Map mapEnv) {
        sPriorRmiHostname = System.getProperty("java.rmi.server.hostname");
        try {
            sHost = sAddr == null ? null : InetAddressHelper.getLocalAddress(sAddr).getHostAddress();
            sAuthFile = System.getProperty("com.sun.management.jmxremote.password.file");
            sAccessFile = System.getProperty("com.sun.management.jmxremote.access.file");
            sAuth = System.getProperty("com.sun.management.jmxremote.authenticate", sAuthFile != null || sAccessFile != null || nRegPort != 0 || mapEnv != null && "true".equals(mapEnv.get("com.oracle.coherence.tcmp.ssl")) != false ? "true" : "false");
            sSSL = System.getProperty("com.sun.management.jmxremote.ssl", sAuth);
            if (sAuth.equalsIgnoreCase("true")) {
                sJavaHome = System.getProperty("java.home");
                if (sAuthFile == null) {
                    pathPreJava11 = Paths.get(sJavaHome, new String[]{"lib", "management", "jmxremote.password"});
                    v0 = sAuthFile = pathPreJava11.toFile().exists() != false ? pathPreJava11.toString() : Paths.get(sJavaHome, new String[]{"conf", "management", "jmxremote.password"}).toString();
                }
                if (sAccessFile == null) {
                    pathPreJava11 = Paths.get(sJavaHome, new String[]{"lib", "management", "jmxremote.access"});
                    v1 = sAccessFile = pathPreJava11.toFile().exists() != false ? pathPreJava11.toString() : Paths.get(sJavaHome, new String[]{"conf", "management", "jmxremote.access"}).toString();
                }
            }
            if (mapEnv == null) {
                mapEnv = new HashMap<String, String>();
            }
            mapEnv.put("jmx.remote.x.daemon", "true");
            if (sAuthFile != null && mapEnv.get("jmx.remote.x.password.file") == null) {
                mapEnv.put("jmx.remote.x.password.file", sAuthFile);
            }
            if (sAccessFile != null && mapEnv.get("jmx.remote.x.access.file") == null) {
                mapEnv.put("jmx.remote.x.access.file", sAccessFile);
            }
            if (sSSL.equalsIgnoreCase("true")) {
                try {
                    if (mapEnv.get("jmx.remote.rmi.client.socket.factory") == null) {
                        mapEnv.put("jmx.remote.rmi.client.socket.factory", (String)Class.forName("javax.rmi.ssl.SslRMIClientSocketFactory").newInstance());
                    }
                    if (mapEnv.get("jmx.remote.rmi.server.socket.factory") != null) ** GOTO lbl48
                    mapEnv.put("jmx.remote.rmi.server.socket.factory", (String)Class.forName("javax.rmi.ssl.SslRMIServerSocketFactory").newInstance());
                }
                catch (ClassNotFoundException e) {
                    sMsg = "JMXConnectorServer not started. SSL security requires the Java Dynamic Management Kit or Java 1.5.";
                    throw MBeanHelper.ensureRuntimeException(e, sMsg);
                }
            } else if (!InetAddressHelper.isAnyLocalAddress(sHost)) {
                factory = new RMISocketFactory(){

                    @Override
                    public ServerSocket createServerSocket(int nPort) throws IOException {
                        ServerSocket socket = TcpSocketProvider.DEMULTIPLEXED.openServerSocket();
                        socket.bind(sHost == null ? new InetSocketAddress(nPort) : new InetSocketAddress(sHost, nPort));
                        return socket;
                    }

                    @Override
                    public Socket createSocket(String sRemoteHost, int nPort) throws IOException {
                        return RMISocketFactory.getDefaultSocketFactory().createSocket(sRemoteHost, nPort);
                    }
                };
                mapEnv.put("jmx.remote.rmi.server.socket.factory", (String)factory);
                try {
                    System.setProperty("java.rmi.server.hostname", sHost);
                }
                catch (Throwable sMsg) {
                    // empty catch block
                }
            }
lbl48:
            // 6 sources

            i = 0;
            while (true) {
                nPortAttempt = nConPort;
                srv = new ServerSocket(nPortAttempt, 0);
                try {
                    nPortAttempt = srv.getLocalPort();
                }
                finally {
                    srv.close();
                }
                if (nRegPort == 0) {
                    url = new JMXServiceURL("rmi", sHost, nPortAttempt);
                } else {
                    LocateRegistry.createRegistry(nRegPort);
                    url = new JMXServiceURL("service:jmx:rmi://" + sHost + ":" + nPortAttempt + "/jndi/rmi://" + sHost + ":" + nRegPort + "/server");
                }
                try {
                    connector = JMXConnectorServerFactory.newJMXConnectorServer(url, mapEnv, mbs);
                    connector.start();
                    var15_23 = connector;
                    return var15_23;
                }
                catch (IOException e) {
                    try {
                        if (nConPort != 0 || i > 32767) {
                            throw e;
                        }
                        ++i;
                        continue;
                    }
                    catch (Exception e) {
                        throw MBeanHelper.ensureRuntimeException(e, "Could not start JMXConnectorServer");
                    }
                }
                break;
            }
        }
        finally {
            try {
                if (sPriorRmiHostname == null) {
                    System.getProperties().remove("java.rmi.server.hostname");
                } else {
                    System.setProperty("java.rmi.server.hostname", sPriorRmiHostname);
                }
            }
            catch (Throwable var16_24) {}
        }
    }

    public static Object startHttpConnector(int nPort, MBeanServer mbs) {
        try {
            String sAdapter = "HttpAdapter:port=" + nPort;
            ObjectName nameAdapter = new ObjectName(sAdapter);
            Object adaptorServer = ClassHelper.newInstance(Class.forName("com.sun.jdmk.comm.HtmlAdaptorServer"), new Object[]{nPort});
            mbs.registerMBean(adaptorServer, nameAdapter);
            mbs.invoke(nameAdapter, "start", null, null);
            return adaptorServer;
        }
        catch (Exception e) {
            throw MBeanHelper.ensureRuntimeException(e, "Please ensure that JMX RI (jmxtools.jar, jmxri.jar) is in the classpath");
        }
    }

    public static String quote(String s) {
        return MBeanHelper.quote(s, true);
    }

    protected static String quote(String s, boolean fKey) {
        String sDelims = "\n\\\"" + (fKey ? "*?" : "");
        StringTokenizer tokens = new StringTokenizer(s, sDelims, true);
        StringBuilder sb = new StringBuilder("\"");
        while (tokens.hasMoreTokens()) {
            String sToken = tokens.nextToken();
            if (sToken.length() == 1 && sDelims.contains(sToken)) {
                sb.append('\\');
                if (sToken.equals("\n")) {
                    sb.append('n');
                    continue;
                }
                sb.append(sToken);
                continue;
            }
            sb.append(sToken);
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String safeUnquote(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.replaceAll("^\"|\"$", "");
        }
        return s;
    }

    public static String unquote(String s) {
        String sDelims = "\"\\";
        StringTokenizer tokens = new StringTokenizer(s, sDelims, true);
        StringBuilder sb = new StringBuilder("");
        if (tokens.countTokens() == 1) {
            return s;
        }
        if (tokens.nextToken().equals("\"")) {
            while (tokens.hasMoreTokens()) {
                String sToken = tokens.nextToken();
                if (sDelims.contains(sToken)) {
                    if (!tokens.hasMoreTokens()) continue;
                    String sNextToken = tokens.nextToken();
                    if (sNextToken.startsWith("n")) {
                        sb.append('\n');
                        sb.append(sNextToken.substring(1));
                        continue;
                    }
                    sb.append(sNextToken);
                    continue;
                }
                sb.append(sToken);
            }
        } else {
            throw new IllegalArgumentException("Argument not quoted");
        }
        return sb.toString();
    }

    public static boolean isQuoteRequired(String s) {
        return MBeanHelper.isQuoteRequired(s, true);
    }

    public static boolean isQuoteRequired(String s, boolean fKey) {
        return !MBeanHelper.isQuoted(s) && (s.indexOf(44) != -1 || s.indexOf(61) != -1 || s.indexOf(58) != -1 || !MBeanHelper.quote(s, fKey).equals("\"" + s + "\""));
    }

    private static boolean isQuoted(String s) {
        int nLen = s.length();
        return nLen >= 2 && s.charAt(0) == '\"' && s.charAt(nLen - 1) == '\"';
    }

    public static String quoteCanonical(String sCanonical) throws MalformedObjectNameException {
        int ofDomain = sCanonical.indexOf(58);
        int ofEquals = sCanonical.indexOf(61);
        String sName = sCanonical;
        StringBuilder sbCanonical = new StringBuilder();
        if (ofDomain >= 0 && (ofEquals < 0 || ofDomain < ofEquals)) {
            sName = sCanonical.substring(ofDomain + 1);
            sbCanonical.append(sCanonical.substring(0, ofDomain + 1));
        }
        String[] asPairs = Base.parseDelimitedString(sName, ',');
        int cPairs = asPairs.length;
        for (int i = 0; i < cPairs; ++i) {
            String sKey;
            StringBuilder sbValue = new StringBuilder();
            String sPair = asPairs[i];
            if (asPairs[i].equals("*")) {
                sbCanonical.append(asPairs[i]);
                continue;
            }
            int ofValue = sPair.indexOf(61);
            if (ofValue > -1) {
                String[] asPair = Base.parseDelimitedString(asPairs[i], '=');
                sKey = asPair[0];
                if (MBeanHelper.isQuoteRequired(sKey)) {
                    sKey = MBeanHelper.quote(sKey);
                }
            } else {
                throw new MalformedObjectNameException("ObjectName \"" + sCanonical + "\" is invalid.");
            }
            sbCanonical.append(sKey).append('=');
            sbValue.append(sPair.substring(ofValue + 1));
            String sValue = sbValue.toString();
            if (MBeanHelper.isQuoteRequired(sValue, false)) {
                sValue = MBeanHelper.quote(sValue, false);
            }
            sbCanonical.append(sValue);
            if (i + 1 >= cPairs) continue;
            sbCanonical.append(',');
        }
        return sbCanonical.toString();
    }

    public static boolean hasDomain(String sCanonical) {
        if (sCanonical == null) {
            return false;
        }
        int ofDomain = sCanonical.indexOf(58);
        int ofEquals = sCanonical.indexOf(61);
        return ofDomain >= 0 && (ofEquals < 0 || ofDomain < ofEquals);
    }

    public static String ensureDomain(String sCanonical) {
        if (sCanonical == null || MBeanHelper.hasDomain(sCanonical) && sCanonical.indexOf(58) > 0) {
            return sCanonical;
        }
        String sDomain = CacheFactory.getCluster().getManagement().getDomainName();
        if (sDomain == null || sDomain.length() == 0) {
            sDomain = MBeanHelper.getDefaultDomain();
        }
        if (sDomain == null) {
            sDomain = "Coherence";
        }
        if (sCanonical.indexOf(58) == 0) {
            return sDomain + sCanonical;
        }
        return sDomain + ":" + sCanonical;
    }

    public static String stripDomain(String sCanonical) {
        return MBeanHelper.hasDomain(sCanonical) ? sCanonical.substring(sCanonical.indexOf(58) + 1) : sCanonical;
    }

    public static int compareKeyList(ObjectName oname1, ObjectName oname2) {
        Set setKeys2;
        Hashtable<String, String> mapKeyList1 = oname1.getKeyPropertyList();
        Hashtable<String, String> mapKeyList2 = oname2.getKeyPropertyList();
        Set setKeys1 = mapKeyList1.keySet();
        if (setKeys1.equals(setKeys2 = mapKeyList2.keySet())) {
            for (Object o : mapKeyList1.keySet()) {
                String sKey = (String)o;
                String sValue1 = (String)mapKeyList1.get(sKey);
                String sValue2 = (String)mapKeyList2.get(sKey);
                if ((sKey + "=").equals("nodeId=")) {
                    int n2;
                    int n1 = Integer.parseInt(sValue1);
                    if (n1 == (n2 = Integer.parseInt(sValue2))) continue;
                    return n1 - n2;
                }
                int iCompare = sValue1.compareTo(sValue2);
                if (iCompare == 0) continue;
                return iCompare;
            }
            return 0;
        }
        return oname1.getCanonicalName().compareTo(oname2.getCanonicalName());
    }

    public static String getDescription(Class<?> clzMBeanIface, MBeanInfo info) {
        Description desc;
        String sDesc = null;
        if (clzMBeanIface != null && (desc = clzMBeanIface.getAnnotation(Description.class)) != null) {
            sDesc = desc.value();
        }
        return sDesc == null ? info.getDescription() : sDesc;
    }

    public static String getDescription(Class clzMBeanIface, MBeanAttributeInfo info) {
        String sDesc = null;
        Object sMethName = info.getName();
        sMethName = info.isIs() ? "is" + (String)sMethName : "get" + (String)sMethName;
        Method methGetter = MBeanHelper.findMethod(clzMBeanIface, (String)sMethName, new String[0]);
        if (methGetter != null) {
            Description descGetter = methGetter.getAnnotation(Description.class);
            if (descGetter != null) {
                sDesc = descGetter.value();
            } else {
                Description descSetter;
                sMethName = "set" + info.getName();
                Method methSetter = MBeanHelper.findMethod(clzMBeanIface, (String)sMethName, new String[0]);
                if (methSetter != null && (descSetter = methSetter.getAnnotation(Description.class)) != null) {
                    sDesc = descSetter.value();
                }
            }
        }
        return sDesc == null ? info.getDescription() : sDesc;
    }

    public static String getDescription(Class clzMBeanIface, MBeanOperationInfo info) {
        Description desc;
        String sDesc = null;
        Method meth = MBeanHelper.findMethod(clzMBeanIface, info);
        if (meth != null && (desc = meth.getAnnotation(Description.class)) != null) {
            sDesc = desc.value();
        }
        return sDesc == null ? info.getDescription() : sDesc;
    }

    public static String getParameterName(Class clzMBeanIface, MBeanOperationInfo infoOp, MBeanParameterInfo infoParam, int iParam) {
        Description desc;
        String sName = infoParam.getName();
        Method meth = MBeanHelper.findMethod(clzMBeanIface, infoOp);
        if (meth != null && (desc = MBeanHelper.getParameterAnnotation(meth, iParam, Description.class)) != null) {
            sName = desc.value();
        }
        return sName;
    }

    public static MBeanNotificationInfo[] getNotificationInfo(Class<?> clzMBeanIface) {
        Notification anno = clzMBeanIface.getAnnotation(Notification.class);
        if (anno != null) {
            return new MBeanNotificationInfo[]{new MBeanNotificationInfo(anno.types(), anno.className(), anno.description())};
        }
        return new MBeanNotificationInfo[0];
    }

    protected static <A extends Annotation> A getParameterAnnotation(Method meth, int iParam, Class<A> clzAnno) {
        for (Annotation a : meth.getParameterAnnotations()[iParam]) {
            if (!clzAnno.isInstance(a)) continue;
            return (A)((Annotation)clzAnno.cast(a));
        }
        return null;
    }

    protected static Method findMethod(Class clzMBean, MBeanOperationInfo op) {
        MBeanParameterInfo[] aParam = op.getSignature();
        int cParams = aParam.length;
        String[] asParamTypes = new String[cParams];
        for (int i = 0; i < cParams; ++i) {
            asParamTypes[i] = aParam[i].getType();
        }
        return MBeanHelper.findMethod(clzMBean, op.getName(), asParamTypes);
    }

    protected static Method findMethod(Class clz, String sName, String ... asParamTypes) {
        ClassLoader loader = clz.getClassLoader();
        int cParams = asParamTypes.length;
        Class[] aclzParam = new Class[cParams];
        try {
            for (int i = 0; i < cParams; ++i) {
                aclzParam[i] = MBeanHelper.classForName(asParamTypes[i], loader);
            }
            return ClassHelper.findMethod(clz, sName, aclzParam, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    static Class classForName(String sName, ClassLoader loader) throws ClassNotFoundException {
        Class<?> clz = SCALAR_TYPES.get(sName);
        if (clz == null) {
            clz = Class.forName(sName, false, loader);
        }
        return clz;
    }

    private static GatewayDependencies ensureGatewayDependencies() {
        GatewayDependencies deps = s_deps;
        if (deps == null) {
            deps = s_deps = LegacyXmlGatewayHelper.fromXml(CacheFactory.getManagementConfig(), new DefaultGatewayDependencies());
        }
        return deps;
    }

    public static boolean isNonMemberMBean(String sName) {
        return sName.contains("type=Cluster") || sName.contains("type=Management") || sName.contains("responsibility=") || sName.contains("type=PagedTopicSubscriber,");
    }

    static {
        HashMap<String, Class<Comparable<Boolean>>> mapScalar = new HashMap<String, Class<Comparable<Boolean>>>();
        mapScalar.put("java.lang.Boolean", Boolean.TYPE);
        mapScalar.put("boolean", Boolean.TYPE);
        mapScalar.put("java.lang.Character", Character.TYPE);
        mapScalar.put("char", Character.TYPE);
        mapScalar.put("java.lang.Byte", Byte.TYPE);
        mapScalar.put("byte", Byte.TYPE);
        mapScalar.put("java.lang.Short", Short.TYPE);
        mapScalar.put("short", Short.TYPE);
        mapScalar.put("java.lang.Integer", Integer.TYPE);
        mapScalar.put("int", Integer.TYPE);
        mapScalar.put("java.lang.Long", Long.TYPE);
        mapScalar.put("long", Long.TYPE);
        mapScalar.put("java.lang.Float", Float.TYPE);
        mapScalar.put("float", Float.TYPE);
        mapScalar.put("java.lang.Double", Double.TYPE);
        mapScalar.put("double", Double.TYPE);
        SCALAR_TYPES = Collections.unmodifiableMap(mapScalar);
        HashMap<String, SimpleType<Object>> mapSimple = new HashMap<String, SimpleType<Object>>();
        mapSimple.put("java.lang.Boolean", SimpleType.BOOLEAN);
        mapSimple.put("boolean", SimpleType.BOOLEAN);
        mapSimple.put("java.lang.Character", SimpleType.CHARACTER);
        mapSimple.put("character", SimpleType.CHARACTER);
        mapSimple.put("java.lang.Byte", SimpleType.BYTE);
        mapSimple.put("byte", SimpleType.BYTE);
        mapSimple.put("java.lang.Short", SimpleType.SHORT);
        mapSimple.put("short", SimpleType.SHORT);
        mapSimple.put("java.lang.Integer", SimpleType.INTEGER);
        mapSimple.put("int", SimpleType.INTEGER);
        mapSimple.put("java.lang.Long", SimpleType.LONG);
        mapSimple.put("long", SimpleType.LONG);
        mapSimple.put("java.lang.Float", SimpleType.FLOAT);
        mapSimple.put("float", SimpleType.FLOAT);
        mapSimple.put("java.lang.Double", SimpleType.DOUBLE);
        mapSimple.put("double", SimpleType.DOUBLE);
        mapSimple.put("java.lang.String", SimpleType.STRING);
        mapSimple.put("string", SimpleType.STRING);
        SCALAR_SIMPLETYPES = Collections.unmodifiableMap(mapSimple);
        s_lockTopicSubscriberGroups = new ReentrantLock();
    }

    public static class QueryExpFilter
    implements QueryExp {
        private final Filter<ObjectName> f_filter;

        public QueryExpFilter(Filter<ObjectName> filter) {
            this.f_filter = filter;
        }

        @Override
        public boolean apply(ObjectName name) {
            return this.f_filter == null || this.f_filter.evaluate(name);
        }

        @Override
        public void setMBeanServer(MBeanServer s) {
        }
    }
}

