/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.management;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.management.MBeanServerFinder;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class JmxmpServer
implements MBeanServerFinder {
    private static JMXServiceURL jmxServiceURL;
    private static JMXConnectorServer connectorServer;
    private final String address;

    public JmxmpServer() {
        this("0.0.0.0");
    }

    public JmxmpServer(String address) {
        this.address = address;
    }

    @Override
    public MBeanServer findMBeanServer(String s) {
        return JmxmpServer.ensureServer(this.address).getMBeanServer();
    }

    @Override
    public JMXServiceURL findJMXServiceUrl(String s) {
        return jmxServiceURL;
    }

    private static synchronized JMXConnectorServer ensureServer(String address) {
        try {
            if (connectorServer == null) {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                int nPort = Config.getInteger("coherence.jmxmp.port", 9000);
                jmxServiceURL = new JMXServiceURL("jmxmp", address, nPort);
                connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxServiceURL, null, server);
                connectorServer.start();
                Logger.info("Started JMXMP connector " + String.valueOf(connectorServer.getAddress()));
            }
            return connectorServer;
        }
        catch (IOException e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }
}

