/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.tangosol.net.CompositeSocketAddressProvider;
import com.tangosol.net.SocketAddressProvider;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class WrapperSocketAddressProvider
extends CompositeSocketAddressProvider {
    private int m_nSubPort;

    public WrapperSocketAddressProvider(SocketAddressProvider provider) {
        this(provider, -1);
    }

    public WrapperSocketAddressProvider(SocketAddress address) {
        this(address, -1);
    }

    public WrapperSocketAddressProvider(SocketAddressProvider provider, int nSubPort) {
        super(provider);
        this.m_nSubPort = nSubPort;
    }

    public WrapperSocketAddressProvider(SocketAddress address, int nSubPort) {
        super(address);
        this.m_nSubPort = nSubPort;
    }

    @Override
    public SocketAddress getNextAddress() {
        SocketAddress address = super.getNextAddress();
        if (address instanceof InetSocketAddress32) {
            InetSocketAddress32 baseAddress = (InetSocketAddress32)address;
            address = new InetSocketAddress32(baseAddress.getAddress(), MultiplexedSocketProvider.getPort(MultiplexedSocketProvider.getBasePort(baseAddress.getPort()), this.m_nSubPort));
        } else if (address instanceof InetSocketAddress) {
            InetSocketAddress baseAddress = (InetSocketAddress)address;
            address = new InetSocketAddress32(baseAddress.getAddress(), MultiplexedSocketProvider.getPort(baseAddress.getPort(), this.m_nSubPort));
        }
        return address;
    }

    public static WrapperSocketAddressProvider createEphemeralSubPortSocketAddressProvider(SocketAddress address) {
        return new WrapperSocketAddressProvider(address, 0);
    }

    public static WrapperSocketAddressProvider createEphemeralSubPortSocketAddressProvider(SocketAddressProvider provider) {
        return new WrapperSocketAddressProvider(provider, 0);
    }
}

