/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.CopyOnWriteLongArray;
import com.tangosol.util.LongArray;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

public class StorageVersion {
    protected final AtomicLong m_atomicSubmittedVersion;
    protected final AtomicLong m_atomicCommittedVersion;
    protected final LongArray<PartitionVersion> m_laPartitionVersion = new CopyOnWriteLongArray<PartitionVersion>();
    protected volatile int m_cWaitingThreads = 0;

    public StorageVersion() {
        this.m_atomicCommittedVersion = new AtomicLong(0L);
        this.m_atomicSubmittedVersion = new AtomicLong(0L);
    }

    public long getCommittedVersion() {
        return this.m_atomicCommittedVersion.get();
    }

    public String toString() {
        StringBuilder sbMap = new StringBuilder();
        Iterator iter = this.m_laPartitionVersion.iterator();
        while (iter.hasNext()) {
            PartitionVersion version = (PartitionVersion)iter.next();
            if (version.f_atomicSubmission.get() <= 0L) continue;
            sbMap.append("\n{Partition ").append(iter.getIndex()).append(' ').append(version).append('}');
        }
        return "StorageVersion{SubmittedVersion=" + this.m_atomicSubmittedVersion.get() + ", CommittedVersion=" + this.m_atomicCommittedVersion.get() + ", WaitingThreads=" + this.m_cWaitingThreads + ", PartitionVersions={" + String.valueOf(sbMap) + "\n}}";
    }

    public long getSubmittedVersion() {
        return this.m_atomicSubmittedVersion.get();
    }

    public long getSubmittedVersion(int nPart) {
        PartitionVersion version = this.m_laPartitionVersion.get(nPart);
        return version == null ? 0L : version.f_atomicSubmitted.get();
    }

    public boolean isPartitionModified(long lCommittedVersion, int nPart) {
        PartitionVersion version = this.m_laPartitionVersion.get(nPart);
        return version != null && version.isNewerThan(lCommittedVersion);
    }

    public PartitionSet getModifiedPartitions(long lCommittedVersion, PartitionSet partsCheck) {
        LongArray<PartitionVersion> laPartitionVersion = this.m_laPartitionVersion;
        PartitionSet partsSuspect = new PartitionSet(partsCheck.getPartitionCount());
        int nPart = partsCheck.next(0);
        while (nPart >= 0) {
            PartitionVersion version = laPartitionVersion.get(nPart);
            if (version != null && version.isNewerThan(lCommittedVersion)) {
                partsSuspect.add(nPart);
            }
            nPart = partsCheck.next(nPart + 1);
        }
        return partsSuspect;
    }

    public long submit(int nPartition) {
        LongArray<PartitionVersion> laPartitionVersion = this.m_laPartitionVersion;
        PartitionVersion version = this.ensurePartitionVersion(nPartition);
        version.f_atomicSubmission.incrementAndGet();
        this.m_atomicSubmittedVersion.incrementAndGet();
        return version.f_atomicSubmitted.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(int nPartition) {
        boolean fNotify;
        PartitionVersion version = this.m_laPartitionVersion.get(nPartition);
        Object object = version;
        synchronized (object) {
            long lVersion = this.m_atomicCommittedVersion.incrementAndGet();
            version.f_atomicCommitted.set(lVersion);
            long cPendingUpdates = version.f_atomicSubmission.decrementAndGet();
            assert (cPendingUpdates >= 0L);
            fNotify = cPendingUpdates == 0L && this.m_cWaitingThreads > 0;
        }
        if (fNotify) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    public void waitForPendingCommit() {
        long lCommitted;
        long lSubmitted = this.m_atomicSubmittedVersion.get();
        if (lSubmitted == (lCommitted = this.m_atomicCommittedVersion.get())) {
            return;
        }
        this.waitForNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNotify() {
        StorageVersion storageVersion = this;
        synchronized (storageVersion) {
            ++this.m_cWaitingThreads;
            try {
                Blocking.wait(this, 50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                --this.m_cWaitingThreads;
            }
        }
    }

    public long waitForPendingCommit(int nPartition) {
        PartitionVersion version = this.m_laPartitionVersion.get(nPartition);
        if (version == null) {
            return 0L;
        }
        while (version.f_atomicSubmission.get() > 0L) {
            this.waitForNotify();
        }
        return version.f_atomicCommitted.get();
    }

    public void dropCommittedVersion(int nPartition) {
        this.m_laPartitionVersion.remove(nPartition);
    }

    public void resetSubmitted(int nPartition, long lNewVersion) {
        long lCurrentVersion;
        LongArray<PartitionVersion> laPartitionVersion = this.m_laPartitionVersion;
        PartitionVersion version = this.ensurePartitionVersion(nPartition);
        while ((lCurrentVersion = version.f_atomicSubmitted.get()) < lNewVersion && !version.f_atomicSubmitted.compareAndSet(lCurrentVersion, lNewVersion)) {
        }
    }

    protected PartitionVersion ensurePartitionVersion(int nPartition) {
        LongArray<PartitionVersion> laPartitionVersion = this.m_laPartitionVersion;
        PartitionVersion version = laPartitionVersion.get(nPartition);
        if (version == null) {
            version = new PartitionVersion();
            laPartitionVersion.set(nPartition, version);
        }
        return version;
    }

    private static class PartitionVersion {
        final AtomicLong f_atomicSubmitted = new AtomicLong();
        final AtomicLong f_atomicCommitted = new AtomicLong();
        final AtomicLong f_atomicSubmission = new AtomicLong();

        private PartitionVersion() {
        }

        public boolean isNewerThan(long lCommittedVersion) {
            return this.f_atomicSubmission.get() > 0L || this.f_atomicCommitted.get() > lCommittedVersion;
        }

        public String toString() {
            return "PartitionVersion{CommittedVersion=" + this.f_atomicCommitted.get() + ", SubmissionCounter=" + this.f_atomicSubmission.get() + "}";
        }
    }
}

