/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.internal.SessionExpiryExtractor;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SessionUpdateTimestamp
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected long m_ldtAccess;
    protected long m_ldtFlush;

    public SessionUpdateTimestamp() {
    }

    public SessionUpdateTimestamp(long ldtAccess, long ldtFlush) {
        if (ldtAccess <= 0L || ldtFlush <= 0L) {
            throw new IllegalArgumentException();
        }
        this.m_ldtAccess = ldtAccess;
        this.m_ldtFlush = ldtFlush;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        if (entry.isPresent()) {
            try {
                BinaryEntry binentry = (BinaryEntry)entry;
                Binary binSession = binentry.getBinaryValue();
                int of = SessionExpiryExtractor.validateBinarySession(binSession);
                ReadBuffer.BufferInput in = binSession.getBufferInput();
                in.setOffset(of + 4);
                long ldtAccessOld = in.readLong();
                long ldtAccessNew = this.m_ldtAccess;
                in.setOffset(of + 16);
                long ldtFlushOld = in.readLong();
                long ldtFlushNew = this.m_ldtFlush;
                if (ldtAccessNew > ldtAccessOld || ldtFlushNew > ldtFlushOld) {
                    int cb = binSession.length();
                    BinaryWriteBuffer bufNew = new BinaryWriteBuffer(cb, cb);
                    bufNew.write(0, binSession);
                    WriteBuffer.BufferOutput out = bufNew.getBufferOutput();
                    out.setOffset(of + 4);
                    out.writeLong(Math.max(ldtAccessNew, ldtAccessOld));
                    out.setOffset(of + 16);
                    out.writeLong(Math.max(ldtFlushNew, ldtFlushOld));
                    binentry.updateBinaryValue(bufNew.toBinary());
                }
            }
            catch (IOException e) {
                throw SessionUpdateTimestamp.ensureRuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_ldtAccess = ExternalizableHelper.readLong(in);
        this.m_ldtFlush = ExternalizableHelper.readLong(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong(out, this.m_ldtAccess);
        ExternalizableHelper.writeLong(out, this.m_ldtFlush);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_ldtAccess = in.readLong(0);
        this.m_ldtFlush = in.readLong(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_ldtAccess);
        out.writeLong(1, this.m_ldtFlush);
    }
}

