/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.IdentityHolder;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.Releasable;
import com.tangosol.net.internal.AbstractScopedReferenceStore;
import com.tangosol.net.internal.ScopedReferenceStore;
import com.tangosol.net.internal.ScopedServiceReferenceStore;
import com.tangosol.net.security.Security;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.util.SegmentedConcurrentMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class ScopedTopicReferenceStore
extends ScopedReferenceStore<NamedTopic> {
    protected Map<IdentityHolder<NamedTopic>, Object> f_mapPending = new ConcurrentHashMap<IdentityHolder<NamedTopic>, Object>();

    public ScopedTopicReferenceStore() {
        super(NamedTopic.class, Releasable::isActive, NamedCollection::getName, NamedCollection::getService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInactiveTopicRefs() {
        Iterator iterByName = this.m_mapByName.values().iterator();
        while (iterByName.hasNext()) {
            Map mapByLoader;
            Map map = mapByLoader = (Map)iterByName.next();
            synchronized (map) {
                Iterator iter = mapByLoader.entrySet().iterator();
                while (iter.hasNext()) {
                    NamedTopic topic;
                    Collection col;
                    Map.Entry entry = iter.next();
                    Object oHolder = entry.getValue();
                    if (oHolder instanceof NamedTopic) {
                        NamedTopic topic2 = (NamedTopic)entry.getValue();
                        if (!topic2.isDestroyed() && !topic2.isReleased()) continue;
                        iter.remove();
                        this.internalReleaseTopic(topic2);
                        continue;
                    }
                    if (!(oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) || (col = ((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).values()).isEmpty() || !(topic = (NamedTopic)col.iterator().next()).isDestroyed() && !topic.isReleased()) continue;
                    iter.remove();
                    this.internalReleaseTopic(topic);
                }
                if (mapByLoader.isEmpty()) {
                    iterByName.remove();
                }
            }
        }
    }

    public NamedTopic getTopic(String sTopicName, ClassLoader loader) {
        Map mapByLoader = (Map)this.m_mapByName.get(sTopicName);
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Object oHolder = mapByLoader.get(loader);
                if (oHolder == null || oHolder instanceof NamedTopic) {
                    return (NamedTopic)oHolder;
                }
                if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                    return (NamedTopic)((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).get();
                }
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    public void putTopic(NamedTopic topic, ClassLoader loader) {
        if (topic.isReleased()) {
            throw new IllegalArgumentException("Storing a released topic is not allowed: " + topic.getName());
        }
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sTopicName = topic.getName();
        WeakHashMap<ClassLoader, Object> mapByLoader = (WeakHashMap<ClassLoader, Object>)mapByName.get(sTopicName);
        if (mapByLoader == null) {
            mapByLoader = new WeakHashMap<ClassLoader, Object>();
            mapByName.put(sTopicName, mapByLoader);
        }
        if (ScopedServiceReferenceStore.isRemoteServiceType(topic.getService().getInfo().getServiceType()) && Security.SUBJECT_SCOPED) {
            AbstractScopedReferenceStore.SubjectScopedReference scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)mapByLoader.get(loader);
            if (scopedRef == null) {
                scopedRef = new AbstractScopedReferenceStore.SubjectScopedReference();
                mapByLoader.put(loader, scopedRef);
            }
            scopedRef.set(topic);
        } else {
            mapByLoader.put(loader, topic);
        }
    }

    public Object putTopicIfAbsent(NamedTopic topic, ClassLoader loader) {
        Object oResult;
        Map mapByLoader;
        if (topic.isReleased()) {
            throw new IllegalArgumentException("Storing a released topic is not allowed: " + topic.getName());
        }
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sTopicName = topic.getName();
        do {
            Map mapTmp;
            if ((mapByLoader = (WeakHashMap)mapByName.get(sTopicName)) == null && (mapTmp = (Map)mapByName.putIfAbsent(sTopicName, mapByLoader = new WeakHashMap())) != null) {
                mapByLoader = mapTmp;
            }
            if (ScopedServiceReferenceStore.isRemoteServiceType(topic.getService().getInfo().getServiceType()) && Security.SUBJECT_SCOPED) {
                AbstractScopedReferenceStore.SubjectScopedReference scopedRef = new AbstractScopedReferenceStore.SubjectScopedReference();
                oResult = this.putLoaderIfAbsent(mapByLoader, loader, scopedRef);
                if (oResult != null) {
                    scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oResult;
                }
                oResult = scopedRef.putIfAbsent(topic);
                continue;
            }
            oResult = this.putLoaderIfAbsent(mapByLoader, loader, topic);
        } while (mapByName.get(sTopicName) != mapByLoader);
        return oResult;
    }

    public boolean releaseTopic(NamedTopic topic, ClassLoader loader) {
        return this.releaseTopic(topic, loader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseTopic(NamedTopic topic, ClassLoader loader, Runnable postRelease) {
        Map map;
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sTopicName = topic.getName();
        Map mapByLoader = (Map)mapByName.get(sTopicName);
        boolean fFound = false;
        Object oPending = null;
        IdentityHolder<NamedTopic> topicId = new IdentityHolder<NamedTopic>(topic);
        if (mapByLoader != null) {
            map = mapByLoader;
            synchronized (map) {
                AbstractScopedReferenceStore.SubjectScopedReference scopedRef;
                Object oHolder = mapByLoader.get(loader);
                if (oHolder == topic) {
                    mapByLoader.remove(loader);
                    fFound = true;
                } else if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference && (scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oHolder).get() == topic) {
                    scopedRef.remove();
                    fFound = true;
                    if (scopedRef.isEmpty()) {
                        mapByLoader.remove(loader);
                    }
                }
                if (fFound && postRelease != null) {
                    oPending = new Object();
                    this.f_mapPending.put(topicId, oPending);
                }
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sTopicName);
                }
            }
        }
        if (oPending != null) {
            try {
                postRelease.run();
            }
            finally {
                this.f_mapPending.remove(topicId, oPending);
                map = oPending;
                synchronized (map) {
                    oPending.notifyAll();
                }
            }
        }
        if (!fFound) {
            this.awaitPending(topicId);
        }
        return fFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseTopic(NamedTopic topic) {
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sTopicName = topic.getName();
        Map mapByLoader = (Map)mapByName.get(sTopicName);
        boolean fFound = false;
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Collection col = mapByLoader.values();
                fFound = col.remove(topic);
                if (!fFound) {
                    Object oHolder;
                    if (topic instanceof ClassLoaderAware) {
                        return this.releaseTopic(topic, ((ClassLoaderAware)((Object)topic)).getContextClassLoader());
                    }
                    Iterator iter = col.iterator();
                    while (iter.hasNext() && (oHolder = iter.next()) instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                        AbstractScopedReferenceStore.SubjectScopedReference scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oHolder;
                        if (scopedRef.get() != topic) continue;
                        scopedRef.remove();
                        fFound = true;
                        if (!scopedRef.isEmpty()) break;
                        iter.remove();
                        break;
                    }
                }
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sTopicName);
                }
            }
        }
        return fFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitPending(IdentityHolder<NamedTopic> topicId) {
        Object oPending = this.f_mapPending.get(topicId);
        if (oPending != null) {
            Object object = oPending;
            synchronized (object) {
                if (oPending == this.f_mapPending.get(topicId)) {
                    try {
                        Blocking.wait(oPending);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object putLoaderIfAbsent(Map map, ClassLoader loader, Object oValue) {
        Object oResult;
        Map map2 = map;
        synchronized (map2) {
            oResult = map.get(loader);
            if (oResult == null) {
                map.put(loader, oValue);
            }
        }
        return oResult;
    }

    private void internalReleaseTopic(NamedTopic topic) {
        try {
            topic.release();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

