/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.Service;
import com.tangosol.net.internal.AbstractScopedReferenceStore;
import com.tangosol.net.internal.ScopedServiceReferenceStore;
import com.tangosol.net.security.Security;
import com.tangosol.util.SegmentedConcurrentMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;

public class ScopedReferenceStore<R>
extends AbstractScopedReferenceStore {
    protected final Class<R> f_clsType;
    private final Function<R, Boolean> f_supplierIsActive;
    private final Function<R, String> f_supplierName;
    private final Function<R, Service> f_supplierService;

    public ScopedReferenceStore(Class<R> clsType, Function<R, Boolean> supplierIsActive, Function<R, String> supplierName, Function<R, Service> supplierService) {
        this.f_clsType = clsType;
        this.f_supplierIsActive = supplierIsActive;
        this.f_supplierName = supplierName;
        this.f_supplierService = supplierService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> clearInactiveRefs(String sName) {
        HashSet<Integer> setHashCode;
        Map mapByLoader = (Map)this.m_mapByName.get(sName);
        if (mapByLoader == null) {
            return null;
        }
        Map map = mapByLoader;
        synchronized (map) {
            setHashCode = mapByLoader.isEmpty() ? Collections.emptySet() : new HashSet<Integer>();
            Iterator iter = mapByLoader.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ClassLoader loaderTmp = (ClassLoader)entry.getKey();
                Object oHolder = entry.getValue();
                if (this.f_clsType.isAssignableFrom(oHolder.getClass())) {
                    Object referenceTmp = entry.getValue();
                    if (this.f_supplierIsActive.apply(referenceTmp).booleanValue()) continue;
                    setHashCode.add(loaderTmp == null ? 0 : loaderTmp.hashCode());
                    iter.remove();
                    continue;
                }
                if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                    for (Object o : ((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).values()) {
                        Object referenceTmp = o;
                        if (this.f_supplierIsActive.apply(referenceTmp).booleanValue()) continue;
                        setHashCode.add(loaderTmp == null ? 0 : loaderTmp.hashCode());
                        iter.remove();
                    }
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        return setHashCode;
    }

    public R get(String sName, ClassLoader loader) {
        Map mapByLoader = (Map)this.m_mapByName.get(sName);
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Object oHolder = mapByLoader.get(loader);
                if (oHolder == null || this.f_clsType.isAssignableFrom(oHolder.getClass())) {
                    return (R)oHolder;
                }
                if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                    return (R)((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).get();
                }
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<R> getAll() {
        HashSet setRef = new HashSet();
        Collection colLoader = this.m_mapByName.values();
        for (Object aColLoader : colLoader) {
            Map mapByLoader;
            Map map = mapByLoader = (Map)aColLoader;
            synchronized (map) {
                for (Object oHolder : mapByLoader.values()) {
                    if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                        setRef.addAll(((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).values());
                        continue;
                    }
                    if (this.f_clsType.isAssignableFrom(oHolder.getClass())) {
                        setRef.add(oHolder);
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        return setRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<R> getAll(String sName) {
        HashSet setRef = new HashSet();
        Map mapByLoader = (Map)this.m_mapByName.get(sName);
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Collection col = mapByLoader.values();
                for (Object oHolder : col) {
                    if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                        setRef.addAll(((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).values());
                        continue;
                    }
                    if (this.f_clsType.isAssignableFrom(oHolder.getClass())) {
                        setRef.add(oHolder);
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        return setRef;
    }

    public void put(R reference, ClassLoader loader) {
        Service service;
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sName = this.f_supplierName.apply(reference);
        WeakHashMap<ClassLoader, AbstractScopedReferenceStore.SubjectScopedReference> mapByLoader = (WeakHashMap<ClassLoader, AbstractScopedReferenceStore.SubjectScopedReference>)mapByName.get(sName);
        if (mapByLoader == null) {
            mapByLoader = new WeakHashMap<ClassLoader, AbstractScopedReferenceStore.SubjectScopedReference>();
            mapByName.put(sName, mapByLoader);
        }
        if ((service = this.f_supplierService.apply(reference)) != null && ScopedServiceReferenceStore.isRemoteServiceType(service.getInfo().getServiceType()) && Security.SUBJECT_SCOPED) {
            AbstractScopedReferenceStore.SubjectScopedReference scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)mapByLoader.get(loader);
            if (scopedRef == null) {
                scopedRef = new AbstractScopedReferenceStore.SubjectScopedReference();
                mapByLoader.put(loader, scopedRef);
            }
            scopedRef.set(reference);
        } else {
            mapByLoader.put(loader, (AbstractScopedReferenceStore.SubjectScopedReference)reference);
        }
    }

    public Object putIfAbsent(R reference, ClassLoader loader) {
        Object oResult;
        Service service;
        Map mapTmp;
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sName = this.f_supplierName.apply(reference);
        Map mapByLoader = (WeakHashMap)mapByName.get(sName);
        if (mapByLoader == null && (mapTmp = (Map)mapByName.putIfAbsent(sName, mapByLoader = new WeakHashMap())) != null) {
            mapByLoader = mapTmp;
        }
        if ((service = this.f_supplierService.apply(reference)) != null && ScopedServiceReferenceStore.isRemoteServiceType(service.getInfo().getServiceType()) && Security.SUBJECT_SCOPED) {
            AbstractScopedReferenceStore.SubjectScopedReference scopedRef = new AbstractScopedReferenceStore.SubjectScopedReference();
            oResult = this.putLoaderIfAbsent(mapByLoader, loader, scopedRef);
            if (oResult != null) {
                scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oResult;
            }
            oResult = scopedRef.putIfAbsent(reference);
        } else {
            oResult = this.putLoaderIfAbsent(mapByLoader, loader, reference);
        }
        return oResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(R reference, ClassLoader loader) {
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sName = this.f_supplierName.apply(reference);
        Map mapByLoader = (Map)mapByName.get(sName);
        boolean fFound = false;
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                AbstractScopedReferenceStore.SubjectScopedReference scopedRef;
                Object oHolder = mapByLoader.get(loader);
                if (oHolder == reference) {
                    mapByLoader.remove(loader);
                    fFound = true;
                } else if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference && (scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oHolder).get() == reference) {
                    scopedRef.remove();
                    fFound = true;
                    if (scopedRef.isEmpty()) {
                        mapByLoader.remove(loader);
                    }
                }
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sName);
                }
            }
        }
        return fFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(R reference) {
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sName = this.f_supplierName.apply(reference);
        Map mapByLoader = (Map)mapByName.get(sName);
        boolean fFound = false;
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Collection col = mapByLoader.values();
                fFound = col.remove(reference);
                if (!fFound) {
                    Object oHolder;
                    if (reference instanceof ClassLoaderAware) {
                        return this.release(reference, ((ClassLoaderAware)reference).getContextClassLoader());
                    }
                    Iterator iter = col.iterator();
                    while (iter.hasNext() && (oHolder = iter.next()) instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                        AbstractScopedReferenceStore.SubjectScopedReference scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oHolder;
                        if (scopedRef.get() != reference) continue;
                        scopedRef.remove();
                        fFound = true;
                        if (!scopedRef.isEmpty()) break;
                        iter.remove();
                        break;
                    }
                }
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sName);
                }
            }
        }
        return fFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object putLoaderIfAbsent(Map map, ClassLoader loader, Object oValue) {
        Object oResult;
        Map map2 = map;
        synchronized (map2) {
            oResult = map.get(loader);
            if (oResult == null) {
                map.put(loader, oValue);
            }
        }
        return oResult;
    }
}

