/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.IdentityHolder;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.Releasable;
import com.tangosol.net.internal.AbstractScopedReferenceStore;
import com.tangosol.net.internal.ScopedReferenceStore;
import com.tangosol.net.internal.ScopedServiceReferenceStore;
import com.tangosol.net.security.Security;
import com.tangosol.util.SegmentedConcurrentMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class ScopedCollectionReferenceStore<C extends NamedCollection>
extends ScopedReferenceStore<C> {
    protected Map<IdentityHolder<C>, Object> f_mapPending = new ConcurrentHashMap<IdentityHolder<C>, Object>();

    public ScopedCollectionReferenceStore(Class<C> type) {
        super(type, Releasable::isActive, NamedCollection::getName, NamedCollection::getService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInactiveCollectionRefs() {
        Iterator iterByName = this.m_mapByName.values().iterator();
        while (iterByName.hasNext()) {
            Map mapByLoader;
            Map map = mapByLoader = (Map)iterByName.next();
            synchronized (map) {
                Iterator iter = mapByLoader.entrySet().iterator();
                while (iter.hasNext()) {
                    NamedCollection collection;
                    Collection col;
                    Map.Entry entry = iter.next();
                    Object oHolder = entry.getValue();
                    if (this.f_clsType.isInstance(oHolder)) {
                        NamedCollection collection2 = (NamedCollection)entry.getValue();
                        if (!collection2.isDestroyed() && !collection2.isReleased()) continue;
                        iter.remove();
                        this.internalReleaseCollection(collection2);
                        continue;
                    }
                    if (!(oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) || (col = ((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).values()).isEmpty() || !(collection = (NamedCollection)col.iterator().next()).isDestroyed() && !collection.isReleased()) continue;
                    iter.remove();
                    this.internalReleaseCollection(collection);
                }
                if (mapByLoader.isEmpty()) {
                    iterByName.remove();
                }
            }
        }
    }

    public C getCollection(String sCollectionName, ClassLoader loader) {
        Map mapByLoader = (Map)this.m_mapByName.get(sCollectionName);
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Object oHolder = mapByLoader.get(loader);
                if (oHolder == null || this.f_clsType.isInstance(oHolder)) {
                    return (C)((NamedCollection)oHolder);
                }
                if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                    return (C)((NamedCollection)((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).get());
                }
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    public void putCollection(C col, ClassLoader loader) {
        if (col.isReleased()) {
            throw new IllegalArgumentException("Storing a released collection is not allowed: " + col.getName());
        }
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sCollectionName = col.getName();
        WeakHashMap<ClassLoader, AbstractScopedReferenceStore.SubjectScopedReference> mapByLoader = (WeakHashMap<ClassLoader, AbstractScopedReferenceStore.SubjectScopedReference>)mapByName.get(sCollectionName);
        if (mapByLoader == null) {
            mapByLoader = new WeakHashMap<ClassLoader, AbstractScopedReferenceStore.SubjectScopedReference>();
            mapByName.put(sCollectionName, mapByLoader);
        }
        if (ScopedServiceReferenceStore.isRemoteServiceType(col.getService().getInfo().getServiceType()) && Security.SUBJECT_SCOPED) {
            AbstractScopedReferenceStore.SubjectScopedReference scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)mapByLoader.get(loader);
            if (scopedRef == null) {
                scopedRef = new AbstractScopedReferenceStore.SubjectScopedReference();
                mapByLoader.put(loader, scopedRef);
            }
            scopedRef.set(col);
        } else {
            mapByLoader.put(loader, (AbstractScopedReferenceStore.SubjectScopedReference)col);
        }
    }

    public Object putCollectionIfAbsent(C collection, ClassLoader loader) {
        Object oResult;
        Map mapByLoader;
        if (collection.isReleased()) {
            throw new IllegalArgumentException("Storing a released collection is not allowed: " + collection.getName());
        }
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sCollectionName = collection.getName();
        do {
            Map mapTmp;
            if ((mapByLoader = (WeakHashMap)mapByName.get(sCollectionName)) == null && (mapTmp = (Map)mapByName.putIfAbsent(sCollectionName, mapByLoader = new WeakHashMap())) != null) {
                mapByLoader = mapTmp;
            }
            if (ScopedServiceReferenceStore.isRemoteServiceType(collection.getService().getInfo().getServiceType()) && Security.SUBJECT_SCOPED) {
                AbstractScopedReferenceStore.SubjectScopedReference scopedRef = new AbstractScopedReferenceStore.SubjectScopedReference();
                oResult = this.putLoaderIfAbsent(mapByLoader, loader, scopedRef);
                if (oResult != null) {
                    scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oResult;
                }
                oResult = scopedRef.putIfAbsent(collection);
                continue;
            }
            oResult = this.putLoaderIfAbsent(mapByLoader, loader, collection);
        } while (mapByName.get(sCollectionName) != mapByLoader);
        return oResult;
    }

    public boolean releaseCollection(C collection, ClassLoader loader) {
        return this.releaseCollection(collection, loader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseCollection(C collection, ClassLoader loader, Runnable postRelease) {
        Map map;
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sCollectionName = collection.getName();
        Map mapByLoader = (Map)mapByName.get(sCollectionName);
        boolean fFound = false;
        Object oPending = null;
        IdentityHolder<C> collectionId = new IdentityHolder<C>(collection);
        if (mapByLoader != null) {
            map = mapByLoader;
            synchronized (map) {
                AbstractScopedReferenceStore.SubjectScopedReference scopedRef;
                Object oHolder = mapByLoader.get(loader);
                if (oHolder == collection) {
                    mapByLoader.remove(loader);
                    fFound = true;
                } else if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference && (scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oHolder).get() == collection) {
                    scopedRef.remove();
                    fFound = true;
                    if (scopedRef.isEmpty()) {
                        mapByLoader.remove(loader);
                    }
                }
                if (fFound && postRelease != null) {
                    oPending = new Object();
                    this.f_mapPending.put(collectionId, oPending);
                }
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sCollectionName);
                }
            }
        }
        if (oPending != null) {
            try {
                postRelease.run();
            }
            finally {
                this.f_mapPending.remove(collectionId, oPending);
                map = oPending;
                synchronized (map) {
                    oPending.notifyAll();
                }
            }
        }
        if (!fFound) {
            this.awaitPending(collectionId);
        }
        return fFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseCollection(C collection) {
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sCollectionName = collection.getName();
        Map mapByLoader = (Map)mapByName.get(sCollectionName);
        boolean fFound = false;
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Collection col = mapByLoader.values();
                fFound = col.remove(collection);
                if (!fFound) {
                    Object oHolder;
                    if (collection instanceof ClassLoaderAware) {
                        return this.releaseCollection(collection, ((ClassLoaderAware)collection).getContextClassLoader());
                    }
                    Iterator iter = col.iterator();
                    while (iter.hasNext() && (oHolder = iter.next()) instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                        AbstractScopedReferenceStore.SubjectScopedReference scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oHolder;
                        if (scopedRef.get() != collection) continue;
                        scopedRef.remove();
                        fFound = true;
                        if (!scopedRef.isEmpty()) break;
                        iter.remove();
                        break;
                    }
                }
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sCollectionName);
                }
            }
        }
        return fFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitPending(IdentityHolder<C> collectionId) {
        Object oPending = this.f_mapPending.get(collectionId);
        if (oPending != null) {
            Object object = oPending;
            synchronized (object) {
                if (oPending == this.f_mapPending.get(collectionId)) {
                    try {
                        Blocking.wait(oPending);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object putLoaderIfAbsent(Map map, ClassLoader loader, Object oValue) {
        Object oResult;
        Map map2 = map;
        synchronized (map2) {
            oResult = map.get(loader);
            if (oResult == null) {
                map.put(loader, oValue);
            }
        }
        return oResult;
    }

    private void internalReleaseCollection(C col) {
        try {
            col.release();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

