/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import java.util.Arrays;
import java.util.function.Consumer;

public class PartitionVersionExclusionList {
    protected static final long NO_VALUE = -1L;
    protected final int f_cMinSize;
    protected long[] m_alPartVersions;
    protected int m_cSize;

    public PartitionVersionExclusionList() {
        this(8);
    }

    public PartitionVersionExclusionList(int cMinSize) {
        this.f_cMinSize = cMinSize;
        this.initializeSlots(cMinSize);
    }

    public void exclude(int iPartition, int nVersion) {
        assert (iPartition >= 0);
        assert (nVersion >= 0);
        int iSlot = this.findIndex(iPartition, nVersion);
        if (iSlot < 0) {
            this.insert(iSlot, iPartition, nVersion);
        }
    }

    public void reset(int iPartition) {
        int iSlot;
        while ((iSlot = this.findIndex(iPartition)) != -1) {
            this.removeInternal(iSlot);
        }
    }

    public void reset(int iPartition, int nVersion) {
        int iPartVersion = this.findIndex(iPartition, nVersion);
        if (iPartVersion >= 0) {
            this.removeInternal(iPartVersion);
        }
    }

    public boolean isExcluded(int iPartition, int nVersion) {
        return this.findIndex(iPartition, nVersion) >= 0;
    }

    public boolean isAllowed(int iPartition, int nVersion) {
        return !this.isExcluded(iPartition, nVersion);
    }

    public void forEach(Consumer<Entry> consumer) {
        int cSlots = this.m_alPartVersions.length;
        Entry entry = new Entry();
        for (int i = cSlots - this.m_cSize; i < cSlots; ++i) {
            entry.reset(i);
            consumer.accept(entry);
        }
    }

    protected void removeInternal(int iSlot) {
        int iStart = this.m_alPartVersions.length - this.m_cSize - 1;
        for (int i = iSlot; i > iStart; --i) {
            this.m_alPartVersions[i] = i <= 0 ? 0L : this.m_alPartVersions[i - 1];
        }
        --this.m_cSize;
        this.shrink();
    }

    protected int findIndex(int iPart) {
        long[] alPartVersions = this.m_alPartVersions;
        long lInternal = this.toInternal(iPart, 0);
        int iPartVersion = Arrays.binarySearch(alPartVersions, lInternal);
        if (iPartVersion < 0) {
            int iClosest = -(iPartVersion + 1);
            iPartVersion = iClosest < alPartVersions.length && this.getPartition(alPartVersions[iClosest]) == iPart ? iClosest : -1;
        }
        return iPartVersion;
    }

    protected int findIndex(int iPart, int nVersion) {
        return Arrays.binarySearch(this.m_alPartVersions, this.toInternal(iPart, nVersion));
    }

    protected void insert(int iInsert, int iPartition, int nVersion) {
        assert (iInsert < 0);
        int cSizeDelta = this.ensureCapacity(this.m_cSize + 1);
        long[] alPartVersions = this.m_alPartVersions;
        if (cSizeDelta > 0) {
            iInsert -= cSizeDelta;
        }
        iInsert = -(iInsert + 2);
        for (int i = alPartVersions.length - this.m_cSize; i <= iInsert; ++i) {
            alPartVersions[i - 1] = alPartVersions[i];
        }
        alPartVersions[iInsert] = this.toInternal(iPartition, nVersion);
        ++this.m_cSize;
    }

    protected int ensureCapacity(int cSize) {
        int cSlots = this.m_alPartVersions.length;
        if (cSize >= cSlots) {
            int cNewSlots = Math.min(cSize << 1, cSize + 32);
            int cSizeDelta = cNewSlots - cSize;
            long[] alPartVersions = this.m_alPartVersions;
            this.initializeSlots(cNewSlots);
            System.arraycopy(alPartVersions, 0, this.m_alPartVersions, cSizeDelta, cSlots);
            return cSizeDelta;
        }
        return 0;
    }

    protected void shrink() {
        int cSlots = this.m_alPartVersions.length;
        int cSize = this.m_cSize;
        int cFree = cSlots - cSize;
        if (cSlots > this.f_cMinSize && cFree > Math.max(cSlots >> 2, 16)) {
            int cNewSize = Math.max(this.f_cMinSize, cSlots - (cFree >> 1));
            long[] alPartVersions = this.m_alPartVersions;
            this.initializeSlots(cNewSize);
            System.arraycopy(alPartVersions, cSlots - cSize, this.m_alPartVersions, cNewSize - cSize, cSize);
        }
    }

    protected long toInternal(int iPart, int nVersion) {
        return ((long)iPart & 0xFFFFFFFFL) << 32 | (long)nVersion & 0xFFFFFFFFL;
    }

    protected int getPartition(long lInternal) {
        return (int)(lInternal >>> 32);
    }

    protected int getVersion(long lInternal) {
        return (int)(lInternal & 0xFFFFFFFFL);
    }

    protected void initializeSlots(int cSlots) {
        this.m_alPartVersions = new long[cSlots];
        Arrays.fill(this.m_alPartVersions, 0, cSlots - this.m_cSize, -1L);
    }

    public class Entry {
        protected int m_iSlot;

        protected Entry() {
        }

        protected Entry(int iSlot) {
            this.m_iSlot = iSlot;
        }

        public int getPartition() {
            return PartitionVersionExclusionList.this.getPartition(PartitionVersionExclusionList.this.m_alPartVersions[this.m_iSlot]);
        }

        public int getVersion() {
            return PartitionVersionExclusionList.this.getVersion(PartitionVersionExclusionList.this.m_alPartVersions[this.m_iSlot]);
        }

        protected void reset(int iSlot) {
            this.m_iSlot = iSlot;
        }
    }
}

