/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.internal.PartitionSize;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.function.Remote;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class PartitionSizeAggregator<K, V>
implements InvocableMap.StreamingAggregator<K, V, Map<Integer, PartitionSize>, SortedSet<PartitionSize>>,
ExternalizableLite,
PortableObject {
    private transient Map<Integer, PartitionSize> mapResults = new HashMap<Integer, PartitionSize>();

    @Override
    public InvocableMap.StreamingAggregator<K, V, Map<Integer, PartitionSize>, SortedSet<PartitionSize>> supply() {
        return new PartitionSizeAggregator<K, V>();
    }

    @Override
    public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
        BinaryEntry<K, V> binEntry = entry.asBinaryEntry();
        int partitionId = binEntry.getBackingMapContext().getManagerContext().getKeyPartition(binEntry.getBinaryKey());
        PartitionSize partSize = this.mapResults.computeIfAbsent(partitionId, PartitionSize::new);
        partSize.accumulate(binEntry);
        return true;
    }

    @Override
    public boolean combine(Map<Integer, PartitionSize> partialResult) {
        for (PartitionSize partSizeOther : partialResult.values()) {
            PartitionSize partSizeThis = this.mapResults.computeIfAbsent(partSizeOther.getPartitionId(), PartitionSize::new);
            partSizeThis.combine(partSizeOther);
        }
        return true;
    }

    @Override
    public Map<Integer, PartitionSize> getPartialResult() {
        return this.mapResults;
    }

    @Override
    public SortedSet<PartitionSize> finalizeResult() {
        TreeSet<PartitionSize> result = new TreeSet<PartitionSize>(Remote.comparator(PartitionSize::getPartitionId));
        result.addAll(this.mapResults.values());
        return result;
    }

    @Override
    public int characteristics() {
        return 1;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
    }
}

