/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.cache.BinaryMemoryCalculator;
import com.tangosol.util.BinaryEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PartitionSize
implements ExternalizableLite,
PortableObject {
    private int m_nPartitionId;
    private int m_cCount;
    private long m_nTotalSize;
    private long m_nMaxEntrySize;
    private int m_nMemberId;

    public PartitionSize() {
    }

    public PartitionSize(int nPartitionId) {
        this.m_nPartitionId = nPartitionId;
    }

    public int getPartitionId() {
        return this.m_nPartitionId;
    }

    public int getCount() {
        return this.m_cCount;
    }

    public long getTotalSize() {
        return this.m_nTotalSize;
    }

    public long getMaxEntrySize() {
        return this.m_nMaxEntrySize;
    }

    public int getMemberId() {
        return this.m_nMemberId;
    }

    public void accumulate(BinaryEntry<?, ?> entry) {
        long nEntrySize = BinaryMemoryCalculator.INSTANCE.calculateUnits(entry.getBinaryKey(), entry.getBinaryValue());
        ++this.m_cCount;
        this.m_nTotalSize += nEntrySize;
        if (nEntrySize > this.m_nMaxEntrySize) {
            this.m_nMaxEntrySize = nEntrySize;
        }
        if (this.m_nMemberId == 0) {
            this.m_nMemberId = entry.getContext().getCacheService().getCluster().getLocalMember().getId();
        }
    }

    public void combine(PartitionSize other) {
        this.m_cCount += other.m_cCount;
        this.m_nTotalSize += other.m_nTotalSize;
        this.m_nMemberId = other.m_nMemberId;
        this.m_nMaxEntrySize = Math.max(other.m_nMaxEntrySize, this.m_nMaxEntrySize);
    }

    public String toString() {
        return String.format("#%,d, count=%,d, totalSize=%,d, maxEntrySize=%,d, member=%d", this.m_nPartitionId, this.m_cCount, this.m_nTotalSize, this.m_nMaxEntrySize, this.m_nMemberId);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nPartitionId = in.readInt();
        this.m_cCount = in.readInt();
        this.m_nTotalSize = in.readLong();
        this.m_nMaxEntrySize = in.readLong();
        this.m_nMemberId = in.readInt();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_nPartitionId);
        out.writeInt(this.m_cCount);
        out.writeLong(this.m_nTotalSize);
        out.writeLong(this.m_nMaxEntrySize);
        out.writeInt(this.m_nMemberId);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nPartitionId = in.readInt(0);
        this.m_cCount = in.readInt(1);
        this.m_nTotalSize = in.readLong(2);
        this.m_nMaxEntrySize = in.readLong(3);
        this.m_nMemberId = in.readInt(4);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nPartitionId);
        out.writeInt(1, this.m_cCount);
        out.writeLong(2, this.m_nTotalSize);
        out.writeLong(3, this.m_nMaxEntrySize);
        out.writeInt(4, this.m_nMemberId);
    }
}

