/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class CopyOnWriteLongList {
    protected static final Holder EMPTY_HOLDER = new Holder(new long[0], 0);
    protected static final AtomicReferenceFieldUpdater f_atomicHolder = AtomicReferenceFieldUpdater.newUpdater(CopyOnWriteLongList.class, Holder.class, "m_holder");
    protected volatile Holder m_holder = EMPTY_HOLDER;

    public boolean add(long lValue) {
        Holder holder;
        Holder holderNew;
        boolean fAdded;
        while ((fAdded = (holderNew = CopyOnWriteLongList.cloneAndAdd(lValue, holder = this.m_holder)) != holder) && !f_atomicHolder.compareAndSet(this, holder, holderNew)) {
        }
        return fAdded;
    }

    public boolean contains(long lValue) {
        return Arrays.binarySearch(this.m_holder.m_alValues, lValue) >= 0;
    }

    public boolean remove(long lValue) {
        Holder holder;
        Holder holderNew;
        boolean fRemoved;
        while ((fRemoved = (holderNew = CopyOnWriteLongList.cloneAndRemove(lValue, holder = this.m_holder)) != holder) && !f_atomicHolder.compareAndSet(this, holder, holderNew)) {
        }
        return fRemoved;
    }

    public int size() {
        return this.m_holder.m_cSize;
    }

    public String toString() {
        return "CopyOnWriteLongList" + Arrays.toString(this.m_holder.m_alValues);
    }

    private static Holder cloneAndAdd(long lValue, Holder holder) {
        boolean fForward = lValue < 0L;
        boolean fGrow = holder.isFull();
        long[] al = holder.m_alValues;
        int iInsert = Arrays.binarySearch(al, lValue);
        if (iInsert >= 0) {
            return holder;
        }
        long[] alNew = null;
        int cSize = holder.m_cSize + 1;
        if (fGrow) {
            alNew = new long[al.length + 8];
            System.arraycopy(al, 0, alNew, 0, al.length);
            alNew[al.length] = lValue;
            Arrays.sort(alNew);
        } else {
            iInsert = Math.min(Math.max(-(iInsert + 1), 0), al.length);
            alNew = Arrays.copyOf(al, al.length);
            if (fForward) {
                alNew[iInsert] = lValue;
                int c = al.length;
                for (int i = iInsert; al[i] != 0L && i < c; ++i) {
                    alNew[i + 1] = al[i];
                }
            } else {
                alNew[iInsert - 1] = lValue;
                for (int i = iInsert - 1; al[i] != 0L && i > 0; --i) {
                    alNew[i - 1] = al[i];
                }
            }
        }
        return new Holder(alNew, cSize);
    }

    private static Holder cloneAndRemove(long lValue, Holder holder) {
        long[] al = holder.m_alValues;
        int iValue = Arrays.binarySearch(al, lValue);
        if (iValue < 0) {
            return holder;
        }
        if (holder.m_cSize == 1) {
            return EMPTY_HOLDER;
        }
        int cCurrent = al.length;
        long[] alNew = new long[cCurrent - 1];
        if (iValue > 0) {
            System.arraycopy(al, 0, alNew, 0, iValue);
        }
        if (iValue >= 0 && iValue < cCurrent - 1) {
            System.arraycopy(al, iValue + 1, alNew, iValue, alNew.length - iValue);
        }
        return new Holder(alNew, holder.m_cSize - 1);
    }

    protected static class Holder {
        protected long[] m_alValues;
        protected int m_cSize;

        protected Holder(long[] alValues, int cSize) {
            this.m_alValues = alValues;
            this.m_cSize = cSize;
        }

        protected boolean isFull() {
            return this.m_alValues.length == this.m_cSize;
        }
    }
}

