/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.grpc;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.net.grpc.GrpcDependencies;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public interface GrpcAcceptorController
extends Comparable<GrpcAcceptorController> {
    public static final GrpcAcceptorController NULL_CONTROLLER = new GrpcAcceptorController(){
        private GrpcAcceptorDependencies m_deps;

        @Override
        public void setDependencies(GrpcAcceptorDependencies deps) {
            this.m_deps = deps;
        }

        @Override
        public GrpcAcceptorDependencies getDependencies() {
            return this.m_deps;
        }

        @Override
        public void setDaemonPool(DaemonPool pool) {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public boolean isRunning() {
            return false;
        }

        @Override
        public String getLocalAddress() {
            return "0.0.0.0";
        }

        @Override
        public int getLocalPort() {
            return -1;
        }

        @Override
        public String getInProcessName() {
            return null;
        }

        @Override
        public List<?> getBindableServices() {
            return Collections.emptyList();
        }

        @Override
        public GrpcDependencies.ServerType getServerType() {
            return GrpcDependencies.ServerType.Asynchronous;
        }
    };
    public static final int PRIORITY_NORMAL = 0;

    public void setDependencies(GrpcAcceptorDependencies var1);

    public GrpcAcceptorDependencies getDependencies();

    public void setDaemonPool(DaemonPool var1);

    public void start();

    public void stop();

    public boolean isRunning();

    public String getLocalAddress();

    public String getInProcessName();

    public int getLocalPort();

    public List<?> getBindableServices();

    default public int getPriority() {
        return -1;
    }

    @Override
    default public int compareTo(GrpcAcceptorController o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public static GrpcAcceptorController discoverController() {
        return ServiceLoader.load(GrpcAcceptorController.class).stream().map(GrpcAcceptorController::createInstance).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(NULL_CONTROLLER);
    }

    private static GrpcAcceptorController createInstance(ServiceLoader.Provider<GrpcAcceptorController> provider) {
        try {
            return provider.get();
        }
        catch (Exception e) {
            Logger.err("Error during discovery of GrpcAcceptorController instances", (Throwable)e);
            return null;
        }
    }

    public GrpcDependencies.ServerType getServerType();
}

