/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.tangosol.net.Session;
import com.tangosol.net.events.SessionDispatcher;
import com.tangosol.net.events.SessionLifecycleEvent;
import com.tangosol.net.events.internal.AbstractEventDispatcher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SessionEventDispatcher
extends AbstractEventDispatcher
implements SessionDispatcher {
    protected static final Set<Enum> EVENT_TYPES = new HashSet<Enum>();
    protected final Session f_session;

    public SessionEventDispatcher(Session session) {
        super(EVENT_TYPES);
        this.f_session = session;
    }

    @Override
    public String getName() {
        return this.f_session.getName();
    }

    public void dispatchStarting() {
        this.dispatchEvent(SessionLifecycleEvent.Type.STARTING);
    }

    public void dispatchStarted() {
        this.dispatchEvent(SessionLifecycleEvent.Type.STARTED);
    }

    public void dispatchStopping() {
        this.dispatchEvent(SessionLifecycleEvent.Type.STOPPING);
    }

    public void dispatchStopped() {
        this.dispatchEvent(SessionLifecycleEvent.Type.STOPPED);
    }

    protected void dispatchEvent(SessionLifecycleEvent.Type eventType) {
        List list = (List)this.getInterceptorMap().get((Object)eventType);
        if (list != null) {
            new LifecycleEvent(this, eventType, this.f_session).dispatch(list);
        }
    }

    static {
        EVENT_TYPES.addAll(Arrays.asList(SessionLifecycleEvent.Type.values()));
    }

    protected static class LifecycleEvent
    extends AbstractEvent<SessionLifecycleEvent.Type>
    implements SessionLifecycleEvent {
        private final Session f_session;

        protected LifecycleEvent(SessionEventDispatcher dispatcher, SessionLifecycleEvent.Type eventType, Session coherence) {
            super(dispatcher, eventType);
            this.f_session = coherence;
        }

        @Override
        protected boolean isMutableEvent() {
            return false;
        }

        @Override
        protected String getDescription() {
            return super.getDescription() + ", Session=" + this.getName();
        }

        @Override
        public Session getSession() {
            return this.f_session;
        }
    }

    protected static abstract class AbstractEvent<T extends Enum<T>>
    extends com.tangosol.net.events.internal.AbstractEvent<T> {
        public AbstractEvent(SessionEventDispatcher dispatcher, T eventType) {
            super(dispatcher, eventType);
        }

        public String getName() {
            return ((SessionEventDispatcher)this.m_dispatcher).getName();
        }

        @Override
        public SessionDispatcher getDispatcher() {
            return (SessionDispatcher)this.m_dispatcher;
        }
    }
}

