/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.oracle.coherence.common.base.Disposable;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.NamedEventInterceptor;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.util.Base;
import com.tangosol.util.RegistrationBehavior;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Registry
implements InterceptorRegistry,
EventDispatcherRegistry,
Disposable {
    protected final Map<String, NamedEventInterceptor<?>> m_mapInterceptors = new LinkedHashMap();
    protected final Set<EventDispatcher> m_setDispatchers = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public synchronized String registerEventInterceptor(EventInterceptor<?> interceptor) {
        return this.registerEventInterceptorInternal(null, interceptor, null);
    }

    @Override
    public synchronized String registerEventInterceptor(EventInterceptor<?> interceptor, RegistrationBehavior behavior) {
        return this.registerEventInterceptorInternal(null, interceptor, behavior);
    }

    @Override
    public synchronized String registerEventInterceptor(String sIdentifier, EventInterceptor<?> interceptor, RegistrationBehavior behavior) {
        return this.registerEventInterceptorInternal(sIdentifier, interceptor, behavior);
    }

    @Override
    public synchronized void unregisterEventInterceptor(String sIdentifier) {
        EventInterceptor interceptor;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("Service.registerEventInterceptor"));
        }
        if ((interceptor = (EventInterceptor)this.m_mapInterceptors.remove(sIdentifier)) != null) {
            this.removeInterceptorFromDispatchers(sIdentifier);
        }
    }

    @Override
    public synchronized EventInterceptor<?> getEventInterceptor(String sIdentifier) {
        NamedEventInterceptor<?> incptr = this.m_mapInterceptors.get(sIdentifier);
        return incptr == null ? null : incptr.getInterceptor();
    }

    @Override
    public synchronized void dispose() {
        this.m_setDispatchers.clear();
        this.m_mapInterceptors.clear();
    }

    @Override
    public synchronized void registerEventDispatcher(EventDispatcher dispatcher) {
        this.m_setDispatchers.add(dispatcher);
        this.introduceDispatcher(dispatcher);
    }

    @Override
    public synchronized void unregisterEventDispatcher(EventDispatcher dispatcher) {
        this.m_setDispatchers.remove(dispatcher);
    }

    protected <T extends Event<? extends Enum>> String registerEventInterceptorInternal(String sIdentifier, EventInterceptor<T> interceptor, RegistrationBehavior behavior) {
        NamedEventInterceptor<T> incptrNamed;
        if (interceptor instanceof NamedEventInterceptor) {
            incptrNamed = (NamedEventInterceptor<T>)interceptor;
            if (sIdentifier != null && !incptrNamed.getRegisteredName().equals(sIdentifier)) {
                incptrNamed = new NamedEventInterceptor<T>(sIdentifier, incptrNamed.getInterceptor(), incptrNamed.getCacheName(), incptrNamed.getServiceName(), incptrNamed.getOrder(), behavior == null ? incptrNamed.getBehavior() : behavior, incptrNamed.getEventTypes());
            }
        } else {
            incptrNamed = new NamedEventInterceptor<T>(sIdentifier, interceptor, behavior);
        }
        this.registerEventInterceptorInternal(incptrNamed);
        return incptrNamed.getRegisteredName();
    }

    protected void registerEventInterceptorInternal(NamedEventInterceptor<?> incptrNamed) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("Service.registerEventInterceptor"));
        }
        String sIdentifier = incptrNamed.getRegisteredName();
        RegistrationBehavior behavior = incptrNamed.getBehavior();
        Map<String, NamedEventInterceptor<?>> mapInterceptors = this.m_mapInterceptors;
        if (mapInterceptors.containsKey(sIdentifier)) {
            switch (behavior) {
                case IGNORE: {
                    return;
                }
                case REPLACE: {
                    this.unregisterEventInterceptor(sIdentifier);
                    break;
                }
                case ALWAYS: {
                    for (int i = 0; i < 1024 && mapInterceptors.containsKey(sIdentifier); ++i) {
                        sIdentifier = incptrNamed.generateName();
                    }
                    if (!mapInterceptors.containsKey(sIdentifier)) break;
                }
                case FAIL: {
                    throw new IllegalArgumentException("EventInterceptor " + String.valueOf(incptrNamed) + " is already registered");
                }
            }
        }
        mapInterceptors.put(sIdentifier, incptrNamed);
        try {
            this.introduceInterceptor(incptrNamed);
        }
        catch (Exception e) {
            this.unregisterEventInterceptor(sIdentifier);
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void introduceDispatcher(EventDispatcher dispatcher) {
        for (Map.Entry<String, NamedEventInterceptor<?>> entry : this.m_mapInterceptors.entrySet()) {
            entry.getValue().introduceEventDispatcher(entry.getKey(), dispatcher);
        }
    }

    protected void introduceInterceptor(NamedEventInterceptor incptrNamed) {
        String sIdentifier = incptrNamed.getRegisteredName();
        for (EventDispatcher dispatcher : this.m_setDispatchers) {
            incptrNamed.introduceEventDispatcher(sIdentifier, dispatcher);
        }
    }

    protected void removeInterceptorFromDispatchers(String sIdentifier) {
        for (EventDispatcher dispatcher : this.m_setDispatchers) {
            dispatcher.removeEventInterceptor(sIdentifier);
        }
    }
}

