/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.QueryMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperConcurrentMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WrapperNamedCache<K, V>
extends WrapperConcurrentMap<K, V>
implements NamedCache<K, V> {
    protected String m_sName;
    protected CacheService m_service;

    public WrapperNamedCache(String sName) {
        this(new HashMap(), sName);
    }

    public WrapperNamedCache(Map<K, V> map, String sName) {
        this(map, sName, null);
    }

    public WrapperNamedCache(Map<K, V> map, String sName, CacheService service) {
        super(map, false, -1L);
        this.m_sName = map instanceof NamedCache && sName == null ? ((NamedCache)map).getCacheName() : sName;
        this.m_service = map instanceof NamedCache ? ((NamedCache)map).getCacheService() : service;
    }

    @Override
    public String getCacheName() {
        return this.m_sName;
    }

    @Override
    public CacheService getCacheService() {
        Map map;
        CacheService service = this.m_service;
        if (service == null && (map = this.getMap()) instanceof NamedCache) {
            service = ((NamedCache)map).getCacheService();
        }
        return service;
    }

    @Override
    public boolean isActive() {
        Map map = this.getMap();
        return !(map instanceof NamedCache) || ((NamedCache)map).isActive();
    }

    @Override
    public boolean isReady() {
        Map map = this.getMap();
        return !(map instanceof NamedMap) || ((NamedMap)map).isActive();
    }

    @Override
    public void release() {
        Map map = this.getMap();
        if (map instanceof NamedCache) {
            ((NamedCache)map).release();
        }
    }

    @Override
    public void destroy() {
        Map map = this.getMap();
        if (map instanceof NamedCache) {
            ((NamedCache)map).destroy();
        }
    }

    @Override
    public void truncate() {
        Map map = this.getMap();
        if (map instanceof NamedCache) {
            ((NamedCache)map).truncate();
        } else {
            this.clear();
        }
    }

    @Override
    public boolean isDestroyed() {
        Map map = this.getMap();
        return map instanceof NamedCache && ((NamedCache)map).isDestroyed();
    }

    @Override
    public boolean isReleased() {
        Map map = this.getMap();
        return map instanceof NamedCache && ((NamedCache)map).isReleased();
    }

    @Override
    public Map<K, V> getAll(Collection<? extends K> colKeys) {
        Map map = this.getMap();
        if (map instanceof CacheMap) {
            long ldtStart = WrapperNamedCache.getSafeTimeMillis();
            Map mapResult = ((CacheMap)map).getAll(colKeys);
            if (this.isCollectStats()) {
                int cMisses;
                int cHits = mapResult.size();
                if (cHits > 0) {
                    this.m_stats.registerHits(cHits, ldtStart);
                }
                if ((cMisses = colKeys.size() - cHits) > 0) {
                    this.m_stats.registerMisses(cMisses, ldtStart);
                }
            }
            return mapResult;
        }
        HashMap mapResult = new HashMap(colKeys.size());
        for (K key : colKeys) {
            Object value = this.get(key);
            if (value == null && !this.containsKey(key)) continue;
            mapResult.put(key, value);
        }
        return mapResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public V put(K oKey, V oValue, long cMillis) {
        V oOrig;
        Map mapInner = this.getMap();
        if (mapInner instanceof CacheMap) {
            boolean fForceLock = this.isLockingEnforced();
            if (fForceLock && !this.lock(oKey, this.getWaitMillis())) throw new ConcurrentModificationException("(thread=" + String.valueOf(Thread.currentThread()) + ") " + this.getLockDescription(oKey));
            try {
                long ldtStart;
                boolean fStats = this.isCollectStats();
                long l = ldtStart = fStats ? WrapperNamedCache.getSafeTimeMillis() : 0L;
                if (this.isEventFabricator()) {
                    int nEvent = mapInner.containsKey(oKey) ? 2 : 1;
                    oOrig = ((CacheMap)mapInner).put(oKey, oValue, cMillis);
                    this.dispatchEvent(new CacheEvent<K, V>(this, nEvent, oKey, oOrig, oValue, false));
                } else {
                    oOrig = ((CacheMap)mapInner).put(oKey, oValue, cMillis);
                }
                if (!fStats) return oOrig;
                this.m_stats.registerPut(ldtStart);
                return oOrig;
            }
            finally {
                if (fForceLock) {
                    this.unlock(oKey);
                }
            }
        } else {
            if (cMillis > 0L) throw new UnsupportedOperationException();
            oOrig = super.put(oKey, oValue);
        }
        return oOrig;
    }

    @Override
    public Set<K> keySet(Filter filter) {
        Map map = this.getMap();
        return map instanceof QueryMap ? ((QueryMap)map).keySet(filter) : InvocableMapHelper.query(map, filter, false, false, null);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Filter filter) {
        Map map = this.getMap();
        return map instanceof QueryMap ? ((QueryMap)map).entrySet(filter) : InvocableMapHelper.query(map, filter, true, false, null);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Filter filter, Comparator comparator) {
        Map map = this.getMap();
        return map instanceof QueryMap ? ((QueryMap)map).entrySet(filter, comparator) : InvocableMapHelper.query(map, filter, true, true, comparator);
    }

    @Override
    public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> extractor, boolean fOrdered, Comparator<? super E> comparator) {
        Map map = this.getMap();
        if (map instanceof QueryMap) {
            ((QueryMap)map).addIndex(extractor, fOrdered, comparator);
        }
    }

    @Override
    public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> extractor) {
        Map map = this.getMap();
        if (map instanceof QueryMap) {
            ((QueryMap)map).removeIndex(extractor);
        }
    }

    @Override
    public <R> R invoke(K key, InvocableMap.EntryProcessor<K, V, R> agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).invoke(key, agent);
        }
        return InvocableMapHelper.invokeLocked(this, InvocableMapHelper.makeEntry(this, key), agent);
    }

    @Override
    public <R> Map<K, R> invokeAll(Collection<? extends K> collKeys, InvocableMap.EntryProcessor<K, V, R> agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).invokeAll(collKeys, agent);
        }
        return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, collKeys, false), agent);
    }

    @Override
    public <R> Map<K, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<K, V, R> agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).invokeAll(filter, agent);
        }
        return this.invokeAll(this.keySet(filter), agent);
    }

    @Override
    public <R> R aggregate(Collection<? extends K> collKeys, InvocableMap.EntryAggregator<? super K, ? super V, R> agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).aggregate(collKeys, agent);
        }
        return agent.aggregate(InvocableMapHelper.makeEntrySet(this, collKeys, true));
    }

    @Override
    public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super K, ? super V, R> agent) {
        Map map = this.getMap();
        if (map instanceof InvocableMap) {
            return ((InvocableMap)map).aggregate(filter, agent);
        }
        return this.aggregate(this.keySet(filter), agent);
    }
}

