/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.CachingMap;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.net.cache.SerializationMap;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterEnumerator;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.Gate;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.ThreadGateLite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class SimpleOverflowMap
extends AbstractKeyBasedMap {
    public static final int ENTRY_INSERTED = 1;
    public static final int ENTRY_UPDATED = 2;
    public static final int ENTRY_DELETED = 3;
    static final Map.Entry[] ENTRY_ARRAY = new Map.Entry[0];
    protected ObservableMap m_mapFront;
    protected Map m_mapBack;
    protected Map m_mapMiss;
    private boolean m_fNullValuesAllowed;
    private boolean m_fUseFrontPutAll;
    private Map m_mapStatus = new SafeHashMap();
    private List m_listDeferred = new RecyclingLinkedList();
    private Gate m_gate = new ThreadGateLite();
    private MapListener m_listenerFront;
    protected SimpleCacheStatistics m_stats = new SimpleCacheStatistics();
    private static boolean s_fWarnedEventSequence;

    public SimpleOverflowMap(ObservableMap mapFront, Map mapBack) {
        this(mapFront, mapBack, null);
    }

    public SimpleOverflowMap(ObservableMap mapFront, Map mapBack, Map mapMiss) {
        SimpleOverflowMap.azzert(mapFront != null && mapBack != null);
        this.m_mapFront = mapFront;
        this.m_mapBack = mapBack;
        ImmutableArrayList setInitial = new ImmutableArrayList(mapFront.keySet());
        if (!setInitial.isEmpty()) {
            Map mapStatus = this.getStatusMap();
            for (Object oKey : setInitial) {
                Status status = new Status();
                status.setEntryInFront(true);
                status.setBackUpToDate(false);
                mapStatus.put(oKey, status);
            }
        }
        this.setFrontMapListener(this.instantiateFrontMapListener());
        if (mapMiss != null && !mapMiss.isEmpty()) {
            mapMiss.clear();
        }
        this.m_mapMiss = mapMiss;
        if (!setInitial.isEmpty()) {
            SimpleOverflowMap.verifyNoNulls(mapFront.keySet(), "The front map contains a null key");
            if (!this.isNullValuesAllowed()) {
                SimpleOverflowMap.verifyNoNulls(mapFront.values(), "NullValuesAllowed is false but the front map contains at least one null value");
            }
            SimpleOverflowMap.azzert(mapFront.keySet().equals(setInitial));
        }
        if (mapFront instanceof NamedCache || mapFront instanceof CachingMap || mapFront instanceof SerializationMap || mapFront instanceof BinaryMap || mapFront instanceof OverflowMap || mapFront instanceof SimpleOverflowMap) {
            this.setFrontPutBlind(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.beginMapProcess();
        try {
            MapListener listener = this.getFrontMapListener();
            this.setFrontMapListener(null);
            try {
                Map mapStatus;
                this.getFrontMap().clear();
                this.getBackMap().clear();
                this.getCacheStatistics().resetHitStatistics();
                Map mapMiss = this.getMissCache();
                if (mapMiss != null) {
                    mapMiss.clear();
                }
                Map map = mapStatus = this.getStatusMap();
                synchronized (map) {
                    Iterator iter = mapStatus.values().iterator();
                    while (iter.hasNext()) {
                        Status status;
                        Status status2 = status = (Status)iter.next();
                        synchronized (status2) {
                            assert (status.isOwnedByCurrentThread());
                            status.setEntryInFront(false);
                            status.setBackUpToDate(true);
                            status.takeEvent();
                        }
                    }
                }
                this.getDeferredList().clear();
            }
            finally {
                this.setFrontMapListener(listener);
            }
        }
        finally {
            this.endMapProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object oKey) {
        Status status = this.beginKeyProcess(oKey);
        try {
            if (status.isEntryInFront()) {
                boolean bl = true;
                return bl;
            }
            Map mapMiss = this.getMissCache();
            if (mapMiss != null && mapMiss.containsKey(oKey)) {
                boolean bl = false;
                return bl;
            }
            boolean fContains = this.getBackMap().containsKey(oKey);
            if (!fContains && mapMiss != null) {
                mapMiss.put(oKey, null);
            }
            boolean bl = fContains;
            return bl;
        }
        finally {
            this.endKeyProcess(oKey, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object oKey) {
        long ldtStart;
        boolean fContains;
        Object oValue;
        block20: {
            oValue = null;
            fContains = false;
            ldtStart = SimpleOverflowMap.getSafeTimeMillis();
            Status status = this.beginKeyProcess(oKey);
            try {
                if (status.isEntryInFront()) {
                    MapEvent evt;
                    fContains = true;
                    ObservableMap mapFront = this.getFrontMap();
                    oValue = mapFront.get(oKey);
                    ObservableMap observableMap = mapFront;
                    synchronized (observableMap) {
                        evt = status.closeProcessing();
                    }
                    if (evt != null) {
                        switch (evt.getId()) {
                            case 1: 
                            case 2: {
                                if (oValue != null) break;
                                oValue = evt.getNewValue();
                                break;
                            }
                            case 3: {
                                if (oValue != null) break;
                                oValue = evt.getOldValue();
                            }
                        }
                        this.processFrontEvent(status, evt);
                    }
                    break block20;
                }
                Map mapMiss = this.getMissCache();
                if (mapMiss != null && mapMiss.containsKey(oKey)) break block20;
                Map mapBack = this.getBackMap();
                oValue = mapBack.get(oKey);
                boolean bl = fContains = oValue != null || this.isNullValuesAllowed() && mapBack.containsKey(oKey);
                if (fContains) {
                    MapEvent evt;
                    ObservableMap mapFront = this.getFrontMap();
                    SimpleOverflowMap.putOne(mapFront, oKey, oValue, this.isFrontPutBlind());
                    status.setEntryInFront(true);
                    status.setBackUpToDate(true);
                    ObservableMap observableMap = mapFront;
                    synchronized (observableMap) {
                        evt = status.closeProcessing();
                    }
                    if (evt != null && evt.getId() != 1) {
                        this.processFrontEvent(status, evt);
                    }
                    break block20;
                }
                if (mapMiss != null) {
                    mapMiss.put(oKey, null);
                }
            }
            finally {
                this.endKeyProcess(oKey, status);
            }
        }
        if (fContains) {
            this.m_stats.registerHit(ldtStart);
        } else {
            this.m_stats.registerMiss(ldtStart);
        }
        return oValue;
    }

    @Override
    public boolean isEmpty() {
        if (this.getFrontMap().isEmpty() && this.getBackMap().isEmpty()) {
            this.beginMapProcess();
            try {
                boolean bl = this.getFrontMap().isEmpty() && this.getBackMap().isEmpty();
                return bl;
            }
            finally {
                this.endMapProcess();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object oKey, Object oValue) {
        if (oValue == null && !this.isNullValuesAllowed()) {
            throw new IllegalArgumentException("null value is unsupported(key=\"" + String.valueOf(oKey) + "\")");
        }
        long ldtStart = SimpleOverflowMap.getSafeTimeMillis();
        Object oOldValue = null;
        Status status = this.beginKeyProcess(oKey);
        try {
            ObservableMap mapFront = this.getFrontMap();
            Map mapBack = this.getBackMap();
            Map mapMiss = this.getMissCache();
            boolean fEntryWasInFront = status.isEntryInFront();
            boolean fBackWasUpToDate = status.isBackUpToDate();
            boolean fOldValue = false;
            boolean fEvicted = false;
            if (fEntryWasInFront) {
                oOldValue = mapFront.put(oKey, oValue);
                if (oOldValue != null) {
                    fOldValue = true;
                }
            } else {
                SimpleOverflowMap.putOne(mapFront, oKey, oValue, this.isFrontPutBlind());
            }
            status.setEntryInFront(true);
            status.setBackUpToDate(false);
            MapEvent evt = status.closeProcessing();
            if (evt == null) {
                if (!fOldValue && fEntryWasInFront && !fBackWasUpToDate) {
                    fOldValue = true;
                }
            } else {
                switch (evt.getId()) {
                    case 1: 
                    case 2: {
                        if (!fEntryWasInFront || fOldValue) break;
                        oOldValue = evt.getOldValue();
                        fOldValue = true;
                        break;
                    }
                    case 3: {
                        if (fEntryWasInFront && !fOldValue) {
                            oOldValue = evt.getOldValue();
                            fOldValue = true;
                        }
                        status.setEntryInFront(false);
                        fEvicted = true;
                    }
                }
            }
            if (mapMiss != null && mapMiss.containsKey(oKey)) {
                mapMiss.remove(oKey);
                fOldValue = true;
            }
            if (fEvicted && !fOldValue) {
                oOldValue = mapBack.put(oKey, oValue);
            } else if (fEvicted) {
                SimpleOverflowMap.putOne(mapBack, oKey, oValue, true);
                status.setBackUpToDate(true);
            } else if (!fOldValue) {
                assert (!fEntryWasInFront);
                oOldValue = mapBack.get(oKey);
            }
        }
        finally {
            this.endKeyProcess(oKey, status);
        }
        this.m_stats.registerPut(ldtStart);
        return oOldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map map) {
        Object[] aoKey;
        long ldtStart = SimpleOverflowMap.getSafeTimeMillis();
        if (this.isNullValuesAllowed()) {
            aoKey = map.keySet().toArray();
        } else {
            int i = 0;
            int c = map.size();
            aoKey = new Object[c];
            for (Map.Entry entry : map.entrySet()) {
                try {
                    aoKey[i++] = entry.getKey();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw Base.ensureRuntimeException(e, "a modification was detected in the passed map during iteration");
                }
                if (entry.getValue() != null) continue;
                throw new IllegalArgumentException("null value is unsupported(putAll: " + String.valueOf(map) + ")");
            }
            if (i != c) {
                throw new IllegalStateException("a modification was detected in the passed map during iteration");
            }
        }
        Status[] astatus = this.beginBulkKeyProcess(aoKey);
        try {
            ObservableMap mapFront = this.getFrontMap();
            mapFront.putAll(map);
            block13: for (Status status : astatus) {
                MapEvent evt;
                ObservableMap observableMap = mapFront;
                synchronized (observableMap) {
                    evt = status.closeProcessing();
                }
                if (evt == null) continue;
                switch (evt.getId()) {
                    case 1: 
                    case 2: {
                        status.setEntryInFront(true);
                        status.setBackUpToDate(false);
                        continue block13;
                    }
                    case 3: {
                        Object oKey = evt.getKey();
                        SimpleOverflowMap.putOne(this.getBackMap(), oKey, map.get(oKey), true);
                        status.setEntryInFront(false);
                        status.setBackUpToDate(true);
                    }
                }
            }
            Map mapMiss = this.getMissCache();
            if (mapMiss != null) {
                mapMiss.keySet().removeAll(map.keySet());
            }
        }
        finally {
            this.endBulkKeyProcess(aoKey, astatus);
        }
        this.m_stats.registerPuts(map.size(), ldtStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object oKey) {
        Object oValue;
        block14: {
            oValue = null;
            Status status = this.beginKeyProcess(oKey);
            try {
                if (status.isEntryInFront()) {
                    MapEvent evt;
                    ObservableMap mapFront = this.getFrontMap();
                    mapFront.keySet().remove(oKey);
                    ObservableMap observableMap = mapFront;
                    synchronized (observableMap) {
                        evt = status.closeProcessing();
                    }
                    if (evt != null) {
                        if (evt.getId() == 3) {
                            oValue = evt.getOldValue();
                            status.setEntryInFront(false);
                            status.setBackUpToDate(true);
                        } else {
                            this.processFrontEvent(status, evt);
                        }
                    }
                    this.getBackMap().keySet().remove(oKey);
                    break block14;
                }
                Map mapMiss = this.getMissCache();
                if (mapMiss == null || !mapMiss.containsKey(oKey)) {
                    Map mapBack = this.getBackMap();
                    boolean fContains = mapBack.containsKey(oKey);
                    if (fContains) {
                        oValue = mapBack.remove(oKey);
                    } else if (mapMiss != null) {
                        mapMiss.put(oKey, null);
                    }
                }
            }
            finally {
                this.endKeyProcess(oKey, status);
            }
        }
        return oValue;
    }

    @Override
    public int size() {
        try {
            Map mapBack = this.getBackMap();
            int c = mapBack.size();
            for (Map.Entry entry : this.getStatusMap().entrySet()) {
                Status status = (Status)entry.getValue();
                if (!status.isValid() || !status.isEntryInFront() || mapBack.containsKey(entry.getKey())) continue;
                ++c;
            }
            return c;
        }
        catch (ConcurrentModificationException e) {
            return super.size();
        }
    }

    protected Iterator iterateKeys() {
        return new KeyIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeBlind(Object oKey) {
        boolean fDidContain;
        block11: {
            fDidContain = false;
            Status status = this.beginKeyProcess(oKey);
            try {
                if (status.isEntryInFront()) {
                    MapEvent evt;
                    ObservableMap mapFront = this.getFrontMap();
                    mapFront.keySet().remove(oKey);
                    ObservableMap observableMap = mapFront;
                    synchronized (observableMap) {
                        evt = status.closeProcessing();
                    }
                    if (evt != null) {
                        if (evt.getId() == 3) {
                            status.setEntryInFront(false);
                            status.setBackUpToDate(true);
                        } else {
                            this.processFrontEvent(status, evt);
                        }
                    }
                    this.getBackMap().keySet().remove(oKey);
                    fDidContain = true;
                    break block11;
                }
                Map mapMiss = this.getMissCache();
                if (!(mapMiss != null && mapMiss.containsKey(oKey) || (fDidContain = this.getBackMap().keySet().remove(oKey)) || mapMiss == null)) {
                    mapMiss.put(oKey, null);
                }
            }
            finally {
                this.endKeyProcess(oKey, status);
            }
        }
        return fDidContain;
    }

    public ObservableMap getFrontMap() {
        return this.m_mapFront;
    }

    public Map getBackMap() {
        return this.m_mapBack;
    }

    public Map getMissCache() {
        return this.m_mapMiss;
    }

    public void setMissCache(Map mapMiss) {
        this.m_mapMiss = mapMiss;
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    protected Gate getGate() {
        return this.m_gate;
    }

    protected Map getStatusMap() {
        return this.m_mapStatus;
    }

    protected List getDeferredList() {
        return this.m_listDeferred;
    }

    public boolean isNullValuesAllowed() {
        return this.m_fNullValuesAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNullValuesAllowed(boolean fAllowNulls) {
        this.beginMapProcess();
        try {
            SimpleOverflowMap simpleOverflowMap = this;
            synchronized (simpleOverflowMap) {
                if (fAllowNulls != this.isNullValuesAllowed()) {
                    if (!fAllowNulls && !this.getStatusMap().isEmpty()) {
                        SimpleOverflowMap.azzert(!this.values().contains(null), "NullValuesAllowed cannot be set to false because the SimpleOverflowMap contains null values");
                    }
                    this.m_fNullValuesAllowed = fAllowNulls;
                }
            }
        }
        finally {
            this.endMapProcess();
        }
    }

    public boolean isFrontPutBlind() {
        return this.m_fUseFrontPutAll;
    }

    public void setFrontPutBlind(boolean fUseFrontPutAll) {
        this.m_fUseFrontPutAll = fUseFrontPutAll;
    }

    protected MapListener getFrontMapListener() {
        return this.m_listenerFront;
    }

    protected void setFrontMapListener(MapListener listener) {
        ObservableMap mapFront = this.getFrontMap();
        SimpleOverflowMap.azzert(mapFront != null);
        MapListener listenerOld = this.m_listenerFront;
        if (listener != listenerOld) {
            if (listenerOld != null) {
                mapFront.removeMapListener(listenerOld);
                this.m_listenerFront = null;
            }
            if (listener != null) {
                mapFront.addMapListener(listener);
                this.m_listenerFront = listener;
            }
        }
    }

    protected MapListener instantiateFrontMapListener() {
        return new FrontMapListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onFrontEvent(MapEvent evt) {
        Gate gate = this.getGate();
        boolean fReentrant = gate.isEnteredByCurrentThread();
        if (!fReentrant) {
            gate.enter(-1L);
        }
        try {
            Map mapStatus = this.getStatusMap();
            Object oKey = evt.getKey();
            while (true) {
                Status status;
                Object object = mapStatus;
                synchronized (object) {
                    status = (Status)mapStatus.get(oKey);
                    if (status == null) {
                        status = this.instantiateStatus();
                        mapStatus.put(oKey, status);
                    }
                }
                object = status;
                synchronized (object) {
                    if (status.isValid()) {
                        if (!status.registerFrontEvent(evt)) return;
                        this.getDeferredList().add(oKey);
                        return;
                    }
                }
            }
        }
        finally {
            if (!fReentrant) {
                gate.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFrontEvent(Status status, MapEvent evt) {
        assert (status.isOwnedByCurrentThread() && (status.isProcessing() || status.isCommitting()));
        if (evt != null) {
            Status status2 = status;
            synchronized (status2) {
                switch (evt.getId()) {
                    case 1: {
                        status.setEntryInFront(true);
                        status.setBackUpToDate(false);
                        Map mapMiss = this.getMissCache();
                        if (mapMiss == null) break;
                        mapMiss.remove(evt.getKey());
                        break;
                    }
                    case 2: {
                        status.setEntryInFront(true);
                        status.setBackUpToDate(false);
                        break;
                    }
                    case 3: {
                        status.setEntryInFront(false);
                        if (status.isBackUpToDate()) break;
                        this.getBackMap().put(evt.getKey(), evt.getOldValue());
                        status.setBackUpToDate(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status beginKeyProcess(Object oKey) {
        Gate gate = this.getGate();
        boolean fReentrant = gate.isEnteredByCurrentThread();
        gate.enter(-1L);
        if (!fReentrant) {
            this.processDeferredEvents();
        }
        while (true) {
            Status status;
            Map mapStatus = this.getStatusMap();
            Object object = mapStatus;
            synchronized (object) {
                status = (Status)mapStatus.get(oKey);
                if (status == null) {
                    status = this.instantiateStatus();
                    mapStatus.put(oKey, status);
                }
            }
            object = status;
            synchronized (object) {
                if (status.isValid()) {
                    MapEvent evtDeferred = status.waitForAvailable();
                    if (evtDeferred != null) {
                        this.processFrontEvent(status, evtDeferred);
                    }
                    return status;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endKeyProcess(Object oKey, Status status) {
        Map mapStatus;
        Map map = mapStatus = this.getStatusMap();
        synchronized (map) {
            Status status2 = status;
            synchronized (status2) {
                if (status.isProcessing()) {
                    this.processFrontEvent(status, status.closeProcessing());
                }
                if (status.commitAndMaybeInvalidate()) {
                    mapStatus.remove(oKey);
                }
            }
        }
        this.getGate().exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status[] beginBulkKeyProcess(Object[] aoKey) {
        int cKeys = aoKey.length;
        Status[] aStatus = new Status[cKeys];
        switch (cKeys) {
            case 0: {
                break;
            }
            case 1: {
                aStatus[0] = this.beginKeyProcess(aoKey[0]);
                break;
            }
            default: {
                this.getGate().enter(-1L);
                this.processDeferredEvents();
                Map mapStatus = this.getStatusMap();
                boolean fDone = false;
                int cIters = 0;
                while (!fDone) {
                    int i;
                    boolean fSuccess = true;
                    int cReserved = 0;
                    while (fSuccess && cReserved < cKeys) {
                        Status status;
                        Object oKey = aoKey[cReserved];
                        Object object = mapStatus;
                        synchronized (object) {
                            status = (Status)mapStatus.get(oKey);
                            if (status == null) {
                                status = this.instantiateStatus();
                                mapStatus.put(oKey, status);
                            }
                        }
                        object = status;
                        synchronized (object) {
                            if (status.isValid()) {
                                if (status.requestReservation()) {
                                    aStatus[cReserved++] = status;
                                } else {
                                    fSuccess = false;
                                }
                            } else {
                                fSuccess = false;
                            }
                        }
                    }
                    if (fSuccess) {
                        for (int i2 = 0; i2 < cKeys; ++i2) {
                            MapEvent evtDeferred = aStatus[i2].useReservation();
                            if (evtDeferred == null) continue;
                            this.processFrontEvent(aStatus[i2], evtDeferred);
                        }
                        fDone = true;
                        continue;
                    }
                    Map i2 = mapStatus;
                    synchronized (i2) {
                        for (i = 0; i < cReserved; ++i) {
                            Status status;
                            Status status2 = status = aStatus[i];
                            synchronized (status2) {
                                if (status.commitAndMaybeInvalidate()) {
                                    mapStatus.remove(aoKey[i]);
                                }
                            }
                            aStatus[i] = null;
                        }
                    }
                    switch (cIters++) {
                        case 0: {
                            boolean fComparable = true;
                            for (i = 0; i < cKeys; ++i) {
                                if (aoKey[i] instanceof Comparable) continue;
                                fComparable = false;
                            }
                            if (fComparable) {
                                Arrays.sort(aoKey);
                                break;
                            }
                            Arrays.sort(aoKey, HashcodeComparator.INSTANCE);
                            break;
                        }
                        case 1: {
                            Thread.yield();
                            break;
                        }
                        default: {
                            try {
                                Blocking.sleep(cIters);
                                break;
                            }
                            catch (InterruptedException e) {
                                Thread.interrupted();
                                this.getGate().exit();
                                throw SimpleOverflowMap.ensureRuntimeException(e);
                            }
                        }
                    }
                }
                break block9;
            }
        }
        return aStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endBulkKeyProcess(Object[] aoKey, Status[] aStatus) {
        int cStatus = aStatus.length;
        switch (cStatus) {
            case 0: {
                break;
            }
            case 1: {
                this.endKeyProcess(aoKey[0], aStatus[0]);
                break;
            }
            default: {
                Map mapStatus;
                Map map = mapStatus = this.getStatusMap();
                synchronized (map) {
                    for (int i = 0; i < cStatus; ++i) {
                        Status status;
                        Status status2 = status = aStatus[i];
                        synchronized (status2) {
                            if (status.isProcessing()) {
                                this.processFrontEvent(status, status.closeProcessing());
                            }
                            if (status.commitAndMaybeInvalidate()) {
                                mapStatus.remove(aoKey[i]);
                            }
                            continue;
                        }
                    }
                }
                this.getGate().exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginMapProcess() {
        Map mapStatus;
        Gate gate = this.getGate();
        gate.close(-1L);
        gate.enter(-1L);
        Map map = mapStatus = this.getStatusMap();
        synchronized (map) {
            Iterator iter = mapStatus.values().iterator();
            while (iter.hasNext()) {
                Status status;
                Status status2 = status = (Status)iter.next();
                synchronized (status2) {
                    assert (status.isAvailable() || status.isOwnedByCurrentThread());
                    MapEvent evtDeferred = status.waitForAvailable();
                    if (evtDeferred != null) {
                        this.processFrontEvent(status, evtDeferred);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endMapProcess() {
        Map mapStatus;
        Map map = mapStatus = this.getStatusMap();
        synchronized (map) {
            for (Map.Entry entry : mapStatus.entrySet()) {
                Status status;
                Status status2 = status = (Status)entry.getValue();
                synchronized (status2) {
                    if (status.isProcessing()) {
                        this.processFrontEvent(status, status.closeProcessing());
                    }
                    if (status.commitAndMaybeInvalidate()) {
                        mapStatus.remove(entry.getKey());
                    }
                }
            }
        }
        Gate gate = this.getGate();
        gate.exit();
        gate.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeferredEvents() {
        List listDeferred = this.getDeferredList();
        if (!listDeferred.isEmpty()) {
            int cTarget = Math.max(10, Math.min(100, listDeferred.size() >>> 7));
            int cProcessed = 0;
            Map mapStatus = this.getStatusMap();
            do {
                Status status;
                Object oKey = null;
                try {
                    oKey = listDeferred.remove(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (oKey == null || (status = (Status)mapStatus.get(oKey)) == null) continue;
                boolean fOwned = false;
                Status status2 = status;
                synchronized (status2) {
                    if (status.isValid() && status.isAvailable()) {
                        MapEvent evtDeferred = status.waitForAvailable();
                        fOwned = true;
                        if (evtDeferred != null) {
                            this.processFrontEvent(status, evtDeferred);
                        }
                    }
                }
                if (fOwned) {
                    MapEvent evtJustHappened = status.closeProcessing();
                    if (evtJustHappened != null) {
                        this.processFrontEvent(status, evtJustHappened);
                    }
                    Map map = mapStatus;
                    synchronized (map) {
                        Status status3 = status;
                        synchronized (status3) {
                            if (status.commitAndMaybeInvalidate()) {
                                mapStatus.remove(oKey);
                            }
                        }
                    }
                    ++cProcessed;
                    continue;
                }
                listDeferred.add(oKey);
            } while (!listDeferred.isEmpty() && cProcessed < cTarget);
        }
    }

    protected static void verifyNoNulls(Collection collection, String sAssert) {
        boolean fHasNull = false;
        try {
            fHasNull = collection.contains(null);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        SimpleOverflowMap.azzert(!fHasNull, sAssert);
    }

    protected static void putOne(Map map, Object oKey, Object oValue, boolean fPutBlind) {
        try {
            if (fPutBlind) {
                map.putAll(Collections.singletonMap(oKey, oValue));
            } else {
                map.put(oKey, oValue);
            }
        }
        catch (NullPointerException e) {
            SimpleOverflowMap.out("null pointer exception occurred during putOne()\nMap=" + String.valueOf(map) + "\nKey=" + String.valueOf(oKey) + "\nValue=" + String.valueOf(oValue) + "\nPutBlind=" + fPutBlind + "\nException=" + String.valueOf(e));
            throw e;
        }
    }

    protected static void warnEventSequence(MapEvent evtOld, MapEvent evtNew) {
        if (!s_fWarnedEventSequence) {
            s_fWarnedEventSequence = true;
            SimpleOverflowMap.log("Overflow Map has detected an illegal event sequence:\nEvent 1: " + String.valueOf(evtOld) + "\nEvent 2: " + String.valueOf(evtNew) + "\nThis warning will not be repeated. Stack trace follows:\n" + SimpleOverflowMap.getStackTrace());
        }
    }

    protected Status instantiateStatus() {
        return new Status();
    }

    protected static class Status {
        protected static final int STATE_MASK_STATUS = 7;
        protected static final int STATE_MASK_FRONT = 8;
        protected static final int STATE_MASK_INSYNC = 16;
        protected static final int STATUS_AVAILABLE = 0;
        protected static final int STATUS_RESERVED = 1;
        protected static final int STATUS_PROCESSING = 2;
        protected static final int STATUS_COMMITTING = 3;
        protected static final int STATUS_INVALIDATED = 4;
        protected static final int STATE_MASK_RETAIN = 31;
        protected static final int STATE_VALUE_RETAIN = 16;
        private Thread m_threadOwner;
        private byte m_cWaiting;
        private volatile byte m_nState = 0;
        private volatile MapEvent m_evtFront;

        protected int getStatus() {
            return this.extractState(7);
        }

        protected void setStatus(int nStatus) {
            this.updateState(7, nStatus);
        }

        public boolean isValid() {
            return this.getStatus() != 4;
        }

        public boolean isAvailable() {
            return this.getStatus() == 0;
        }

        public boolean isReserved() {
            return this.getStatus() == 1;
        }

        public boolean isProcessing() {
            return this.getStatus() == 2;
        }

        public boolean isCommitting() {
            return this.getStatus() == 3;
        }

        public Thread getOwnerThread() {
            return this.m_threadOwner;
        }

        protected void setOwnerThread(Thread thread) {
            this.m_threadOwner = thread;
        }

        public boolean isOwnedByCurrentThread() {
            Thread thread = this.getOwnerThread();
            return thread != null && thread == Thread.currentThread();
        }

        public boolean isEntryInFront() {
            return this.extractFlag(8);
        }

        public void setEntryInFront(boolean fEntryInFront) {
            this.updateFlag(8, fEntryInFront);
        }

        public boolean isBackUpToDate() {
            return this.extractFlag(16);
        }

        public void setBackUpToDate(boolean fUpToDate) {
            this.updateFlag(16, fUpToDate);
        }

        protected MapEvent getFrontEvent() {
            return this.m_evtFront;
        }

        protected void setFrontEvent(MapEvent evt) {
            this.m_evtFront = evt;
        }

        public boolean hasEvent() {
            return this.getFrontEvent() != null;
        }

        public synchronized MapEvent takeEvent() {
            assert (this.isProcessing() || this.isCommitting());
            MapEvent evt = this.getFrontEvent();
            if (evt != null) {
                this.setFrontEvent(null);
            }
            return evt;
        }

        protected boolean isDiscardable() {
            return this.extractState(31) == 16 && !this.hasEvent();
        }

        public String getDescription() {
            return "Valid=" + this.isValid() + ", Available=" + this.isAvailable() + ", Processing=" + this.isProcessing() + ", Committing=" + this.isCommitting() + ", OwnerThread=" + String.valueOf(this.getOwnerThread()) + ", OwnedByCurrentThread=" + this.isOwnedByCurrentThread() + ", EntryInFront=" + this.isEntryInFront() + ", BackUpToDate=" + this.isBackUpToDate() + ", hasEvent=" + this.hasEvent() + ", FrontEvent=" + String.valueOf(this.getFrontEvent()) + ", Discardable=" + this.isDiscardable();
        }

        public String toString() {
            return "Status{" + this.getDescription() + "}";
        }

        protected MapEvent waitForAvailable() {
            boolean fRegisteredWaiting = false;
            try {
                while (!this.isAvailable()) {
                    assert (this.isValid());
                    if (this.isOwnedByCurrentThread()) {
                        throw new IllegalStateException("Re-entrancy is not supported (State=" + this.getState() + ")");
                    }
                    if (!fRegisteredWaiting) {
                        int cWaiting = this.m_cWaiting & 0xFF;
                        if (cWaiting == 255) {
                            throw new IllegalStateException("Exceeded maximum number of waiting threads (Status=" + this.getStatus() + ")");
                        }
                        this.m_cWaiting = (byte)(cWaiting + 1);
                        fRegisteredWaiting = true;
                    }
                    Blocking.wait(this);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
            finally {
                if (fRegisteredWaiting) {
                    this.m_cWaiting = (byte)(this.m_cWaiting - 1);
                }
            }
            this.setStatus(2);
            this.setOwnerThread(Thread.currentThread());
            return this.takeEvent();
        }

        protected synchronized boolean requestReservation() {
            boolean fSuccess = false;
            if (this.isAvailable()) {
                this.setStatus(1);
                this.setOwnerThread(Thread.currentThread());
                fSuccess = true;
            } else if (this.isOwnedByCurrentThread()) {
                throw new IllegalStateException("Re-entrancy is not supported (State=" + this.getState() + ")");
            }
            return fSuccess;
        }

        protected void waitForReservationDecision() {
            boolean fRegisteredWaiting = false;
            try {
                while (this.isReserved()) {
                    assert (this.isValid());
                    if (!fRegisteredWaiting) {
                        int cWaiting = this.m_cWaiting & 0xFF;
                        if (cWaiting == 255) {
                            throw new IllegalStateException("Exceeded maximum number of waiting threads (Status=" + this.getStatus() + ")");
                        }
                        this.m_cWaiting = (byte)(cWaiting + 1);
                        fRegisteredWaiting = true;
                    }
                    Blocking.wait(this);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
            finally {
                if (fRegisteredWaiting) {
                    this.m_cWaiting = (byte)(this.m_cWaiting - 1);
                }
            }
        }

        protected synchronized MapEvent useReservation() {
            assert (this.isReserved());
            assert (this.getOwnerThread() == Thread.currentThread());
            this.setStatus(2);
            if (this.m_cWaiting != 0) {
                this.notifyAll();
            }
            return this.takeEvent();
        }

        public synchronized MapEvent closeProcessing() {
            assert (this.isProcessing());
            assert (this.getOwnerThread() == Thread.currentThread());
            this.setStatus(3);
            return this.takeEvent();
        }

        protected boolean commitAndMaybeInvalidate() {
            assert (this.isReserved() || this.isCommitting());
            assert (this.isOwnedByCurrentThread());
            boolean fInvalidated = false;
            boolean fWasReserved = this.isReserved();
            this.setStatus(0);
            if (this.m_cWaiting != 0) {
                if (fWasReserved) {
                    this.notifyAll();
                } else {
                    this.notify();
                }
            } else if (this.isDiscardable()) {
                this.setStatus(4);
                fInvalidated = true;
            }
            this.setOwnerThread(null);
            return fInvalidated;
        }

        public synchronized boolean registerFrontEvent(MapEvent evt) {
            assert (this.isValid());
            MapEvent evtOld = this.getFrontEvent();
            if (evtOld != null) {
                evt = this.mergeEvents(evtOld, evt);
            }
            this.setFrontEvent(evt);
            return !this.isProcessing();
        }

        protected MapEvent mergeEvents(MapEvent evtOld, MapEvent evtNew) {
            CacheEvent evtResult = evtNew;
            boolean fCreate = true;
            int nId = evtNew.getId();
            switch (evtOld.getId() << 2 | nId) {
                case 6: {
                    nId = 1;
                    break;
                }
                case 7: {
                    fCreate = false;
                    if (evtNew instanceof CacheEvent && ((CacheEvent)evtNew).isSynthetic()) break;
                    evtResult = null;
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    break;
                }
                case 13: {
                    nId = 2;
                    break;
                }
                default: {
                    SimpleOverflowMap.warnEventSequence(evtOld, evtNew);
                    fCreate = false;
                }
            }
            if (fCreate) {
                ObservableMap map = evtNew.getMap();
                Object oKey = evtNew.getKey();
                Object oValueOld = evtOld.getOldValue();
                Object oValueNew = evtNew.getNewValue();
                boolean fSynthetic = evtNew instanceof CacheEvent && ((CacheEvent)evtNew).isSynthetic();
                boolean fPriming = evtNew instanceof CacheEvent && ((CacheEvent)evtNew).isPriming();
                evtResult = new CacheEvent(map, nId, oKey, oValueOld, oValueNew, fSynthetic, fPriming);
            }
            return evtResult;
        }

        protected int getState() {
            return this.m_nState;
        }

        protected void setState(int nState) {
            this.m_nState = (byte)nState;
        }

        protected int extractState(int nMask) {
            return this.getState() & nMask;
        }

        protected void updateState(int nMask, int nValue) {
            assert ((nValue & ~nMask) == 0);
            int nStateOld = this.getState();
            int nStateNew = nStateOld & ~nMask | nValue;
            if (nStateNew != nStateOld) {
                this.setState((byte)nStateNew);
            }
        }

        protected boolean extractFlag(int nMask) {
            return this.extractState(nMask) != 0;
        }

        protected void updateFlag(int nMask, boolean f) {
            this.updateState(nMask, f ? nMask : 0);
        }
    }

    protected class KeyIterator
    implements Iterator {
        private static final int ITERATE_INITIAL = 0;
        private static final int ITERATE_FRONT = 1;
        private static final int ITERATE_BACK = 2;
        private static final int ITERATE_SNAPSHOT = 3;
        private static final int ITERATE_DONE = 4;
        private int m_nMode = 0;
        private Iterator m_iter = NullImplementation.getIterator();
        private Collection m_collPrevKeys;
        private boolean m_fNextKeyReady;
        private Object m_oNextKey;
        private boolean m_fCanDelete;
        private Object m_oPrevKey;

        @Override
        public boolean hasNext() {
            if (this.m_fNextKeyReady) {
                return true;
            }
            return this.advance();
        }

        public Object next() {
            if (!this.m_fNextKeyReady && !this.advance()) {
                throw new NoSuchElementException();
            }
            Object oKey = this.m_oNextKey;
            this.m_fNextKeyReady = false;
            this.m_fCanDelete = true;
            this.m_oPrevKey = oKey;
            return oKey;
        }

        @Override
        public void remove() {
            if (!this.m_fCanDelete) {
                throw new IllegalStateException();
            }
            this.m_fCanDelete = false;
            SimpleOverflowMap.this.remove(this.m_oPrevKey);
        }

        protected boolean advance() {
            assert (!this.m_fNextKeyReady);
            while (true) {
                Object oKey;
                boolean fNext;
                Iterator iter = this.m_iter;
                try {
                    fNext = iter.hasNext();
                    oKey = fNext ? (Object)iter.next() : null;
                }
                catch (ConcurrentModificationException e) {
                    int nMode = this.m_nMode;
                    if (nMode == 1 || nMode == 2) {
                        this.useSnapshotIterator();
                        continue;
                    }
                    throw e;
                }
                if (fNext) {
                    Collection collPrevKeys = this.m_collPrevKeys;
                    if (collPrevKeys != null && !collPrevKeys.add(oKey)) continue;
                    this.m_oNextKey = oKey;
                    this.m_fNextKeyReady = true;
                    return true;
                }
                switch (this.m_nMode) {
                    case 0: {
                        this.useFrontIterator();
                        break;
                    }
                    case 1: {
                        this.useBackIterator();
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.useDoneIterator();
                    }
                    case 4: {
                        return false;
                    }
                }
            }
        }

        protected void useFrontIterator() {
            assert (this.m_nMode == 0);
            Iterator iter = SimpleOverflowMap.this.getStatusMap().entrySet().iterator();
            FrontFilterConverter filter = FrontFilterConverter.INSTANCE;
            FrontFilterConverter conv = FrontFilterConverter.INSTANCE;
            this.m_nMode = 1;
            this.m_iter = new ConverterEnumerator((Iterator)new FilterEnumerator(iter, (Filter)filter), (Converter)conv);
            this.m_collPrevKeys = new ArrayList();
        }

        protected void useBackIterator() {
            assert (this.m_nMode == 1);
            Iterator iter = SimpleOverflowMap.this.getBackMap().keySet().iterator();
            this.m_nMode = 2;
            this.m_iter = iter;
            this.m_collPrevKeys = new HashSet(this.m_collPrevKeys);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void useSnapshotIterator() {
            Map mapStatus = SimpleOverflowMap.this.getStatusMap();
            Map mapBack = SimpleOverflowMap.this.getBackMap();
            HashSet setKeys = new HashSet(mapStatus.size() + mapBack.size());
            for (Map.Entry entry : mapStatus.entrySet().toArray(ENTRY_ARRAY)) {
                Status status = (Status)entry.getValue();
                if (!status.isValid() || !status.isEntryInFront()) continue;
                setKeys.add(entry.getKey());
            }
            Map.Entry[] aEntry = null;
            try {
                setKeys.addAll(mapBack.keySet());
            }
            catch (ConcurrentModificationException e) {
                Object[] aoKey;
                Map map = mapBack;
                synchronized (map) {
                    aoKey = mapBack.keySet().toArray();
                }
                setKeys.addAll(new ImmutableArrayList(aoKey));
                aoKey = null;
            }
            Collection collPrevKeys = this.m_collPrevKeys;
            if (collPrevKeys != null) {
                setKeys.removeAll(collPrevKeys);
            }
            this.m_nMode = 3;
            this.m_iter = setKeys.iterator();
            this.m_collPrevKeys = null;
        }

        protected void useDoneIterator() {
            this.m_nMode = 4;
            this.m_iter = NullImplementation.getIterator();
            this.m_collPrevKeys = null;
            this.m_oNextKey = null;
        }
    }

    protected class FrontMapListener
    extends MultiplexingMapListener {
        protected FrontMapListener() {
        }

        protected void onMapEvent(MapEvent evt) {
            SimpleOverflowMap.this.onFrontEvent(evt);
        }
    }

    protected static class HashcodeComparator
    implements Comparator {
        public static final HashcodeComparator INSTANCE = new HashcodeComparator();

        protected HashcodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            int n2;
            int n1 = o1 == null ? 0 : o1.hashCode();
            int n = n2 = o2 == null ? 0 : o2.hashCode();
            return n1 > n2 ? 1 : (n1 == n2 ? 0 : -1);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }

    protected static class FrontFilterConverter
    implements Filter,
    Converter {
        public static final FrontFilterConverter INSTANCE = new FrontFilterConverter();

        protected FrontFilterConverter() {
        }

        public boolean evaluate(Object o) {
            Status status = (Status)((Map.Entry)o).getValue();
            return status.isValid() && status.isEntryInFront();
        }

        @Override
        public Object convert(Object o) {
            return ((Map.Entry)o).getKey();
        }
    }
}

