/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SimpleMemoryCalculator
extends Base
implements ConfigurableCacheMap.UnitCalculator {
    public static final int SIZE_OBJECT_REF;
    public static final int SIZE_OBJECT;
    public static final int SIZE_BOOLEAN;
    public static final int SIZE_BYTE;
    public static final int SIZE_SHORT;
    public static final int SIZE_CHARACTER;
    public static final int SIZE_INTEGER;
    public static final int SIZE_FLOAT;
    public static final int SIZE_LONG;
    public static final int SIZE_DOUBLE;
    public static final int SIZE_DATE;
    public static final int SIZE_TIMESTAMP;
    public static final int SIZE_BIGINTEGER;
    public static final int SIZE_BIGDECIMAL;
    public static final int SIZE_STRING;
    public static final int SIZE_BINARY;
    public static final int SIZE_ENTRY;
    public static final Map MAP_FIXED_SIZES;
    public static final Map MAP_PRIMITIVE_SIZES;
    protected static final int SIZE_BASIC_OBJECT;

    @Override
    public int calculateUnits(Object oKey, Object oValue) {
        return oKey == null ? this.sizeOf(oValue) : this.getEntrySize() + this.sizeOf(oKey) + this.sizeOf(oValue);
    }

    @Override
    public String getName() {
        return ClassHelper.getSimpleName(this.getClass());
    }

    protected int getEntrySize() {
        return SIZE_ENTRY;
    }

    public int sizeOf(Object o) {
        int cb;
        if (o == null) {
            throw new IllegalArgumentException("value is null");
        }
        Class<?> clz = o.getClass();
        Integer IBytes = (Integer)MAP_FIXED_SIZES.get(clz);
        if (IBytes != null) {
            cb = IBytes;
        } else if (clz.equals(String.class)) {
            cb = SIZE_STRING + SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4 + 2 * ((String)o).length());
        } else if (clz.equals(Binary.class)) {
            cb = SIZE_BINARY + SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4 + ((Binary)o).length());
        } else if (clz.isArray()) {
            int cElements = Array.getLength(o);
            Class<?> clzElement = clz.getComponentType();
            IBytes = (Integer)MAP_FIXED_SIZES.get(clzElement);
            cb = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4 + cElements * (IBytes == null ? SIZE_OBJECT_REF : IBytes));
            if (IBytes == null) {
                try {
                    for (int i = 0; i < cElements; ++i) {
                        cb += this.sizeOf(Array.get(o, i));
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
        } else {
            throw new IllegalArgumentException("Unsupported type: " + clz.getName());
        }
        return cb;
    }

    protected int sizeOf(Class clz) {
        Base.azzert(clz != null);
        Integer cb = (Integer)MAP_FIXED_SIZES.get(clz);
        if (cb == null) {
            throw new IllegalArgumentException("Unsupported type: " + clz.getName());
        }
        return cb;
    }

    protected static int padMemorySize(int cb) {
        return (int)SimpleMemoryCalculator.pad(cb, 8L);
    }

    protected static int calculateShallowSize(Class clz) {
        int cb;
        if (clz == null) {
            throw new IllegalArgumentException("class is null");
        }
        Integer IBytes = (Integer)MAP_PRIMITIVE_SIZES.get(clz);
        if (IBytes == null) {
            cb = SIZE_BASIC_OBJECT;
            try {
                do {
                    Field[] aField;
                    if (SimpleMemoryCalculator.isInnerClass(clz)) {
                        cb += SIZE_OBJECT_REF;
                    }
                    int cField = (aField = clz.getDeclaredFields()) == null ? 0 : aField.length;
                    for (int i = 0; i < cField; ++i) {
                        Field field = aField[i];
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        IBytes = (Integer)MAP_PRIMITIVE_SIZES.get(field.getType());
                        cb += IBytes == null ? SIZE_OBJECT_REF : IBytes;
                    }
                } while ((clz = clz.getSuperclass()) != null);
            }
            catch (SecurityException e) {
                throw SimpleMemoryCalculator.ensureRuntimeException(e, "Error calculating the shallow size of: " + String.valueOf(clz));
            }
        } else {
            cb = IBytes;
        }
        return SimpleMemoryCalculator.padMemorySize(cb);
    }

    public static boolean isInnerClass(Class clz) {
        return clz.getEnclosingClass() != null && (clz.getModifiers() & 8) == 0;
    }

    private static int calculateObjectRefSize(int nBits) {
        if (nBits == 64) {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            try {
                for (String sParam : bean.getInputArguments()) {
                    if (sParam.indexOf("+UseCompressedOops") > 0) {
                        return 4;
                    }
                    if (sParam.indexOf("-UseCompressedOops") <= 0) continue;
                    return 8;
                }
                long cb = Runtime.getRuntime().maxMemory();
                if (cb >= 0x800000000L) {
                    return 8;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 4;
    }

    public static void main(String[] asArg) {
        if (asArg.length > 0) {
            String sClass = asArg[0];
            try {
                SimpleMemoryCalculator.log(sClass + "=" + SimpleMemoryCalculator.calculateShallowSize(Class.forName(sClass)));
            }
            catch (Exception e) {
                SimpleMemoryCalculator.log("Could not load class: " + sClass);
            }
        } else {
            SimpleMemoryCalculator calc = new SimpleMemoryCalculator();
            SimpleMemoryCalculator.log("SIZE_OBJECT_REF=" + SIZE_OBJECT_REF);
            SimpleMemoryCalculator.log("SIZE_BASIC_OBJECT=" + SIZE_BASIC_OBJECT);
            SimpleMemoryCalculator.log("SIZE_OBJECT=" + SIZE_OBJECT);
            SimpleMemoryCalculator.log("SIZE_BOOLEAN=" + SIZE_BOOLEAN);
            SimpleMemoryCalculator.log("SIZE_BYTE=" + SIZE_BYTE);
            SimpleMemoryCalculator.log("SIZE_SHORT=" + SIZE_SHORT);
            SimpleMemoryCalculator.log("SIZE_CHARACTER=" + SIZE_CHARACTER);
            SimpleMemoryCalculator.log("SIZE_INTEGER=" + SIZE_INTEGER);
            SimpleMemoryCalculator.log("SIZE_FLOAT=" + SIZE_FLOAT);
            SimpleMemoryCalculator.log("SIZE_LONG=" + SIZE_LONG);
            SimpleMemoryCalculator.log("SIZE_DOUBLE=" + SIZE_DOUBLE);
            SimpleMemoryCalculator.log("SIZE_DATE=" + SIZE_DATE);
            SimpleMemoryCalculator.log("SIZE_TIMESTAMP=" + SIZE_TIMESTAMP);
            SimpleMemoryCalculator.log("SIZE_BIGINTEGER=" + SIZE_BIGINTEGER);
            SimpleMemoryCalculator.log("SIZE_BIGDECIMAL=" + SIZE_BIGDECIMAL);
            SimpleMemoryCalculator.log("SIZE_STRING=" + SIZE_STRING);
            SimpleMemoryCalculator.log("SIZE_BINARY=" + SIZE_BINARY);
            SimpleMemoryCalculator.log("SIZE_ENTRY=" + SIZE_ENTRY);
            SimpleMemoryCalculator.log("sizeof(\"hello world\")=" + calc.sizeOf("hello world"));
            SimpleMemoryCalculator.log("sizeof(0x010203040506070809)=" + calc.sizeOf(new Binary(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9})));
        }
    }

    static {
        String sValue = System.getProperty("sun.arch.data.model");
        int nBits = 32;
        try {
            nBits = Integer.parseInt(sValue);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        SIZE_OBJECT_REF = SimpleMemoryCalculator.calculateObjectRefSize(nBits);
        SIZE_BASIC_OBJECT = SIZE_OBJECT_REF + nBits / 8;
        SIZE_OBJECT = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT);
        SIZE_BOOLEAN = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 1);
        SIZE_BYTE = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 1);
        SIZE_SHORT = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 2);
        SIZE_CHARACTER = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 2);
        SIZE_INTEGER = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4);
        SIZE_FLOAT = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4);
        SIZE_LONG = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 8);
        SIZE_DOUBLE = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 8);
        SIZE_DATE = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + SIZE_OBJECT_REF + 8);
        SIZE_TIMESTAMP = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + SIZE_OBJECT_REF + 12);
        SIZE_BIGINTEGER = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 48);
        SIZE_BIGDECIMAL = SimpleMemoryCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4 + SIZE_OBJECT_REF) + SIZE_BIGINTEGER;
        HashMap<Class<Object>, Integer> map = new HashMap<Class<Object>, Integer>();
        map.put(Boolean.TYPE, 1);
        map.put(Byte.TYPE, 1);
        map.put(Short.TYPE, 2);
        map.put(Character.TYPE, 2);
        map.put(Integer.TYPE, 4);
        map.put(Float.TYPE, 4);
        map.put(Long.TYPE, 8);
        map.put(Double.TYPE, 8);
        MAP_PRIMITIVE_SIZES = Collections.unmodifiableMap(map);
        map = new HashMap(map);
        map.put(Object.class, SIZE_OBJECT);
        map.put(Enum.class, SIZE_OBJECT + SIZE_INTEGER);
        map.put(Boolean.class, SIZE_BOOLEAN);
        map.put(Byte.class, SIZE_BYTE);
        map.put(Short.class, SIZE_SHORT);
        map.put(Character.class, SIZE_CHARACTER);
        map.put(Integer.class, SIZE_INTEGER);
        map.put(Float.class, SIZE_FLOAT);
        map.put(Long.class, SIZE_LONG);
        map.put(Double.class, SIZE_DOUBLE);
        map.put(java.util.Date.class, SIZE_DATE);
        map.put(Date.class, SIZE_DATE);
        map.put(Time.class, SIZE_DATE);
        map.put(Timestamp.class, SIZE_TIMESTAMP);
        map.put(BigInteger.class, SIZE_BIGINTEGER);
        map.put(BigDecimal.class, SIZE_BIGDECIMAL);
        MAP_FIXED_SIZES = Collections.unmodifiableMap(map);
        SIZE_STRING = SimpleMemoryCalculator.calculateShallowSize(String.class);
        SIZE_BINARY = SimpleMemoryCalculator.calculateShallowSize(Binary.class);
        SIZE_ENTRY = SimpleMemoryCalculator.calculateShallowSize(LocalCache.Entry.class);
    }
}

