/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.io.BinaryStore;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.net.cache.AbstractSerializationCache;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Daemon;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.SimpleEnumerator;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SerializationPagedCache
extends AbstractSerializationCache {
    private XmlElement m_xmlConfig;
    private BinaryStoreManager m_storemgr;
    private List m_listStores = new SafeLinkedList();
    private boolean m_fPassiveBackup;
    private boolean m_fVirtualErase = true;
    private long m_cPageMillis = 3600000L;
    private boolean m_fAsyncDeactivate = true;
    private long m_ldtCurrentPage;
    private ConcurrentMap m_mapLocks = new SegmentedConcurrentMap();
    private int m_cSecondsLockDelay = 60;
    private int m_cWorkerThreads;
    private static boolean s_fDebug = false;

    public SerializationPagedCache(BinaryStoreManager storemgr, int cPages, int cPageSecs) {
        super(null);
        this.init(storemgr, cPages, cPageSecs);
    }

    public SerializationPagedCache(BinaryStoreManager storemgr, int cPages, int cPageSecs, ClassLoader loader) {
        super(null, loader);
        this.init(storemgr, cPages, cPageSecs);
    }

    public SerializationPagedCache(BinaryStoreManager storemgr, int cPages, int cPageSecs, boolean fBinaryMap, boolean fPassive) {
        super(null, fBinaryMap);
        this.setPassivePagedBackup(fPassive);
        this.init(storemgr, cPages, cPageSecs);
    }

    private void init(BinaryStoreManager storemgr, int cPages, int cPageSecs) {
        if (cPages < 2) {
            throw new IllegalArgumentException("Minimum page count is 2; specified value is " + cPages);
        }
        if (cPages > 3600) {
            throw new IllegalArgumentException("Maximum page count is 3600; specified value is " + cPages);
        }
        if (cPageSecs < 5) {
            throw new IllegalArgumentException("Minimum page duration is 5 seconds; specified value is " + cPageSecs + " seconds.");
        }
        if (cPageSecs > 604800) {
            throw new IllegalArgumentException("Maximum page duration is 604800 seconds (one week); specified value is " + cPageSecs + " seconds.");
        }
        this.m_cPageMillis = (long)cPageSecs * 1000L;
        this.m_storemgr = storemgr;
        if (storemgr == null) {
            this.setBinaryStore(null);
        } else {
            this.setBinaryStore(this.instantiatePagedStore(cPages));
        }
    }

    public XmlElement getConfig() {
        return this.m_xmlConfig;
    }

    public void setConfig(XmlElement xml) {
        SerializationPagedCache.azzert(this.getConfig() == null, "The SerializationPagedCache has already been configured.");
        SerializationPagedCache.azzert(this.isEmpty(), "The SerializationPagedCache cannot be configured once it contains data.");
        this.m_xmlConfig = xml;
        if (xml != null) {
            this.setPageDuration(xml.getSafeElement("page-duration-seconds").getLong(this.getPageDuration() / 1000L) * 1000L);
            this.setLockDelaySeconds(xml.getSafeElement("lock-delay-seconds").getInt(this.getLockDelaySeconds()));
            this.setVirtualErase(xml.getSafeElement("virtual-erase").getBoolean(this.isVirtualErase()));
            this.setAsynchronousPageDeactivation(xml.getSafeElement("async-page-deactivation").getBoolean(this.isAsynchronousPageDeactivation()));
            this.setPassivePagedBackup(xml.getSafeElement("passive-paged-backup").getBoolean(this.isPassivePagedBackup()));
            if (SerializationPagedCache.isDebug()) {
                SerializationPagedCache.log("SerializationPagedCache after setConfig():\n" + this.toString());
            }
        }
    }

    @Override
    public void clear() {
        this.lockInternal(ConcurrentMap.LOCK_ALL);
        try {
            super.clear();
        }
        finally {
            this.unlockInternal(ConcurrentMap.LOCK_ALL);
        }
    }

    @Override
    public Object get(Object oKey) {
        this.lockInternal(oKey);
        try {
            Object object = super.get(oKey);
            return object;
        }
        finally {
            this.unlockInternal(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object oKey, Object oValue) {
        this.checkPage();
        this.lockInternal(oKey);
        try {
            Object object = super.put(oKey, oValue);
            return object;
        }
        finally {
            this.unlockInternal(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map map) {
        this.checkPage();
        boolean fSinglePut = map.size() == 1;
        for (Map.Entry entry : map.entrySet()) {
            Object oKey = entry.getKey();
            this.lockInternal(oKey);
            try {
                super.putAll(fSinglePut ? map : Collections.singletonMap(oKey, entry.getValue()));
            }
            finally {
                this.unlockInternal(oKey);
            }
        }
    }

    @Override
    public Object remove(Object oKey) {
        this.lockInternal(oKey);
        try {
            Object object = super.remove(oKey);
            return object;
        }
        finally {
            this.unlockInternal(oKey);
        }
    }

    @Override
    protected boolean removeBlind(Object oKey) {
        this.lockInternal(oKey);
        try {
            boolean bl = super.removeBlind(oKey);
            return bl;
        }
        finally {
            this.unlockInternal(oKey);
        }
    }

    @Override
    protected void eraseStore() {
        PagedBinaryStore storePaged = this.getPagedBinaryStore();
        WrapperBinaryStore storeCurrent = storePaged.getCurrentPage();
        for (WrapperBinaryStore storeWrapped : storePaged.getActivePageArray()) {
            if (storeWrapped == null || storeWrapped == storeCurrent) continue;
            storeWrapped.destroy();
        }
        BinaryStore storeRealCurrent = storeCurrent.getBinaryStore();
        Iterator iter = this.iterateBinaryStores();
        while (iter.hasNext()) {
            BinaryStore store = (BinaryStore)iter.next();
            if (store == storeRealCurrent) continue;
            this.destroyBinaryStore(store);
        }
        storeCurrent.eraseAll();
    }

    @Override
    public void evict() {
        this.checkPage();
    }

    @Override
    public String toString() {
        return "SerializationPagedCache {" + this.getDescription() + "}";
    }

    @Override
    protected String getDescription() {
        return super.getDescription() + ", PageDurationMillis=" + this.getPageDuration() + ", MaximumPages=" + this.getMaximumPages() + ", LockDelaySeconds=" + this.getLockDelaySeconds() + ", VirtualErase=" + this.isVirtualErase() + ", AsynchronousPageDeactivation=" + this.isAsynchronousPageDeactivation() + ", PassivePagedBackup=" + this.isPassivePagedBackup() + ", Debug=" + SerializationPagedCache.isDebug();
    }

    public boolean isVirtualErase() {
        return this.m_fVirtualErase;
    }

    protected void setVirtualErase(boolean fVirtualErase) {
        this.m_fVirtualErase = fVirtualErase;
    }

    public int getLockDelaySeconds() {
        return this.m_cSecondsLockDelay;
    }

    public void setLockDelaySeconds(int cSecondsLockDelay) {
        this.m_cSecondsLockDelay = cSecondsLockDelay;
    }

    protected ConcurrentMap getLockMap() {
        return this.m_mapLocks;
    }

    protected BinaryStoreManager getBinaryStoreManager() {
        return this.m_storemgr;
    }

    @Override
    protected void setBinaryStore(BinaryStore store) {
        PagedBinaryStore storeOld = this.getPagedBinaryStore();
        PagedBinaryStore storeNew = (PagedBinaryStore)store;
        if (storeOld != null) {
            storeOld.close();
        }
        super.setBinaryStore(storeNew);
        if (storeNew != null) {
            this.advancePage();
        }
    }

    protected PagedBinaryStore getPagedBinaryStore() {
        return (PagedBinaryStore)this.getBinaryStore();
    }

    protected List getBinaryStoreList() {
        return this.m_listStores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator iterateBinaryStores() {
        List list;
        List list2 = list = this.getBinaryStoreList();
        synchronized (list2) {
            return new SimpleEnumerator<Object>(list.toArray());
        }
    }

    public int getMaximumPages() {
        return this.getPagedBinaryStore().getMaximumPages();
    }

    public long getPageDuration() {
        return this.m_cPageMillis;
    }

    protected void setPageDuration(long cPageMillis) {
        this.m_cPageMillis = cPageMillis;
    }

    protected long getCurrentPageTime() {
        return this.m_ldtCurrentPage;
    }

    protected long getPageAdvanceTime() {
        long lPrev = this.getCurrentPageTime();
        return lPrev == 0L ? 0L : lPrev + this.getPageDuration();
    }

    public boolean isPassivePagedBackup() {
        return this.m_fPassiveBackup;
    }

    protected void setPassivePagedBackup(boolean fPassiveBackup) {
        this.m_fPassiveBackup = fPassiveBackup;
    }

    public boolean isAsynchronousPageDeactivation() {
        return this.m_fAsyncDeactivate;
    }

    public void setAsynchronousPageDeactivation(boolean fAsync) {
        this.m_fAsyncDeactivate = fAsync;
    }

    public static boolean isDebug() {
        return s_fDebug;
    }

    public static void setDebug(boolean fDebug) {
        s_fDebug = fDebug;
    }

    protected void lockInternal(Object oKey) {
        ConcurrentMap mapLocks = this.getLockMap();
        if (SerializationPagedCache.isDebug()) {
            if (mapLocks.lock(oKey)) {
                return;
            }
            SerializationPagedCache.log("Queuing for lock on \"" + String.valueOf(oKey) + "\"");
            long ldtStart = SerializationPagedCache.getSafeTimeMillis();
            if (mapLocks.lock(oKey, (long)this.getLockDelaySeconds() * 1000L)) {
                long ldtStop = SerializationPagedCache.getSafeTimeMillis();
                SerializationPagedCache.log("Lock  on \"" + String.valueOf(oKey) + "\" obtained after " + (ldtStop - ldtStart) + "ms.");
                return;
            }
            String sMsg = "Unable to obtain lock on \"" + String.valueOf(oKey) + "\" within the interval of " + this.getLockDelaySeconds() + " seconds; aborting lock due to debug mode.";
            SerializationPagedCache.log(sMsg);
            throw new RuntimeException(sMsg);
        }
        while (!mapLocks.lock(oKey, -1L)) {
            Thread.yield();
        }
    }

    protected boolean lockInternalNoWait(Object oKey) {
        return this.getLockMap().lock(oKey);
    }

    protected void unlockInternal(Object oKey) {
        this.getLockMap().unlock(oKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BinaryStore createBinaryStore() {
        List list;
        BinaryStoreManager mgr = this.getBinaryStoreManager();
        SerializationPagedCache.azzert(mgr != null, "BinaryStoreManager is required by createBinaryStore().");
        BinaryStore store = mgr.createBinaryStore();
        SerializationPagedCache.azzert(store != null);
        List list2 = list = this.getBinaryStoreList();
        synchronized (list2) {
            SerializationPagedCache.azzert(!list.contains(store));
            list.add(store);
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyBinaryStore(BinaryStore store) {
        List list;
        SerializationPagedCache.azzert(store != null);
        if (store instanceof FakeBinaryStore) {
            return;
        }
        if (SerializationPagedCache.isDebug()) {
            SerializationPagedCache.log("destroyBinaryStore: " + String.valueOf(store));
        }
        List list2 = list = this.getBinaryStoreList();
        synchronized (list2) {
            if (list.contains(store)) {
                this.getBinaryStoreManager().destroyBinaryStore(store);
                list.remove(store);
            } else if (SerializationPagedCache.isDebug()) {
                SerializationPagedCache.log("destroyBinaryStore: The specified BinaryStore is not registered; skipping.");
            }
        }
    }

    protected synchronized void checkPage() {
        if (SerializationPagedCache.getSafeTimeMillis() > this.getPageAdvanceTime()) {
            this.advancePage();
        }
    }

    protected synchronized void advancePage() {
        WrapperBinaryStore storeNew = this.instantiateWrapperStore(this.createBinaryStore());
        final WrapperBinaryStore storeOld = this.getPagedBinaryStore().advanceCurrentPage(storeNew);
        if (SerializationPagedCache.isDebug()) {
            SerializationPagedCache.log("SerializationPagedCache: Processing advancePage(), Current-System-Time=" + SerializationPagedCache.formatDateTime(SerializationPagedCache.getSafeTimeMillis()) + ", Current-Page-Time=" + SerializationPagedCache.formatDateTime(this.getCurrentPageTime()) + ", Page-Duration=" + this.getPageDuration() + "ms, Page-Advance-Time=" + SerializationPagedCache.formatDateTime(this.getPageAdvanceTime()) + ", Passive-Paged-Backup=" + this.isPassivePagedBackup() + ", Store-New=" + String.valueOf(storeNew) + ", Store-Old=" + String.valueOf(storeOld));
        }
        this.m_ldtCurrentPage = SerializationPagedCache.getSafeTimeMillis();
        if (storeOld != null && !this.isPassivePagedBackup()) {
            if (this.isAsynchronousPageDeactivation()) {
                this.runTask(new Runnable(){

                    @Override
                    public void run() {
                        SerializationPagedCache.this.deactivatePage(storeOld);
                    }
                });
            } else {
                this.deactivatePage(storeOld);
            }
        }
    }

    protected void runTask(final Runnable task) {
        Daemon daemon = new Daemon("SerializationPagedCache-" + ++this.m_cWorkerThreads, 5, false){

            @Override
            public void run() {
                task.run();
            }
        };
        daemon.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivatePage(WrapperBinaryStore store) {
        try {
            Object[] aoKey = null;
            while (aoKey == null) {
                try {
                    aoKey = SimpleEnumerator.toArray(store.keys());
                }
                catch (ConcurrentModificationException concurrentModificationException) {}
            }
            HashSet setEvict = new HashSet();
            setEvict.addAll(new ImmutableArrayList(aoKey));
            Map mapBinKeys = this.getPagedBinaryStore().getPagedKeyMap();
            int cIters = 0;
            while (!setEvict.isEmpty()) {
                if (cIters++ > 0) {
                    if (SerializationPagedCache.isDebug()) {
                        SerializationPagedCache.log("Iteration #" + cIters + " in deactivatePage().");
                    }
                    try {
                        Blocking.sleep(cIters * 10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Iterator iter = setEvict.iterator();
                while (iter.hasNext()) {
                    Binary binKey = (Binary)iter.next();
                    Object oKey = this.fromBinary(binKey);
                    if (!this.lockInternalNoWait(oKey)) continue;
                    try {
                        if (mapBinKeys.get(binKey) == store) {
                            if (this.hasListeners()) {
                                this.dispatchPendingEvent(oKey, 3, null, true);
                            }
                            this.unregisterKey(oKey);
                        }
                        iter.remove();
                    }
                    finally {
                        this.unlockInternal(oKey);
                    }
                }
            }
        }
        catch (Throwable e) {
            SerializationPagedCache.err("An exception has been thrown during deactivatePage() processing:");
            SerializationPagedCache.err(e);
            SerializationPagedCache.err("(Exception has been logged; deactivatePage() will simply discard the page.)");
        }
        finally {
            BinaryStore storeActual = store.getBinaryStore();
            if (storeActual != null) {
                this.destroyBinaryStore(storeActual);
            }
        }
    }

    protected PagedBinaryStore instantiatePagedStore(int cPages) {
        return new PagedBinaryStore(cPages);
    }

    protected WrapperBinaryStore instantiateWrapperStore(BinaryStore store) {
        return new WrapperBinaryStore(store);
    }

    protected FakeBinaryStore instantiateFakeBinaryStore() {
        return new FakeBinaryStore();
    }

    public class PagedBinaryStore
    extends Base
    implements BinaryStore {
        private Map m_mapKeys = new SafeHashMap();
        private int m_cPages;
        private int m_cMaxPages;
        private WrapperBinaryStore[] m_astore;

        public PagedBinaryStore(int cPages) {
            this.m_cMaxPages = cPages;
            this.m_astore = new WrapperBinaryStore[cPages];
        }

        @Override
        public Binary load(Binary binKey) {
            Binary binValue = null;
            WrapperBinaryStore store = (WrapperBinaryStore)this.getPagedKeyMap().get(binKey);
            if (store != null) {
                binValue = store.load(binKey);
            }
            return binValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store(Binary binKey, Binary binValue) {
            Map mapKeys = this.getPagedKeyMap();
            WrapperBinaryStore storeNew = this.getCurrentPage();
            if (storeNew == null) {
                throw new IllegalStateException("PagedBinaryStore.store(" + String.valueOf(binKey) + ", " + String.valueOf(binValue) + "): No current page available.");
            }
            storeNew.store(binKey, binValue);
            try {
                WrapperBinaryStore storeOld = (WrapperBinaryStore)mapKeys.get(binKey);
                if (storeOld != null && storeOld != storeNew) {
                    try {
                        storeOld.erase(binKey);
                    }
                    catch (Exception e) {
                        this.logException(e, "store");
                    }
                }
            }
            finally {
                mapKeys.put(binKey, storeNew);
            }
        }

        @Override
        public void erase(Binary binKey) {
            WrapperBinaryStore storeOld = (WrapperBinaryStore)this.getPagedKeyMap().remove(binKey);
            if (storeOld != null) {
                try {
                    storeOld.erase(binKey);
                }
                catch (Exception e) {
                    this.logException(e, "erase");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eraseAll() {
            try {
                for (WrapperBinaryStore store : this.getActivePageArray()) {
                    if (store == null) continue;
                    try {
                        store.eraseAll();
                    }
                    catch (Exception e) {
                        this.logException(e, "eraseAll");
                    }
                }
            }
            finally {
                this.getPagedKeyMap().clear();
            }
        }

        public Iterator keys() {
            Map map = this.getPagedKeyMap();
            Object[] aoKey = map.keySet().toArray();
            return new SimpleEnumerator<Object>(aoKey);
        }

        public void close() {
            if (SerializationPagedCache.isDebug()) {
                PagedBinaryStore.log("SerializationPagedCache: Performing close().");
            }
            for (WrapperBinaryStore storeWrapped : this.getActivePageArray()) {
                if (storeWrapped == null) continue;
                storeWrapped.destroy();
            }
            Iterator iter = SerializationPagedCache.this.iterateBinaryStores();
            while (iter.hasNext()) {
                BinaryStore store = (BinaryStore)iter.next();
                SerializationPagedCache.this.destroyBinaryStore(store);
            }
            if (SerializationPagedCache.isDebug()) {
                PagedBinaryStore.log("SerializationPagedCache: Completed close().");
            }
        }

        public int getMaximumPages() {
            return this.m_cMaxPages;
        }

        public int getActivePageCount() {
            int cPages = this.getTotalPageCount();
            int cMax = this.getMaximumPages();
            return Math.min(cPages, cMax);
        }

        public int getTotalPageCount() {
            return this.m_cPages;
        }

        public int getCurrentPageNumber() {
            return this.getTotalPageCount() - 1;
        }

        public boolean isPageActive(int nPage) {
            int cPages = this.getTotalPageCount();
            if (nPage >= cPages) {
                return false;
            }
            int cActive = this.getActivePageCount();
            return nPage >= cPages - cActive;
        }

        public WrapperBinaryStore[] getActivePageArray() {
            return this.m_astore;
        }

        public WrapperBinaryStore getPage(int nPage) {
            int iPage = this.toPageIndex(nPage);
            if (iPage != -1) {
                try {
                    return this.m_astore[iPage];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return null;
        }

        protected WrapperBinaryStore getCurrentPage() {
            return this.getPage(this.getCurrentPageNumber());
        }

        protected WrapperBinaryStore getOldestActivePage() {
            int cActive = this.getActivePageCount();
            return cActive <= 0 ? null : this.getPage(this.getCurrentPageNumber() - cActive + 1);
        }

        protected int toPageIndex(int nPage) {
            int cPages = this.getTotalPageCount();
            if (nPage >= cPages) {
                return -1;
            }
            int cMax = this.getMaximumPages();
            if (nPage < cPages - cMax) {
                return -1;
            }
            return nPage % cMax;
        }

        protected Map getPagedKeyMap() {
            return this.m_mapKeys;
        }

        protected WrapperBinaryStore advanceCurrentPage(WrapperBinaryStore store) {
            WrapperBinaryStore[] astore = this.getActivePageArray();
            WrapperBinaryStore storePrevCurrent = this.getCurrentPage();
            int nCurrent = this.m_cPages++;
            int iCurrent = this.toPageIndex(nCurrent);
            if (nCurrent == Integer.MAX_VALUE) {
                throw new IllegalStateException("SerializationPagedCache: Maximum total pages exceeded (2147483647).");
            }
            WrapperBinaryStore storeOld = astore[iCurrent];
            astore[iCurrent] = store;
            if (storePrevCurrent != null) {
                storePrevCurrent.close();
            }
            return storeOld;
        }

        protected void logException(Throwable e, String sMethod) {
            PagedBinaryStore.err("An exception has been thrown by the underlying BinaryStore during processing:");
            PagedBinaryStore.err(e);
            PagedBinaryStore.err("(Exception has been logged; \" + sMethod + \"() will continue.)");
        }
    }

    public class WrapperBinaryStore
    implements BinaryStore {
        private BinaryStore m_store;
        private Map m_mapKeys = new SafeHashMap();
        private boolean m_fCurrent = true;

        public WrapperBinaryStore(BinaryStore store) {
            this.setBinaryStore(store);
        }

        @Override
        public Binary load(Binary binKey) {
            if (this.getBinaryStoreKeyMap().containsKey(binKey)) {
                return this.getBinaryStore().load(binKey);
            }
            return null;
        }

        @Override
        public void store(Binary binKey, Binary binValue) {
            this.getBinaryStore().store(binKey, binValue);
            Map mapKeys = this.getBinaryStoreKeyMap();
            if (!mapKeys.containsKey(binKey)) {
                mapKeys.put(binKey, null);
            }
        }

        @Override
        public void erase(Binary binKey) {
            Map mapKeys = this.getBinaryStoreKeyMap();
            if (mapKeys.containsKey(binKey)) {
                if (!SerializationPagedCache.this.isVirtualErase()) {
                    this.getBinaryStore().erase(binKey);
                }
                mapKeys.remove(binKey);
            }
            this.checkDestroy();
        }

        @Override
        public void eraseAll() {
            Map mapKeys = this.getBinaryStoreKeyMap();
            if (!mapKeys.isEmpty()) {
                if (!SerializationPagedCache.this.isVirtualErase()) {
                    this.getBinaryStore().eraseAll();
                }
                mapKeys.clear();
            }
            this.checkDestroy();
        }

        public Iterator keys() {
            return new SimpleEnumerator<Object>(this.getBinaryStoreKeyMap().keySet().toArray());
        }

        public String toString() {
            return "WrapperBinaryStore {BinaryStore=" + String.valueOf(this.getBinaryStore()) + ", Current=" + this.isCurrent() + ", Size=" + this.getSize() + "}";
        }

        public synchronized BinaryStore getBinaryStore() {
            return this.m_store;
        }

        protected void setBinaryStore(BinaryStore store) {
            this.m_store = store;
        }

        public int getSize() {
            return this.getBinaryStoreKeyMap().size();
        }

        protected Map getBinaryStoreKeyMap() {
            return this.m_mapKeys;
        }

        public boolean isCurrent() {
            return this.m_fCurrent;
        }

        protected void close() {
            if (this.isCurrent()) {
                this.m_fCurrent = false;
                this.checkDestroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkDestroy() {
            if (!this.isCurrent() && this.getSize() == 0) {
                WrapperBinaryStore wrapperBinaryStore = this;
                synchronized (wrapperBinaryStore) {
                    BinaryStore store = this.getBinaryStore();
                    if (store != null && !(store instanceof FakeBinaryStore) && this.getSize() == 0) {
                        this.destroy();
                    }
                }
            }
        }

        protected synchronized void destroy() {
            BinaryStore store = this.getBinaryStore();
            if (store != null && !(store instanceof FakeBinaryStore)) {
                this.setBinaryStore(SerializationPagedCache.this.instantiateFakeBinaryStore());
                SerializationPagedCache.this.destroyBinaryStore(store);
            }
        }
    }

    public static class FakeBinaryStore
    implements BinaryStore {
        private Map m_mapBinaries = new SafeHashMap();

        @Override
        public Binary load(Binary binKey) {
            return (Binary)this.getBinaryMap().get(binKey);
        }

        @Override
        public void store(Binary binKey, Binary binValue) {
            this.getBinaryMap().put(binKey, binValue);
        }

        @Override
        public void erase(Binary binKey) {
            this.getBinaryMap().remove(binKey);
        }

        @Override
        public void eraseAll() {
            this.getBinaryMap().clear();
        }

        public Iterator keys() {
            return new IteratorEnumerator(this.getBinaryMap().keySet().iterator());
        }

        public String toString() {
            return "FakeBinaryStore {BinaryMap.size=" + this.getBinaryMap().size() + "}";
        }

        protected Map getBinaryMap() {
            return this.m_mapBinaries;
        }
    }
}

