/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.application.ContainerHelper;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.tracing.Scope;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.license.CoherenceCommunityEdition;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardian;
import com.tangosol.net.cache.AbstractBinaryEntryBundler;
import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.net.cache.AbstractCacheStore;
import com.tangosol.net.cache.AbstractEntryBundler;
import com.tangosol.net.cache.AbstractKeyBundler;
import com.tangosol.net.cache.BackingMapBinaryEntry;
import com.tangosol.net.cache.BinaryEntryStore;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.NonBlockingEntryStore;
import com.tangosol.net.cache.StoreObserver;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Daemon;
import com.tangosol.util.EntrySetMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InflatableList;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.SubSet;
import com.tangosol.util.WrapperException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ReadWriteBackingMap
extends AbstractMap
implements CacheMap {
    protected static final Binary REMOVED = new Binary();
    protected static final Binary BIN_STORE_PENDING = ExternalizableHelper.toBinary(Boolean.FALSE);
    protected static final float GUARD_RECOVERY = 0.9f;
    public static final long MIN_REQUEUE_DELAY = Config.getLong("coherence.rwbm.requeue.delay", 60000L);
    public static final Binary BIN_ERASE_PENDING = ExternalizableHelper.decorate(ExternalizableHelper.toBinary(null), 2, BIN_STORE_PENDING);
    public static final String PROP_WB_REMOVE_DEFAULT = "coherence.rwbm.writebehind.remove.default";
    public static final boolean RWBM_WB_REMOVE_DEFAULT = Config.getBoolean("coherence.rwbm.writebehind.remove.default", false);
    private final ConfigurableCacheMap.EvictionApprover f_writeBehindDisapprover = new ConfigurableCacheMap.EvictionApprover(){

        @Override
        public boolean isEvictable(ConfigurableCacheMap.Entry cacheEntry) {
            return ReadWriteBackingMap.this.m_queueWrite.accelerateEntryRipe((Binary)cacheEntry.getKey());
        }
    };
    private BackingMapManagerContext m_ctxService;
    private boolean m_fActive = true;
    private ObservableMap m_mapInternal;
    private Map m_mapMisses;
    private Set m_setPendingRemoves;
    private ConcurrentMap m_mapControl;
    private MapListener m_listenerInternal;
    private Map m_mapSyntheticEvents;
    private StoreWrapper m_store;
    private boolean m_fReadOnly;
    private ReadQueue m_queueRead;
    private ReadThread m_daemonRead;
    private WriteQueue m_queueWrite;
    private WriteThread m_daemonWrite;
    protected MapListenerSupport m_listenerSupport;
    private EntrySet m_entryset;
    private KeySet m_keyset;
    private ValuesCollection m_values;
    private long m_cWriteBehindMillis;
    private long m_cStoreTimeoutMillis;
    private volatile double m_dflRefreshAheadFactor;
    private volatile boolean m_fRethrowExceptions;
    private volatile double m_dflWriteBatchFactor;
    private volatile int m_cWriteRequeueThreshold;
    private int m_cWriteMaxBatchSize = 128;
    private boolean m_fWBRemove;

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheLoader loader) {
        this.init(ctxService, mapInternal, mapMisses, loader, null, null, true, 0, 0.0, RWBM_WB_REMOVE_DEFAULT);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheLoader loader, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        this.init(ctxService, mapInternal, mapMisses, loader, null, null, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, RWBM_WB_REMOVE_DEFAULT);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheLoader loader, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        this.init(ctxService, mapInternal, mapMisses, loader, null, null, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, fWriteBehindRemove);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, BinaryEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        this(ctxService, mapInternal, mapMisses, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, RWBM_WB_REMOVE_DEFAULT);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, BinaryEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        this.init(ctxService, mapInternal, mapMisses, null, storeBinary, null, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, fWriteBehindRemove);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, NonBlockingEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        this.init(ctxService, mapInternal, mapMisses, null, null, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, RWBM_WB_REMOVE_DEFAULT);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, NonBlockingEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        this.init(ctxService, mapInternal, mapMisses, null, null, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, fWriteBehindRemove);
    }

    private void init(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheLoader loader, BinaryEntryStore storeBinary, NonBlockingEntryStore storeNonBlocking, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, boolean fWriteBehindRemove) {
        this.m_ctxService = ctxService;
        this.m_setPendingRemoves = null;
        this.configureInternalCache(mapInternal);
        if (loader != null || storeBinary != null || storeNonBlocking != null) {
            boolean fWBRemove = cWriteBehindSeconds > 0 ? fWriteBehindRemove : false;
            this.m_mapMisses = mapMisses;
            if (loader == null) {
                this.configureCacheStore(storeBinary == null ? this.instantiateCacheStoreWrapper(storeNonBlocking) : this.instantiateCacheStoreWrapper(storeBinary), fReadOnly, fWBRemove);
            } else if (loader instanceof CacheStore) {
                this.configureCacheStore(this.instantiateCacheStoreWrapper((CacheStore)loader), fReadOnly, fWBRemove);
            } else {
                this.configureCacheStore(this.instantiateCacheStoreWrapper(this.instantiateCacheLoaderCacheStore(loader)), true, RWBM_WB_REMOVE_DEFAULT);
            }
            this.configureWriteThread(cWriteBehindSeconds);
            this.configureReadThread(dflRefreshAheadFactor);
        }
    }

    public BackingMapManagerContext getContext() {
        return this.m_ctxService;
    }

    public CacheService getCacheService() {
        return this.getContext().getCacheService();
    }

    public boolean isRethrowExceptions() {
        return this.m_fRethrowExceptions;
    }

    public void setRethrowExceptions(boolean fRethrow) {
        this.m_fRethrowExceptions = fRethrow;
    }

    public double getRefreshAheadFactor() {
        return this.m_dflRefreshAheadFactor;
    }

    public void setRefreshAheadFactor(double dflRefreshAheadFactor) {
        if (this.isRefreshAhead()) {
            if (dflRefreshAheadFactor >= 0.0 && dflRefreshAheadFactor <= 1.0) {
                this.m_dflRefreshAheadFactor = dflRefreshAheadFactor;
            } else {
                throw new IllegalArgumentException("Invalid refresh-ahead factor: " + dflRefreshAheadFactor);
            }
        }
    }

    public boolean isReadOnly() {
        return this.m_fReadOnly;
    }

    public boolean isRefreshAhead() {
        return this.getCacheStore() != null && this.getReadQueue() != null;
    }

    public int getWriteMaxBatchSize() {
        return this.m_cWriteMaxBatchSize;
    }

    public void setWriteMaxBatchSize(int cWriteMaxBatchSize) {
        if (cWriteMaxBatchSize <= 0) {
            throw new IllegalArgumentException("Invalid batch size: " + cWriteMaxBatchSize);
        }
        this.m_cWriteMaxBatchSize = cWriteMaxBatchSize;
    }

    public double getWriteBatchFactor() {
        return this.m_dflWriteBatchFactor;
    }

    public void setWriteBatchFactor(double dflWriteBatchFactor) {
        if (this.isWriteBehind()) {
            if (dflWriteBatchFactor >= 0.0 && dflWriteBatchFactor <= 1.0) {
                this.m_dflWriteBatchFactor = dflWriteBatchFactor;
            } else {
                throw new IllegalArgumentException("Invalid write-batch factor: " + dflWriteBatchFactor);
            }
        }
    }

    public boolean isWriteBehind() {
        return !this.isReadOnly() && this.getCacheStore() != null && this.getWriteQueue() != null;
    }

    public int getWriteBehindSeconds() {
        long cMillis = this.getWriteBehindMillis();
        return cMillis == 0L ? 0 : Math.max(1, (int)(cMillis / 1000L));
    }

    public void setWriteBehindSeconds(int cSecs) {
        this.setWriteBehindMillis(1000L * (long)cSecs);
    }

    public long getWriteBehindMillis() {
        return this.m_cWriteBehindMillis;
    }

    public void setWriteBehindMillis(long cMillis) {
        if (this.isWriteBehind()) {
            if (cMillis > 0L) {
                int cExpiryMillis;
                ConfigurableCacheMap cache = this.getInternalConfigurableCache();
                if (cache != null && (cExpiryMillis = cache.getExpiryDelay()) > 0 && (long)cExpiryMillis < cMillis) {
                    StringBuilder sb = new StringBuilder().append("ReadWriteBackingMap internal cache expiry of ").append(cExpiryMillis).append(" milliseconds is less than the write-delay of ").append(cMillis).append(" milliseconds; ");
                    cMillis = cExpiryMillis;
                    sb.append("decreasing the write-delay to ").append(cMillis).append(" milliseconds.");
                    Base.log(sb.toString());
                }
                this.m_cWriteBehindMillis = cMillis;
                this.getWriteQueue().setDelayMillis(cMillis);
            } else {
                throw new IllegalArgumentException("Invalid write-behind delay: " + cMillis);
            }
        }
    }

    public int getWriteRequeueThreshold() {
        return this.m_cWriteRequeueThreshold;
    }

    public void setWriteRequeueThreshold(int cThreshold) {
        if (this.isWriteBehind()) {
            if (cThreshold >= 0) {
                this.m_cWriteRequeueThreshold = cThreshold;
            } else {
                throw new IllegalArgumentException("Invalid write requeue threshold: " + cThreshold);
            }
        }
    }

    public boolean isWriteThrough() {
        return !this.isReadOnly() && this.getCacheStore() != null && this.getWriteQueue() == null;
    }

    public long getCacheStoreTimeoutMillis() {
        return this.m_cStoreTimeoutMillis;
    }

    public void setCacheStoreTimeoutMillis(long cStoreTimeoutMillis) {
        this.m_cStoreTimeoutMillis = cStoreTimeoutMillis;
        CacheService service = this.getContext().getCacheService();
        if (service instanceof Guardian) {
            ReadThread daemonRead = this.getReadThread();
            WriteThread daemonWrite = this.getWriteThread();
            if (daemonRead != null) {
                daemonRead.setGuardPolicy((Guardian)((Object)service), cStoreTimeoutMillis, 0.9f);
                daemonRead.m_fRefreshContext = true;
            }
            if (daemonWrite != null) {
                daemonWrite.setGuardPolicy((Guardian)((Object)service), cStoreTimeoutMillis, 0.9f);
                daemonWrite.m_fRefreshContext = true;
            }
        }
    }

    public void setCacheName(String sCacheName) {
        if (sCacheName != null && sCacheName.trim().length() > 0) {
            this.updateThreadName(this.getReadThread(), sCacheName);
            this.updateThreadName(this.getWriteThread(), sCacheName);
        }
    }

    public int getPendingWrites() {
        if (this.isWriteBehind()) {
            return this.getWriteQueue().size();
        }
        StoreWrapper store = this.getCacheStore();
        if (store != null && !store.isBlocking()) {
            return (int)store.f_cPendingAsyncStoreOps.get();
        }
        return -1;
    }

    public boolean isWriteBehindRemove() {
        return this.m_fWBRemove;
    }

    @Override
    public void clear() {
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean containsKey(Object oKey) {
        if (this.isWriteBehindRemove() && this.getPendingRemoves().contains(oKey)) {
            return false;
        }
        return this.getInternalCache().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getInternalCache().containsValue(oValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object oKey) {
        ConcurrentMap mapControl = this.getControlMap();
        Map mapMisses = this.getMissesCache();
        mapControl.lock(oKey, -1L);
        try {
            StoreWrapper store;
            if (mapMisses != null && mapMisses.containsKey(oKey)) {
                Object var4_4 = null;
                return var4_4;
            }
            if (this.isWriteBehindRemove() && this.getPendingRemoves().contains(oKey)) {
                Object var4_5 = null;
                return var4_5;
            }
            Object oValue = this.getFromInternalCache(oKey);
            if (oValue == null && this.getContext().isKeyOwned(oKey) && (store = this.getCacheStore()) != null) {
                Entry entry = store.load(oKey);
                oValue = entry == null ? null : entry.getBinaryValue();
                this.putToInternalCache(oKey, oValue, this.extractExpiry(entry));
            }
            Object object = oValue;
            return object;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.putInternal(oKey, oValue, 0L);
    }

    @Override
    public Object remove(Object oKey) {
        return this.removeInternal(oKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map map) {
        block16: {
            StoreWrapper store = this.getCacheStore();
            if (map.size() == 1 || this.getWriteQueue() != null || store == null || !store.isStoreAllSupported() || this.isReadOnly()) {
                super.putAll(map);
                return;
            }
            ConcurrentMap mapControl = this.getControlMap();
            try {
                Map mapMisses = this.getMissesCache();
                ObservableMap mapInternal = this.getInternalCache();
                LinkedHashSet<Entry> setEntries = new LinkedHashSet<Entry>(map.size());
                BackingMapManagerContext ctx = this.getContext();
                for (Map.Entry entry : map.entrySet()) {
                    Object oKey = entry.getKey();
                    mapControl.lock(oKey, -1L);
                    if (mapMisses != null) {
                        mapMisses.remove(oKey);
                    }
                    if (this.isWriteBehindRemove()) {
                        this.getPendingRemoves().remove(oKey);
                    }
                    this.cancelOutstandingReads(oKey);
                    if (!ctx.isKeyOwned(oKey)) continue;
                    setEntries.add(this.instantiateEntry(oKey, entry.getValue(), mapInternal.get(oKey), 0L));
                }
                if (setEntries.isEmpty()) break block16;
                SubSet setEntriesFailed = new SubSet(setEntries);
                Set<Entry> setSuccess = null;
                try {
                    store.storeAll(setEntriesFailed);
                    setSuccess = setEntries;
                }
                catch (Throwable e) {
                    try {
                        setSuccess = setEntriesFailed.getRemoved();
                        throw Base.ensureRuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        for (Entry entry : setSuccess) {
                            long cMillis = 0L;
                            Binary binValue = entry.getBinaryValue();
                            if (entry.isChanged()) {
                                binValue = entry.getChangedBinaryValue();
                                cMillis = binValue == null ? 1L : this.extractExpiry(entry);
                            }
                            this.putToInternalMap(entry.getBinaryKey(), binValue, cMillis);
                        }
                        throw throwable;
                    }
                }
                for (Entry entry : setSuccess) {
                    long cMillis = 0L;
                    Binary binValue = entry.getBinaryValue();
                    if (entry.isChanged()) {
                        binValue = entry.getChangedBinaryValue();
                        cMillis = binValue == null ? 1L : this.extractExpiry(entry);
                    }
                    this.putToInternalMap(entry.getBinaryKey(), binValue, cMillis);
                }
            }
            finally {
                for (Object oKey : map.keySet()) {
                    mapControl.unlock(oKey);
                }
            }
        }
    }

    protected Object putToInternalMap(Object binKey, Object binValue, long cExpiry) {
        ObservableMap mapInternal = this.getInternalCache();
        if (mapInternal instanceof CacheMap) {
            return ((CacheMap)mapInternal).put(binKey, binValue, cExpiry);
        }
        if (cExpiry <= 0L) {
            return mapInternal.put(binKey, binValue);
        }
        throw new UnsupportedOperationException("Class \"" + mapInternal.getClass().getName() + "\" does not implement CacheMap interface");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeInternal(Object oKey, boolean fBlind) {
        ConcurrentMap mapControl = this.getControlMap();
        Map mapMisses = this.getMissesCache();
        mapControl.lock(oKey, -1L);
        try {
            if (mapMisses != null) {
                mapMisses.remove(oKey);
            }
            this.cancelOutstandingReads(oKey);
            Object oValue = this.getCachedOrPending(oKey);
            WriteQueue queue = this.getWriteQueue();
            StoreWrapper store = this.getCacheStore();
            boolean fQueued = false;
            if (store != null) {
                boolean fOwned = this.getContext().isKeyOwned(oKey);
                if (!fBlind && oValue == null && fOwned) {
                    Entry entry = store.load(oKey);
                    Object object = oValue = entry == null ? null : entry.getBinaryValue();
                    if (oValue == null) {
                        Object var11_12 = null;
                        return var11_12;
                    }
                }
                if (!this.isReadOnly()) {
                    this.removeFromWriteQueue(oKey);
                    if (fOwned) {
                        if (this.isWriteBehindRemove() && queue != null) {
                            queue.add(this.instantiateEntry(oKey, BIN_ERASE_PENDING, oValue, 0L), 0L);
                            this.getInternalCache().put(oKey, BIN_ERASE_PENDING);
                            this.getPendingRemoves().add(oKey);
                            fQueued = true;
                        } else {
                            store.erase(this.instantiateEntry(oKey, null, oValue));
                        }
                    }
                }
            }
            if (!fQueued) {
                this.getInternalCache().remove(oKey);
            }
            Object object = oValue;
            return object;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    @Override
    public int size() {
        int cPendingRemoves = this.isWriteBehindRemove() ? this.getPendingRemoves().size() : 0;
        return this.getInternalCache().size() - cPendingRemoves;
    }

    @Override
    public Set entrySet() {
        EntrySet set = this.m_entryset;
        if (set == null) {
            this.m_entryset = set = this.instantiateEntrySet();
        }
        return set;
    }

    @Override
    public Set keySet() {
        KeySet set = this.m_keyset;
        if (set == null) {
            this.m_keyset = set = this.instantiateKeySet();
        }
        return set;
    }

    @Override
    public Collection values() {
        ValuesCollection values = this.m_values;
        if (values == null) {
            this.m_values = values = this.instantiateValuesCollection();
        }
        return values;
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.putInternal(oKey, oValue, cMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(Collection colKeys) {
        ConcurrentMap mapControl = this.getControlMap();
        BackingMapManagerContext ctx = this.getContext();
        if (!(colKeys instanceof SortedSet)) {
            colKeys = new TreeSet(colKeys);
        }
        try {
            Map mapMisses = this.getMissesCache();
            HashMap<Object, Object> mapResult = new HashMap<Object, Object>();
            HashSet<Object> setLoad = new HashSet<Object>();
            for (Object oKey : colKeys) {
                if (!ctx.isKeyOwned(oKey)) {
                    throw new IllegalStateException("Key is not owned: " + String.valueOf(oKey));
                }
                mapControl.lock(oKey, -1L);
                if (mapMisses != null && mapMisses.containsKey(oKey) || this.isWriteBehindRemove() && this.getPendingRemoves().contains(oKey)) continue;
                Object oValue = this.getFromInternalCache(oKey);
                if (oValue == null) {
                    setLoad.add(oKey);
                    continue;
                }
                mapResult.put(oKey, oValue);
            }
            if (setLoad.isEmpty()) {
                HashMap<Object, Object> hashMap = mapResult;
                return hashMap;
            }
            StoreWrapper store = this.getCacheStore();
            if (store != null) {
                Set setLoaded = store.loadAll(setLoad);
                SubSet setMissed = new SubSet(setLoad);
                for (Object oEntry : setLoaded) {
                    Entry entry = (Entry)oEntry;
                    Binary binKey = entry.getBinaryKey();
                    this.putToInternalCache(entry);
                    mapResult.put(binKey, entry.getBinaryValue());
                    setMissed.remove(binKey);
                }
                for (Object oKey : setMissed) {
                    this.putToInternalCache(oKey, null, 0L);
                }
            }
            HashMap<Object, Object> hashMap = mapResult;
            return hashMap;
        }
        finally {
            for (Object oKey : colKeys) {
                mapControl.unlock(oKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeAll(Collection colKeys) {
        if (this.isWriteBehindRemove()) {
            for (Object oKey : colKeys) {
                this.remove(oKey);
            }
            return true;
        }
        StoreWrapper store = this.getCacheStore();
        ConcurrentMap mapControl = this.getControlMap();
        ObservableMap mapInternal = this.getInternalCache();
        ConverterCollections.ConverterCollection<Object, Object> colKeysProcessed = colKeys;
        try {
            Map mapMisses = this.getMissesCache();
            HashSet<Entry> setEntries = new HashSet<Entry>(colKeys.size());
            boolean fReadOnly = this.isReadOnly();
            BackingMapManagerContext ctx = this.getContext();
            for (Object oKey : colKeys) {
                mapControl.lock(oKey, -1L);
                if (mapMisses != null) {
                    mapMisses.remove(oKey);
                }
                this.cancelOutstandingReads(oKey);
                if (store == null) continue;
                Object oValue = this.getCachedOrPending(oKey);
                boolean fOwned = ctx.isKeyOwned(oKey);
                if (fReadOnly) continue;
                this.removeFromWriteQueue(oKey);
                if (!fOwned) continue;
                setEntries.add(this.instantiateEntry(oKey, null, oValue, 0L));
            }
            if (!setEntries.isEmpty()) {
                SubSet setEntriesFailed = new SubSet(setEntries);
                Set<Entry> setSuccess = null;
                try {
                    if (store != null) {
                        store.eraseAll(setEntriesFailed);
                    }
                    setSuccess = setEntries;
                }
                catch (Throwable e) {
                    setSuccess = setEntriesFailed.getRemoved();
                    throw Base.ensureRuntimeException(e);
                }
                finally {
                    colKeysProcessed = ConverterCollections.getCollection(setSuccess, BackingMapBinaryEntry::getBinaryKey, NullImplementation.getConverter());
                }
            }
            boolean bl = !colKeysProcessed.isEmpty();
            return bl;
        }
        finally {
            for (Object binKey : colKeysProcessed) {
                mapInternal.remove(binKey);
            }
            for (Object oKey : colKeys) {
                mapControl.unlock(oKey);
            }
        }
    }

    protected void putToInternalCache(Object oKey, Object oVal) {
        this.putToInternalCache(oKey, oVal, 0L);
    }

    protected void putToInternalCache(Entry entry) {
        Binary oKey = entry.getBinaryKey();
        Binary oVal = entry.getBinaryValue();
        this.putToInternalCache(oKey, oVal, this.extractExpiry(entry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putToInternalCache(Object oKey, Object oVal, long cMillis) {
        ObservableMap mapInternal = this.getInternalCache();
        if (oVal == null) {
            Map mapMisses = this.getMissesCache();
            if (mapMisses != null) {
                mapMisses.put(oKey, oKey);
            }
        } else {
            Map mapSynthetic = this.getSyntheticEventsMap();
            mapSynthetic.put(oKey, oKey);
            try {
                if (cMillis != 0L && mapInternal instanceof CacheMap) {
                    ((CacheMap)mapInternal).put(oKey, oVal, cMillis);
                } else {
                    mapInternal.put(oKey, oVal);
                }
            }
            finally {
                mapSynthetic.remove(oKey);
            }
        }
    }

    protected void cancelOutstandingReads(Object oKey) {
        if (this.isRefreshAhead() && !this.isReadOnly()) {
            ConcurrentMap mapControl = this.getControlMap();
            this.getReadQueue().remove(oKey);
            ReadLatch latch = (ReadLatch)mapControl.get(oKey);
            if (latch != null) {
                latch.cancel();
                mapControl.remove(oKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getFromInternalCache(Object oKey) {
        ReadLatch latch;
        if (!this.isRefreshAhead()) return this.getCachedOrPending(oKey);
        ConfigurableCacheMap cache = this.getInternalConfigurableCache();
        ConfigurableCacheMap.Entry entry = cache.getCacheEntry(oKey);
        ConcurrentMap mapControl = this.getControlMap();
        if (entry == null) {
            if (!this.getContext().isKeyOwned(oKey)) {
                return null;
            }
            ReadLatch latch2 = (ReadLatch)mapControl.get(oKey);
            if (latch2 == null) {
                this.getReadQueue().remove(oKey);
                return this.getCachedOrPending(oKey);
            }
            try {
                ReadLatch readLatch = latch2;
                synchronized (readLatch) {
                    while (!latch2.isComplete()) {
                        Blocking.wait(latch2);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                mapControl.remove(oKey);
            }
            Object oVal = latch2.getValue();
            this.putToInternalCache(oKey, oVal);
            return oVal;
        }
        long lExpiryMillis = entry.getExpiryMillis();
        if (lExpiryMillis == 0L) return entry.getValue();
        long lInterval = (long)((double)cache.getExpiryDelay() * this.getRefreshAheadFactor());
        if (Base.getSafeTimeMillis() < lExpiryMillis - lInterval || (latch = (ReadLatch)mapControl.get(oKey)) != null) return entry.getValue();
        this.getReadQueue().add(oKey);
        return entry.getValue();
    }

    protected Object getCachedOrPending(Object oKey) {
        WriteQueue queue;
        Object oValue = this.getInternalCache().get(oKey);
        if (oValue == null && (queue = this.getWriteQueue()) != null) {
            oValue = queue.checkPending(oKey);
        }
        return oValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object putInternal(Object oKey, Object oValue, long cMillis) {
        ConcurrentMap mapControl = this.getControlMap();
        Map mapMisses = this.getMissesCache();
        ObservableMap mapInternal = this.getInternalCache();
        Set setRemoves = this.getPendingRemoves();
        mapControl.lock(oKey, -1L);
        try {
            if (mapMisses != null) {
                mapMisses.remove(oKey);
            }
            if (this.isWriteBehindRemove() && !setRemoves.isEmpty()) {
                setRemoves.remove(oKey);
            }
            this.cancelOutstandingReads(oKey);
            BackingMapManagerContext ctx = this.getContext();
            StoreWrapper store = this.getCacheStore();
            WriteQueue queue = this.getWriteQueue();
            if (store != null && !this.isReadOnly()) {
                boolean fOwned = ctx.isKeyOwned(oKey);
                if (queue == null) {
                    boolean fDecorated;
                    boolean bl = fDecorated = !fOwned && !store.isBlocking() && ExternalizableHelper.isDecorated((Binary)oValue, 2);
                    if (fOwned || fDecorated) {
                        if (!store.isBlocking() && !fDecorated) {
                            oValue = ExternalizableHelper.decorate((Binary)oValue, 2, BIN_STORE_PENDING);
                        }
                        Entry entry = this.instantiateEntry(oKey, oValue, mapInternal.get(oKey), cMillis);
                        store.store(entry, false);
                        if (entry.isChanged()) {
                            oValue = entry.getChangedBinaryValue();
                            cMillis = oValue == null ? 1L : this.extractExpiry(entry);
                        }
                    }
                } else if (fOwned) {
                    oValue = ExternalizableHelper.decorate((Binary)oValue, 2, BIN_STORE_PENDING);
                } else if (!ExternalizableHelper.isDecorated((Binary)oValue, 2)) {
                    queue = null;
                }
            }
            if (queue != null) {
                queue.add(this.instantiateEntry(oKey, oValue, mapInternal.get(oKey), cMillis), 0L);
            }
            Object object = this.putToInternalMap(oKey, oValue, cMillis);
            return object;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    protected boolean waitFor(Object o, long cMillis) {
        try {
            Blocking.wait(o, cMillis);
        }
        catch (InterruptedException e) {
            if (this.isActive()) {
                throw Base.ensureRuntimeException(e);
            }
            return false;
        }
        return true;
    }

    protected void heartbeat() {
        long cMillis = this.getCacheStoreTimeoutMillis();
        if (cMillis == 0L) {
            GuardSupport.heartbeat();
        } else {
            GuardSupport.heartbeat(cMillis);
        }
    }

    protected long extractExpiry(Entry entry) {
        return entry == null ? 0L : entry.getExpiry();
    }

    protected void updateThreadName(Daemon daemon, String sName) {
        Thread thread;
        String sNamePrev;
        if (daemon != null && !(sNamePrev = (thread = daemon.getThread()).getName()).endsWith((String)(sName = ":" + (String)sName))) {
            thread.setName(sNamePrev + (String)sName);
        }
    }

    protected EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    protected KeySet instantiateKeySet() {
        return new KeySet();
    }

    protected ValuesCollection instantiateValuesCollection() {
        return new ValuesCollection();
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, oKey, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Map && this.getInternalCache().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getInternalCache().hashCode();
    }

    @Override
    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{" + String.valueOf(this.getInternalCache()) + "}";
    }

    public ObservableMap getInternalCache() {
        return this.m_mapInternal;
    }

    protected ConfigurableCacheMap getInternalConfigurableCache() {
        ObservableMap mapInternal = this.m_mapInternal;
        return mapInternal instanceof ConfigurableCacheMap ? (ConfigurableCacheMap)mapInternal : null;
    }

    protected void configureInternalCache(ObservableMap mapInternal) {
        this.m_mapInternal = mapInternal;
        this.m_mapControl = this.instantiateControlMap();
        this.m_listenerInternal = this.instantiateInternalListener();
        mapInternal.addMapListener(this.getInternalListener());
    }

    public Map getMissesCache() {
        return this.m_mapMisses;
    }

    public Set getPendingRemoves() {
        return this.m_setPendingRemoves;
    }

    public ConcurrentMap getControlMap() {
        return this.m_mapControl;
    }

    protected ConcurrentMap instantiateControlMap() {
        return new SegmentedConcurrentMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getSyntheticEventsMap() {
        SafeHashMap map = this.m_mapSyntheticEvents;
        if (map == null) {
            ReadWriteBackingMap readWriteBackingMap = this;
            synchronized (readWriteBackingMap) {
                map = this.m_mapSyntheticEvents;
                if (map == null) {
                    map = this.m_mapSyntheticEvents = new SafeHashMap();
                }
            }
        }
        return map;
    }

    protected MapListener getInternalListener() {
        return this.m_listenerInternal;
    }

    protected MapListener instantiateInternalListener() {
        return new InternalMapListener();
    }

    public void release() {
        if (this.isActive()) {
            try {
                this.getInternalCache().removeMapListener(this.getInternalListener());
            }
            catch (Exception e) {
                Base.err("An exception occurred while removing an internal listener during release:");
                Base.err(e);
            }
            if (this.isRefreshAhead()) {
                this.terminateReadThread();
            }
            if (this.isWriteBehind()) {
                this.terminateWriteThread();
            }
            this.m_store = null;
            this.m_fActive = false;
        }
    }

    public boolean isActive() {
        return this.m_fActive;
    }

    protected ReadLatch instantiateReadLatch(Object oKey) {
        return new ReadLatch(oKey);
    }

    public ReadQueue getReadQueue() {
        return this.m_queueRead;
    }

    protected ReadQueue instantiateReadQueue() {
        return new ReadQueue();
    }

    public WriteQueue getWriteQueue() {
        return this.m_queueWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        WriteQueue queue = this.getWriteQueue();
        StoreWrapper store = this.getCacheStore();
        if (queue != null && store != null && !this.isReadOnly()) {
            WriteThread writeThread = this.m_daemonWrite;
            synchronized (writeThread) {
                if (queue == this.getWriteQueue()) {
                    this.flush(queue, store);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(WriteQueue queue, StoreWrapper store) {
        Base.azzert(queue != null && store != null);
        ConcurrentMap mapControl = this.getControlMap();
        BackingMapManagerContext ctx = this.getContext();
        boolean fBatch = mapControl.lock(ConcurrentMap.LOCK_ALL, 10L);
        LinkedHashSet<Entry> setBatch = fBatch ? new LinkedHashSet<Entry>() : null;
        try {
            Entry entry = queue.removeImmediate();
            while (entry != null && this.isActive()) {
                Binary binKey = entry.getBinaryKey();
                if (ctx.isKeyOwned(binKey)) {
                    if (fBatch) {
                        setBatch.add(entry);
                    } else {
                        mapControl.lock(binKey, -1L);
                        try {
                            store.store(entry, true);
                        }
                        catch (WrapperException e) {
                            Base.err(e);
                        }
                        finally {
                            mapControl.unlock(binKey);
                        }
                    }
                }
                entry = queue.removeImmediate();
            }
            if (fBatch) {
                try {
                    store.storeAll(setBatch);
                }
                catch (WrapperException e) {
                    Base.err(e);
                }
            }
        }
        finally {
            if (fBatch) {
                mapControl.unlock(ConcurrentMap.LOCK_ALL);
            }
        }
        WriteQueue writeQueue = queue;
        synchronized (writeQueue) {
            while (!queue.getPendingMap().isEmpty()) {
                queue.setWaitingOnPending(true);
                this.waitFor(queue, 255L);
            }
        }
    }

    protected Entry removeFromWriteQueue(Object binKey) {
        WriteQueue queue = this.getWriteQueue();
        return queue == null ? null : queue.remove(binKey);
    }

    protected Entry instantiateEntry(Object oKey, Object oValue, Object oValueOrig) {
        return this.instantiateEntry(oKey, oValue, oValueOrig, 0L);
    }

    protected Entry instantiateEntry(Object oKey, Object oValue, Object oValueOrig, long cExpiry) {
        return new Entry((Binary)oKey, (Binary)oValue, (Binary)oValueOrig, cExpiry, this.getContext());
    }

    protected WriteQueue instantiateWriteQueue() {
        return new WriteQueue();
    }

    protected ReadThread getReadThread() {
        return this.m_daemonRead;
    }

    protected void configureReadThread(double dflRefreshAheadFactor) {
        Base.azzert(dflRefreshAheadFactor >= 0.0 && dflRefreshAheadFactor <= 1.0, "Invalid refresh-ahead factor: " + dflRefreshAheadFactor);
        ConfigurableCacheMap cache = this.getInternalConfigurableCache();
        if (dflRefreshAheadFactor > 0.0 && cache != null) {
            int cWriteDelay;
            int cExpiry;
            int cReadDelay;
            int cExpiryMillis = cache.getExpiryDelay();
            if (cExpiryMillis == 0) {
                dflRefreshAheadFactor = 0.0;
            } else if (this.isWriteBehind() && (cReadDelay = (int)((double)(cExpiry = cExpiryMillis / 1000) * (1.0 - dflRefreshAheadFactor))) < (cWriteDelay = this.getWriteBehindSeconds())) {
                cReadDelay = (cExpiry + cWriteDelay) / 2;
                StringBuilder sb = new StringBuilder().append("ReadWriteBackingMap refresh-ahead factor of ").append(dflRefreshAheadFactor).append(" is too aggressive for the write-delay of ").append(cWriteDelay).append(" seconds; ");
                double d = dflRefreshAheadFactor = cExpiry == 0 ? 0.0 : 1.0 - (double)cReadDelay / (double)cExpiry;
                if (dflRefreshAheadFactor > 0.0) {
                    sb.append("reducing the factor to ").append(dflRefreshAheadFactor).append('.');
                } else {
                    sb.append("disabling refresh-ahead.");
                }
                Base.log(sb.toString());
            }
            if (dflRefreshAheadFactor > 0.0) {
                this.m_dflRefreshAheadFactor = dflRefreshAheadFactor;
                this.m_queueRead = this.instantiateReadQueue();
                this.m_daemonRead = this.instantiateReadThread();
                this.m_daemonRead.start();
            }
        }
    }

    protected ReadThread instantiateReadThread() {
        return new ReadThread();
    }

    protected void terminateReadThread() {
        if (this.isActive()) {
            ReadThread daemon = this.m_daemonRead;
            ReadQueue queue = this.m_queueRead;
            this.m_daemonRead = null;
            this.m_queueRead = null;
            if (daemon != null) {
                daemon.stop();
            }
            if (queue != null) {
                queue.clear();
            }
        }
    }

    protected WriteThread getWriteThread() {
        return this.m_daemonWrite;
    }

    protected void configureWriteThread(int cWriteBehindSeconds) {
        if (cWriteBehindSeconds > 0 && !this.isReadOnly()) {
            this.m_queueWrite = this.instantiateWriteQueue();
            this.m_daemonWrite = this.instantiateWriteThread();
            this.m_daemonWrite.start();
            if (this.isWriteBehindRemove()) {
                this.m_setPendingRemoves = new SafeHashSet();
            }
            this.setWriteBehindSeconds(cWriteBehindSeconds);
            ConfigurableCacheMap mapInternal = this.getInternalConfigurableCache();
            if (mapInternal != null) {
                mapInternal.setEvictionApprover(this.f_writeBehindDisapprover);
            }
        }
    }

    protected WriteThread instantiateWriteThread() {
        return new WriteThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateWriteThread() {
        if (this.isActive()) {
            StoreWrapper store = this.getCacheStore();
            WriteQueue queue = this.getWriteQueue();
            if (store != null && queue != null) {
                try {
                    WriteThread daemon;
                    WriteThread writeThread = daemon = this.m_daemonWrite;
                    synchronized (writeThread) {
                        this.m_daemonWrite = null;
                        this.m_queueWrite = null;
                        this.flush(queue, store);
                        if (daemon != null) {
                            daemon.stop();
                        }
                    }
                }
                catch (Exception e) {
                    Base.err("An exception occurred while flushing the write-behind queue while terminating the write-behind thread:");
                    Base.err(e);
                    Base.err("(The write-behind thread is exiting.)");
                }
            }
        }
    }

    public StoreWrapper getCacheStore() {
        return this.m_store;
    }

    protected void configureCacheStore(StoreWrapper store, boolean fReadOnly, boolean fWBRemove) {
        Base.azzert(store != null && this.m_store == null);
        this.m_fReadOnly = fReadOnly;
        this.m_store = store;
        this.m_fWBRemove = fWBRemove;
    }

    protected StoreWrapper instantiateCacheStoreWrapper(CacheStore store) {
        return new CacheStoreWrapper(store);
    }

    protected StoreWrapper instantiateCacheStoreWrapper(BinaryEntryStore store) {
        return new BinaryEntryStoreWrapper(store);
    }

    protected StoreWrapper instantiateCacheStoreWrapper(NonBlockingEntryStore store) {
        return new NonBlockingEntryStoreWrapper(store);
    }

    protected CacheStore instantiateCacheLoaderCacheStore(CacheLoader loader) {
        return new CacheLoaderCacheStore(loader);
    }

    public abstract class StoreWrapper
    extends Base {
        protected final AtomicLong f_cLoadOps = new AtomicLong();
        protected final AtomicLong f_cLoadFailures = new AtomicLong();
        protected final AtomicLong f_cLoadMillis = new AtomicLong();
        protected final AtomicLong f_cStoreOps = new AtomicLong();
        protected final AtomicLong f_cStoreEntries = new AtomicLong();
        protected final AtomicLong f_cStoreFailures = new AtomicLong();
        protected final AtomicLong f_cStoreMillis = new AtomicLong();
        protected final AtomicLong f_cPendingAsyncStoreOps = new AtomicLong();
        protected volatile long m_cEraseOps;
        protected volatile long m_cEraseFailures;
        protected volatile long m_cEraseMillis;
        protected boolean m_fStoreSupported = true;
        protected boolean m_fStoreAllSupported = true;
        protected boolean m_fEraseSupported = true;
        protected boolean m_fEraseAllSupported = true;
        protected AbstractBundler m_loadBundler;
        protected AbstractBundler m_storeBundler;
        protected AbstractBundler m_eraseBundler;

        public synchronized AbstractBundler ensureLoadBundler(int cBundleThreshold) {
            if (cBundleThreshold > 0) {
                AbstractBundler bundler = this.m_loadBundler;
                if (bundler == null) {
                    this.m_loadBundler = bundler = this.instantiateLoadBundler();
                }
                bundler.setSizeThreshold(cBundleThreshold);
                return bundler;
            }
            this.m_loadBundler = null;
            return null;
        }

        public synchronized AbstractBundler ensureStoreBundler(int cBundleThreshold) {
            if (cBundleThreshold > 0) {
                AbstractBundler bundler = this.m_storeBundler;
                if (bundler == null) {
                    this.m_storeBundler = bundler = this.instantiateStoreBundler();
                }
                bundler.setSizeThreshold(cBundleThreshold);
                return bundler;
            }
            this.m_storeBundler = null;
            return null;
        }

        public synchronized AbstractBundler ensureEraseBundler(int cBundleThreshold) {
            if (cBundleThreshold > 0) {
                AbstractBundler bundler = this.m_eraseBundler;
                if (bundler == null) {
                    this.m_eraseBundler = bundler = this.instantiateEraseBundler();
                }
                bundler.setSizeThreshold(cBundleThreshold);
                return bundler;
            }
            this.m_eraseBundler = null;
            return null;
        }

        public long getLoadOps() {
            return this.f_cLoadOps.get();
        }

        public long getLoadFailures() {
            return this.f_cLoadFailures.get();
        }

        public long getLoadMillis() {
            return this.f_cLoadMillis.get();
        }

        public long getStoreOps() {
            return this.f_cStoreOps.get();
        }

        public long getStoreFailures() {
            return this.f_cStoreFailures.get();
        }

        public long getStoreMillis() {
            return this.f_cStoreMillis.get();
        }

        public long getEraseOps() {
            return this.m_cEraseOps;
        }

        public long getEraseFailures() {
            return this.m_cEraseFailures;
        }

        public long getEraseMillis() {
            return this.m_cEraseMillis;
        }

        public long getAverageBatchSize() {
            long cOps = this.getStoreOps();
            return cOps > 0L ? this.f_cStoreEntries.get() / cOps : 0L;
        }

        public long getAverageLoadMillis() {
            long cOps = this.getLoadOps();
            return cOps > 0L ? this.f_cLoadMillis.get() / cOps : 0L;
        }

        public long getAverageStoreMillis() {
            long cOps = this.getStoreOps();
            return cOps > 0L ? this.f_cStoreMillis.get() / cOps : 0L;
        }

        public long getAverageEraseMillis() {
            long cOps = this.m_cEraseOps;
            return cOps > 0L ? this.m_cEraseMillis / cOps : 0L;
        }

        public long getPendingAsyncStoreOps() {
            return this.f_cPendingAsyncStoreOps.get();
        }

        public void resetStatistics() {
            this.f_cLoadOps.set(0L);
            this.f_cLoadFailures.set(0L);
            this.f_cLoadMillis.set(0L);
            this.f_cStoreOps.set(0L);
            this.f_cStoreEntries.set(0L);
            this.f_cStoreFailures.set(0L);
            this.f_cStoreMillis.set(0L);
            this.f_cPendingAsyncStoreOps.set(0L);
            this.m_cEraseOps = 0L;
            this.m_cEraseFailures = 0L;
            this.m_cEraseMillis = 0L;
        }

        public AbstractBundler getLoadBundler() {
            return this.m_loadBundler;
        }

        public AbstractBundler getStoreBundler() {
            return this.m_storeBundler;
        }

        public AbstractBundler getEraseBundler() {
            return this.m_eraseBundler;
        }

        public boolean isStoreSupported() {
            return this.m_fStoreSupported;
        }

        public void setStoreSupported(boolean fSupported) {
            this.m_fStoreSupported = fSupported;
        }

        public boolean isStoreAllSupported() {
            return this.m_fStoreAllSupported;
        }

        public void setStoreAllSupported(boolean fSupported) {
            this.m_fStoreAllSupported = fSupported;
        }

        public boolean isEraseSupported() {
            return this.m_fEraseSupported;
        }

        public void setEraseSupported(boolean fSupported) {
            this.m_fEraseSupported = fSupported;
        }

        public boolean isEraseAllSupported() {
            return this.m_fEraseAllSupported;
        }

        public void setEraseAllSupported(boolean fSupported) {
            this.m_fEraseAllSupported = fSupported;
        }

        public boolean isBlocking() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Entry load(Object binKey) {
            ReadWriteBackingMap.this.heartbeat();
            long lStart = StoreWrapper.getSafeTimeMillis();
            try {
                Entry entry = this.loadInternal(binKey);
                return entry;
            }
            finally {
                this.f_cLoadOps.incrementAndGet();
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.f_cLoadMillis.addAndGet(lElapsed);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set loadAll(Set setBinKey) {
            ReadWriteBackingMap.this.heartbeat();
            long lStart = StoreWrapper.getSafeTimeMillis();
            try {
                Set set = this.loadAllInternal(setBinKey);
                return set;
            }
            finally {
                this.f_cLoadOps.incrementAndGet();
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.f_cLoadMillis.addAndGet(lElapsed);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void store(Entry binEntry, boolean fAllowChange) {
            boolean fAsynch;
            ReadWriteBackingMap.this.heartbeat();
            long lStart = StoreWrapper.getSafeTimeMillis();
            boolean fSuccess = true;
            try {
                this.storeInternal(binEntry);
            }
            catch (RuntimeException e) {
                fSuccess = false;
                this.f_cStoreFailures.incrementAndGet();
                this.onStoreFailure(binEntry, e);
            }
            finally {
                if (this.isBlocking()) {
                    this.f_cStoreOps.incrementAndGet();
                    this.f_cStoreEntries.incrementAndGet();
                    binEntry.stopTracking();
                    long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                    if (lElapsed != 0L) {
                        this.f_cStoreMillis.addAndGet(lElapsed);
                    }
                } else {
                    this.f_cPendingAsyncStoreOps.incrementAndGet();
                }
            }
            boolean bl = fAsynch = ReadWriteBackingMap.this.getWriteQueue() != null;
            if (fAllowChange && (binEntry.isChanged() || fAsynch && fSuccess)) {
                this.replace(binEntry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void storeAll(Set setBinEntries) {
            int cEntries = setBinEntries.size();
            if (cEntries == 0) {
                return;
            }
            ReadWriteBackingMap.this.heartbeat();
            boolean fAsynch = ReadWriteBackingMap.this.getWriteQueue() != null;
            HashSet setAll = setBinEntries;
            if (fAsynch) {
                setAll = new HashSet(setBinEntries);
            }
            long lStart = StoreWrapper.getSafeTimeMillis();
            boolean fSuccess = true;
            try {
                this.storeAllInternal(setBinEntries);
            }
            catch (RuntimeException e) {
                fSuccess = false;
                this.f_cStoreFailures.incrementAndGet();
                this.onStoreAllFailure(setBinEntries, e, this.isBlocking());
            }
            finally {
                if (this.isBlocking()) {
                    this.f_cStoreOps.incrementAndGet();
                    this.f_cStoreEntries.addAndGet(cEntries);
                    long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                    if (lElapsed != 0L) {
                        this.f_cStoreMillis.addAndGet(lElapsed);
                    }
                } else {
                    this.f_cPendingAsyncStoreOps.incrementAndGet();
                }
            }
            for (Object o : setAll) {
                Entry entry = (Entry)o;
                entry.stopTracking();
                if (!entry.isChanged() && (!fAsynch || !fSuccess && setBinEntries.contains(entry))) continue;
                this.replace(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void erase(Entry binEntry) {
            ReadWriteBackingMap.this.heartbeat();
            long lStart = StoreWrapper.getSafeTimeMillis();
            try {
                this.eraseInternal(binEntry);
                if (ReadWriteBackingMap.this.getWriteQueue() != null && ReadWriteBackingMap.this.isWriteBehindRemove()) {
                    Binary binKey = binEntry.getBinaryKey();
                    ReadWriteBackingMap.this.getInternalCache().remove(binKey);
                    ReadWriteBackingMap.this.getPendingRemoves().remove(binKey);
                }
            }
            catch (RuntimeException e) {
                ++this.m_cEraseFailures;
                this.onEraseFailure(binEntry, (Exception)e);
            }
            finally {
                ++this.m_cEraseOps;
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cEraseMillis += lElapsed;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void eraseAll(Set setBinEntries) {
            boolean fAsynch;
            ReadWriteBackingMap.this.heartbeat();
            HashSet setAll = setBinEntries;
            boolean bl = fAsynch = ReadWriteBackingMap.this.getWriteQueue() != null && ReadWriteBackingMap.this.isWriteBehindRemove();
            if (fAsynch) {
                setAll = new HashSet(setBinEntries);
            }
            long lStart = StoreWrapper.getSafeTimeMillis();
            try {
                this.eraseAllInternal(setBinEntries);
                if (fAsynch) {
                    for (Entry entry : setAll) {
                        ReadWriteBackingMap.this.getInternalCache().remove(entry.getBinaryKey());
                        ReadWriteBackingMap.this.getPendingRemoves().remove(entry.getBinaryKey());
                    }
                }
            }
            catch (RuntimeException e) {
                ++this.m_cEraseFailures;
                this.onEraseAllFailure(setBinEntries, e);
            }
            finally {
                ++this.m_cEraseOps;
                long lElapsed = StoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cEraseMillis += lElapsed;
                }
            }
            if (fAsynch && !setBinEntries.isEmpty()) {
                for (Object o : setAll) {
                    Entry entry = (Entry)o;
                    if (setBinEntries.contains(entry)) continue;
                    ReadWriteBackingMap.this.getInternalCache().remove(entry.getBinaryKey());
                    ReadWriteBackingMap.this.getPendingRemoves().remove(entry.getBinaryKey());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void replace(Entry entry) {
            boolean fSync;
            ObservableMap mapInternal = ReadWriteBackingMap.this.getInternalCache();
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            Binary binKey = entry.getBinaryKey();
            boolean bl = fSync = ReadWriteBackingMap.this.getWriteQueue() == null;
            if (fSync || ReadWriteBackingMap.this.getContext().isKeyOwned(binKey) && mapControl.lock(binKey, 50L)) {
                try {
                    Binary binValue = entry.getBinaryValue();
                    if (Base.equals(binValue, mapInternal.get(binKey))) {
                        if (entry.isChanged()) {
                            binValue = entry.getChangedBinaryValue();
                        }
                        binValue = ExternalizableHelper.undecorate(binValue, 2);
                        ConfigurableCacheMap mapCCM = ReadWriteBackingMap.this.getInternalConfigurableCache();
                        long cExpire = ReadWriteBackingMap.this.extractExpiry(entry);
                        if (binValue == null || cExpire == 1L && mapCCM == null) {
                            mapInternal.remove(binKey);
                        } else if (cExpire == 1L) {
                            mapCCM.evict(binKey);
                        } else if (mapInternal instanceof CacheMap) {
                            ((CacheMap)mapInternal).put(binKey, binValue, cExpire);
                        } else {
                            mapInternal.put(binKey, binValue);
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                }
                finally {
                    if (!fSync) {
                        mapControl.unlock(binKey);
                    }
                }
            }
        }

        protected void onLoadFailure(Object oKeyReal, Exception e) {
            this.onLoadFailure(oKeyReal, e, true);
        }

        protected void onLoadFailure(Object oKeyReal, Exception e, boolean fThrow) {
            if (ReadWriteBackingMap.this.isRethrowExceptions() && fThrow) {
                throw StoreWrapper.ensureRuntimeException(e, "Failed to load key=\"" + String.valueOf(oKeyReal) + "\"");
            }
            StoreWrapper.err("Failed to load key=\"" + String.valueOf(oKeyReal) + "\":");
            StoreWrapper.err(e);
        }

        protected void onLoadAllFailure(Collection colKeys, Exception e) {
            this.onLoadAllFailure(colKeys, e, true);
        }

        protected void onLoadAllFailure(Collection colKeys, Exception e, boolean fThrow) {
            if (ReadWriteBackingMap.this.isRethrowExceptions() && fThrow) {
                throw StoreWrapper.ensureRuntimeException(e, "Failed to load keys=\"" + String.valueOf(colKeys) + "\"");
            }
            StoreWrapper.err("Failed to load keys=\"" + String.valueOf(colKeys) + "\":");
            StoreWrapper.err(e);
        }

        protected void onStoreFailure(Entry entry, Exception e) {
            this.onStoreFailure(entry, e, true);
        }

        protected void onStoreFailure(Entry entry, Exception e, boolean fThrow) {
            WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
            WriteThread writeThread = ReadWriteBackingMap.this.getWriteThread();
            int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
            if (e instanceof UnsupportedOperationException) {
                if (this.isStoreSupported()) {
                    this.setStoreSupported(false);
                    this.reportUnsupported("store");
                }
                cThreshold = Integer.MAX_VALUE;
            }
            String sMsg = "Failed to store key=\"" + String.valueOf(entry.getKey()) + "\"";
            if (queue == null || Thread.currentThread() != writeThread.getThread()) {
                if (ReadWriteBackingMap.this.isRethrowExceptions() && fThrow) {
                    throw StoreWrapper.ensureRuntimeException(e, sMsg);
                }
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
            } else {
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
                if (cThreshold != 0) {
                    this.requeue(queue, cThreshold, entry);
                }
            }
        }

        protected void onStoreAllFailure(Set setBinEntries, Exception e) {
            this.onStoreAllFailure(setBinEntries, e, true);
        }

        protected void onStoreAllFailure(Set setBinEntries, Exception e, boolean fThrow) {
            WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
            WriteThread writeThread = ReadWriteBackingMap.this.getWriteThread();
            int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
            if (e instanceof UnsupportedOperationException) {
                if (this.isStoreAllSupported()) {
                    this.setStoreAllSupported(false);
                    this.reportUnsupported("storeAll");
                }
                cThreshold = Integer.MAX_VALUE;
            }
            String sMsg = this.formatKeys(setBinEntries, "Failed to store");
            if (queue == null || Thread.currentThread() != writeThread.getThread()) {
                if (ReadWriteBackingMap.this.isRethrowExceptions() && fThrow) {
                    throw StoreWrapper.ensureRuntimeException(e, sMsg);
                }
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
            } else {
                if (this.isStoreAllSupported()) {
                    StoreWrapper.err(sMsg);
                    StoreWrapper.err(e);
                }
                if (cThreshold != 0) {
                    for (Object o : setBinEntries) {
                        this.requeue(queue, cThreshold, (Entry)o);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean requeue(WriteQueue queue, int cThreshold, Entry entry) {
            WriteQueue writeQueue = queue;
            synchronized (writeQueue) {
                BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
                Binary binKey = entry.getBinaryKey();
                if (!queue.containsKey(binKey) && ctx.isKeyOwned(binKey)) {
                    long ldtDelay = this.calculateRequeueDelay(queue);
                    queue.add(entry, ldtDelay);
                }
            }
            return true;
        }

        protected long calculateRequeueDelay(WriteQueue queue) {
            return Math.max(ReadWriteBackingMap.this.getWriteBehindMillis() * 2L, MIN_REQUEUE_DELAY);
        }

        protected void onEraseFailure(Entry entry, Exception e) {
            if (e instanceof UnsupportedOperationException) {
                if (this.isEraseSupported()) {
                    this.setEraseSupported(false);
                    this.reportUnsupported("erase");
                }
            } else {
                String sMsg = "Failed to erase key=\"" + String.valueOf(entry.getKey()) + "\"";
                if (ReadWriteBackingMap.this.isWriteBehindRemove()) {
                    WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
                    int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
                    StoreWrapper.err(sMsg);
                    StoreWrapper.err(e);
                    if (queue != null && cThreshold != 0) {
                        this.requeue(queue, cThreshold, entry);
                    }
                } else {
                    if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                        throw StoreWrapper.ensureRuntimeException(e, sMsg);
                    }
                    StoreWrapper.err(sMsg);
                    StoreWrapper.err(e);
                }
            }
        }

        protected void onEraseFailure(Object oKeyReal, Exception e) {
            if (e instanceof UnsupportedOperationException) {
                if (this.isEraseSupported()) {
                    this.setEraseSupported(false);
                    this.reportUnsupported("erase");
                }
            } else {
                String sMsg = "Failed to erase key=\"" + String.valueOf(oKeyReal) + "\"";
                if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                    throw StoreWrapper.ensureRuntimeException(e, sMsg);
                }
                StoreWrapper.err(sMsg);
                StoreWrapper.err(e);
            }
        }

        protected void onEraseAllFailure(Set setBinEntries, Exception e) {
            if (e instanceof UnsupportedOperationException) {
                if (this.isEraseAllSupported()) {
                    this.setEraseAllSupported(false);
                    this.reportUnsupported("eraseAll");
                }
            } else {
                String sMsg = this.formatKeys(setBinEntries, "Failed to eraseAll");
                if (ReadWriteBackingMap.this.isWriteBehindRemove()) {
                    WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
                    int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
                    StoreWrapper.err(sMsg);
                    StoreWrapper.err(e);
                    if (queue != null && cThreshold != 0) {
                        for (Object o : setBinEntries) {
                            this.requeue(queue, cThreshold, (Entry)o);
                        }
                    }
                } else {
                    if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                        throw StoreWrapper.ensureRuntimeException(e, sMsg);
                    }
                    StoreWrapper.err(sMsg);
                    StoreWrapper.err(e);
                }
            }
        }

        protected void reportUnsupported(String sOp) {
            StoreWrapper.log("The cache store \"" + String.valueOf(this.getStore()) + "\" does not support the " + sOp + " operation.");
        }

        protected String formatKeys(Set setBinEntries, String sHeader) {
            StringBuilder sb = new StringBuilder();
            sb.append(sHeader).append(" keys=\"");
            for (Object o : setBinEntries) {
                sb.append(((Entry)o).getKey()).append(", ");
            }
            sb.append('\"');
            return sb.toString();
        }

        public abstract Object getStore();

        protected abstract AbstractBundler instantiateLoadBundler();

        protected abstract AbstractBundler instantiateStoreBundler();

        protected abstract AbstractBundler instantiateEraseBundler();

        protected abstract Entry loadInternal(Object var1);

        protected abstract Set loadAllInternal(Set var1);

        protected abstract void storeInternal(Entry var1);

        protected abstract void storeAllInternal(Set var1);

        protected abstract void eraseInternal(Entry var1);

        protected abstract void eraseAllInternal(Set var1);
    }

    public class ReadQueue
    extends CoherenceCommunityEdition {
        private List m_listQueued = new RecyclingLinkedList();
        private Map m_mapQueuedReads = new HashMap();

        protected ReadQueue() {
        }

        public synchronized boolean add(Object oKey) {
            Map<Object, Span> map = this.getKeyMap();
            if (map.get(oKey) == null) {
                map.put(oKey, (Span)oKey);
                List list = this.getKeyList();
                boolean fWasEmpty = list.isEmpty();
                list.add(oKey);
                if (fWasEmpty) {
                    this.notify();
                }
                return true;
            }
            return false;
        }

        public Object peek() {
            return this.peek(-1L);
        }

        public synchronized Object peek(long cMillis) {
            List list = this.getKeyList();
            while (ReadWriteBackingMap.this.isActive()) {
                if (!list.isEmpty()) {
                    return list.get(0);
                }
                if (cMillis == 0L) {
                    return null;
                }
                long cWait = cMillis < 0L || cMillis > 255L ? 255L : cMillis;
                ReadWriteBackingMap.this.waitFor(this, cWait);
                if (cMillis <= 0L) continue;
                cMillis = Math.max(0L, cMillis - cWait);
            }
            return null;
        }

        public synchronized boolean remove(Object oKey) {
            if (this.getKeyMap().remove(oKey) != null) {
                this.getKeyList().remove(oKey);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ReadLatch select(long cWaitMillis) {
            Object oKey;
            List listKeys = this.getKeyList();
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            if (cWaitMillis == -1L) {
                oKey = this.peek(-1L);
            } else {
                long ldtStart = Base.getSafeTimeMillis();
                oKey = this.peek(cWaitMillis);
                cWaitMillis -= Math.max(0L, Base.getSafeTimeMillis() - ldtStart);
            }
            if (oKey == null) {
                return null;
            }
            block6: do {
                long cWaitLatch = 0L;
                int index = 0;
                while (oKey != null) {
                    boolean fRemoved = false;
                    if (mapControl.lock(oKey, cWaitLatch)) {
                        try {
                            if (this.remove(oKey)) {
                                ReadLatch latch = ReadWriteBackingMap.this.instantiateReadLatch(oKey);
                                mapControl.put(oKey, latch);
                                ReadLatch readLatch = latch;
                                return readLatch;
                            }
                            fRemoved = true;
                        }
                        finally {
                            mapControl.unlock(oKey);
                        }
                    }
                    if ((cWaitMillis -= cWaitLatch) < 0L) continue block6;
                    try {
                        oKey = listKeys.get(fRemoved ? index : ++index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        continue block6;
                    }
                    cWaitLatch += 10L;
                }
            } while (cWaitMillis != 0L);
            return null;
        }

        public synchronized void clear() {
            this.getKeyMap().clear();
            this.getKeyList().clear();
        }

        public int size() {
            return this.getKeyList().size();
        }

        @Override
        public String toString() {
            return "ReadQueue: " + String.valueOf(this.getKeyList());
        }

        protected List getKeyList() {
            return this.m_listQueued;
        }

        protected Map<Object, Span> getKeyMap() {
            return this.m_mapQueuedReads;
        }
    }

    public class WriteQueue
    extends CoherenceCommunityEdition {
        private final Map m_mapQueuedWrites = new SafeHashMap();
        private final LongArray m_arrQueue = new SparseArray();
        private final Map m_mapPending = new HashMap();
        private long m_cDelayMillis = 60000L;
        private static final long ACCELERATE_MIN = 255L;
        private boolean m_fWaitingOnPending;
        private boolean m_fFlush;

        protected WriteQueue() {
        }

        public int getDelaySeconds() {
            long cMillis = this.getDelayMillis();
            return cMillis == 0L ? 0 : Math.max(1, (int)(cMillis / 1000L));
        }

        public void setDelaySeconds(int cSeconds) {
            this.setDelayMillis(1000L * (long)cSeconds);
        }

        public long getDelayMillis() {
            return this.m_cDelayMillis;
        }

        public synchronized void setDelayMillis(long cMillis) {
            this.m_cDelayMillis = Math.max(1L, cMillis);
            this.notify();
        }

        protected synchronized Entry add(Entry entryNew, long cDelay) {
            Binary binKey;
            Map map = this.getEntryMap();
            Entry entry = (Entry)map.get(binKey = entryNew.getBinaryKey());
            if (entry == null) {
                List listKeys;
                cDelay = Math.max(this.getDelayMillis(), cDelay);
                LongArray arrayRipe = this.getRipeArray();
                boolean fWasEmpty = arrayRipe.isEmpty();
                long ldtNow = WriteQueue.getSafeTimeMillis();
                long ldtRipe = ldtNow + cDelay & 0xFFFFFFFFFFFFFF00L;
                long ldtSoftRipe = ldtNow + (long)((double)cDelay * (1.0 - ReadWriteBackingMap.this.getWriteBatchFactor()));
                if (!fWasEmpty) {
                    long ldtFirst = arrayRipe.getFirstIndex();
                    long ldtLast = arrayRipe.getLastIndex();
                    if (ldtSoftRipe <= ldtFirst) {
                        ldtRipe = ldtFirst;
                    } else if (ldtLast > ldtRipe) {
                        int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
                        int cSize = this.size();
                        if (cThreshold > 0 && cSize % cThreshold == 0) {
                            WriteQueue.log("Due to requeuing after store failures, the queue size reached " + cSize + " entries and runs behind the schedule by " + (ldtLast - ldtRipe) + " ms.");
                        }
                        ldtRipe = ldtLast;
                    }
                }
                if (arrayRipe.exists(ldtRipe)) {
                    listKeys = (List)arrayRipe.get(ldtRipe);
                } else {
                    listKeys = new InflatableList();
                    arrayRipe.set(ldtRipe, listKeys);
                }
                entryNew.setRipeMillis(ldtRipe);
                map.put(binKey, entryNew);
                listKeys.add(binKey);
                if (fWasEmpty) {
                    this.notify();
                }
                return entryNew;
            }
            entry.updateBinaryValue(entryNew.getBinaryValue());
            entry.expire(entryNew.getExpiry());
            return entry;
        }

        protected synchronized Entry remove(Object binKey) {
            long lIndex;
            LongArray arrayRipe;
            List listKeys;
            Entry entry;
            if (ReadWriteBackingMap.this.getContext().isKeyOwned(binKey) && Thread.currentThread() != ReadWriteBackingMap.this.getWriteThread().getThread()) {
                while (this.getPendingMap().containsKey(binKey)) {
                    this.setWaitingOnPending(true);
                    ReadWriteBackingMap.this.waitFor(this, 100L);
                }
            }
            if ((entry = (Entry)this.getEntryMap().remove(binKey)) != null && (listKeys = (List)(arrayRipe = this.getRipeArray()).get(lIndex = entry.getRipeMillis())) != null) {
                listKeys.remove(binKey);
                if (listKeys.isEmpty()) {
                    arrayRipe.remove(lIndex);
                }
            }
            return entry;
        }

        protected synchronized Entry removeImmediate() {
            long lIndex;
            List listKeys;
            if (!ReadWriteBackingMap.this.isActive()) {
                return null;
            }
            LongArray arrayRipe = this.getRipeArray();
            if (!arrayRipe.isEmpty() && !(listKeys = (List)arrayRipe.get(lIndex = arrayRipe.getFirstIndex())).isEmpty()) {
                Object oKey = listKeys.remove(0);
                if (listKeys.isEmpty()) {
                    arrayRipe.remove(lIndex);
                }
                return (Entry)this.getEntryMap().remove(oKey);
            }
            return null;
        }

        public Entry remove() {
            return this.remove(-1L);
        }

        public synchronized Entry remove(long cMillis) {
            LongArray arrayRipe = this.getRipeArray();
            while (ReadWriteBackingMap.this.isActive()) {
                long cWait;
                long ldtNow = WriteQueue.getSafeTimeMillis();
                long lIndex = arrayRipe.getFirstIndex();
                long ldtSoftRipe = lIndex - (long)((double)this.getDelayMillis() * ReadWriteBackingMap.this.getWriteBatchFactor());
                if (lIndex > 0L && (ldtSoftRipe <= ldtNow || this.m_fFlush)) {
                    List listKeys = (List)arrayRipe.get(lIndex);
                    if (!listKeys.isEmpty()) {
                        Object oKey = listKeys.remove(0);
                        Entry entry = (Entry)this.getEntryMap().remove(oKey);
                        if (listKeys.isEmpty()) {
                            arrayRipe.remove(lIndex);
                        }
                        this.getPendingMap().put(oKey, entry);
                        return entry;
                    }
                    arrayRipe.remove(lIndex);
                    continue;
                }
                this.m_fFlush = false;
                if (cMillis == 0L) {
                    return null;
                }
                long l = cWait = cMillis <= 0L || cMillis > 255L ? 255L : cMillis;
                if (lIndex > ldtNow) {
                    cWait = Math.min(cWait, lIndex - ldtNow);
                }
                ReadWriteBackingMap.this.waitFor(this, cWait);
                if (cMillis <= 0L) continue;
                cMillis = Math.max(0L, cMillis - cWait);
            }
            return null;
        }

        public synchronized Entry removeNoWait() {
            if (ReadWriteBackingMap.this.isActive()) {
                LongArray arrayRipe = this.getRipeArray();
                if (arrayRipe.isEmpty()) {
                    this.m_fFlush = false;
                } else {
                    List listKeys;
                    long ldtNow = WriteQueue.getSafeTimeMillis();
                    long lIndex = arrayRipe.getFirstIndex();
                    long ldtSoftRipe = lIndex - (long)((double)this.getDelayMillis() * ReadWriteBackingMap.this.getWriteBatchFactor());
                    if ((this.m_fFlush || ldtSoftRipe <= ldtNow) && !(listKeys = (List)arrayRipe.get(lIndex)).isEmpty()) {
                        Object binKey = listKeys.remove(0);
                        Entry entry = (Entry)this.getEntryMap().remove(binKey);
                        if (listKeys.isEmpty()) {
                            arrayRipe.remove(lIndex);
                        }
                        this.getPendingMap().put(binKey, entry);
                        return entry;
                    }
                }
            }
            return null;
        }

        public int size() {
            return this.getEntryMap().size();
        }

        public boolean isEmpty() {
            return this.getEntryMap().isEmpty();
        }

        public synchronized boolean isFlushed() {
            return this.getEntryMap().isEmpty() && this.getPendingMap().isEmpty();
        }

        public synchronized void flush() {
            this.m_fFlush = true;
            this.notifyAll();
        }

        public boolean containsKey(Object binKey) {
            return this.getEntryMap().containsKey(binKey);
        }

        public synchronized Object checkPending(Object binKey) {
            Entry entry = (Entry)this.getEntryMap().get(binKey);
            if (entry == null) {
                entry = (Entry)this.getPendingMap().get(binKey);
            }
            return entry == null ? null : entry.getBinaryValue();
        }

        public synchronized void clearPending() {
            if (this.isWaitingOnPending()) {
                this.notifyAll();
                this.setWaitingOnPending(false);
            }
            this.getPendingMap().clear();
        }

        public synchronized boolean accelerateEntryRipe(Binary binKey) {
            long ldtRipeThreshold;
            Entry entry = (Entry)this.getEntryMap().get(binKey);
            if (entry == null) {
                entry = (Entry)this.getPendingMap().get(binKey);
                return entry == null || ReadWriteBackingMap.this.extractExpiry(entry) == 1L;
            }
            long ldtNow = Base.getSafeTimeMillis();
            long ldtRipe = entry.getRipeMillis();
            if (ldtRipe >= (ldtRipeThreshold = ldtNow + 255L)) {
                long ldtFirst;
                LongArray arrayRipe = this.getRipeArray();
                List listKeys = (List)arrayRipe.get(ldtRipe);
                listKeys.remove(binKey);
                if (listKeys.isEmpty()) {
                    arrayRipe.remove(ldtRipe);
                }
                if ((ldtFirst = arrayRipe.getFirstIndex()) >= 0L && ldtFirst < ldtRipeThreshold) {
                    listKeys = (List)arrayRipe.get(ldtFirst);
                    listKeys.add(binKey);
                    entry.setRipeMillis(ldtFirst);
                } else {
                    ldtRipe = ldtNow + 10L;
                    listKeys = new InflatableList();
                    arrayRipe.set(ldtRipe, listKeys);
                    listKeys.add(binKey);
                    entry.setRipeMillis(ldtRipe);
                }
                entry.expire(1L);
            }
            return false;
        }

        protected Map getEntryMap() {
            return this.m_mapQueuedWrites;
        }

        protected LongArray getRipeArray() {
            return this.m_arrQueue;
        }

        protected Map getPendingMap() {
            return this.m_mapPending;
        }

        protected boolean isWaitingOnPending() {
            return this.m_fWaitingOnPending;
        }

        protected void setWaitingOnPending(boolean fPending) {
            this.m_fWaitingOnPending = fPending;
        }
    }

    public class ReadThread
    extends Daemon {
        protected volatile boolean m_fRefreshContext;

        public ReadThread() {
            super("ReadThread:" + String.valueOf(ReadWriteBackingMap.this.getCacheStore()) + (String)(ReadWriteBackingMap.this.getCacheService() == null ? "" : ":" + ReadWriteBackingMap.this.getCacheService().getInfo().getServiceName()), 5, false);
            this.m_fRefreshContext = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ContainerHelper.initializeThreadContext(ReadWriteBackingMap.this.getCacheService());
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            ReadQueue queue = ReadWriteBackingMap.this.getReadQueue();
            long cWaitMillis = this.getMaxWaitMillis(255L);
            try {
                while (ReadWriteBackingMap.this.isActive() && !this.isStopping()) {
                    Binary oValue;
                    StoreWrapper store;
                    if (this.m_fRefreshContext) {
                        GuardSupport.setThreadContext(this.getContext());
                        this.m_fRefreshContext = false;
                    }
                    if ((store = ReadWriteBackingMap.this.getCacheStore()) == null) continue;
                    this.heartbeat();
                    ReadLatch latch = queue.select(cWaitMillis);
                    if (latch == null) continue;
                    Object oKey = latch.getKey();
                    BackingMapBinaryEntry entry = null;
                    Throwable exception = null;
                    try {
                        if (ReadWriteBackingMap.this.getContext().isKeyOwned(oKey)) {
                            entry = store.load(oKey);
                        }
                    }
                    catch (Throwable e) {
                        exception = e;
                    }
                    Binary binary = oValue = entry == null ? null : entry.getBinaryValue();
                    if (mapControl.lock(oKey, 0L)) {
                        try {
                            if (exception != null || latch.isCanceled() || !ReadWriteBackingMap.this.getContext().isKeyOwned(oKey)) continue;
                            ReadWriteBackingMap.this.putToInternalCache(oKey, oValue, ReadWriteBackingMap.this.extractExpiry((Entry)entry));
                            continue;
                        }
                        finally {
                            mapControl.remove(oKey);
                            mapControl.unlock(oKey);
                            continue;
                        }
                    }
                    if (exception == null) {
                        latch.complete(oValue);
                    } else {
                        latch.cancel(exception);
                    }
                    mapControl.remove(oKey);
                }
            }
            finally {
                ReadWriteBackingMap.this.terminateReadThread();
            }
        }

        @Override
        public void terminate() {
            ReadThread.err("The refresh-ahead thread timed out.  This could be indicative of an extremely slow-running or hung CacheStore call, or deadlock.");
            GuardSupport.logStackTraces();
            this.setGuardPolicy((Guardian)((Object)ReadWriteBackingMap.this.getContext().getCacheService()), ReadWriteBackingMap.this.getCacheStoreTimeoutMillis(), 0.9f);
        }

        @Override
        protected void setGuardPolicy(Guardian guardian, long cTimeoutMillis, float flPctRecover) {
            super.setGuardPolicy(guardian, cTimeoutMillis, flPctRecover);
        }
    }

    public class WriteThread
    extends Daemon {
        protected volatile boolean m_fRefreshContext;

        public WriteThread() {
            super("WriteBehindThread:" + String.valueOf(ReadWriteBackingMap.this.getCacheStore()) + (String)(ReadWriteBackingMap.this.getCacheService() == null ? "" : ":" + ReadWriteBackingMap.this.getCacheService().getInfo().getServiceName()), 5, false);
            this.m_fRefreshContext = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CacheService service = ReadWriteBackingMap.this.getCacheService();
            ClassLoader loader = service.getContextClassLoader();
            if (loader != null) {
                this.setThreadContextClassLoader(loader);
            }
            ContainerHelper.initializeThreadContext(service);
            try {
                while (ReadWriteBackingMap.this.isActive() && !this.isStopping()) {
                    WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
                    StoreWrapper store = ReadWriteBackingMap.this.getCacheStore();
                    long cWait = this.getMaxWaitMillis(255L);
                    if (this.m_fRefreshContext) {
                        GuardSupport.setThreadContext(this.getContext());
                        this.m_fRefreshContext = false;
                    }
                    if (queue == null || store == null) continue;
                    try {
                        LinkedHashSet<Entry> setErase;
                        this.heartbeat();
                        Entry entry = queue.remove(cWait);
                        if (entry == null) continue;
                        boolean fStoreAll = store.isStoreAllSupported();
                        boolean fEraseAll = store.isEraseAllSupported();
                        int cEntries = 0;
                        int cMaxEntries = ReadWriteBackingMap.this.getWriteMaxBatchSize();
                        LinkedHashSet<Entry> setStore = fStoreAll ? new LinkedHashSet<Entry>(cMaxEntries, 0.75f) : null;
                        LinkedHashSet<Entry> linkedHashSet = setErase = fEraseAll ? new LinkedHashSet<Entry>(cMaxEntries, 0.75f) : null;
                        while (entry != null) {
                            boolean fRemove = WriteThread.equals(entry.getBinaryValue(), BIN_ERASE_PENDING);
                            if (fRemove) {
                                if (fEraseAll) {
                                    setErase.add(entry);
                                } else {
                                    store.erase(entry);
                                }
                            } else if (fStoreAll) {
                                setStore.add(entry);
                            } else {
                                store.store(entry, true);
                            }
                            if (++cEntries >= cMaxEntries) break;
                            entry = queue.removeNoWait();
                        }
                        if (fEraseAll && !setErase.isEmpty()) {
                            if (setErase.size() == 1) {
                                store.erase((Entry)setErase.iterator().next());
                            } else {
                                store.eraseAll(setErase);
                            }
                        }
                        if (!fStoreAll || setStore.isEmpty()) continue;
                        if (setStore.size() == 1) {
                            store.store((Entry)setStore.iterator().next(), true);
                            continue;
                        }
                        store.storeAll(setStore);
                    }
                    catch (Throwable e) {
                        WriteThread.err("An exception occurred on the write-behind thread");
                        WriteThread.err(e);
                        WriteThread.err("(The exception will be ignored. The write-behind thread will continue.)");
                        Thread.interrupted();
                    }
                    finally {
                        queue.clearPending();
                    }
                }
            }
            finally {
                ReadWriteBackingMap.this.terminateWriteThread();
            }
        }

        @Override
        public void terminate() {
            WriteThread.err("The write-behind thread timed out.  This could be indicative of an extremely slow-running or hung CacheStore call, or deadlock.");
            GuardSupport.logStackTraces();
            this.setGuardPolicy((Guardian)((Object)ReadWriteBackingMap.this.getContext().getCacheService()), ReadWriteBackingMap.this.getCacheStoreTimeoutMillis(), 0.9f);
        }

        @Override
        protected void setGuardPolicy(Guardian guardian, long cTimeoutMillis, float flPctRecover) {
            super.setGuardPolicy(guardian, cTimeoutMillis, flPctRecover);
        }
    }

    public class Entry
    extends BackingMapBinaryEntry {
        private long m_ldtRipeMillis;
        private boolean m_fTrackChanges;
        private Binary m_binChangedValue;
        private boolean m_fExpiryChanged;
        protected final Span f_spanParent;

        public Entry(Binary binKey, Binary binValue, Binary binValueOrig, long cExpiry, BackingMapManagerContext ctx) {
            super(binKey, binValue, binValueOrig, cExpiry, ctx);
            this.f_spanParent = TracingHelper.getActiveSpan();
        }

        @Override
        public Object setValue(Object oValue) {
            if (this.m_fTrackChanges) {
                this.m_binChangedValue = (Binary)this.getContext().getValueToInternalConverter().convert(oValue);
                return null;
            }
            return super.setValue(oValue);
        }

        @Override
        public void updateBinaryValue(Binary binValue) {
            Span entrySpan = this.getParentSpan();
            if (!TracingHelper.isNoop(entrySpan)) {
                SpanContext entryContext = entrySpan.getContext();
                Span currentSpan = TracingHelper.getActiveSpan();
                if (currentSpan != null) {
                    SpanContext currentContext = currentSpan.getContext();
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("Span").append("[trace-id=").append(entryContext.getTraceId()).append(", span-id=").append(entryContext.getSpanId()).append("] associated with this queued entry has been updated by this operation").append("[trace-id=").append(currentContext.getTraceId()).append(", span-id=").append(currentContext.getSpanId()).append("] prior to flush.");
                    currentSpan.log(sb.toString());
                }
            }
            if (this.m_fTrackChanges) {
                this.m_binChangedValue = binValue == null ? REMOVED : binValue;
            } else {
                super.updateBinaryValue(binValue);
            }
        }

        @Override
        public ObservableMap getBackingMap() {
            return ReadWriteBackingMap.this;
        }

        @Override
        public void expire(long cMillis) {
            if (this.m_fTrackChanges && cMillis != this.getExpiry()) {
                this.m_fExpiryChanged = true;
            }
            super.expire(cMillis);
        }

        public long getRipeMillis() {
            return this.m_ldtRipeMillis;
        }

        protected void setRipeMillis(long ldtMillis) {
            this.m_ldtRipeMillis = ldtMillis;
        }

        public boolean isChanged() {
            return this.m_binChangedValue != null || this.m_fExpiryChanged;
        }

        public Binary getChangedBinaryValue() {
            Binary binValue = this.m_binChangedValue;
            if (this.isChanged() && binValue == null) {
                return this.getBinaryValue();
            }
            return binValue == REMOVED ? null : binValue;
        }

        protected void startTracking() {
            this.m_fTrackChanges = true;
        }

        protected void stopTracking() {
            this.m_fTrackChanges = false;
        }

        protected Span getParentSpan() {
            return this.f_spanParent;
        }
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        @Override
        public Iterator iterator() {
            if (ReadWriteBackingMap.this.isEmpty()) {
                return NullImplementation.getIterator();
            }
            return new SimpleEnumerator(ReadWriteBackingMap.this.getInternalCache().keySet().toArray()){
                private Map.Entry m_entryPrev;

                @Override
                public Object next() {
                    this.m_entryPrev = EntrySet.this.instantiateEntry(super.next());
                    return this.m_entryPrev;
                }

                @Override
                public void remove() {
                    if (this.m_entryPrev == null) {
                        throw new IllegalStateException();
                    }
                    ReadWriteBackingMap.this.removeInternal(this.m_entryPrev.getKey(), true);
                    this.m_entryPrev = null;
                }
            };
        }

        @Override
        public int size() {
            int cPendingRemoves = ReadWriteBackingMap.this.getPendingRemoves() == null ? 0 : ReadWriteBackingMap.this.getPendingRemoves().size();
            return ReadWriteBackingMap.this.size() - cPendingRemoves;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                ReadWriteBackingMap map = ReadWriteBackingMap.this;
                Map.Entry entry = (Map.Entry)o;
                Object oKey = entry.getKey();
                return map.containsKey(oKey) && Base.equals(entry.getValue(), map.get(oKey)) && map.containsKey(oKey);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            ReadWriteBackingMap map = ReadWriteBackingMap.this;
            Object oKey = ((Map.Entry)o).getKey();
            boolean fExists = map.containsKey(oKey);
            map.removeInternal(oKey, true);
            return fExists;
        }

        @Override
        public void clear() {
            ReadWriteBackingMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            Object[] aoKey = ReadWriteBackingMap.this.getInternalCache().keySet().toArray();
            int cKeys = aoKey.length;
            if (ao == null) {
                ao = new Object[cKeys];
            } else if (ao.length < cKeys) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cKeys);
            } else if (ao.length > cKeys) {
                ao[cKeys] = null;
            }
            for (int i = 0; i < cKeys; ++i) {
                ao[i] = this.instantiateEntry(aoKey[i]);
            }
            return ao;
        }

        protected Map.Entry instantiateEntry(Object oKey) {
            return new SimpleMapEntry(oKey){

                @Override
                public Object getValue() {
                    return ReadWriteBackingMap.this.get(this.getKey());
                }

                @Override
                public Object setValue(Object oValue) {
                    return ReadWriteBackingMap.this.put(this.getKey(), oValue);
                }
            };
        }
    }

    protected class KeySet
    extends AbstractSet {
        protected KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator m_iter;
                private Object m_oKeyPrev;
                {
                    this.m_iter = ReadWriteBackingMap.this.getInternalCache().keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    Object oKey = this.m_iter.next();
                    this.m_oKeyPrev = oKey;
                    return oKey;
                }

                @Override
                public void remove() {
                    if (this.m_oKeyPrev == null) {
                        throw new IllegalStateException();
                    }
                    ReadWriteBackingMap.this.removeInternal(this.m_oKeyPrev, true);
                    this.m_oKeyPrev = null;
                }
            };
        }

        @Override
        public int size() {
            int cPendinRemoves = ReadWriteBackingMap.this.isWriteBehindRemove() ? ReadWriteBackingMap.this.getPendingRemoves().size() : 0;
            return ReadWriteBackingMap.this.getInternalCache().keySet().size() - cPendinRemoves;
        }

        @Override
        public boolean contains(Object oKey) {
            return ReadWriteBackingMap.this.containsKey(oKey);
        }

        @Override
        public boolean remove(Object o) {
            ReadWriteBackingMap map = ReadWriteBackingMap.this;
            boolean fExists = map.containsKey(o);
            map.removeInternal(o, true);
            return fExists;
        }

        @Override
        public boolean removeAll(Collection colKeys) {
            return ReadWriteBackingMap.this.removeAll(colKeys);
        }

        @Override
        public void clear() {
            ReadWriteBackingMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return ReadWriteBackingMap.this.getInternalCache().keySet().toArray();
        }

        @Override
        public Object[] toArray(Object[] ao) {
            return ReadWriteBackingMap.this.getInternalCache().keySet().toArray(ao);
        }
    }

    protected class ValuesCollection
    extends AbstractCollection {
        protected ValuesCollection() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator m_iter;
                {
                    this.m_iter = ReadWriteBackingMap.this.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    return ReadWriteBackingMap.this.get(this.m_iter.next());
                }

                @Override
                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        @Override
        public int size() {
            int cPendinRemoves = ReadWriteBackingMap.this.isWriteBehindRemove() ? ReadWriteBackingMap.this.getPendingRemoves().size() : 0;
            return ReadWriteBackingMap.this.size() - cPendinRemoves;
        }

        @Override
        public void clear() {
            ReadWriteBackingMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return ReadWriteBackingMap.this.getInternalCache().values().toArray();
        }

        @Override
        public Object[] toArray(Object[] ao) {
            return ReadWriteBackingMap.this.getInternalCache().values().toArray(ao);
        }
    }

    protected static class ReadLatch {
        private volatile boolean m_fComplete;
        private volatile boolean m_fCanceled;
        private Object m_oKey;
        private Object m_oValue;
        private Throwable m_throwable;

        protected ReadLatch(Object oKey) {
            this.m_oKey = oKey;
        }

        public synchronized void cancel() {
            this.cancel(null);
        }

        public synchronized void cancel(Throwable t) {
            if (!this.m_fCanceled && !this.m_fComplete) {
                this.m_oValue = null;
                this.m_throwable = t;
                this.m_fCanceled = true;
                this.m_fComplete = true;
                this.notifyAll();
            }
        }

        public synchronized void complete(Object oValue) {
            if (!this.m_fCanceled && !this.m_fComplete) {
                this.m_oValue = oValue;
                this.m_fComplete = true;
                this.notifyAll();
            }
        }

        public boolean isComplete() {
            return this.m_fComplete;
        }

        public boolean isCanceled() {
            return this.m_fCanceled;
        }

        public Object getKey() {
            return this.m_oKey;
        }

        public synchronized Object getValue() {
            Throwable throwable = this.m_throwable;
            if (throwable != null && this.m_fCanceled) {
                throw Base.ensureRuntimeException(throwable);
            }
            return this.m_oValue;
        }
    }

    protected class InternalMapListener
    extends Base
    implements MapListener {
        protected InternalMapListener() {
        }

        public void entryInserted(MapEvent evt) {
            this.dispatch(evt);
        }

        public void entryUpdated(MapEvent evt) {
            this.dispatch(evt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void entryDeleted(MapEvent evt) {
            if (ReadWriteBackingMap.this.isWriteBehind()) {
                mapInternal = ReadWriteBackingMap.this.getInternalConfigurableCache();
                approver = mapInternal == null ? null : mapInternal.getEvictionApprover();
                v0 = fApproverChanged = mapInternal != null && approver != ConfigurableCacheMap.EvictionApprover.DISAPPROVER && approver != ReadWriteBackingMap.this.f_writeBehindDisapprover;
                if (mapInternal == null || fApproverChanged) {
                    if (fApproverChanged) {
                        InternalMapListener.err(String.format("The internal map of a ReadWriteBackingMap has an unexpected EvictionApprover(type=%s); custom maps should accept and use the supplied approver.", new Object[]{approver == null ? null : approver.getClass().getName()}));
                    }
                    if ((mapControl = ReadWriteBackingMap.this.getControlMap()).lock(oKey = evt.getKey(), 500L)) {
                        try {
                            if (!ReadWriteBackingMap.this.getContext().isKeyOwned(oKey)) ** GOTO lbl23
                            this.processDeletedEntry(oKey, evt.getOldValue());
                        }
                        finally {
                            mapControl.unlock(oKey);
                        }
                    } else {
                        oValueOld = evt.getOldValue();
                        oValue = ReadWriteBackingMap.this.getInternalCache().put(oKey, oValueOld);
                        if (oValue != null && !InternalMapListener.equals(oValue, oValueOld)) {
                            sCulprit = ReadWriteBackingMap.this.getCacheStore() == null ? "backing map" : "cache store";
                            InternalMapListener.err("Due to an exceptionally long " + sCulprit + " operation an eviction event cannot be processed in order. Canceling the eviction: " + String.valueOf(evt));
                        }
                        return;
                    }
                }
            }
lbl23:
            // 6 sources

            this.dispatch(evt);
        }

        protected void processDeletedEntry(Object oKey, Object oValueOld) {
            Entry entry;
            StoreWrapper store = ReadWriteBackingMap.this.getCacheStore();
            if (store != null && !ReadWriteBackingMap.this.isReadOnly() && (entry = ReadWriteBackingMap.this.removeFromWriteQueue(oKey)) != null) {
                try {
                    store.store(entry, false);
                }
                catch (WrapperException e) {
                    InternalMapListener.log(e);
                }
            }
        }

        protected void dispatch(final MapEvent evt) {
            MapListenerSupport support = ReadWriteBackingMap.this.m_listenerSupport;
            if (support != null) {
                Object oKey = evt.getKey();
                boolean fSynthetic = evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic() || ReadWriteBackingMap.this.getSyntheticEventsMap().containsKey(oKey);
                CacheEvent evtNew = new CacheEvent(ReadWriteBackingMap.this, evt.getId(), oKey, null, null, fSynthetic, CacheEvent.TransformationState.TRANSFORMABLE, false, evt instanceof CacheEvent && ((CacheEvent)evt).isExpired()){

                    @Override
                    public Object getOldValue() {
                        return evt.getOldValue();
                    }

                    @Override
                    public Object getNewValue() {
                        return evt.getNewValue();
                    }
                };
                support.fireEvent(evtNew, true);
            }
        }
    }

    public class CacheStoreWrapper
    extends StoreWrapper {
        private CacheStore m_store;

        public CacheStoreWrapper(CacheStore store) {
            CacheStoreWrapper.azzert(store != null);
            this.m_store = store;
        }

        @Override
        public AbstractBundler instantiateLoadBundler() {
            return new AbstractKeyBundler(){

                @Override
                protected Map bundle(Collection colKeys) {
                    return CacheStoreWrapper.this.getCacheStore().loadAll(colKeys);
                }

                @Override
                protected Object unbundle(Object oKey) {
                    return CacheStoreWrapper.this.getCacheStore().load(oKey);
                }
            };
        }

        @Override
        public AbstractBundler instantiateStoreBundler() {
            return new AbstractEntryBundler(){

                @Override
                protected void bundle(Map map) {
                    CacheStoreWrapper.this.getCacheStore().storeAll(map);
                }
            };
        }

        @Override
        public AbstractBundler instantiateEraseBundler() {
            return new AbstractKeyBundler(){

                @Override
                protected Map bundle(Collection colKeys) {
                    CacheStoreWrapper.this.getCacheStore().eraseAll(colKeys);
                    return NullImplementation.getMap();
                }

                @Override
                protected Object unbundle(Object oKey) {
                    CacheStoreWrapper.this.getCacheStore().erase(oKey);
                    return null;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Entry loadInternal(Object binKey) {
            BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
            Object oKey = ctx.getKeyFromInternalConverter().convert(binKey);
            Span span = this.newSpan("load").startSpan();
            try {
                Scope scope = TracingHelper.getTracer().withSpan(span);
                try {
                    Entry entry;
                    AbstractKeyBundler bundler = (AbstractKeyBundler)this.m_loadBundler;
                    Object oValueReal = bundler == null ? this.getCacheStore().load(oKey) : bundler.process(oKey);
                    Entry entry2 = entry = oValueReal == null ? null : ReadWriteBackingMap.this.instantiateEntry(binKey, ctx.getValueToInternalConverter().convert(oValueReal), null);
                    if (scope != null) {
                        scope.close();
                    }
                    return entry;
                }
                catch (Throwable bundler) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable) {
                                bundler.addSuppressed(throwable);
                            }
                        }
                        throw bundler;
                    }
                    catch (RuntimeException e) {
                        this.f_cLoadFailures.incrementAndGet();
                        try {
                            this.onLoadFailure(oKey, e);
                        }
                        catch (RuntimeException re) {
                            TracingHelper.augmentSpanWithErrorDetails(span, true, re);
                            throw re;
                        }
                        Entry entry = null;
                        return entry;
                    }
                }
            }
            finally {
                span.end();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Set loadAllInternal(Set setBinKey) {
            BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
            ConverterCollections.ConverterCollection colKeysReal = ConverterCollections.getCollection(setBinKey, ctx.getKeyFromInternalConverter(), ctx.getKeyToInternalConverter());
            Span span = this.newSpan("loadAll").withMetadata("entryCount", colKeysReal.size()).startSpan();
            try {
                Scope scope = TracingHelper.getTracer().withSpan(span);
                try {
                    AbstractKeyBundler bundler = (AbstractKeyBundler)this.m_loadBundler;
                    Map map = bundler == null ? this.getCacheStore().loadAll(colKeysReal) : bundler.processAll(colKeysReal);
                    HashSet<Entry> setReturn = new HashSet<Entry>(map.size());
                    Object object = map.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry oEntry;
                        Map.Entry entry = oEntry = object.next();
                        setReturn.add(ReadWriteBackingMap.this.instantiateEntry(ctx.getKeyToInternalConverter().convert(entry.getKey()), ctx.getValueToInternalConverter().convert(entry.getValue()), null));
                    }
                    object = setReturn;
                    if (scope != null) {
                        scope.close();
                    }
                    return object;
                }
                catch (Throwable bundler) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable) {
                                bundler.addSuppressed(throwable);
                            }
                        }
                        throw bundler;
                    }
                    catch (RuntimeException e) {
                        this.f_cLoadFailures.incrementAndGet();
                        try {
                            this.onLoadFailure(colKeysReal, e);
                        }
                        catch (RuntimeException re) {
                            TracingHelper.augmentSpanWithErrorDetails(span, true, re);
                            throw re;
                        }
                        Set set = Collections.EMPTY_SET;
                        return set;
                    }
                }
            }
            finally {
                span.end();
            }
        }

        @Override
        protected void storeInternal(Entry binEntry) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            Object oKey = binEntry.getKey();
            Object oValue = binEntry.getValue();
            AbstractEntryBundler bundler = (AbstractEntryBundler)this.m_storeBundler;
            Span span = this.newSpan("store", binEntry).startSpan();
            try (Scope scope = TracingHelper.getTracer().withSpan(span);){
                if (bundler == null) {
                    this.getCacheStore().store(oKey, oValue);
                } else {
                    bundler.process(oKey, oValue);
                }
            }
            catch (RuntimeException e) {
                TracingHelper.augmentSpanWithErrorDetails(span, true, e);
                throw e;
            }
            finally {
                span.end();
            }
        }

        @Override
        protected void storeAllInternal(Set setBinEntries) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            EntrySetMap mapEntries = new EntrySetMap(setBinEntries);
            AbstractEntryBundler bundler = (AbstractEntryBundler)this.m_storeBundler;
            Span span = this.newSpan("storeAll", setBinEntries).withMetadata("entryCount", setBinEntries.size()).startSpan();
            try (Scope scope = TracingHelper.getTracer().withSpan(span);){
                if (bundler == null) {
                    this.getCacheStore().storeAll(mapEntries);
                } else {
                    bundler.processAll(mapEntries);
                }
            }
            catch (RuntimeException e) {
                TracingHelper.augmentSpanWithErrorDetails(span, true, e);
                throw e;
            }
            finally {
                span.end();
            }
        }

        @Override
        protected void eraseInternal(Entry binEntry) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            Object oKey = binEntry.getKey();
            AbstractKeyBundler bundler = (AbstractKeyBundler)this.m_eraseBundler;
            Span span = this.newSpan("erase", binEntry).startSpan();
            try (Scope scope = TracingHelper.getTracer().withSpan(span);){
                if (bundler == null) {
                    this.getCacheStore().erase(oKey);
                } else {
                    bundler.process(oKey);
                }
            }
            catch (RuntimeException e) {
                TracingHelper.augmentSpanWithErrorDetails(span, true, e);
                throw e;
            }
            finally {
                span.end();
            }
        }

        @Override
        protected void eraseAllInternal(Set setBinEntries) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            Set colKeys = new EntrySetMap(setBinEntries).keySet();
            AbstractKeyBundler bundler = (AbstractKeyBundler)this.m_eraseBundler;
            Span span = this.newSpan("eraseAll", setBinEntries).withMetadata("entryCount", setBinEntries.size()).startSpan();
            try (Scope scope = TracingHelper.getTracer().withSpan(span);){
                if (bundler == null) {
                    this.getCacheStore().eraseAll(colKeys);
                } else {
                    bundler.processAll(colKeys);
                }
            }
            catch (RuntimeException e) {
                TracingHelper.augmentSpanWithErrorDetails(span, true, e);
                throw e;
            }
            finally {
                span.end();
            }
        }

        @Override
        public Object getStore() {
            return this.getCacheStore();
        }

        public CacheStore getCacheStore() {
            return this.m_store;
        }

        protected Span.Builder newSpan(String sOperation) {
            return TracingHelper.newSpan("cachestore." + sOperation).withMetadata(Span.Type.COMPONENT.key(), "ReadWriteBackingMap");
        }

        protected Span.Builder newSpan(String sOperation, Entry entry) {
            Span.Builder builder = this.newSpan(sOperation);
            Span span = entry.getParentSpan();
            return span == TracingHelper.getActiveSpan() ? builder : builder.withAssociation(Span.Association.FOLLOWS_FROM.key(), span.getContext());
        }

        protected Span.Builder newSpan(String sOperation, Set<Entry> setEntries) {
            Span.Builder builder = this.newSpan(sOperation);
            Span spanLast = TracingHelper.getActiveSpan();
            if (spanLast != null) {
                for (Entry entry : setEntries) {
                    Span span = entry.getParentSpan();
                    if (span == null || span == spanLast) continue;
                    builder = builder.withAssociation(Span.Association.FOLLOWS_FROM.key(), span.getContext());
                    spanLast = span;
                }
            }
            return builder;
        }

        public String toString() {
            Class<?> clzStore = this.m_store.getClass();
            while (clzStore.isSynthetic()) {
                clzStore = clzStore.getSuperclass();
            }
            return "Store=" + clzStore.getName();
        }
    }

    public class BinaryEntryStoreWrapper
    extends StoreWrapper {
        private BinaryEntryStore m_storeBinary;

        public BinaryEntryStoreWrapper(BinaryEntryStore store) {
            BinaryEntryStoreWrapper.azzert(store != null);
            this.m_storeBinary = store;
        }

        @Override
        public AbstractBundler instantiateLoadBundler() {
            return new AbstractBinaryEntryBundler(){

                @Override
                protected void bundle(Set setEntries) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().loadAll(setEntries);
                }

                @Override
                protected void unbundle(BinaryEntry binEntry) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().load(binEntry);
                }
            };
        }

        @Override
        public AbstractBundler instantiateStoreBundler() {
            return new AbstractBinaryEntryBundler(){

                @Override
                protected void bundle(Set setEntries) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().storeAll(setEntries);
                }

                @Override
                protected void unbundle(BinaryEntry binEntry) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().store(binEntry);
                }
            };
        }

        @Override
        public AbstractBundler instantiateEraseBundler() {
            return new AbstractBinaryEntryBundler(){

                @Override
                protected void bundle(Set setEntries) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().eraseAll(setEntries);
                }

                @Override
                protected void unbundle(BinaryEntry binEntry) {
                    BinaryEntryStoreWrapper.this.getBinaryEntryStore().erase(binEntry);
                }
            };
        }

        @Override
        protected Entry loadInternal(Object binKey) {
            Entry binEntry = ReadWriteBackingMap.this.instantiateEntry(binKey, null, null);
            try {
                AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_loadBundler;
                if (bundler == null) {
                    this.getBinaryEntryStore().load(binEntry);
                } else {
                    bundler.process(binEntry);
                }
                return binEntry;
            }
            catch (RuntimeException e) {
                this.f_cLoadFailures.incrementAndGet();
                this.onLoadFailure(binKey, e);
                return null;
            }
        }

        @Override
        protected Set loadAllInternal(Set setBinKey) {
            HashSet<Entry> setEntry = new HashSet<Entry>(setBinKey.size());
            for (Object oKey : setBinKey) {
                setEntry.add(ReadWriteBackingMap.this.instantiateEntry(oKey, null, null));
            }
            try {
                AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_loadBundler;
                if (bundler == null) {
                    this.getBinaryEntryStore().loadAll(setEntry);
                } else {
                    bundler.processAll(setEntry);
                }
                return setEntry;
            }
            catch (RuntimeException e) {
                this.f_cLoadFailures.incrementAndGet();
                this.onLoadAllFailure(setBinKey, e);
                return Collections.EMPTY_SET;
            }
        }

        @Override
        protected void storeInternal(Entry binEntry) {
            BinaryEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            binEntry.startTracking();
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_storeBundler;
            if (bundler == null) {
                this.getBinaryEntryStore().store(binEntry);
            } else {
                bundler.process(binEntry);
            }
        }

        @Override
        protected void storeAllInternal(Set setBinEntries) {
            BinaryEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            for (Object o : setBinEntries) {
                ((Entry)o).startTracking();
            }
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_storeBundler;
            if (bundler == null) {
                this.getBinaryEntryStore().storeAll(setBinEntries);
            } else {
                bundler.processAll(setBinEntries);
            }
        }

        @Override
        protected void eraseInternal(Entry binEntry) {
            BinaryEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_eraseBundler;
            if (bundler == null) {
                this.getBinaryEntryStore().erase(binEntry);
            } else {
                bundler.process(binEntry);
            }
        }

        @Override
        protected void eraseAllInternal(Set setBinEntries) {
            BinaryEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_eraseBundler;
            if (bundler == null) {
                this.getBinaryEntryStore().eraseAll(setBinEntries);
            } else {
                bundler.processAll(setBinEntries);
            }
        }

        @Override
        public Object getStore() {
            return this.getBinaryEntryStore();
        }

        public BinaryEntryStore getBinaryEntryStore() {
            return this.m_storeBinary;
        }

        public String toString() {
            Class<?> clzStore = this.m_storeBinary.getClass();
            while (clzStore.isSynthetic()) {
                clzStore = clzStore.getSuperclass();
            }
            return "BinaryStore=" + clzStore.getName();
        }
    }

    public class NonBlockingEntryStoreWrapper
    extends StoreWrapper {
        private NonBlockingEntryStore f_storeNonBlocking;

        public NonBlockingEntryStoreWrapper(NonBlockingEntryStore store) {
            NonBlockingEntryStoreWrapper.azzert(store != null);
            this.f_storeNonBlocking = store;
        }

        @Override
        public AbstractBundler instantiateLoadBundler() {
            return new AbstractBinaryEntryBundler(){

                @Override
                protected void bundle(Set setEntries) {
                    for (Entry entry : setEntries) {
                        if (!ReadWriteBackingMap.this.isRefreshAhead()) continue;
                        ReadWriteBackingMap.this.getReadQueue().remove(entry.getBinaryKey());
                    }
                    LoadOperationObserver observer = new LoadOperationObserver(setEntries.size());
                    NonBlockingEntryStoreWrapper.this.getNonBlockingEntryStore().loadAll(setEntries, observer);
                    observer.waitForCompleted();
                }

                @Override
                protected void unbundle(BinaryEntry binEntry) {
                    if (ReadWriteBackingMap.this.isRefreshAhead()) {
                        ReadWriteBackingMap.this.getReadQueue().remove(binEntry.getBinaryKey());
                    }
                    LoadOperationObserver observer = new LoadOperationObserver();
                    NonBlockingEntryStoreWrapper.this.getNonBlockingEntryStore().load(binEntry, observer);
                    observer.waitForCompleted();
                }
            };
        }

        @Override
        public AbstractBundler instantiateStoreBundler() {
            return new AbstractBinaryEntryBundler(){

                @Override
                protected void bundle(Set setEntries) {
                    NonBlockingEntryStoreWrapper.this.getNonBlockingEntryStore().storeAll(setEntries, new StoreOperationObserver(setEntries));
                }

                @Override
                protected void unbundle(BinaryEntry binEntry) {
                    NonBlockingEntryStoreWrapper.this.getNonBlockingEntryStore().store(binEntry, new StoreOperationObserver());
                }
            };
        }

        @Override
        public AbstractBundler instantiateEraseBundler() {
            return new AbstractBinaryEntryBundler(){

                @Override
                protected void bundle(Set setEntries) {
                    NonBlockingEntryStoreWrapper.this.getNonBlockingEntryStore().eraseAll(setEntries);
                }

                @Override
                protected void unbundle(BinaryEntry binEntry) {
                    NonBlockingEntryStoreWrapper.this.getNonBlockingEntryStore().erase(binEntry);
                }
            };
        }

        @Override
        protected Entry loadInternal(Object binKey) {
            Entry binEntry = ReadWriteBackingMap.this.instantiateEntry(binKey, null, null);
            try {
                AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_loadBundler;
                if (bundler == null) {
                    if (ReadWriteBackingMap.this.isRefreshAhead()) {
                        ReadWriteBackingMap.this.getReadQueue().remove(binKey);
                    }
                    LoadOperationObserver observer = new LoadOperationObserver();
                    this.getNonBlockingEntryStore().load(binEntry, observer);
                    observer.waitForCompleted();
                    ReadWriteBackingMap.this.putToInternalCache(binEntry);
                } else {
                    bundler.process(binEntry);
                }
                return binEntry;
            }
            catch (RuntimeException e) {
                this.f_cLoadFailures.incrementAndGet();
                this.onLoadFailure(binKey, e);
                return null;
            }
        }

        @Override
        protected Set loadAllInternal(Set setBinKey) {
            HashSet<Entry> setEntries = new HashSet<Entry>(setBinKey.size());
            for (Object oKey : setBinKey) {
                setEntries.add(ReadWriteBackingMap.this.instantiateEntry(oKey, null, null));
                if (!ReadWriteBackingMap.this.isRefreshAhead()) continue;
                ReadWriteBackingMap.this.getReadQueue().remove(oKey);
            }
            try {
                AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_loadBundler;
                if (bundler == null) {
                    LoadOperationObserver observer = new LoadOperationObserver(setBinKey.size());
                    this.getNonBlockingEntryStore().loadAll(setEntries, observer);
                    observer.waitForCompleted();
                    return observer.getProcessedEntries();
                }
                bundler.processAll(setEntries);
                return setEntries;
            }
            catch (RuntimeException e) {
                this.f_cLoadFailures.incrementAndGet();
                this.onLoadAllFailure(setBinKey, e);
                return Collections.EMPTY_SET;
            }
        }

        @Override
        protected void storeInternal(Entry binEntry) {
            NonBlockingEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            binEntry.startTracking();
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_storeBundler;
            if (bundler == null) {
                this.getNonBlockingEntryStore().store(binEntry, new StoreOperationObserver());
            } else {
                bundler.process(binEntry);
            }
        }

        @Override
        protected void storeAllInternal(Set setBinEntries) {
            NonBlockingEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            for (Object o : setBinEntries) {
                ((Entry)o).startTracking();
            }
            StoreOperationObserver observer = new StoreOperationObserver(setBinEntries);
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_storeBundler;
            if (bundler == null) {
                this.getNonBlockingEntryStore().storeAll(setBinEntries, observer);
            } else {
                bundler.processAll(setBinEntries);
            }
        }

        @Override
        protected void eraseInternal(Entry binEntry) {
            NonBlockingEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_eraseBundler;
            if (bundler == null) {
                this.getNonBlockingEntryStore().erase(binEntry);
            } else {
                bundler.process(binEntry);
            }
        }

        @Override
        protected void eraseAllInternal(Set setBinEntries) {
            NonBlockingEntryStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            AbstractBinaryEntryBundler bundler = (AbstractBinaryEntryBundler)this.m_eraseBundler;
            if (bundler == null) {
                this.getNonBlockingEntryStore().eraseAll(setBinEntries);
            } else {
                bundler.processAll(setBinEntries);
            }
        }

        @Override
        public Object getStore() {
            return this.getNonBlockingEntryStore();
        }

        public NonBlockingEntryStore getNonBlockingEntryStore() {
            return this.f_storeNonBlocking;
        }

        public String toString() {
            Class<?> clzStore = this.f_storeNonBlocking.getClass();
            while (clzStore.isSynthetic()) {
                clzStore = clzStore.getSuperclass();
            }
            return "NonBlockingStore=" + clzStore.getName();
        }

        @Override
        public boolean isBlocking() {
            return false;
        }

        public class LoadOperationObserver
        implements StoreObserver {
            private final AtomicInteger f_counterEntries;
            private final Set f_setProcessedEntries;
            private final Set f_setEntriesInError;
            private Throwable m_error;

            public LoadOperationObserver() {
                this(null, 1);
            }

            public LoadOperationObserver(int cEntries) {
                this(new SafeHashSet(), cEntries);
            }

            private LoadOperationObserver(Set setProcessed, int cEntries) {
                this.f_setProcessedEntries = setProcessed;
                this.f_setEntriesInError = new SafeHashSet();
                this.f_counterEntries = new AtomicInteger(cEntries);
            }

            public void onNext(BinaryEntry binEntry) {
                this.completeSync(binEntry, null);
                if (this.f_setProcessedEntries != null) {
                    this.f_setProcessedEntries.add(binEntry);
                }
            }

            public void onError(BinaryEntry binEntry, Exception exception) {
                this.setThrowable(exception);
                this.completeSync(binEntry, exception);
                this.f_setEntriesInError.add(binEntry);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete() {
                this.f_counterEntries.set(-1);
                AtomicInteger atomicInteger = this.f_counterEntries;
                synchronized (atomicInteger) {
                    this.f_counterEntries.notify();
                }
            }

            private void completeSync(BinaryEntry binEntry, Exception exception) {
                if (this.f_setProcessedEntries != null && this.f_setProcessedEntries.contains(binEntry) || this.f_setEntriesInError.contains(binEntry)) {
                    return;
                }
                if (this.f_counterEntries.get() == -1) {
                    throw new IllegalStateException("A method was called on an already closed StoreObserver");
                }
                if (this.f_counterEntries.decrementAndGet() == 0) {
                    this.onComplete();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void waitForCompleted() {
                try {
                    AtomicInteger atomicInteger = this.f_counterEntries;
                    synchronized (atomicInteger) {
                        while (this.f_counterEntries.get() > 0) {
                            Blocking.wait(this.f_counterEntries);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    throw Base.ensureRuntimeException(ie);
                }
                if (this.f_setProcessedEntries != null && this.f_setProcessedEntries.size() == 0 && this.getThrowable() != null) {
                    throw Base.ensureRuntimeException(this.getThrowable());
                }
            }

            protected Set getProcessedEntries() {
                return this.f_setProcessedEntries;
            }

            private Throwable getThrowable() {
                return this.m_error;
            }

            private void setThrowable(Throwable error) {
                this.m_error = error;
            }
        }

        public class StoreOperationObserver
        implements StoreObserver {
            private final long f_ldtStartTime;
            private final AtomicInteger f_counterProcessed = new AtomicInteger();
            private final Set f_setUnProcessed;

            public StoreOperationObserver() {
                this(null);
            }

            public StoreOperationObserver(Set setEntries) {
                this.f_ldtStartTime = Base.getSafeTimeMillis();
                this.f_setUnProcessed = new SafeHashSet();
                if (setEntries != null) {
                    this.f_setUnProcessed.addAll(setEntries);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(BinaryEntry binEntry) {
                Entry entry = (Entry)binEntry;
                ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
                Binary binKey = binEntry.getBinaryKey();
                this.f_counterProcessed.incrementAndGet();
                if (ReadWriteBackingMap.this.getContext().isKeyOwned(binKey) && mapControl.lock(binKey, 100L)) {
                    try {
                        NonBlockingEntryStoreWrapper.this.replace(entry);
                        this.getSetUnProcessed().remove(binEntry);
                    }
                    finally {
                        entry.stopTracking();
                        mapControl.unlock(binKey);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(BinaryEntry binEntry, Exception exception) {
                Entry entry = (Entry)binEntry;
                ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
                Binary binKey = binEntry.getBinaryKey();
                this.f_counterProcessed.incrementAndGet();
                NonBlockingEntryStoreWrapper.this.f_cStoreFailures.incrementAndGet();
                NonBlockingEntryStoreWrapper.this.onStoreFailure(entry, exception, false);
                if (ReadWriteBackingMap.this.getContext().isKeyOwned(binKey) && mapControl.lock(binKey, 100L)) {
                    try {
                        NonBlockingEntryStoreWrapper.this.replace(entry);
                        this.getSetUnProcessed().remove(binEntry);
                    }
                    finally {
                        mapControl.unlock(binKey);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete() {
                ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
                if (this.f_counterProcessed.get() == 0) {
                    NonBlockingEntryStoreWrapper.this.f_cStoreFailures.incrementAndGet();
                }
                NonBlockingEntryStoreWrapper.this.f_cStoreOps.incrementAndGet();
                NonBlockingEntryStoreWrapper.this.f_cStoreEntries.addAndGet(this.f_counterProcessed.get());
                long lElapsed = Base.getSafeTimeMillis() - this.f_ldtStartTime;
                if (lElapsed != 0L) {
                    NonBlockingEntryStoreWrapper.this.f_cStoreMillis.addAndGet(lElapsed);
                }
                NonBlockingEntryStoreWrapper.this.f_cPendingAsyncStoreOps.decrementAndGet();
                for (Entry entry : this.getSetUnProcessed()) {
                    Binary binKey = entry.getBinaryKey();
                    if (!ReadWriteBackingMap.this.getContext().isKeyOwned(binKey) || !mapControl.lock(binKey, 100L)) continue;
                    try {
                        NonBlockingEntryStoreWrapper.this.replace(entry);
                    }
                    finally {
                        entry.stopTracking();
                        mapControl.unlock(binKey);
                    }
                }
            }

            private Set getSetUnProcessed() {
                return this.f_setUnProcessed;
            }
        }
    }

    public static class CacheLoaderCacheStore
    extends AbstractCacheStore {
        private CacheLoader m_loader;

        public CacheLoaderCacheStore(CacheLoader loader) {
            CacheLoaderCacheStore.azzert(loader != null);
            this.m_loader = loader;
        }

        @Override
        public Object load(Object oKey) {
            return this.getCacheLoader().load(oKey);
        }

        @Override
        public Map loadAll(Collection colKeys) {
            return this.getCacheLoader().loadAll(colKeys);
        }

        protected CacheLoader getCacheLoader() {
            return this.m_loader;
        }
    }

    public static class EvictingBackupMap
    extends AbstractKeyBasedMap {
        private Map m_map = new SafeHashMap();

        @Override
        public Object get(Object oKey) {
            return this.m_map.get(oKey);
        }

        @Override
        public Object put(Object oKey, Object oValue) {
            Binary binDeco = ExternalizableHelper.getDecoration((Binary)oValue, 2);
            return EvictingBackupMap.equals(binDeco, BIN_STORE_PENDING) ? this.m_map.put(oKey, oValue) : this.m_map.remove(oKey);
        }

        @Override
        public Object remove(Object oKey) {
            return this.m_map.remove(oKey);
        }

        protected Iterator iterateKeys() {
            return this.m_map.keySet().iterator();
        }
    }
}

