/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.collections.AbstractStableIterator;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.AbstractSerializationCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.CachingMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.SerializationMap;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.net.cache.SimpleOverflowMap;
import com.tangosol.util.AbstractKeySetBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.Gate;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGateLite;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class OverflowMap
extends AbstractKeySetBasedMap
implements CacheMap {
    static final Object[] EMPTY_ARRAY = new Object[0];
    public static final int ENTRY_INSERTED = 1;
    public static final int ENTRY_UPDATED = 2;
    public static final int ENTRY_DELETED = 3;
    private ObservableMap m_mapFront;
    private Map m_mapBack;
    private Map m_mapStatus = new SafeHashMap();
    private Set m_setKeysInternal;
    private AtomicInteger m_countItems = new AtomicInteger();
    private List m_listDeferred = new RecyclingLinkedList();
    private LongArray m_laExpiry;
    private boolean m_fNullValuesAllowed;
    private boolean m_fExpiryEnabled;
    private int m_cExpiryDelay;
    private boolean m_fUseFrontPutAll;
    private Gate m_gate = new ThreadGateLite();
    private MapListener m_listenerFront;
    private MapListener m_listenerBack;
    private MapListenerSupport m_listenerSupport;
    private SimpleCacheStatistics m_stats = new SimpleCacheStatistics();
    private boolean m_fLoggedMissingEvent;
    private boolean m_fLoggedUnfathomableEvent;
    private static boolean m_sWarnedEventSequence;

    public OverflowMap(ObservableMap mapFront, Map mapBack) {
        ImmutableArrayList setBack;
        OverflowMap.azzert(mapFront != null && mapBack != null);
        this.m_mapFront = mapFront;
        this.m_mapBack = mapBack;
        ImmutableArrayList setFront = new ImmutableArrayList(mapFront.keySet());
        if (!setFront.isEmpty()) {
            Map mapStatus = this.getStatusMap();
            for (Object oKey : setFront) {
                Status status = this.instantiateStatus();
                status.setEntryInFront(true);
                status.setBackUpToDate(false);
                mapStatus.put(oKey, status);
            }
            this.setSize(mapStatus.size());
        }
        if (!(setBack = new ImmutableArrayList(mapBack.keySet())).isEmpty()) {
            Map mapStatus = this.getStatusMap();
            for (Object oKey : setBack) {
                Status status = (Status)mapStatus.get(oKey);
                if (status == null) {
                    status = this.instantiateStatus();
                    mapStatus.put(oKey, status);
                }
                status.setEntryInBack(true);
            }
            this.setSize(mapStatus.size());
        }
        this.setFrontMapListener(this.instantiateFrontMapListener());
        if (mapBack instanceof ObservableMap) {
            this.setBackMapListener(this.instantiateBackMapListener());
        }
        if (!setFront.isEmpty()) {
            OverflowMap.verifyNoNulls(mapFront.keySet(), "The front map contains a null key");
            if (!this.isNullValuesAllowed()) {
                OverflowMap.verifyNoNulls(mapFront.values(), "NullValuesAllowed is false but the front map contains at least one null value");
            }
            OverflowMap.azzert(mapFront.keySet().equals(setFront));
        }
        if (!setBack.isEmpty()) {
            OverflowMap.verifyNoNulls(mapBack.keySet(), "The back map contains a null key");
            if (!this.isNullValuesAllowed()) {
                OverflowMap.verifyNoNulls(mapBack.values(), "NullValuesAllowed is false but the back map contains at least one null value");
            }
            OverflowMap.azzert(mapBack.keySet().equals(setBack));
        }
        if (mapFront instanceof NamedCache || mapFront instanceof CachingMap || mapFront instanceof SerializationMap || mapFront instanceof BinaryMap || mapFront instanceof OverflowMap || mapFront instanceof SimpleOverflowMap) {
            this.setFrontPutBlind(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.getGate().isEnteredByCurrentThread() || this.hasListeners()) {
            Iterator iter = this.keySet().iterator();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        } else {
            this.beginMapProcess();
            try {
                OverflowMap overflowMap = this;
                synchronized (overflowMap) {
                    MapListener listenerFront = this.getFrontMapListener();
                    MapListener listenerBack = this.getBackMapListener();
                    this.setFrontMapListener(null);
                    this.setBackMapListener(null);
                    try {
                        Map mapStatus;
                        this.getFrontMap().clear();
                        this.getBackMap().clear();
                        this.setSize(0);
                        Map map = mapStatus = this.getStatusMap();
                        synchronized (map) {
                            Iterator iter = mapStatus.values().iterator();
                            while (iter.hasNext()) {
                                Status status;
                                Status status2 = status = (Status)iter.next();
                                synchronized (status2) {
                                    assert (status.isOwnedByCurrentThread());
                                    status.setEntryInFront(false);
                                    status.setEntryInBack(false);
                                    status.takeEvent();
                                }
                            }
                        }
                        this.getDeferredList().clear();
                        LongArray laExpiry = this.getExpiryArray();
                        if (laExpiry != null) {
                            laExpiry.clear();
                        }
                        this.getCacheStatistics().resetHitStatistics();
                    }
                    finally {
                        this.setFrontMapListener(listenerFront);
                        this.setBackMapListener(listenerBack);
                    }
                }
            }
            finally {
                this.endMapProcess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object oKey) {
        boolean fContains = false;
        if (this.getStatusMap().containsKey(oKey)) {
            Status status = this.beginKeyProcess(oKey);
            try {
                fContains = status.isEntryExistent();
            }
            finally {
                this.endKeyProcess(oKey, status);
            }
        }
        return fContains;
    }

    @Override
    public Object get(Object oKey) {
        Object oResult;
        if (this.getStatusMap().containsKey(oKey)) {
            oResult = this.getInternal(oKey, true, null);
        } else {
            oResult = null;
            this.m_stats.registerMiss();
        }
        return oResult;
    }

    @Override
    public boolean isEmpty() {
        if (this.getStatusMap().isEmpty()) {
            return true;
        }
        return this.size() == 0;
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.putInternal(oKey, oValue, false, 0L);
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.putInternal(entry.getKey(), entry.getValue(), true, 0L);
        }
    }

    @Override
    public Object remove(Object oKey) {
        return this.getStatusMap().containsKey(oKey) ? this.removeInternal(oKey, false, false) : null;
    }

    @Override
    public int size() {
        this.evict();
        return this.getSize();
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.putInternal(oKey, oValue, false, cMillis);
    }

    @Override
    public Map getAll(Collection colKeys) {
        int cMisses;
        HashMap mapResult = new HashMap();
        long ldtStart = OverflowMap.getSafeTimeMillis();
        int cKeys = colKeys.size();
        for (Object oKey : colKeys) {
            if (!this.getStatusMap().containsKey(oKey)) continue;
            this.getInternal(oKey, false, mapResult);
        }
        int cHits = mapResult.size();
        if (cHits > 0) {
            this.m_stats.registerHits(cHits, ldtStart);
        }
        if ((cMisses = cKeys - cHits) > 0) {
            this.m_stats.registerMisses(cMisses, ldtStart);
        }
        return mapResult;
    }

    @Override
    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        OverflowMap.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, oKey, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        OverflowMap.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        OverflowMap.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        OverflowMap.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    @Override
    protected boolean removeBlind(Object oKey) {
        return (Boolean)this.removeInternal(oKey, true, false);
    }

    protected Set getInternalKeySet() {
        Set set = this.m_setKeysInternal;
        if (set == null) {
            this.m_setKeysInternal = set = this.instantiateInternalKeySet();
        }
        return set;
    }

    @Override
    protected boolean isInternalKeySetIteratorMutable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getInternal(Object oKey, boolean fStats, Map mapResult) {
        Object oValue = null;
        boolean fContains = false;
        MapEvent evtRaise = null;
        long ldtStart = fStats ? OverflowMap.getSafeTimeMillis() : 0L;
        Status status = this.beginKeyProcess(oKey);
        boolean fExists = status.isEntryExistent();
        try {
            block54: {
                MapEvent evtFront;
                ObservableMap observableMap;
                ObservableMap mapFront = this.getFrontMap();
                Map mapBack = this.getBackMap();
                if (status.isEntryInFront()) {
                    fContains = true;
                    oValue = mapFront.get(oKey);
                    observableMap = mapFront;
                    synchronized (observableMap) {
                        Status status2 = status;
                        synchronized (status2) {
                            evtFront = status.takeFrontEvent();
                            if (evtFront == null || evtFront.getId() != 3) {
                                status.closeProcessing();
                            }
                        }
                    }
                    if (evtFront != null) {
                        switch (evtFront.getId()) {
                            case 1: {
                                this.warnUnfathomable(evtFront);
                                if (oValue == null) {
                                    oValue = evtFront.getNewValue();
                                }
                                status.setBackUpToDate(false);
                                evtRaise = new CacheEvent<Object, Object>(this, 2, oKey, null, oValue, OverflowMap.isSynthetic(evtFront));
                                break;
                            }
                            case 2: {
                                if (oValue == null) {
                                    oValue = evtFront.getNewValue();
                                }
                                status.setBackUpToDate(false);
                                evtRaise = evtFront;
                                break;
                            }
                            case 3: {
                                if (oValue == null) {
                                    oValue = OverflowMap.getLatestOldValue(evtFront);
                                }
                                status.setEntryInFront(false);
                            }
                        }
                    }
                } else if (status.isEntryInBack()) {
                    fContains = true;
                    oValue = mapBack.get(oKey);
                    CacheEvent<Object, Object> evtBack = status.takeBackEvent();
                    if (evtBack != null) {
                        switch (evtBack.getId()) {
                            case 1: {
                                this.warnUnfathomable(evtBack);
                                if (oValue == null) {
                                    oValue = evtBack.getNewValue();
                                }
                                evtRaise = new CacheEvent<Object, Object>(this, 2, oKey, null, oValue, OverflowMap.isSynthetic(evtBack));
                                break;
                            }
                            case 2: {
                                if (oValue == null) {
                                    oValue = evtBack.getNewValue();
                                }
                                evtRaise = evtBack;
                                break;
                            }
                            case 3: {
                                if (oValue == null) {
                                    oValue = OverflowMap.getLatestOldValue(evtBack);
                                }
                                status.setEntryInBack(false);
                                status.setBackUpToDate(false);
                            }
                        }
                    }
                }
                if (!fContains || status.isEntryInFront()) break block54;
                OverflowMap.putOne(mapFront, oKey, oValue, this.isFrontPutBlind());
                status.setEntryInFront(true);
                observableMap = mapFront;
                synchronized (observableMap) {
                    evtFront = status.closeProcessing();
                }
                if (evtFront == null || evtFront.getMap() != this.getFrontMap()) break block54;
                block17 : switch (evtFront.getId()) {
                    case 1: {
                        Object oValueNew = evtFront.getNewValue();
                        if (oValueNew == oValue) break;
                        status.setBackUpToDate(false);
                        int nId = 2;
                        Object oOldValue = oValue;
                        if (evtRaise != null) {
                            nId = evtRaise.getId();
                            oOldValue = evtRaise.getOldValue();
                        }
                        evtRaise = new CacheEvent<Object, Object>(this, nId, oKey, oOldValue, oValueNew, OverflowMap.isSynthetic(evtFront));
                        oValue = oValueNew;
                        break;
                    }
                    case 2: {
                        this.warnUnfathomable(evtFront);
                        status.setBackUpToDate(false);
                        oValue = evtFront.getNewValue();
                        evtRaise = evtFront;
                        break;
                    }
                    case 3: {
                        if (!OverflowMap.isSynthetic(evtFront)) {
                            this.warnUnfathomable(evtFront);
                        }
                        status.setEntryInFront(false);
                        boolean fIsInBack = status.isEntryInBack();
                        if (fIsInBack && status.isBackUpToDate()) break;
                        OverflowMap.putOne(mapBack, oKey, oValue, true);
                        status.setEntryInBack(true);
                        status.setBackUpToDate(true);
                        MapEvent evtBack = status.takeBackEvent();
                        if (evtBack == null) break;
                        switch (evtBack.getId()) {
                            case 1: 
                            case 2: {
                                Object oNewValue = evtBack.getNewValue();
                                if (oNewValue != oValue && this.hasListeners()) {
                                    evtRaise = new CacheEvent<Object, Object>(this, 2, oKey, oValue, oNewValue, OverflowMap.isSynthetic(evtBack));
                                    oValue = oNewValue;
                                    break block17;
                                }
                                break block54;
                            }
                            case 3: {
                                if (!OverflowMap.isSynthetic(evtBack)) {
                                    this.warnUnfathomable(evtBack);
                                }
                                evtRaise = new CacheEvent<Object, Object>(this, 3, oKey, oValue, null, true);
                                oValue = null;
                                fContains = false;
                            }
                        }
                    }
                }
            }
            if (fExists != status.isEntryExistent()) {
                this.adjustSize(fExists ? -1 : 1);
            }
            if (evtRaise != null) {
                this.dispatchEvent(status, evtRaise);
            }
            this.endKeyProcess(oKey, status);
        }
        catch (Throwable throwable) {
            if (fExists != status.isEntryExistent()) {
                this.adjustSize(fExists ? -1 : 1);
            }
            if (evtRaise != null) {
                this.dispatchEvent(status, evtRaise);
            }
            this.endKeyProcess(oKey, status);
            throw throwable;
        }
        if (fStats) {
            if (fContains) {
                this.m_stats.registerHit(ldtStart);
            } else {
                this.m_stats.registerMiss(ldtStart);
            }
        }
        if (fContains && mapResult != null) {
            mapResult.put(oKey, oValue);
        }
        return oValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object putInternal(Object oKey, Object oValue, boolean fStoreOnly, long cMillis) {
        if (oKey == null) {
            throw new IllegalArgumentException("null keys are unsupported");
        }
        boolean fNullAllowed = this.isNullValuesAllowed();
        if (oValue == null && !fNullAllowed) {
            throw new IllegalArgumentException("null values are unsupported (key=\"" + String.valueOf(oKey) + "\")");
        }
        if (this.isExpiryEnabled()) {
            if (cMillis == 0L) {
                cMillis = this.getExpiryDelay();
            }
        } else if (cMillis > 0L) {
            throw new IllegalArgumentException("expiry is not enabled (key=\"" + String.valueOf(oKey) + "\", expiry=" + cMillis + ")");
        }
        Object oOldValue = null;
        CacheEvent<Object, Object> evtRaise = null;
        long ldtStart = OverflowMap.getSafeTimeMillis();
        Status status = this.beginKeyProcess(oKey);
        boolean fExists = status.isEntryExistent();
        try {
            boolean fInFront = status.isEntryInFront();
            boolean fInBack = status.isEntryInBack();
            boolean fBackUpToDate = status.isBackUpToDate();
            boolean fOldExpiry = status.hasExpiry();
            boolean fNewExpiry = cMillis > 0L;
            boolean fEvtReq = this.hasListeners();
            boolean fOldValue = false;
            boolean fOldValueReq = fEvtReq || !fStoreOnly;
            Object oNewValue = oValue;
            ObservableMap mapFront = this.getFrontMap();
            if (fInFront && fOldValueReq) {
                oOldValue = mapFront.put(oKey, oValue);
                fOldValue = oOldValue != null;
            } else {
                OverflowMap.putOne(mapFront, oKey, oValue, this.isFrontPutBlind());
            }
            status.setEntryInFront(true);
            status.setBackUpToDate(false);
            CacheEvent<Object, Object> evtFront = status.closeProcessing();
            if (evtFront == null || evtFront.getSource() != mapFront) {
                this.warnMissingEvent(oKey, fInFront ? 2 : 1, true);
                if (!fOldValue) {
                    fOldValue = !fInBack || !fBackUpToDate;
                }
            } else {
                switch (evtFront.getId()) {
                    case 1: {
                        if (fExists) {
                            oNewValue = evtFront.getNewValue();
                            if (!fInFront) break;
                            this.warnUnfathomable(evtFront);
                            break;
                        }
                        fOldValue = true;
                        evtRaise = evtFront;
                        break;
                    }
                    case 2: {
                        evtRaise = evtFront;
                        if (!fOldValue) {
                            if (fOldValueReq) {
                                oOldValue = OverflowMap.getLatestOldValue(evtFront);
                            }
                            fOldValue = true;
                        }
                        if (fInFront) break;
                        this.warnUnfathomable(evtFront);
                        break;
                    }
                    case 3: {
                        status.setEntryInFront(false);
                        if (!OverflowMap.isSynthetic(evtFront)) {
                            this.warnUnfathomable(evtFront);
                        }
                        Map mapBack = this.getBackMap();
                        oNewValue = OverflowMap.getLatestOldValue(evtFront);
                        if (fInFront || !fInBack || !fOldValueReq) {
                            if (!fOldValue && fOldValueReq) {
                                oOldValue = fInFront ? evtFront.getOldValue() : null;
                                fOldValue = true;
                            }
                            OverflowMap.putOne(mapBack, oKey, oNewValue, true);
                        } else {
                            oOldValue = mapBack.put(oKey, oNewValue);
                            fOldValue = oOldValue != null || fNullAllowed && mapBack.containsKey(oKey);
                        }
                        status.setEntryInBack(true);
                        status.setBackUpToDate(true);
                        MapEvent evtBack = status.takeBackEvent();
                        if (evtBack != null) {
                            boolean fSynthetic = OverflowMap.isSynthetic(evtBack);
                            switch (evtBack.getId()) {
                                case 1: 
                                case 2: {
                                    oNewValue = evtBack.getNewValue();
                                    if (fOldValue || !fOldValueReq || fInFront || !fInBack) break;
                                    oOldValue = OverflowMap.getLatestOldValue(evtBack);
                                    break;
                                }
                                case 3: {
                                    status.setEntryInBack(false);
                                    if (!fSynthetic) {
                                        this.warnUnfathomable(evtBack);
                                    }
                                    if (fEvtReq) {
                                        evtRaise = new CacheEvent<Object, Object>(this, 3, oKey, oOldValue, null, fSynthetic);
                                    }
                                    fNewExpiry = false;
                                }
                            }
                        }
                        fOldValue = true;
                    }
                }
            }
            if (!fOldValue && (fEvtReq && evtRaise == null || !fStoreOnly) && fInBack && (!fInFront || fBackUpToDate)) {
                oOldValue = this.getBackMap().get(oKey);
                MapEvent evtBack = status.takeBackEvent();
                if (evtBack != null) {
                    switch (evtBack.getId()) {
                        case 1: {
                            this.warnUnfathomable(evtBack);
                            break;
                        }
                        case 2: {
                            oOldValue = OverflowMap.getLatestOldValue(evtBack);
                            break;
                        }
                        case 3: {
                            status.setEntryInBack(false);
                            oOldValue = OverflowMap.getLatestOldValue(evtBack);
                        }
                    }
                }
            }
            if (fEvtReq && evtRaise == null) {
                int nId = fExists ? 2 : 1;
                evtRaise = new CacheEvent<Object, Object>(this, nId, oKey, oOldValue, oNewValue, false);
            }
            if (fOldExpiry) {
                this.unregisterExpiry(oKey, status.getExpiry());
                status.setExpiry(0L);
            }
            if (fNewExpiry) {
                long ldtExpires = ldtStart + cMillis;
                status.setExpiry(ldtExpires);
                this.registerExpiry(oKey, ldtExpires);
            }
            if (fExists != status.isEntryExistent()) {
                this.adjustSize(fExists ? -1 : 1);
            }
            if (evtRaise != null) {
                this.dispatchEvent(status, evtRaise);
            }
            this.endKeyProcess(oKey, status);
        }
        catch (Throwable throwable) {
            if (fExists != status.isEntryExistent()) {
                this.adjustSize(fExists ? -1 : 1);
            }
            if (evtRaise != null) {
                this.dispatchEvent(status, evtRaise);
            }
            this.endKeyProcess(oKey, status);
            throw throwable;
        }
        this.m_stats.registerPut(ldtStart);
        return oOldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeInternal(Object oKey, boolean fCheckRemovedOnly, boolean fEviction) {
        Status status;
        Object oValue;
        block43: {
            oValue = null;
            boolean fFrontRemoved = false;
            boolean fBackRemoved = false;
            CacheEvent<Object, Object> evtRaise = null;
            boolean fEvtReq = this.hasListeners();
            status = fEviction ? (Status)this.getStatusMap().get(oKey) : this.beginKeyProcess(oKey);
            boolean fExists = status.isEntryExistent();
            try {
                long ldtExpire;
                boolean fRemoveFromBack = true;
                if (status.isEntryInFront()) {
                    ObservableMap mapFront = this.getFrontMap();
                    fFrontRemoved = mapFront.keySet().remove(oKey);
                    ObservableMap observableMap = mapFront;
                    synchronized (observableMap) {
                        evtRaise = status.closeProcessing();
                    }
                    if (evtRaise == null || evtRaise.getSource() != mapFront) {
                        if (mapFront.containsKey(oKey)) {
                            fFrontRemoved = false;
                            fRemoveFromBack = false;
                        } else {
                            if (fFrontRemoved) {
                                this.warnMissingEvent(oKey, 3, true);
                            }
                            fFrontRemoved = true;
                            status.setEntryInFront(false);
                            if (fEvtReq) {
                                evtRaise = new CacheEvent<Object, Object>(this, 3, oKey, null, null, fEviction);
                            }
                        }
                    } else {
                        switch (evtRaise.getId()) {
                            case 1: {
                                this.warnUnfathomable(evtRaise);
                            }
                            case 2: {
                                status.setBackUpToDate(false);
                                fFrontRemoved = false;
                                fRemoveFromBack = false;
                                break;
                            }
                            case 3: {
                                fFrontRemoved = true;
                                status.setEntryInFront(false);
                                if (fCheckRemovedOnly) break;
                                oValue = OverflowMap.getLatestOldValue(evtRaise);
                            }
                        }
                    }
                }
                if (fRemoveFromBack && status.isEntryInBack()) {
                    Map mapBack = this.getBackMap();
                    if (fFrontRemoved || fCheckRemovedOnly && !fEvtReq || mapBack instanceof ObservableMap) {
                        fBackRemoved = mapBack.keySet().remove(oKey);
                        CacheEvent evtBack = status.takeBackEvent();
                        if (evtBack == null) {
                            if (fBackRemoved) {
                                if (this.getBackMapListener() != null) {
                                    this.warnMissingEvent(oKey, 3, false);
                                }
                            } else {
                                fBackRemoved = true;
                            }
                            status.setEntryInBack(false);
                            if (fEvtReq && !fFrontRemoved) {
                                evtRaise = new CacheEvent<Object, Object>(this, 3, oKey, null, null, fEviction);
                            }
                        } else {
                            switch (evtBack.getId()) {
                                case 1: {
                                    this.warnUnfathomable(evtBack);
                                }
                                case 2: {
                                    fBackRemoved = false;
                                    if (!fEvtReq) break;
                                    evtRaise = new CacheEvent(this, 2, oKey, (evtRaise == null ? evtBack : evtRaise).getOldValue(), evtBack.getNewValue(), fEviction || OverflowMap.isSynthetic(evtBack));
                                    break;
                                }
                                case 3: {
                                    fBackRemoved = true;
                                    status.setEntryInBack(false);
                                    if (fFrontRemoved) break;
                                    if (!fCheckRemovedOnly) {
                                        oValue = OverflowMap.getLatestOldValue(evtBack);
                                    }
                                    if (!fEvtReq) break;
                                    evtRaise = evtBack;
                                }
                            }
                        }
                    } else {
                        oValue = mapBack.remove(oKey);
                        fBackRemoved = true;
                        if (fEvtReq) {
                            evtRaise = new CacheEvent(this, 3, oKey, oValue, null, fEviction);
                        }
                        status.setEntryInBack(false);
                    }
                }
                if (fCheckRemovedOnly) {
                    boolean fRemoved = (fFrontRemoved || fBackRemoved) && !status.isEntryExistent();
                    oValue = fRemoved;
                }
                if (fExists != status.isEntryExistent()) {
                    this.adjustSize(fExists ? -1 : 1);
                }
                if (!status.isEntryExistent() && (ldtExpire = status.getExpiry()) != 0L) {
                    this.unregisterExpiry(oKey, ldtExpire);
                }
                if (!fEvtReq || evtRaise == null) break block43;
            }
            catch (Throwable throwable) {
                long ldtExpire;
                if (fExists != status.isEntryExistent()) {
                    this.adjustSize(fExists ? -1 : 1);
                }
                if (!status.isEntryExistent() && (ldtExpire = status.getExpiry()) != 0L) {
                    this.unregisterExpiry(oKey, ldtExpire);
                }
                if (fEvtReq && evtRaise != null) {
                    if (fEviction && evtRaise.getId() == 3 && !OverflowMap.isSynthetic(evtRaise)) {
                        CacheEvent evtOrig = evtRaise;
                        evtRaise = new CacheEvent(this, 3, evtRaise.getKey(), null, null, true, evtOrig){
                            final /* synthetic */ MapEvent val$evtOrig;
                            {
                                this.val$evtOrig = mapEvent;
                                super(map, nId, oKey, oValueOld, oValueNew, fSynthetic);
                            }

                            @Override
                            public Object getOldValue() {
                                return this.val$evtOrig.getOldValue();
                            }
                        };
                    }
                    this.dispatchEvent(status, evtRaise);
                }
                if (!fEviction) {
                    this.endKeyProcess(oKey, status);
                }
                throw throwable;
            }
            if (fEviction && evtRaise.getId() == 3 && !OverflowMap.isSynthetic(evtRaise)) {
                CacheEvent evtOrig = evtRaise;
                evtRaise = new /* invalid duplicate definition of identical inner class */;
            }
            this.dispatchEvent(status, evtRaise);
        }
        if (!fEviction) {
            this.endKeyProcess(oKey, status);
        }
        return oValue;
    }

    public ObservableMap getFrontMap() {
        return this.m_mapFront;
    }

    public Map getBackMap() {
        return this.m_mapBack;
    }

    public int getExpiryDelay() {
        int cMillis = this.m_cExpiryDelay;
        return cMillis <= 0 ? -1 : cMillis;
    }

    public void setExpiryDelay(int cMillis) {
        if (!this.isExpiryEnabled() && cMillis > 0) {
            this.setExpiryEnabled(true);
        }
        this.m_cExpiryDelay = Math.max(cMillis, 0);
    }

    protected int getSize() {
        return this.m_countItems.get();
    }

    protected void setSize(int cItems) {
        this.m_countItems.set(cItems);
    }

    protected void adjustSize(int cItems) {
        this.m_countItems.addAndGet(cItems);
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    protected Gate getGate() {
        return this.m_gate;
    }

    protected Map getStatusMap() {
        return this.m_mapStatus;
    }

    protected LongArray getExpiryArray() {
        return this.m_laExpiry;
    }

    protected void setExpiryArray(LongArray laExpiry) {
        this.m_laExpiry = laExpiry;
    }

    protected MapListener getFrontMapListener() {
        return this.m_listenerFront;
    }

    protected void setFrontMapListener(MapListener listener) {
        ObservableMap mapFront = this.getFrontMap();
        assert (mapFront != null);
        MapListener listenerOld = this.m_listenerFront;
        if (listener != listenerOld) {
            if (listenerOld != null) {
                mapFront.removeMapListener(listenerOld);
                this.m_listenerFront = null;
            }
            if (listener != null) {
                mapFront.addMapListener(listener);
                this.m_listenerFront = listener;
            }
        }
    }

    protected MapListener getBackMapListener() {
        return this.m_listenerBack;
    }

    protected void setBackMapListener(MapListener listener) {
        Map mapBack = this.getBackMap();
        assert (mapBack != null);
        if (mapBack instanceof ObservableMap) {
            ObservableMap mapBackObs = (ObservableMap)mapBack;
            MapListener listenerOld = this.m_listenerBack;
            if (listener != listenerOld) {
                if (listenerOld != null) {
                    mapBackObs.removeMapListener(listenerOld);
                    this.m_listenerBack = null;
                }
                if (listener != null) {
                    mapBackObs.addMapListener(listener);
                    this.m_listenerBack = listener;
                }
            }
        } else if (listener != null) {
            throw new UnsupportedOperationException("back map is not observable: map=" + OverflowMap.toString(mapBack.getClass()) + ", listener=" + OverflowMap.toString(listener.getClass()));
        }
    }

    protected List getDeferredList() {
        return this.m_listDeferred;
    }

    public boolean isNullValuesAllowed() {
        return this.m_fNullValuesAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNullValuesAllowed(boolean fAllowNulls) {
        this.beginMapProcess();
        try {
            OverflowMap overflowMap = this;
            synchronized (overflowMap) {
                if (fAllowNulls != this.isNullValuesAllowed()) {
                    if (!fAllowNulls && !this.getStatusMap().isEmpty()) {
                        OverflowMap.azzert(!this.values().contains(null), "NullValuesAllowed cannot be set to false because the OverflowMap contains null values");
                    }
                    this.m_fNullValuesAllowed = fAllowNulls;
                }
            }
        }
        finally {
            this.endMapProcess();
        }
    }

    public boolean isExpiryEnabled() {
        return this.m_fExpiryEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiryEnabled(boolean fEnableExpiry) {
        this.beginMapProcess();
        try {
            OverflowMap overflowMap = this;
            synchronized (overflowMap) {
                if (fEnableExpiry != this.isExpiryEnabled() && !this.getStatusMap().isEmpty()) {
                    throw new IllegalStateException("ExpiryEnabled must be configured before populating the OverflowMap");
                }
                this.m_fExpiryEnabled = fEnableExpiry;
                if (fEnableExpiry != (this.getExpiryArray() != null)) {
                    this.setExpiryArray(fEnableExpiry ? new SparseArray() : null);
                }
            }
        }
        finally {
            this.endMapProcess();
        }
    }

    public boolean isFrontPutBlind() {
        return this.m_fUseFrontPutAll;
    }

    public void setFrontPutBlind(boolean fUseFrontPutAll) {
        this.m_fUseFrontPutAll = fUseFrontPutAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status beginKeyProcess(Object oKey) {
        Gate gate = this.getGate();
        boolean fReentrant = gate.isEnteredByCurrentThread();
        gate.enter(-1L);
        try {
            if (!fReentrant) {
                this.processDeferredEvents(false);
            }
            Status status = null;
            int cAttempts = 0;
            while (++cAttempts < 255) {
                Map mapStatus;
                Map map = mapStatus = this.getStatusMap();
                synchronized (map) {
                    status = (Status)mapStatus.get(oKey);
                    if (status == null || !status.isValid()) {
                        status = this.instantiateStatus();
                        mapStatus.put(oKey, status);
                    }
                }
                if (!this.prepareStatus(oKey, status)) continue;
                return status;
            }
            throw new IllegalStateException("Overflow Map was unable to obtain and prepare the Status for \"" + String.valueOf(oKey) + "\" for processing (Status=" + String.valueOf(status) + ")");
        }
        catch (Error e) {
            gate.exit();
            throw e;
        }
        catch (RuntimeException e) {
            gate.exit();
            throw e;
        }
    }

    protected void endKeyProcess(Object oKey, Status status) {
        this.closeStatus(status);
        this.releaseClosedStatus(oKey);
        this.getGate().exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginMapProcess() {
        Gate gate = this.getGate();
        if (gate.isEnteredByCurrentThread()) {
            throw new IllegalStateException("OverflowMap map-level operations are not permitted from re-entrant code");
        }
        gate.close(-1L);
        gate.enter(-1L);
        try {
            Map mapStatus = this.getStatusMap();
            HashMap mapEvents = new HashMap();
            Map map = mapStatus;
            synchronized (map) {
                Iterator iter = mapStatus.entrySet().iterator();
                while (iter.hasNext()) {
                    Status status;
                    Map.Entry entry = iter.next();
                    Object oKey = entry.getKey();
                    Status status2 = status = (Status)entry.getValue();
                    synchronized (status2) {
                        if (status.isValid()) {
                            MapEvent evt = status.waitForAvailable();
                            if (evt != null || status.isExpired() && status.isEntryExistent()) {
                                mapEvents.put(oKey, evt);
                            }
                        } else {
                            iter.remove();
                        }
                    }
                }
            }
            for (Map.Entry entry : mapEvents.entrySet()) {
                Object oKey = entry.getKey();
                Status status = (Status)mapStatus.get(oKey);
                MapEvent evt = (MapEvent)entry.getValue();
                do {
                    Object object;
                    boolean fEvict = false;
                    if (status != null) {
                        object = status;
                        synchronized (object) {
                            MapEvent evtJustHappened = status.closeProcessing();
                            if (evtJustHappened != null) {
                                MapEvent mapEvent = evt = evt == null ? evtJustHappened : OverflowMap.mergeEvents(evt, evtJustHappened);
                            }
                            if (evt == null && status.isExpired() && status.isEntryExistent()) {
                                fEvict = true;
                            }
                        }
                    }
                    if (fEvict) {
                        this.removeInternal(oKey, true, true);
                        object = status;
                        synchronized (object) {
                            if (status.isProcessing()) {
                                evt = status.closeProcessing();
                            }
                        }
                    }
                    if (evt != null) {
                        this.processEvent(status, evt);
                        evt = null;
                    }
                    object = mapStatus;
                    synchronized (object) {
                        status = (Status)mapStatus.get(oKey);
                        if (status != null) {
                            Status status3 = status;
                            synchronized (status3) {
                                if (!status.isValid() || status.commitAndMaybeInvalidate()) {
                                    mapStatus.remove(oKey);
                                } else {
                                    evt = status.waitForAvailable();
                                }
                            }
                        }
                    }
                } while (evt != null);
            }
        }
        catch (Throwable e) {
            try {
                this.endMapProcess();
            }
            catch (Exception eUnhandleable) {
                OverflowMap.err("Overflow Map encountered an unhandleable  exception while releasing exclusive ownership of the Overflow Map for the current thread (\"" + Thread.currentThread().getName() + "\"); exception:\n" + OverflowMap.getStackTrace(eUnhandleable));
            }
            gate.exit();
            gate.open();
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw OverflowMap.ensureRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endMapProcess() {
        Map mapStatus = this.getStatusMap();
        HashMap mapEvents = new HashMap();
        Map map = mapStatus;
        synchronized (map) {
            Iterator iter = mapStatus.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Status status = (Status)entry.getValue();
                if (!status.isValid()) {
                    iter.remove();
                    continue;
                }
                if (!status.isOwnedByCurrentThread()) continue;
                Status status2 = status;
                synchronized (status2) {
                    boolean fCommit = true;
                    if (status.isProcessing()) {
                        if (status.hasEvent()) {
                            mapEvents.put(entry.getKey(), status);
                            fCommit = false;
                        } else {
                            status.closeProcessing();
                        }
                    }
                    if (fCommit && status.commitAndMaybeInvalidate()) {
                        iter.remove();
                    }
                }
            }
        }
        for (Map.Entry entry : mapEvents.entrySet()) {
            Status status = (Status)entry.getValue();
            if (!status.isValid() || !status.isOwnedByCurrentThread()) continue;
            this.closeStatus(status);
            this.releaseClosedStatus(entry.getKey());
        }
        Gate gate = this.getGate();
        gate.exit();
        gate.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareStatus(Object oKey, Status status) {
        boolean fPrepared;
        boolean fOwned = false;
        boolean fEvict = false;
        MapEvent evt = null;
        Status status2 = status;
        synchronized (status2) {
            fPrepared = status.isValid();
            if (fPrepared) {
                evt = status.waitForAvailable();
                fOwned = true;
                if (evt != null) {
                    MapEvent evtJustHappened = status.closeProcessing();
                    if (evtJustHappened != null) {
                        evt = OverflowMap.mergeEvents(evt, evtJustHappened);
                    }
                    fPrepared = false;
                } else if (status.isExpired() && status.isEntryExistent()) {
                    fEvict = true;
                    fPrepared = false;
                }
            }
        }
        if (fEvict) {
            this.removeInternal(oKey, true, true);
            status2 = status;
            synchronized (status2) {
                if (status.isProcessing()) {
                    evt = status.closeProcessing();
                }
            }
        }
        try {
            if (evt != null) {
                this.processEvent(status, evt);
            }
        }
        finally {
            if (fOwned && !fPrepared) {
                this.releaseClosedStatus(oKey);
            }
        }
        return fPrepared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onFrontEvent(MapEvent evt) {
        Gate gate = this.getGate();
        boolean fReentrant = gate.isEnteredByCurrentThread();
        if (!fReentrant) {
            gate.enter(-1L);
        }
        try {
            Map mapStatus = this.getStatusMap();
            Object oKey = evt.getKey();
            while (true) {
                Status status;
                Object object = mapStatus;
                synchronized (object) {
                    status = (Status)mapStatus.get(oKey);
                    if (status == null || !status.isValid()) {
                        status = this.instantiateStatus();
                        mapStatus.put(oKey, status);
                    }
                }
                object = status;
                synchronized (object) {
                    if (status.isValid()) {
                        if (!status.registerFrontEvent(evt)) return;
                        this.getDeferredList().add(oKey);
                        return;
                    }
                }
            }
        }
        finally {
            if (!fReentrant) {
                gate.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onBackEvent(MapEvent evtBack) {
        Gate gate = this.getGate();
        boolean fReentrant = gate.isEnteredByCurrentThread();
        if (!fReentrant) {
            gate.enter(-1L);
        }
        try {
            Map mapStatus = this.getStatusMap();
            Object oKey = evtBack.getKey();
            while (true) {
                Status status;
                Object object = mapStatus;
                synchronized (object) {
                    status = (Status)mapStatus.get(oKey);
                    if (status == null || !status.isValid()) {
                        status = this.instantiateStatus();
                        mapStatus.put(oKey, status);
                    }
                }
                object = status;
                synchronized (object) {
                    if (status.isValid()) {
                        if (!status.registerBackEvent(evtBack)) return;
                        this.getDeferredList().add(oKey);
                        return;
                    }
                }
            }
        }
        finally {
            if (!fReentrant) {
                gate.exit();
            }
        }
    }

    protected static MapEvent mergeEvents(MapEvent evtOld, MapEvent evtNew) {
        MapEvent evtResult = evtNew;
        boolean fCreate = true;
        int nId = evtNew.getId();
        switch (evtOld.getId() << 2 | nId) {
            case 6: {
                nId = 1;
                break;
            }
            case 7: {
                if (OverflowMap.isSynthetic(evtNew)) break;
                fCreate = false;
                evtResult = null;
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 13: {
                nId = 2;
                break;
            }
            default: {
                OverflowMap.warnEventSequence(evtOld, evtNew);
                fCreate = false;
            }
        }
        if (fCreate) {
            ObservableMap map = evtNew.getMap();
            Object oKey = evtNew.getKey();
            Object oValueOld = evtOld.getOldValue();
            Object oValueNew = evtNew.getNewValue();
            boolean fSynthetic = OverflowMap.isSynthetic(evtNew);
            evtResult = nId == 3 ? new HistoricCacheEvent(map, nId, oKey, oValueOld, oValueNew, fSynthetic, evtNew.getOldValue()) : new CacheEvent(map, nId, oKey, oValueOld, oValueNew, fSynthetic);
        }
        return evtResult;
    }

    protected static Object getLatestOldValue(MapEvent evt) {
        return evt instanceof HistoricCacheEvent ? ((HistoricCacheEvent)evt).getLatestOldValue() : evt.getOldValue();
    }

    protected void processEvent(Status status, MapEvent evt) {
        if (evt != null) {
            ObservableMap map = evt.getMap();
            if (map == this.getFrontMap()) {
                this.processFrontEvent(status, evt);
            } else {
                assert (map == this.getBackMap());
                this.processBackEvent(status, evt);
            }
        }
    }

    protected void processFrontEvent(Status status, MapEvent evtFront) {
        block23: {
            boolean fExists;
            CacheEvent evtRaise;
            block24: {
                assert (status.isOwnedByCurrentThread());
                assert (status.isProcessing() || status.isCommitting());
                if (evtFront == null) break block23;
                evtRaise = null;
                fExists = status.isEntryExistent();
                block0 : switch (evtFront.getId()) {
                    case 1: {
                        status.setEntryInFront(true);
                        if (status.isEntryInBack()) {
                            Object oOldValue;
                            Object oKey = evtFront.getKey();
                            Object oNewValue = evtFront.getNewValue();
                            boolean fUpToDate = oNewValue == (oOldValue = this.getBackMap().get(oKey));
                            MapEvent evtBack = status.takeBackEvent();
                            if (evtBack != null) {
                                if (!OverflowMap.isSynthetic(evtBack)) {
                                    this.warnUnfathomable(evtBack);
                                }
                                switch (evtBack.getId()) {
                                    case 2: {
                                        oOldValue = evtBack.getOldValue();
                                    }
                                    case 1: {
                                        fUpToDate = oNewValue == evtBack.getNewValue();
                                        break;
                                    }
                                    case 3: {
                                        status.setEntryInBack(false);
                                        fUpToDate = false;
                                        oOldValue = evtBack.getOldValue();
                                    }
                                }
                            }
                            status.setBackUpToDate(fUpToDate);
                            if (oNewValue == oOldValue || !this.hasListeners()) break;
                            evtRaise = new CacheEvent(this, 2, oKey, oOldValue, oNewValue, OverflowMap.isSynthetic(evtFront));
                            break;
                        }
                        evtRaise = evtFront;
                        break;
                    }
                    case 2: {
                        status.setEntryInFront(true);
                        status.setBackUpToDate(false);
                        evtRaise = evtFront;
                        break;
                    }
                    case 3: {
                        status.setEntryInFront(false);
                        if (status.isBackUpToDate()) break;
                        Object oKey = evtFront.getKey();
                        Object oOldValue = OverflowMap.getLatestOldValue(evtFront);
                        OverflowMap.putOne(this.getBackMap(), oKey, oOldValue, true);
                        status.setEntryInBack(true);
                        status.setBackUpToDate(true);
                        MapEvent evtBack = status.takeBackEvent();
                        if (evtBack == null) break;
                        switch (evtBack.getId()) {
                            case 1: 
                            case 2: {
                                Object oNewValue = evtBack.getNewValue();
                                if (oNewValue != oOldValue && this.hasListeners()) {
                                    evtRaise = new CacheEvent(this, 2, oKey, oOldValue, oNewValue, OverflowMap.isSynthetic(evtBack));
                                    break block0;
                                }
                                break block24;
                            }
                            case 3: {
                                if (!OverflowMap.isSynthetic(evtBack)) {
                                    this.warnUnfathomable(evtBack);
                                }
                                status.setEntryInBack(false);
                                evtRaise = evtFront;
                            }
                        }
                    }
                }
            }
            if (fExists != status.isEntryExistent()) {
                this.adjustSize(fExists ? -1 : 1);
            }
            if (evtRaise != null) {
                this.dispatchEvent(status, evtRaise);
            }
        }
    }

    protected void processBackEvent(Status status, MapEvent evtBack) {
        if (evtBack != null) {
            boolean fNowInBack;
            status.setBackUpToDate(false);
            boolean fIsInFront = status.isEntryInFront();
            boolean fWasInBack = status.isEntryInBack();
            boolean bl = fNowInBack = evtBack.getId() != 3;
            if (fNowInBack != fWasInBack) {
                status.setEntryInBack(fNowInBack);
                if (!fIsInFront) {
                    this.adjustSize(fWasInBack ? -1 : 1);
                }
            }
            if (!fIsInFront) {
                this.dispatchEvent(status, evtBack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeferredEvents(boolean fProcessAll) {
        List listDeferred = this.getDeferredList();
        if (this.isExpiryEnabled()) {
            LongArray laExpiry;
            LongArray longArray = laExpiry = this.getExpiryArray();
            synchronized (longArray) {
                long ldtCurrent = OverflowMap.getSafeTimeMillis();
                long ldtFirst = laExpiry.getFirstIndex();
                if (ldtCurrent >= ldtFirst) {
                    Iterator iter = laExpiry.iterator();
                    while (iter.hasNext()) {
                        Set setKeys = (Set)iter.next();
                        if (ldtCurrent < iter.getIndex()) continue;
                        listDeferred.addAll(setKeys);
                        iter.remove();
                    }
                }
            }
        }
        if (!listDeferred.isEmpty()) {
            int cDeferred = listDeferred.size();
            int cTarget = fProcessAll ? cDeferred : Math.max(10, Math.min(100, cDeferred >>> 7));
            int cProcessed = 0;
            Map mapStatus = this.getStatusMap();
            Object oFirstDeferredKey = null;
            do {
                Status status;
                Object oKey = null;
                try {
                    oKey = listDeferred.remove(0);
                }
                catch (Exception iter) {
                    // empty catch block
                }
                if (oKey == null || (status = (Status)mapStatus.get(oKey)) == null) continue;
                boolean fRequeue = true;
                if (status.isAvailable()) {
                    if (this.prepareStatus(oKey, status)) {
                        this.closeStatus(status);
                        this.releaseClosedStatus(oKey);
                    }
                    fRequeue = status.isValid() && (status.hasEvent() || status.isExpired());
                    ++cProcessed;
                }
                if (!fRequeue) continue;
                if (oFirstDeferredKey == null) {
                    oFirstDeferredKey = oKey;
                } else if (oKey == oFirstDeferredKey) break;
                listDeferred.add(oKey);
            } while (!listDeferred.isEmpty() && cProcessed < cTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeStatus(Status status) {
        MapEvent evt;
        do {
            evt = null;
            Status status2 = status;
            synchronized (status2) {
                if (status.isProcessing()) {
                    if (status.hasEvent()) {
                        evt = status.takeEvent();
                    } else {
                        status.closeProcessing();
                    }
                }
            }
            if (evt == null) continue;
            this.processEvent(status, evt);
        } while (evt != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseClosedStatus(Object oKey) {
        Map mapStatus;
        Map map = mapStatus = this.getStatusMap();
        synchronized (map) {
            Status status = (Status)mapStatus.get(oKey);
            if (status != null) {
                Status status2 = status;
                synchronized (status2) {
                    if (!status.isValid() || status.commitAndMaybeInvalidate()) {
                        mapStatus.remove(oKey);
                    }
                }
            }
        }
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    protected void dispatchEvent(Status status, int nId, Object oKey, Object oValueOld, Object oValueNew, boolean fSynthetic) {
        if (this.hasListeners()) {
            CacheEvent<Object, Object> evt = new CacheEvent<Object, Object>(this, nId, oKey, oValueOld, oValueNew, fSynthetic);
            this.dispatchEvent(status, evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(Status status, MapEvent evt) {
        MapListenerSupport listenerSupport;
        if (evt != null && (listenerSupport = this.getMapListenerSupport()) != null) {
            if (evt.getMap() != this) {
                final MapEvent evtOrig = evt;
                evt = new CacheEvent(this, evt.getId(), evt.getKey(), null, null, false){

                    @Override
                    public Object getOldValue() {
                        return evtOrig.getOldValue();
                    }

                    @Override
                    public Object getNewValue() {
                        return evtOrig.getNewValue();
                    }

                    @Override
                    public boolean isSynthetic() {
                        return OverflowMap.isSynthetic(evtOrig);
                    }
                };
            }
            Object object = status;
            synchronized (object) {
                MapEvent evtDefer;
                if (status.isProcessing() && (evtDefer = status.closeProcessing()) != null) {
                    if (evt.getMap() == this.getFrontMap()) {
                        status.registerFrontEvent(evtDefer);
                    } else {
                        status.registerBackEvent(evtDefer);
                    }
                }
            }
            object = this;
            synchronized (object) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }

    protected static boolean isSynthetic(MapEvent evt) {
        return evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerExpiry(Object oKey, long ldtExpire) {
        LongArray laExpiry;
        LongArray longArray = laExpiry = this.getExpiryArray();
        synchronized (longArray) {
            LiteSet<Object> collKeys = (LiteSet<Object>)laExpiry.get(ldtExpire);
            if (collKeys == null) {
                collKeys = new LiteSet<Object>();
                laExpiry.set(ldtExpire, collKeys);
            }
            collKeys.add(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterExpiry(Object oKey, long ldtExpire) {
        LongArray laExpiry;
        LongArray longArray = laExpiry = this.getExpiryArray();
        synchronized (longArray) {
            Collection collKeys = (Collection)laExpiry.get(ldtExpire);
            if (collKeys != null) {
                collKeys.remove(oKey);
                if (collKeys.isEmpty()) {
                    laExpiry.remove(ldtExpire);
                }
            }
        }
    }

    protected static void verifyNoNulls(Collection collection, String sAssert) {
        boolean fHasNull = false;
        try {
            fHasNull = collection.contains(null);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        OverflowMap.azzert(!fHasNull, sAssert);
    }

    protected static void putOne(Map map, Object oKey, Object oValue, boolean fPutBlind) {
        try {
            if (fPutBlind) {
                map.putAll(Collections.singletonMap(oKey, oValue));
            } else {
                map.put(oKey, oValue);
            }
        }
        catch (NullPointerException e) {
            OverflowMap.err("null pointer exception occurred during putOne()\nMap=" + String.valueOf(map) + "\nKey=" + String.valueOf(oKey) + "\nValue=" + String.valueOf(oValue) + "\nPutBlind=" + fPutBlind + "\nException=" + String.valueOf(e));
            throw e;
        }
    }

    public void evict() {
        Gate gate = this.getGate();
        if (!gate.isEnteredByCurrentThread()) {
            gate.enter(-1L);
            try {
                OverflowMap.evict(this.getFrontMap());
                OverflowMap.evict(this.getBackMap());
                this.processDeferredEvents(true);
            }
            finally {
                gate.exit();
            }
        }
    }

    protected static void evict(Map map) {
        if (map instanceof LocalCache) {
            ((LocalCache)map).checkFlush();
        } else if (map instanceof AbstractSerializationCache) {
            ((AbstractSerializationCache)map).evict();
        } else if (map instanceof OverflowMap) {
            ((OverflowMap)map).evict();
        }
    }

    protected void warnMissingEvent(Object oKey, int nId, boolean fFront) {
        if (!this.m_fLoggedMissingEvent) {
            this.m_fLoggedMissingEvent = true;
            OverflowMap.log("Overflow Map was expecting to receive an " + MapEvent.getDescription(nId) + " event for the key \"" + String.valueOf(oKey) + "\", but no event was received. This indicates that the Observable Map implementation used as the " + (fFront ? "front" : "back") + " map for the Overflow Map is not implemented correctly. This Overflow Map instance will not repeat this warning, and will attempt to compensate for the missing events.\nStack trace follows:\n" + OverflowMap.getStackTrace());
        }
    }

    protected void warnUnfathomable(MapEvent evt) {
        if (!this.m_fLoggedUnfathomableEvent) {
            this.m_fLoggedUnfathomableEvent = true;
            String sMap = evt.getMap() == this.getFrontMap() ? "the front map" : (evt.getMap() == this.getBackMap() ? "the back map" : "some unknown map");
            OverflowMap.log("Overflow Map has received an inexplicable event from " + sMap + "; such an event should not have been possible to occur. The Overflow Map will arbitrarily interpret the event in order to maintain its own internal consistency. The likely origin of the event is direct modification of the front and/or back maps managed by the Overflow Map, a MapListener making re-entrant modifications to its source map, or an ObservableMap implementation that reacts to the Map API in a manner inconsistent with the specification (e.g. actively modifying its contents in a manner that differs from the sequence of API calls made against it). This Overflow Map instance will not repeat this warning, and will attempt to silently compensate for subsequent similar event irregularities.\nEvent: " + String.valueOf(evt) + "\nStack trace follows:\n" + OverflowMap.getStackTrace());
        }
    }

    protected static void warnEventSequence(MapEvent evtOld, MapEvent evtNew) {
        if (!m_sWarnedEventSequence) {
            m_sWarnedEventSequence = true;
            OverflowMap.log("Overflow Map has detected an illegal event sequence:\nEvent 1: " + String.valueOf(evtOld) + "\nEvent 2: " + String.valueOf(evtNew) + "\nThis warning will not be repeated. Stack trace follows:\n" + OverflowMap.getStackTrace());
        }
    }

    @Override
    protected Set instantiateEntrySet() {
        return new EntrySet();
    }

    protected Set instantiateInternalKeySet() {
        return new InternalKeySet();
    }

    protected Status instantiateStatus() {
        return this.isExpiryEnabled() ? new ExpirableStatus() : new Status();
    }

    protected MapListener instantiateFrontMapListener() {
        return new FrontMapListener();
    }

    protected MapListener instantiateBackMapListener() {
        return new BackMapListener();
    }

    protected static class Status {
        protected static final int STATE_MASK_STATUS = 7;
        protected static final int STATE_MASK_FRONT = 8;
        protected static final int STATE_MASK_BACK = 16;
        protected static final int STATE_MASK_INSYNC = 32;
        protected static final int STATE_MASK_EXISTS = 24;
        protected static final int STATE_MASK_RETAIN = 31;
        protected static final int STATUS_AVAILABLE = 0;
        protected static final int STATUS_PROCESSING = 1;
        protected static final int STATUS_COMMITTING = 2;
        protected static final int STATUS_INVALIDATED = 3;
        private Thread m_threadOwner;
        private volatile byte m_cEnters;
        private byte m_cWaiting;
        private volatile byte m_nState = 0;
        private volatile MapEvent m_evtFront;
        private volatile MapEvent m_evtBack;

        protected int getStatus() {
            return this.extractState(7);
        }

        protected void setStatus(int nStatus) {
            this.updateState(7, nStatus);
        }

        public boolean isValid() {
            return this.getStatus() != 3;
        }

        public boolean isAvailable() {
            return this.getStatus() == 0;
        }

        public boolean isProcessing() {
            return this.getStatus() == 1;
        }

        public boolean isCommitting() {
            return this.getStatus() == 2;
        }

        public Thread getOwnerThread() {
            return this.m_threadOwner;
        }

        protected void setOwnerThread(Thread thread) {
            this.m_threadOwner = thread;
        }

        public boolean isOwnedByCurrentThread() {
            Thread thread = this.getOwnerThread();
            return thread != null && thread == Thread.currentThread();
        }

        public boolean isEntryInFront() {
            return this.extractFlag(8);
        }

        public void setEntryInFront(boolean fEntryInFront) {
            this.updateFlag(8, fEntryInFront);
        }

        public boolean isEntryInBack() {
            return this.extractFlag(16);
        }

        public void setEntryInBack(boolean fEntryInBack) {
            this.updateFlag(16, fEntryInBack);
            if (!fEntryInBack) {
                this.setBackUpToDate(false);
            }
        }

        public boolean isEntryExistent() {
            return this.extractState(24) != 0;
        }

        public boolean isBackUpToDate() {
            return this.extractFlag(32);
        }

        public void setBackUpToDate(boolean fUpToDate) {
            this.updateFlag(32, fUpToDate);
        }

        protected MapEvent getFrontEvent() {
            return this.m_evtFront;
        }

        protected void setFrontEvent(MapEvent evt) {
            this.m_evtFront = evt;
        }

        protected MapEvent getBackEvent() {
            return this.m_evtBack;
        }

        protected void setBackEvent(MapEvent evt) {
            this.m_evtBack = evt;
        }

        public boolean hasEvent() {
            return this.getFrontEvent() != null || this.getBackEvent() != null;
        }

        public synchronized MapEvent takeFrontEvent() {
            assert (this.isProcessing() || this.isCommitting());
            MapEvent evt = this.getFrontEvent();
            if (evt != null) {
                this.setFrontEvent(null);
            }
            return evt;
        }

        public synchronized MapEvent takeBackEvent() {
            assert (this.isProcessing() || this.isCommitting());
            MapEvent evt = this.getBackEvent();
            if (evt != null) {
                this.setBackEvent(null);
            }
            return evt;
        }

        public synchronized MapEvent takeEvent() {
            MapEvent evt = this.takeFrontEvent();
            if (evt == null) {
                evt = this.takeBackEvent();
            } else {
                MapEvent evtBack = this.takeBackEvent();
                if (evtBack != null) {
                    this.setEntryInBack(evtBack.getId() != 3);
                    this.setBackUpToDate(false);
                }
            }
            return evt;
        }

        public long getExpiry() {
            return 0L;
        }

        public void setExpiry(long ldtExpires) {
            throw new UnsupportedOperationException();
        }

        public boolean hasExpiry() {
            return false;
        }

        public boolean isExpired() {
            return false;
        }

        protected boolean isDiscardable() {
            return this.extractState(31) == 0 && !this.hasEvent();
        }

        public String getDescription() {
            return "Valid=" + this.isValid() + ", Available=" + this.isAvailable() + ", Processing=" + this.isProcessing() + ", Committing=" + this.isCommitting() + ", OwnerThread=" + String.valueOf(this.getOwnerThread()) + ", OwnedByCurrentThread=" + this.isOwnedByCurrentThread() + ", EntryInFront=" + this.isEntryInFront() + ", EntryInBack=" + this.isEntryInBack() + ", EntryExistent=" + this.isEntryExistent() + ", BackUpToDate=" + this.isBackUpToDate() + ", hasEvent=" + this.hasEvent() + ", FrontEvent=" + String.valueOf(this.getFrontEvent()) + ", BackEvent=" + String.valueOf(this.getBackEvent()) + ", cWaiting=" + this.m_cWaiting + ", cEnters=" + this.m_cEnters + ", Discardable=" + this.isDiscardable();
        }

        public String toString() {
            return "Status{" + this.getDescription() + "}";
        }

        protected synchronized MapEvent waitForAvailable() {
            boolean fRegisteredWaiting = false;
            try {
                while (!this.isAvailable()) {
                    assert (this.isValid());
                    if (this.isOwnedByCurrentThread()) {
                        if (this.isCommitting()) {
                            break;
                        }
                        throw new IllegalStateException("Re-entrancy requires that the Status be Committing (Status=" + this.getStatus() + ")");
                    }
                    if (!fRegisteredWaiting) {
                        int cWaiting = this.m_cWaiting & 0xFF;
                        if (cWaiting == 255) {
                            throw new IllegalStateException("Exceeded maximum number of waiting threads (Status=" + this.getStatus() + ")");
                        }
                        this.m_cWaiting = (byte)(cWaiting + 1);
                        fRegisteredWaiting = true;
                    }
                    Blocking.wait(this);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
            finally {
                if (fRegisteredWaiting) {
                    this.m_cWaiting = (byte)(this.m_cWaiting - 1);
                }
            }
            this.setStatus(1);
            this.setOwnerThread(Thread.currentThread());
            int cEnters = this.m_cEnters & 0xFF;
            if (cEnters == 255) {
                throw new IllegalStateException("Exceeded maximum depth of re-entrancy (Status=" + this.getStatus() + ")");
            }
            this.m_cEnters = (byte)(cEnters + 1);
            return this.takeEvent();
        }

        public synchronized MapEvent closeProcessing() {
            assert (this.isProcessing());
            assert (this.getOwnerThread() == Thread.currentThread());
            this.setStatus(2);
            return this.takeEvent();
        }

        protected synchronized boolean commitAndMaybeInvalidate() {
            assert (this.isCommitting());
            assert (this.m_cEnters != 0);
            boolean fInvalidated = false;
            this.m_cEnters = (byte)(this.m_cEnters - 1);
            if (this.m_cEnters == 0) {
                this.setStatus(0);
                if (this.m_cWaiting != 0) {
                    this.notify();
                } else if (this.isDiscardable()) {
                    this.setStatus(3);
                    fInvalidated = true;
                }
                this.setOwnerThread(null);
            } else {
                this.setStatus(2);
            }
            return fInvalidated;
        }

        public synchronized boolean registerFrontEvent(MapEvent evt) {
            assert (this.isValid());
            evt.getOldValue();
            MapEvent evtOld = this.getFrontEvent();
            if (evtOld != null) {
                evt = OverflowMap.mergeEvents(evtOld, evt);
            }
            this.setFrontEvent(evt);
            return !this.isProcessing();
        }

        public synchronized boolean registerBackEvent(MapEvent evt) {
            MapEvent evtOld;
            assert (this.isValid());
            if (!this.isEntryInFront()) {
                evt.getOldValue();
            }
            if ((evtOld = this.getBackEvent()) != null) {
                evt = OverflowMap.mergeEvents(evtOld, evt);
            }
            this.setBackEvent(evt);
            return !this.isProcessing();
        }

        protected int getState() {
            return this.m_nState;
        }

        protected void setState(int nState) {
            this.m_nState = (byte)nState;
        }

        protected int extractState(int nMask) {
            return this.getState() & nMask;
        }

        protected void updateState(int nMask, int nValue) {
            assert ((nValue & ~nMask) == 0);
            int nStateOld = this.getState();
            int nStateNew = nStateOld & ~nMask | nValue;
            if (nStateNew != nStateOld) {
                this.setState((byte)nStateNew);
            }
        }

        protected boolean extractFlag(int nMask) {
            return this.extractState(nMask) != 0;
        }

        protected void updateFlag(int nMask, boolean f) {
            this.updateState(nMask, f ? nMask : 0);
        }
    }

    protected static class HistoricCacheEvent
    extends CacheEvent {
        protected Object m_oValueLatestOld;

        public HistoricCacheEvent(ObservableMap map, int nId, Object oKey, Object oValueOld, Object oValueNew, boolean fSynthetic, Object oValueRecent) {
            super(map, nId, oKey, oValueOld, oValueNew, fSynthetic);
            this.m_oValueLatestOld = oValueRecent;
        }

        public Object getLatestOldValue() {
            return this.m_oValueLatestOld;
        }
    }

    public class EntrySet
    extends AbstractKeySetBasedMap.EntrySet {
        public EntrySet() {
            super(OverflowMap.this);
        }

        protected Iterator instantiateIterator() {
            return new EntrySetIterator();
        }

        protected class EntrySetIterator
        extends AbstractStableIterator {
            protected Iterator m_iterKeys;
            protected Map m_mapTemp;

            protected EntrySetIterator() {
                this.m_iterKeys = OverflowMap.this.iterateKeys();
                this.m_mapTemp = new LiteMap();
            }

            @Override
            protected void advance() {
                OverflowMap mapOverflow = OverflowMap.this;
                Map mapTemp = this.m_mapTemp;
                Iterator iter = this.m_iterKeys;
                while (iter.hasNext()) {
                    Object oKey = this.m_iterKeys.next();
                    mapOverflow.getInternal(oKey, false, mapTemp);
                    if (mapTemp.isEmpty()) continue;
                    this.setNext(EntrySet.this.instantiateEntry(oKey, mapTemp.remove(oKey)));
                    break;
                }
            }

            protected void remove(Object oPrev) {
                this.m_iterKeys.remove();
            }
        }
    }

    protected class InternalKeySet
    extends AbstractSet {
        protected InternalKeySet() {
        }

        @Override
        public boolean contains(Object o) {
            return OverflowMap.this.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return OverflowMap.this.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new InternalKeySetIterator();
        }

        @Override
        public int size() {
            return OverflowMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray(Object[] ao) {
            Object[] aoKey;
            OverflowMap mapOverflow = OverflowMap.this;
            mapOverflow.evict();
            Gate gate = mapOverflow.getGate();
            boolean fReentrant = gate.isEnteredByCurrentThread();
            if (fReentrant) {
                aoKey = SimpleEnumerator.toArray(this.iterator(), ao == null ? EMPTY_ARRAY : ao);
            } else {
                gate.close(-1L);
                try {
                    int cKeys = mapOverflow.size();
                    if (ao == null) {
                        aoKey = new Object[cKeys];
                    } else {
                        int cElements = ao.length;
                        if (cKeys > cElements) {
                            aoKey = (Object[])Array.newInstance(ao.getClass().getComponentType(), cKeys);
                        } else {
                            aoKey = ao;
                            if (cKeys < cElements) {
                                aoKey[cKeys] = null;
                            }
                        }
                    }
                    int iKey = 0;
                    for (Map.Entry entry : mapOverflow.getStatusMap().entrySet()) {
                        Status status = (Status)entry.getValue();
                        if (!status.isEntryExistent()) continue;
                        aoKey[iKey++] = entry.getKey();
                    }
                    assert (iKey == cKeys);
                }
                finally {
                    gate.open();
                }
            }
            return aoKey;
        }

        protected class InternalKeySetIterator
        extends AbstractStableIterator {
            private Iterator m_iter;

            public InternalKeySetIterator() {
                this.m_iter = OverflowMap.this.getStatusMap().entrySet().iterator();
            }

            @Override
            protected void advance() {
                Iterator iter = this.m_iter;
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Status status = (Status)entry.getValue();
                    if (!status.isEntryExistent()) continue;
                    this.setNext(entry.getKey());
                    break;
                }
            }

            protected void remove(Object oPrev) {
                OverflowMap.this.removeBlind(oPrev);
            }
        }
    }

    protected static class ExpirableStatus
    extends Status {
        private volatile long m_ldtExpires;

        @Override
        public long getExpiry() {
            return this.m_ldtExpires;
        }

        @Override
        public void setExpiry(long ldtExpires) {
            this.m_ldtExpires = ldtExpires;
        }

        @Override
        public boolean hasExpiry() {
            return this.getExpiry() != 0L;
        }

        @Override
        public boolean isExpired() {
            long ldtExpires = this.getExpiry();
            return ldtExpires != 0L && Base.getSafeTimeMillis() >= ldtExpires;
        }

        @Override
        public String getDescription() {
            return super.getDescription() + ", hasExpiry=" + this.hasExpiry() + ", Expiry=" + Base.formatDateTime(this.getExpiry()) + ", Expired=" + this.isExpired();
        }
    }

    protected class FrontMapListener
    extends MultiplexingMapListener {
        protected FrontMapListener() {
        }

        protected void onMapEvent(MapEvent evt) {
            OverflowMap.this.onFrontEvent(evt);
        }
    }

    protected class BackMapListener
    extends MultiplexingMapListener {
        protected BackMapListener() {
        }

        protected void onMapEvent(MapEvent evt) {
            OverflowMap.this.onBackEvent(evt);
        }
    }
}

