/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.AbstractCacheStore;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.IterableCacheLoader;
import com.tangosol.util.SimpleEnumerator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class MapCacheStore<K, V>
extends AbstractCacheStore<K, V>
implements CacheStore<K, V>,
IterableCacheLoader<K, V> {
    private Map<K, V> m_map;

    public MapCacheStore(Map<K, V> map) {
        this.setMap(map);
    }

    @Override
    public V load(K key) {
        return this.getMap().get(key);
    }

    @Override
    public void store(K key, V value) {
        this.getMap().putAll(Collections.singletonMap(key, value));
    }

    @Override
    public void storeAll(Map<? extends K, ? extends V> mapEntries) {
        this.getMap().putAll(mapEntries);
    }

    @Override
    public void erase(K key) {
        this.getMap().keySet().remove(key);
    }

    @Override
    public void eraseAll(Collection<? extends K> colKeys) {
        this.getMap().keySet().removeAll(colKeys);
    }

    @Override
    public Iterator<K> keys() {
        return new SimpleEnumerator<K>(this.getMap().keySet());
    }

    public Map<K, V> getMap() {
        return this.m_map;
    }

    protected void setMap(Map<K, V> map) {
        this.m_map = map;
    }
}

