/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.FlowControl;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.util.AbstractKeySetBasedMap;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.TaskDaemon;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.KeyAssociatedFilter;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.filter.MapEventFilter;
import com.tangosol.util.filter.MapEventTransformerFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.processor.AsynchronousProcessor;
import com.tangosol.util.processor.ExtractorProcessor;
import com.tangosol.util.transformer.ExtractorEventTransformer;
import com.tangosol.util.transformer.SemiLiteEventTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class ContinuousQueryCache<K, V_BACK, V_FRONT>
extends AbstractKeySetBasedMap<K, V_FRONT>
implements NamedCache<K, V_FRONT> {
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONFIGURING = 1;
    public static final int STATE_CONFIGURED = 2;
    public static final int STATE_SYNCHRONIZED = 3;
    private Supplier<NamedCache<K, V_BACK>> f_supplierCache;
    private volatile NamedCache<K, V_BACK> m_cache;
    protected String m_sName;
    protected Filter m_filter;
    protected boolean m_fCacheValues;
    protected ValueExtractor<? super V_BACK, ? extends V_FRONT> m_transformer;
    protected boolean m_fReadOnly;
    protected long m_cReconnectMillis;
    protected volatile long m_ldtConnectionTimestamp;
    protected ObservableMap<K, V_FRONT> m_mapLocal;
    protected volatile Integer m_nState;
    protected volatile Map m_mapSyncReq;
    protected volatile TaskDaemon m_eventQueue;
    protected boolean m_fListeners;
    protected MapEventFilter m_filterAdd;
    protected MapEventFilter m_filterRemove;
    protected MapListener<K, V_FRONT> m_listenerAdd;
    protected MapListener<K, V_FRONT> m_listenerRemove;
    protected MemberListener m_listenerService;
    protected Map m_mapIndex;
    protected NamedCacheDeactivationListener m_listenerDeactivation;
    protected MapListener<? super K, ? super V_FRONT> m_mapListener;
    protected Converter m_converterFromBinary;
    protected Converter m_converterToBinary;
    protected ClassLoader m_loader;
    protected MapListenerSupport m_listenerSupport;
    protected final List<NamedCacheDeactivationListener> m_listDeactivationListener = new ArrayList<NamedCacheDeactivationListener>();
    protected final Lock m_listenerLock = new ReentrantLock();

    public ContinuousQueryCache(NamedCache<K, V_BACK> cache) {
        this(cache, AlwaysFilter.INSTANCE(), true, null, null);
    }

    public ContinuousQueryCache(Supplier<NamedCache<K, V_BACK>> supplierCache) {
        this(supplierCache, AlwaysFilter.INSTANCE(), true, null, null, null);
    }

    public ContinuousQueryCache(NamedCache<K, V_BACK> cache, Filter filter) {
        this(cache, filter, true, null, null);
    }

    public ContinuousQueryCache(Supplier<NamedCache<K, V_BACK>> supplierCache, Filter filter) {
        this(supplierCache, filter, true, null, null, null);
    }

    public ContinuousQueryCache(NamedCache<K, V_BACK> cache, Filter filter, ValueExtractor<? super V_BACK, ? extends V_FRONT> transformer) {
        this(cache, filter, true, null, transformer);
    }

    public ContinuousQueryCache(NamedCache<K, V_BACK> cache, Filter filter, boolean fCacheValues) {
        this(cache, filter, fCacheValues, null, null);
    }

    public ContinuousQueryCache(NamedCache<K, V_BACK> cache, Filter filter, MapListener<? super K, ? super V_FRONT> listener) {
        this(cache, filter, false, listener, null);
    }

    public ContinuousQueryCache(NamedCache<K, V_BACK> cache, Filter filter, MapListener<? super K, ? super V_FRONT> listener, ValueExtractor<? super V_BACK, ? extends V_FRONT> transformer) {
        this(cache, filter, true, listener, transformer);
    }

    public ContinuousQueryCache(NamedCache<K, V_BACK> cache, Filter filter, boolean fCacheValues, MapListener<? super K, ? super V_FRONT> listener, ValueExtractor<? super V_BACK, ? extends V_FRONT> transformer) {
        this(() -> cache, filter, fCacheValues, listener, transformer, null);
    }

    public ContinuousQueryCache(Supplier<NamedCache<K, V_BACK>> supplierCache, Filter filter, boolean fCacheValues, MapListener<? super K, ? super V_FRONT> listener, ValueExtractor<? super V_BACK, ? extends V_FRONT> transformer, ClassLoader loader) {
        NamedCache<K, V_BACK> cache = supplierCache.get();
        if (cache == null) {
            throw new IllegalArgumentException("NamedCache must be specified");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter must be specified");
        }
        if (filter instanceof LimitFilter) {
            throw new UnsupportedOperationException("LimitFilter may not be used");
        }
        this.m_loader = loader;
        this.f_supplierCache = supplierCache;
        this.m_cache = this.ensureConverters(cache);
        this.m_filter = filter;
        this.m_fCacheValues = fCacheValues;
        this.m_transformer = Lambdas.ensureRemotable(transformer);
        this.m_fReadOnly = transformer != null;
        this.m_nState = 0;
        if (listener instanceof MapTriggerListener) {
            throw new IllegalArgumentException("ContinuousQueryCache does not support MapTriggerListeners");
        }
        if (listener instanceof NamedCacheDeactivationListener) {
            this.addMapListener((MapListener<? super K, ? super V_FRONT>)listener);
        } else {
            this.m_mapListener = listener;
        }
        this.m_sName = ContinuousQueryCache.getDefaultName(cache.getCacheName(), filter, transformer);
        this.ensureInternalCache();
        this.ensureSynchronized(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedCache<K, V_BACK> getCache() {
        NamedCache<K, V_BACK> cache = this.m_cache;
        if (cache == null) {
            ContinuousQueryCache continuousQueryCache = this;
            synchronized (continuousQueryCache) {
                if (this.m_cache == null) {
                    cache = this.f_supplierCache.get();
                    if (cache == null) {
                        throw new IllegalStateException("NamedCache is not active");
                    }
                    cache = this.m_cache = this.ensureConverters(cache);
                }
            }
        }
        return cache;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public ValueExtractor<? super V_BACK, ? extends V_FRONT> getTransformer() {
        return this.m_transformer;
    }

    public MapListener<? super K, ? super V_FRONT> getMapListener() {
        return this.m_mapListener;
    }

    public boolean isCacheValues() {
        return this.m_fCacheValues || this.isObserved();
    }

    public synchronized void setCacheValues(boolean fCacheValues) {
        if (fCacheValues != this.m_fCacheValues) {
            boolean fDidCacheValues = this.isCacheValues();
            if (fDidCacheValues) {
                this.releaseIndexMap();
            }
            this.m_fCacheValues = fCacheValues;
            if (this.isCacheValues() != fDidCacheValues) {
                this.configureSynchronization(false);
            }
        }
    }

    public boolean isTransformed() {
        return this.m_transformer != null;
    }

    public boolean isReadOnly() {
        return this.m_fReadOnly;
    }

    public synchronized void setReadOnly(boolean fReadOnly) {
        if (fReadOnly != this.isReadOnly()) {
            this.checkReadOnly();
            this.m_fReadOnly = fReadOnly;
        }
    }

    protected ObservableMap<K, V_FRONT> instantiateInternalCache() {
        return new ObservableHashMap();
    }

    protected ObservableMap<K, V_FRONT> ensureInternalCache() {
        if (this.m_mapLocal == null) {
            this.m_mapLocal = this.instantiateInternalCache();
            MapListener<? super K, ? super V_FRONT> mapListener = this.m_mapListener;
            if (mapListener != null) {
                this.ensureEventQueue();
                this.ensureListenerSupport().addListener(this.instantiateEventRouter(mapListener, false), (Filter)null, false);
                this.m_fListeners = true;
            }
        }
        return this.m_mapLocal;
    }

    protected ObservableMap<K, V_FRONT> getInternalCache() {
        this.ensureSynchronized(true);
        return this.m_mapLocal;
    }

    protected boolean isObserved() {
        return this.m_fListeners;
    }

    protected synchronized void setObserved(boolean fObserved) {
        if (fObserved != this.isObserved()) {
            boolean fDidCacheValues = this.isCacheValues();
            this.m_fListeners = fObserved;
            if (this.isCacheValues() != fDidCacheValues) {
                this.configureSynchronization(false);
            }
        }
    }

    public int getState() {
        return this.m_nState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(int nState) {
        switch (nState) {
            case 0: {
                this.resetCacheRefs();
                this.m_nState = 0;
                break;
            }
            case 1: {
                Integer n = this.m_nState;
                synchronized (n) {
                    int nStatePrev = this.m_nState;
                    ContinuousQueryCache.azzert(nStatePrev == 0 || nStatePrev == 3);
                    this.m_mapSyncReq = new SafeHashMap();
                    this.m_nState = 1;
                    break;
                }
            }
            case 2: {
                Integer n = this.m_nState;
                synchronized (n) {
                    if (this.m_nState != 1) {
                        throw new IllegalStateException(this.getCacheName() + " has been invalidated");
                    }
                    this.m_nState = 2;
                    break;
                }
            }
            case 3: {
                Integer n = this.m_nState;
                synchronized (n) {
                    if (this.m_nState != 2) {
                        throw new IllegalStateException(this.getCacheName() + " has been invalidated");
                    }
                    this.m_mapSyncReq = null;
                    this.m_nState = 3;
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("unknown state: " + nState);
            }
        }
    }

    protected void resetCacheRefs() {
        this.m_converterFromBinary = null;
        this.m_converterToBinary = null;
        this.m_cache = null;
    }

    public long getReconnectInterval() {
        return this.m_cReconnectMillis;
    }

    public void setReconnectInterval(long cReconnectMillis) {
        this.m_cReconnectMillis = cReconnectMillis;
    }

    public void setCacheName(String sCacheName) {
        this.m_sName = sCacheName == null ? ContinuousQueryCache.getDefaultName(this.getCache().getCacheName(), this.m_filter, this.m_transformer) : sCacheName;
    }

    @Override
    public void clear() {
        this.checkReadOnly();
        this.getCache().keySet().removeAll(this.getInternalKeySet());
    }

    @Override
    public V_FRONT get(Object oKey) {
        Object oResult = this.isCacheValues() ? this.getInternalCache().get(oKey) : (this.containsKey(oKey) ? this.getInternal(oKey) : null);
        return this.ensureInflated(oKey, oResult);
    }

    @Override
    public V_FRONT put(K oKey, V_FRONT oValue) {
        Object oOrig;
        this.checkReadOnly();
        this.checkEntry(oKey, oValue);
        NamedCache<K, V_BACK> cache = this.getCache();
        boolean fLocalCache = this.isCacheValues();
        boolean fPresent = this.containsKey(oKey);
        if (fLocalCache || !fPresent) {
            oOrig = fPresent ? this.getInternalCache().get(oKey) : null;
            cache.putAll(Collections.singletonMap(oKey, oValue));
        } else {
            oOrig = cache.put(oKey, oValue);
            if (!InvocableMapHelper.evaluateEntry(this.getFilter(), oKey, oOrig)) {
                oOrig = null;
            }
        }
        return (V_FRONT)this.fromInternal(oOrig);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V_FRONT> map) {
        this.checkReadOnly();
        Iterator<Map.Entry<K, V_FRONT>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            this.checkEntry(iter.next());
        }
        this.getCache().putAll(map);
    }

    @Override
    public V_FRONT remove(Object oKey) {
        this.checkReadOnly();
        V_FRONT oOrig = null;
        if (this.containsKey(oKey)) {
            NamedCache<K, V_BACK> cache = this.getCache();
            if (this.isCacheValues()) {
                oOrig = this.ensureInflated(oKey, null);
                this.removeBlind(oKey);
            } else {
                oOrig = (V_FRONT)cache.remove(oKey);
            }
        }
        return oOrig;
    }

    @Override
    public Map<K, V_FRONT> getAll(Collection<? extends K> colKeys) {
        Map<Object, Object> mapResult;
        block4: {
            ObservableMap<K, V_FRONT> mapLocal;
            block5: {
                block3: {
                    mapLocal = this.getInternalCache();
                    if (!this.isCacheValues()) break block3;
                    mapResult = new ListMap();
                    for (K oKey : colKeys) {
                        V_FRONT oVal = this.ensureInflated(oKey, null);
                        if (oVal == null && !this.containsKey(oKey)) continue;
                        mapResult.put(oKey, oVal);
                    }
                    break block4;
                }
                if (colKeys.size() > 1) break block5;
                mapResult = new ListMap();
                for (K oKey : colKeys) {
                    V_FRONT oValue;
                    if (!mapLocal.containsKey(oKey) || (oValue = this.getInternal(oKey)) == null && !mapLocal.containsKey(oKey) || !InvocableMapHelper.evaluateEntry(this.getFilter(), oKey, oValue)) continue;
                    mapResult.put(oKey, oValue);
                }
                break block4;
            }
            HashSet<K> collView = new HashSet<K>(colKeys);
            collView.retainAll(mapLocal.keySet());
            mapResult = this.getAllInternal(collView);
            Filter filter = this.getFilter();
            if (mapResult.isEmpty() || !new FilterEnumerator(mapResult.values().iterator(), new NotFilter(filter)).hasNext()) break block4;
            Iterator<Map.Entry<Object, Object>> iter = mapResult.entrySet().iterator();
            mapResult = new HashMap();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                if (!InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                mapResult.put(entry.getKey(), entry.getValue());
            }
        }
        return mapResult;
    }

    @Override
    public V_FRONT put(K oKey, V_FRONT oValue, long cMillis) {
        if (cMillis == 0L) {
            return this.put(oKey, oValue);
        }
        this.checkReadOnly();
        this.checkEntry(oKey, oValue);
        NamedCache<K, V_BACK> cache = this.getCache();
        Object oOrig = this.fromInternal(cache.put(oKey, oValue, cMillis));
        return (V_FRONT)(InvocableMapHelper.evaluateEntry(this.getFilter(), oKey, oOrig) ? oOrig : null);
    }

    @Override
    protected boolean removeBlind(Object oKey) {
        this.checkReadOnly();
        return this.containsKey(oKey) && this.getCache().keySet().remove(oKey);
    }

    @Override
    protected Set<K> getInternalKeySet() {
        return this.getInternalCache().keySet();
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V_FRONT> listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V_FRONT> listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMapListener(MapListener<? super K, ? super V_FRONT> listener, K oKey, boolean fLite) {
        ContinuousQueryCache.azzert(listener != null);
        if (listener instanceof MapTriggerListener) {
            throw new IllegalArgumentException("ContinuousQueryCache does not support MapTriggerListeners");
        }
        this.m_listenerLock.lock();
        try {
            if (listener instanceof NamedCacheDeactivationListener) {
                this.m_listDeactivationListener.add((NamedCacheDeactivationListener)listener);
            } else {
                if (!fLite) {
                    this.setObserved(true);
                }
                this.ensureEventQueue();
                this.ensureListenerSupport().addListener(this.instantiateEventRouter(listener, fLite), oKey, fLite);
            }
        }
        finally {
            this.m_listenerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMapListener(MapListener<? super K, ? super V_FRONT> listener, K oKey) {
        ContinuousQueryCache.azzert(listener != null);
        this.m_listenerLock.lock();
        try {
            if (listener instanceof NamedCacheDeactivationListener) {
                this.m_listDeactivationListener.remove((NamedCacheDeactivationListener)listener);
            } else {
                MapListenerSupport listenerSupport = this.m_listenerSupport;
                if (listenerSupport != null) {
                    listenerSupport.removeListener(this.instantiateEventRouter(listener, false), oKey);
                }
            }
        }
        finally {
            this.m_listenerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMapListener(MapListener<? super K, ? super V_FRONT> listener, Filter filter, boolean fLite) {
        ContinuousQueryCache.azzert(listener != null);
        if (listener instanceof MapTriggerListener) {
            throw new IllegalArgumentException("ContinuousQueryCache does not support MapTriggerListeners");
        }
        this.m_listenerLock.lock();
        try {
            if (listener instanceof NamedCacheDeactivationListener) {
                this.m_listDeactivationListener.add((NamedCacheDeactivationListener)listener);
            } else {
                if (filter != null || !fLite) {
                    this.setObserved(true);
                }
                this.ensureEventQueue();
                this.ensureListenerSupport().addListener(this.instantiateEventRouter(listener, fLite), filter, fLite);
            }
        }
        finally {
            this.m_listenerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMapListener(MapListener<? super K, ? super V_FRONT> listener, Filter filter) {
        ContinuousQueryCache.azzert(listener != null);
        this.m_listenerLock.lock();
        try {
            if (listener instanceof NamedCacheDeactivationListener) {
                this.m_listDeactivationListener.remove((NamedCacheDeactivationListener)listener);
            } else {
                MapListenerSupport listenerSupport = this.m_listenerSupport;
                if (listenerSupport != null) {
                    listenerSupport.removeListener(this.instantiateEventRouter(listener, false), filter);
                }
            }
        }
        finally {
            this.m_listenerLock.unlock();
        }
    }

    @Override
    public Set<K> keySet(Filter filter) {
        return this.isCacheValues() ? InvocableMapHelper.query(this, this.getIndexMap(), filter, false, false, null) : this.getCache().keySet(this.mergeFilter(filter));
    }

    @Override
    public Set<Map.Entry<K, V_FRONT>> entrySet(Filter filter) {
        return this.isCacheValues() ? InvocableMapHelper.query(this, this.getIndexMap(), filter, true, false, null) : this.entrySetInternal(this.mergeFilter(filter));
    }

    @Override
    public Set<Map.Entry<K, V_FRONT>> entrySet(Filter filter, Comparator comparator) {
        return this.isCacheValues() ? InvocableMapHelper.query(this, this.getIndexMap(), filter, true, true, comparator) : this.entrySetInternal(this.mergeFilter(filter), comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> extractor, boolean fOrdered, Comparator<? super E> comparator) {
        ContinuousQueryCache continuousQueryCache = this;
        synchronized (continuousQueryCache) {
            if (this.isCacheValues()) {
                InvocableMapHelper.addIndex(extractor, fOrdered, comparator, this, this.ensureIndexMap());
            }
        }
        this.getCache().addIndex(extractor, fOrdered, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> extractor) {
        ContinuousQueryCache continuousQueryCache = this;
        synchronized (continuousQueryCache) {
            if (this.isCacheValues()) {
                InvocableMapHelper.removeIndex(extractor, this, this.ensureIndexMap());
            }
        }
    }

    @Override
    public void truncate() {
        this.checkReadOnly();
        this.getCache().truncate();
    }

    @Override
    public <R> R invoke(K key, InvocableMap.EntryProcessor<K, V_FRONT, R> processor) {
        NamedCache<K, V_BACK> cache = this.getCache();
        return (R)this.fromInternal(cache.invoke(key, this.ensureConverted(processor)));
    }

    @Override
    public <R> Map<K, R> invokeAll(Collection<? extends K> collKeys, InvocableMap.EntryProcessor<K, V_FRONT, R> processor) {
        if (collKeys.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        NamedCache<K, V_BACK> cache = this.getCache();
        return this.instantiateConverterMap(cache.invokeAll(collKeys, this.ensureConverted(processor)));
    }

    @Override
    public <R> Map<K, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<K, V_FRONT, R> processor) {
        NamedCache<K, V_BACK> cache = this.getCache();
        return this.instantiateConverterMap(cache.invokeAll(this.mergeFilter(filter), this.ensureConverted(processor)));
    }

    @Override
    public <R> R aggregate(Collection<? extends K> collKeys, InvocableMap.EntryAggregator<? super K, ? super V_FRONT, R> aggregator) {
        if (collKeys.isEmpty()) {
            return aggregator.aggregate(Collections.emptySet());
        }
        if (this.isCacheValues()) {
            return aggregator.aggregate(InvocableMapHelper.makeEntrySet(this, collKeys, true));
        }
        if (this.isTransformed()) {
            throw new UnsupportedOperationException("Aggregation cannot be performed on a transforming CQC that does not cache values locally");
        }
        NamedCache<? extends K, V_BACK> cache = this.getCache();
        return cache.aggregate(collKeys, aggregator);
    }

    @Override
    public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super K, ? super V_FRONT, R> aggregator) {
        if (this.isCacheValues()) {
            return this.aggregate((Collection<? extends K>)this.keySet(filter), aggregator);
        }
        if (this.isTransformed()) {
            throw new UnsupportedOperationException("Aggregation cannot be performed on a transforming CQC that does not cache values locally");
        }
        NamedCache<? super K, V_BACK> cache = this.getCache();
        return cache.aggregate(this.mergeFilter(filter), aggregator);
    }

    @Override
    public boolean lock(Object oKey, long cWait) {
        this.checkReadOnly();
        return this.getCache().lock(oKey, cWait);
    }

    @Override
    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    @Override
    public boolean unlock(Object oKey) {
        return this.getCache().unlock(oKey);
    }

    @Override
    public String getCacheName() {
        return this.m_sName;
    }

    @Override
    public CacheService getCacheService() {
        return this.getCache().getCacheService();
    }

    @Override
    public AsyncNamedCache<K, V_FRONT> async(AsyncNamedMap.Option ... options) {
        CacheService service = this.getCacheService();
        return service.ensureCache(this.getCacheName(), service.getContextClassLoader()).async(options);
    }

    @Override
    public boolean isActive() {
        NamedCache<K, V_BACK> cache = this.m_cache;
        return cache != null && cache.isActive();
    }

    @Override
    public boolean isReady() {
        NamedCache<K, V_BACK> cache = this.m_cache;
        return cache != null && cache.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.shutdownEventQueue();
        ContinuousQueryCache continuousQueryCache = this;
        synchronized (continuousQueryCache) {
            this.releaseListeners();
            this.resetCacheRefs();
            this.m_mapLocal = null;
            this.m_nState = 0;
        }
    }

    @Override
    public void destroy() {
        this.release();
    }

    @Override
    public boolean isDestroyed() {
        NamedCache<K, V_BACK> cache = this.m_cache;
        return cache != null && cache.isDestroyed();
    }

    @Override
    public boolean isReleased() {
        NamedCache<K, V_BACK> cache = this.m_cache;
        return cache == null || cache.isReleased();
    }

    protected V_FRONT getInternal(Object oKey) {
        Object value = this.getCache().get(oKey);
        return (V_FRONT)(this.m_transformer == null ? value : this.m_transformer.extract(value));
    }

    protected Map<K, V_FRONT> getAllInternal(Collection<? extends K> colKeys) {
        Map mapResults = this.getCache().getAll(colKeys);
        return this.m_transformer == null ? mapResults : this.transform(mapResults.entrySet(), this.m_transformer);
    }

    protected Set<Map.Entry<K, V_FRONT>> entrySetInternal(Filter filter) {
        Set<Map.Entry<K, V_BACK>> setResults = this.getCache().entrySet(filter);
        return this.m_transformer == null ? setResults : this.transform(setResults, this.m_transformer).entrySet();
    }

    protected Set<Map.Entry<K, V_FRONT>> entrySetInternal(Filter filter, Comparator comparator) {
        Set<Map.Entry<K, V_BACK>> setResults = this.getCache().entrySet(filter, comparator);
        return this.m_transformer == null ? setResults : this.transform(setResults, this.m_transformer).entrySet();
    }

    protected Map<K, V_FRONT> transform(Set<Map.Entry<K, V_BACK>> setIn, ValueExtractor<? super V_BACK, ? extends V_FRONT> transformer) {
        LiteMap mapOut = new LiteMap();
        setIn.forEach((? super T entry) -> mapOut.put(entry.getKey(), transformer.extract((Object)entry.getValue())));
        return mapOut;
    }

    protected Filter mergeFilter(Filter filter) {
        ExternalizableHelper filterMerged;
        if (filter == null) {
            return this.m_filter;
        }
        Filter filterCQC = this.getFilter();
        boolean fKeyAssoc = false;
        Object oKeyAssoc = null;
        if (filterCQC instanceof KeyAssociatedFilter) {
            filterAssoc = (KeyAssociatedFilter)filterCQC;
            oKeyAssoc = filterAssoc.getHostKey();
            filterCQC = filterAssoc.getFilter();
            fKeyAssoc = true;
            if (filter instanceof KeyAssociatedFilter) {
                filter = ((KeyAssociatedFilter)filter).getFilter();
            }
        } else if (filter instanceof KeyAssociatedFilter) {
            filterAssoc = (KeyAssociatedFilter)filter;
            oKeyAssoc = filterAssoc.getHostKey();
            filter = filterAssoc.getFilter();
            fKeyAssoc = true;
        }
        if (filter instanceof LimitFilter) {
            LimitFilter filterNew;
            LimitFilter filterOrig = (LimitFilter)filter;
            int iPageSize = filterOrig.getPageSize();
            Object oCookie = filterOrig.getCookie();
            if (oCookie instanceof LimitFilter) {
                filterNew = (LimitFilter)oCookie;
                filterNew.setPageSize(iPageSize);
            } else {
                filterNew = new LimitFilter(new AndFilter(filterCQC, filterOrig.getFilter()), iPageSize);
                filterOrig.setCookie(filterNew);
            }
            filterNew.setPage(filterOrig.getPage());
            filterMerged = filterNew;
        } else {
            filterMerged = new AndFilter(filterCQC, filter);
        }
        if (fKeyAssoc) {
            filterMerged = new KeyAssociatedFilter(filterMerged, oKeyAssoc);
        }
        return filterMerged;
    }

    protected void checkReadOnly() {
        if (this.isReadOnly()) {
            throw new IllegalStateException(this.getCacheName() + " is read-only");
        }
    }

    protected void checkEntry(Map.Entry entry) {
        if (!InvocableMapHelper.evaluateEntry(this.getFilter(), entry)) {
            throw new IllegalArgumentException(this.getCacheName() + ": Attempted modification violates filter; key=\"" + String.valueOf(entry.getKey()) + "\", value=\"" + String.valueOf(entry.getValue()) + "\"");
        }
    }

    protected void checkEntry(Object oKey, Object oValue) {
        if (!InvocableMapHelper.evaluateEntry(this.getFilter(), oKey, oValue)) {
            throw new IllegalArgumentException(this.getCacheName() + ": Attempted modification violates filter; key=\"" + String.valueOf(oKey) + "\", value=\"" + String.valueOf(oValue) + "\"");
        }
    }

    protected String getStateString(int nState) {
        switch (nState) {
            case 2: {
                return "STATE_CONFIGURED";
            }
            case 1: {
                return "STATE_CONFIGURING";
            }
            case 0: {
                return "STATE_DISCONNECTED";
            }
            case 3: {
                return "STATE_SYNCHRONIZED";
            }
        }
        throw new IllegalStateException("unknown state: " + nState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void configureSynchronization(boolean fReload) {
        ObservableMap mapLocal = null;
        try {
            int nMask;
            boolean fFirstTime;
            this.changeState(1);
            this.m_ldtConnectionTimestamp = ContinuousQueryCache.getSafeTimeMillis();
            NamedCache<K, V_BACK> cache = this.getCache();
            Filter filter = this.getFilter();
            boolean fCacheValues = this.isCacheValues();
            MapEventFilter filterAddPrev = this.m_filterAdd;
            MapListener<K, V_FRONT> listenerAddPrev = this.m_listenerAdd;
            boolean bl = fFirstTime = filterAddPrev == null;
            if (fFirstTime) {
                this.registerServiceListener();
                this.registerDeactivationListener();
                nMask = 20;
                MapEventFilter filterRemove = new MapEventFilter(nMask, filter);
                MapListener<K, V_FRONT> listenerRemove = this.instantiateRemoveListener();
                cache.addMapListener((MapListener<K, V_BACK>)listenerRemove, filterRemove, true);
                this.m_filterRemove = filterRemove;
                this.m_listenerRemove = listenerRemove;
            } else {
                cache.addMapListener((MapListener<K, V_BACK>)this.m_listenerRemove, this.m_filterRemove, true);
            }
            nMask = 9;
            if (fCacheValues) {
                nMask |= 0x20;
            }
            if (fFirstTime || nMask != filterAddPrev.getEventMask()) {
                MapEventFilter filterAdd = new MapEventFilter(nMask, filter);
                MapListener<K, V_FRONT> listenerAdd = this.instantiateAddListener();
                cache.addMapListener(listenerAdd, this.createTransformerFilter(filterAdd), !fCacheValues);
                this.m_filterAdd = filterAdd;
                this.m_listenerAdd = listenerAdd;
                if (listenerAddPrev != null) {
                    ContinuousQueryCache.azzert(filterAddPrev != null);
                    cache.removeMapListener(listenerAddPrev, this.createTransformerFilter(filterAddPrev));
                }
            } else {
                cache.addMapListener(listenerAddPrev, this.createTransformerFilter(filterAddPrev), !fCacheValues);
            }
            mapLocal = this.ensureInternalCache();
            if (fFirstTime || fReload) {
                if (this.isCacheValues()) {
                    Set set;
                    Set set2 = set = this.m_transformer == null ? cache.entrySet(filter) : cache.invokeAll(filter, new ExtractorProcessor(this.m_transformer)).entrySet();
                    if (!mapLocal.isEmpty()) {
                        HashSet setQueryKeys = new HashSet();
                        Iterator iter = set.iterator();
                        while (iter.hasNext()) {
                            setQueryKeys.add(iter.next().getKey());
                        }
                        mapLocal.keySet().retainAll(setQueryKeys);
                    }
                    for (Map.Entry entry : set) {
                        mapLocal.put(entry.getKey(), entry.getValue());
                    }
                } else {
                    Set setQueryKeys = cache.keySet(filter);
                    if (!mapLocal.isEmpty()) {
                        mapLocal.keySet().retainAll(setQueryKeys);
                    }
                    iter = setQueryKeys.iterator();
                    while (iter.hasNext()) {
                        mapLocal.put(iter.next(), null);
                    }
                }
            } else if (fCacheValues) {
                Object[] aoKey;
                iter = mapLocal;
                synchronized (iter) {
                    aoKey = mapLocal.keySet().toArray();
                }
                Map mapValues = cache.getAll(new ImmutableArrayList(aoKey));
                mapLocal.putAll(mapValues);
            } else {
                Iterator iter = mapLocal.entrySet().iterator();
                while (iter.hasNext()) {
                    iter.next().setValue(null);
                }
            }
            int nCurrentState = this.getState();
            if (nCurrentState != 1) {
                throw this.createUnexpectedStateException(2, nCurrentState);
            }
            this.changeState(2);
            Map mapSyncReq = this.m_mapSyncReq;
            if (!mapSyncReq.isEmpty()) {
                Object[] aoKey;
                Map map = mapSyncReq;
                synchronized (map) {
                    aoKey = mapSyncReq.keySet().toArray();
                }
                Map mapSyncVals = cache.getAll(new ImmutableArrayList(aoKey));
                Map map2 = mapSyncReq;
                synchronized (map2) {
                    for (Object oKey : mapSyncReq.keySet()) {
                        boolean fExists;
                        Object oValue = mapSyncVals.get(oKey);
                        boolean bl2 = fExists = oValue != null || mapSyncVals.containsKey(oKey);
                        if (fExists && InvocableMapHelper.evaluateEntry(filter, oKey, oValue)) {
                            mapLocal.put(oKey, oValue);
                            continue;
                        }
                        mapLocal.remove(oKey);
                    }
                    mapSyncReq.clear();
                }
            }
            if ((nCurrentState = this.getState()) != 2) {
                throw this.createUnexpectedStateException(2, nCurrentState);
            }
            this.changeState(3);
        }
        catch (Throwable e) {
            if (mapLocal != null) {
                this.releaseListeners();
            }
            this.changeState(0);
            throw ContinuousQueryCache.ensureRuntimeException(e);
        }
    }

    protected RuntimeException createUnexpectedStateException(int nExpectedState, int nActualState) {
        String sMsg = "Unexpected synchronization state.  Expected: %s, actual: %s";
        return new IllegalStateException(String.format(sMsg, this.getStateString(nExpectedState), this.getStateString(nActualState)));
    }

    protected Filter createTransformerFilter(MapEventFilter filterAdd) {
        return new MapEventTransformerFilter(filterAdd, (MapEventTransformer)((Object)(this.m_transformer == null ? SemiLiteEventTransformer.INSTANCE : new ExtractorEventTransformer(null, this.m_transformer))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureSynchronized(boolean fReload) {
        if (this.getState() != 3) {
            boolean fAllowDisconnect;
            long cReconnectMillis = this.getReconnectInterval();
            boolean bl = fAllowDisconnect = cReconnectMillis > 0L;
            if (fAllowDisconnect && ContinuousQueryCache.getSafeTimeMillis() < this.m_ldtConnectionTimestamp + cReconnectMillis) {
                return;
            }
            Throwable eConfig = null;
            int cAttempts = fAllowDisconnect ? 1 : 3;
            for (int i = 0; i < cAttempts; ++i) {
                ContinuousQueryCache continuousQueryCache = this;
                synchronized (continuousQueryCache) {
                    int nState = this.getState();
                    if (nState == 0) {
                        try {
                            this.configureSynchronization(fReload);
                            return;
                        }
                        catch (Throwable e) {
                            eConfig = e;
                        }
                    } else {
                        ContinuousQueryCache.azzert(nState == 3);
                        return;
                    }
                    continue;
                }
            }
            if (!fAllowDisconnect) {
                String sMsg = "This ContinuousQueryCache is disconnected. Retry the operation again.";
                if (CacheFactory.isLogEnabled(9)) {
                    throw new IllegalStateException(sMsg, eConfig);
                }
                throw new IllegalStateException(sMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEventDeferred(Object oKey) {
        boolean fDeferred = false;
        Map mapSyncReq = this.m_mapSyncReq;
        if (mapSyncReq != null) {
            Integer n = this.m_nState;
            synchronized (n) {
                if (this.getState() <= 1) {
                    if (DeactivationListener.class.getName().equals(oKey)) {
                        mapSyncReq.clear();
                    } else {
                        mapSyncReq.put(oKey, null);
                    }
                    fDeferred = true;
                } else {
                    mapSyncReq.keySet().remove(oKey);
                }
            }
        }
        return fDeferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map ensureIndexMap() {
        ContinuousQueryCache continuousQueryCache = this;
        synchronized (continuousQueryCache) {
            if (this.m_mapIndex == null) {
                this.m_mapIndex = new SafeHashMap();
            }
            return this.m_mapIndex;
        }
    }

    protected Map getIndexMap() {
        return this.m_mapIndex;
    }

    protected void releaseIndexMap() {
        Map mapIndex = this.getIndexMap();
        if (mapIndex != null) {
            HashSet setExtractors = new HashSet(mapIndex.keySet());
            Iterator iter = setExtractors.iterator();
            while (iter.hasNext()) {
                this.removeIndex((ValueExtractor)iter.next());
            }
        }
    }

    protected void releaseListeners() {
        NamedCache<K, V_BACK> cache = this.m_cache;
        if (cache != null) {
            this.unregisterServiceListener();
            this.unregisterDeactivationListener();
            MapListener<K, V_FRONT> listenerAdd = this.m_listenerAdd;
            if (listenerAdd != null) {
                try {
                    cache.removeMapListener(listenerAdd, this.createTransformerFilter(this.m_filterAdd));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_listenerAdd = null;
            }
            this.m_filterAdd = null;
            MapListener<K, V_FRONT> listenerRemove = this.m_listenerRemove;
            if (listenerRemove != null) {
                try {
                    cache.removeMapListener((MapListener<K, V_BACK>)listenerRemove, this.m_filterRemove);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_listenerRemove = null;
            }
            this.m_filterRemove = null;
        }
        this.m_listenerSupport = null;
    }

    protected MapListener<K, V_FRONT> instantiateAddListener() {
        return new AddListener();
    }

    protected MapListener<K, V_FRONT> instantiateRemoveListener() {
        return new RemoveListener();
    }

    protected void registerServiceListener() {
        CacheService service = this.getCacheService();
        if (service != null) {
            try {
                ServiceListener listener = new ServiceListener();
                service.addMemberListener(listener);
                this.m_listenerService = listener;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    protected void unregisterServiceListener() {
        try {
            this.getCacheService().removeMemberListener(this.m_listenerService);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void registerDeactivationListener() {
        CacheService service = this.getCacheService();
        if (service != null) {
            try {
                this.m_listenerDeactivation = new DeactivationListener();
                DeactivationListener deactivationListener = this.m_listenerDeactivation;
                this.m_cache.addMapListener(deactivationListener);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    protected void unregisterDeactivationListener() {
        NamedCacheDeactivationListener deactivationListener = this.m_listenerDeactivation;
        if (deactivationListener != null) {
            try {
                NamedCache<K, V_BACK> cache = this.m_cache;
                if (cache != null) {
                    cache.removeMapListener(deactivationListener);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected EventRouter<K, V_FRONT> instantiateEventRouter(MapListener<? super K, ? super V_FRONT> listener, boolean fLite) {
        return new EventRouter<K, V_FRONT>(listener, fLite);
    }

    protected TaskDaemon instantiateEventQueue() {
        return new TaskDaemon("EventQueue:" + this.getCacheName());
    }

    protected TaskDaemon getEventQueue() {
        return this.m_eventQueue;
    }

    protected synchronized TaskDaemon ensureEventQueue() {
        TaskDaemon queue = this.getEventQueue();
        if (queue == null) {
            this.m_eventQueue = queue = this.instantiateEventQueue();
        }
        return queue;
    }

    protected void shutdownEventQueue() {
        TaskDaemon eventQueue = this.getEventQueue();
        if (eventQueue != null) {
            this.m_eventQueue = null;
            eventQueue.stop(false);
        }
    }

    protected synchronized MapListenerSupport ensureListenerSupport() {
        MapListenerSupport listenerSupport = this.m_listenerSupport;
        if (listenerSupport == null) {
            listenerSupport = this.m_listenerSupport = new MapListenerSupport();
            Converter convKey = NullImplementation.getConverter();
            Converter convValue = this.m_converterFromBinary;
            this.m_mapLocal.addMapListener(new InternalMapListener(listenerSupport, convKey, convValue));
        }
        return listenerSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchDeactivationEvent(int eventType) {
        this.m_listenerLock.lock();
        try {
            MapEvent<Object, Object> evt = new MapEvent<Object, Object>(this, eventType, null, null, null);
            for (MapListener mapListener : this.m_listDeactivationListener) {
                switch (evt.getId()) {
                    case 2: {
                        mapListener.entryUpdated(evt);
                        break;
                    }
                    case 3: {
                        mapListener.entryDeleted(evt);
                    }
                }
            }
        }
        finally {
            this.m_listenerLock.unlock();
        }
    }

    protected V_FRONT ensureInflated(Object oKey, Object oValue) {
        Object oInflated;
        ObservableMap<Object, V_FRONT> mapInternal = this.getInternalCache();
        Object object = oInflated = oValue == null ? mapInternal.get(oKey) : oValue;
        if (oInflated instanceof Binary) {
            oInflated = this.fromInternal(oInflated);
            mapInternal.replace(oKey, oValue, oInflated);
        }
        return (V_FRONT)oInflated;
    }

    protected <T> T fromInternal(Object binValue) {
        return this.m_converterFromBinary.convert(binValue);
    }

    protected Binary toInternal(Object oValue) {
        return (Binary)this.m_converterToBinary.convert(oValue);
    }

    protected Map<K, V_FRONT> instantiateConverterMap(Map<K, V_FRONT> map) {
        if (this.isBinaryNamedCache()) {
            Converter convUp = this.m_converterFromBinary;
            Converter convDown = NullImplementation.getConverter();
            return ConverterCollections.getMap(map, convUp, convDown, convUp, convDown);
        }
        return map;
    }

    protected InvocableMap.EntryProcessor ensureConverted(InvocableMap.EntryProcessor processor) {
        return processor instanceof AsynchronousProcessor && this.isBinaryNamedCache() ? new ConverterAsynchronousProcessor((AsynchronousProcessor)processor) : processor;
    }

    protected boolean isBinaryNamedCache(NamedCache cache) {
        ClassLoader loader = null;
        if (cache instanceof ClassLoaderAware) {
            loader = ((ClassLoaderAware)((Object)cache)).getContextClassLoader();
        }
        return loader == NullImplementation.getClassLoader();
    }

    protected boolean isBinaryNamedCache() {
        ContinuousQueryCache.azzert(this.m_converterFromBinary != null);
        return this.m_converterFromBinary != NullImplementation.getConverter();
    }

    protected Serializer instantiateSerializer() {
        CacheService service = this.getCacheService();
        SerializerFactory factory = service.getDependencies().getSerializerFactory();
        return factory == null ? ExternalizableHelper.ensureSerializer(this.m_loader) : factory.createSerializer(this.m_loader);
    }

    protected NamedCache ensureConverters(NamedCache cache) {
        Converter convDown = this.m_converterFromBinary;
        Converter convUp = this.m_converterToBinary;
        Converter convNull = NullImplementation.getConverter();
        NamedCache cacheLocal = cache;
        if (convDown == null && convUp == null) {
            if (this.isBinaryNamedCache(cacheLocal)) {
                ClassLoader loader = this.m_loader;
                CacheService service = cacheLocal.getCacheService();
                Serializer serializer = loader == null || loader == service.getContextClassLoader() ? service.getSerializer() : this.instantiateSerializer();
                convDown = value -> ExternalizableHelper.toBinary(value, serializer);
                convUp = value -> value instanceof Binary ? ExternalizableHelper.fromBinary((Binary)value, serializer) : value;
            } else {
                convDown = convUp = NullImplementation.getConverter();
            }
            cacheLocal = ConverterCollections.getNamedCache(cacheLocal, convUp, convDown, convNull, convDown);
            this.m_converterFromBinary = convUp;
            this.m_converterToBinary = convDown;
        }
        return cacheLocal;
    }

    protected static String getDefaultName(String sCacheName, Filter filter, ValueExtractor transformer) {
        return String.format("ContinuousQueryCache{Cache=%s, Filter=%s, Transformer=%s}", sCacheName, filter, transformer);
    }

    protected class EventRouter<K, V>
    extends MultiplexingMapListener<K, V> {
        protected MapListener<? super K, ? super V> m_listener;
        protected final boolean f_fLite;

        public EventRouter(MapListener<? super K, ? super V> listener, boolean fLite) {
            this.m_listener = listener;
            this.f_fLite = fLite;
        }

        @Override
        protected void onMapEvent(MapEvent<K, V> evt) {
            MapListener listener = this.m_listener;
            MapListenerSupport.FilterEvent event = evt;
            if (this.f_fLite) {
                event = new MapEvent<K, Object>(ContinuousQueryCache.this, evt.getId(), evt.getKey(), null, null);
                event = evt instanceof MapListenerSupport.FilterEvent ? new MapListenerSupport.FilterEvent(event, ((MapListenerSupport.FilterEvent)evt).getFilter()) : event;
            }
            MapEvent eventRoute = event;
            if (listener instanceof MapListenerSupport.SynchronousListener) {
                try {
                    eventRoute.dispatch(listener);
                }
                catch (RuntimeException e) {
                    EventRouter.err(e);
                }
            } else {
                TaskDaemon eventQueue = ContinuousQueryCache.this.getEventQueue();
                if (eventQueue != null) {
                    Runnable task = () -> eventRoute.dispatch(listener);
                    eventQueue.executeTask(task);
                }
            }
        }

        public int hashCode() {
            return this.m_listener.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EventRouter && this.m_listener.equals(((EventRouter)o).m_listener);
        }

        public String toString() {
            return "EventRouter[" + String.valueOf(this.m_listener) + "]";
        }
    }

    protected class DeactivationListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        protected DeactivationListener() {
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            ContinuousQueryCache.this.changeState(0);
            ContinuousQueryCache.this.dispatchDeactivationEvent(evt.getId());
        }

        @Override
        public void entryUpdated(MapEvent evt) {
            if (!ContinuousQueryCache.this.isEventDeferred(DeactivationListener.class.getName())) {
                ObservableMap local = ContinuousQueryCache.this.m_mapLocal;
                if (local != null) {
                    if (local instanceof ObservableHashMap) {
                        ((ObservableHashMap)local).truncate();
                    } else {
                        local.clear();
                    }
                }
                ContinuousQueryCache.this.dispatchDeactivationEvent(evt.getId());
            }
        }
    }

    public class AddListener
    extends MultiplexingMapListener<K, V_FRONT>
    implements MapListenerSupport.SynchronousListener<K, V_FRONT> {
        @Override
        protected void onMapEvent(MapEvent<K, V_FRONT> evt) {
            ObservableMap map;
            ContinuousQueryCache cqc = ContinuousQueryCache.this;
            Object oKey = evt.getKey();
            if (!cqc.isEventDeferred(oKey) && (map = cqc.m_mapLocal) != null) {
                map.put(oKey, cqc.isCacheValues() ? (Object)evt.getNewValue() : null);
            }
        }

        public String toString() {
            return "AddListener[" + ContinuousQueryCache.this.toString() + "]";
        }
    }

    public class RemoveListener
    extends MultiplexingMapListener<K, V_FRONT>
    implements MapListenerSupport.SynchronousListener<K, V_FRONT> {
        @Override
        protected void onMapEvent(MapEvent<K, V_FRONT> evt) {
            ObservableMap map;
            ContinuousQueryCache cqc = ContinuousQueryCache.this;
            Object oKey = evt.getKey();
            if (!cqc.isEventDeferred(oKey) && (map = cqc.m_mapLocal) != null) {
                map.remove(oKey);
            }
        }

        public String toString() {
            return "RemoveListener[" + ContinuousQueryCache.this.toString() + "]";
        }
    }

    protected class ServiceListener
    implements MemberListener {
        protected ServiceListener() {
        }

        @Override
        public void memberJoined(MemberEvent evt) {
        }

        @Override
        public void memberLeaving(MemberEvent evt) {
        }

        @Override
        public void memberLeft(MemberEvent evt) {
            if (evt.isLocal()) {
                ContinuousQueryCache.this.changeState(0);
            }
        }

        @Override
        public void memberRecovered(MemberEvent evt) {
            ContinuousQueryCache.this.changeState(0);
        }

        public String toString() {
            return "ServiceListener[" + ContinuousQueryCache.this.toString() + "]";
        }
    }

    protected class InternalMapListener
    extends MultiplexingMapListener<K, V_FRONT> {
        protected final Converter f_convKey;
        protected final Converter f_convValue;
        protected final MapListenerSupport f_listenerSupport;

        public InternalMapListener(MapListenerSupport listenerSupport, Converter convKey, Converter convValue) {
            this.f_listenerSupport = listenerSupport;
            this.f_convKey = convKey;
            this.f_convValue = convValue;
        }

        @Override
        protected void onMapEvent(MapEvent<K, V_FRONT> evt) {
            if (evt.getId() == 2 && !(evt.getNewValue() instanceof Binary) && evt.getOldValue() instanceof Binary) {
                return;
            }
            this.f_listenerSupport.fireEvent(ConverterCollections.getMapEvent(ContinuousQueryCache.this, evt, this.f_convKey, this.f_convValue), false);
        }
    }

    protected class ConverterAsynchronousProcessor
    extends AsynchronousProcessor {
        protected final AsynchronousProcessor f_processor;
        protected final Converter f_convUp;

        public ConverterAsynchronousProcessor(AsynchronousProcessor processor) {
            super(processor);
            this.f_processor = processor;
            this.f_convUp = ContinuousQueryCache.this.m_converterFromBinary;
        }

        @Override
        public void onResult(Map.Entry entry) {
            Converter convUp = this.f_convUp;
            Converter convDown = NullImplementation.getConverter();
            this.f_processor.onResult(ConverterCollections.getEntry(entry, convUp, convUp, convDown));
        }

        @Override
        public void onException(Throwable eReason) {
            this.f_processor.onException(eReason);
        }

        @Override
        public void onComplete() {
            this.f_processor.onComplete();
        }

        @Override
        public int getUnitOfOrderId() {
            return this.f_processor.getUnitOfOrderId();
        }

        @Override
        public InvocableMap.EntryProcessor getProcessor() {
            return this.f_processor.getProcessor();
        }

        @Override
        public Object process(InvocableMap.Entry entry) {
            return this.f_processor.process(entry);
        }

        @Override
        public Map processAll(Set setEntries) {
            return this.f_processor.processAll(setEntries);
        }

        @Override
        public void bind(FlowControl control) {
            this.f_processor.bind(control);
        }

        @Override
        public void flush() {
            this.f_processor.flush();
        }

        @Override
        public boolean checkBacklog(Continuation continueNormal) {
            return this.f_processor.checkBacklog(continueNormal);
        }

        @Override
        public long drainBacklog(long cMillis) {
            return this.f_processor.drainBacklog(cMillis);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.f_processor.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.f_processor.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.f_processor.isDone();
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            return this.f_processor.get();
        }

        @Override
        public Object get(long cTimeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.f_processor.get(cTimeout, unit);
        }

        @Override
        public Object getResult() {
            return this.f_processor.getResult();
        }

        @Override
        public Throwable getException() {
            return this.f_processor.getException();
        }

        @Override
        public boolean isCompletedExceptionally() {
            return this.f_processor.isCompletedExceptionally();
        }

        @Override
        public CompletableFuture getCompletableFuture() {
            return this.f_processor.getCompletableFuture();
        }
    }
}

