/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;

public class CacheEvent<K, V>
extends MapEvent<K, V> {
    protected int m_nFlags;
    protected TransformationState m_transformState = TransformationState.TRANSFORMABLE;
    protected static final int SYNTHETIC = 1;
    protected static final int PRIMING = 2;
    protected static final int EXPIRED = 4;

    public CacheEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew, boolean fSynthetic) {
        this(map, nId, oKey, oValueOld, oValueNew, fSynthetic, TransformationState.TRANSFORMABLE);
    }

    public CacheEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew, boolean fSynthetic, boolean fPriming) {
        this(map, nId, oKey, oValueOld, oValueNew, fSynthetic, TransformationState.TRANSFORMABLE, fPriming);
    }

    public CacheEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew, boolean fSynthetic, TransformationState transformState) {
        this(map, nId, oKey, oValueOld, oValueNew, fSynthetic, transformState, false);
    }

    public CacheEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew, boolean fSynthetic, TransformationState transformState, boolean fPriming) {
        super(map, nId, oKey, oValueOld, oValueNew);
        this.m_nFlags |= fSynthetic ? 1 : 0;
        this.m_nFlags |= fPriming ? 2 : 0;
        this.m_transformState = transformState;
    }

    public CacheEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew, boolean fSynthetic, TransformationState transformState, boolean fPriming, boolean fExpired) {
        super(map, nId, oKey, oValueOld, oValueNew);
        this.m_nFlags |= fSynthetic ? 1 : 0;
        this.m_nFlags |= fPriming ? 2 : 0;
        this.m_nFlags |= fExpired ? 4 : 0;
        this.m_transformState = transformState;
    }

    @Override
    public CacheEvent<K, V> with(int nPartition, long lVersion) {
        return (CacheEvent)super.with(nPartition, lVersion);
    }

    @Override
    protected boolean shouldDispatch(MapListener listener) {
        return super.shouldDispatch(listener) && (!this.isPriming() || MapListenerSupport.isPrimingListener(listener) && !this.isVersionUpdate() || listener.isVersionAware());
    }

    public boolean isSynthetic() {
        return (this.m_nFlags & 1) != 0;
    }

    public boolean isExpired() {
        return (this.m_nFlags & 4) != 0;
    }

    public boolean isPriming() {
        return (this.m_nFlags & 2) != 0;
    }

    public boolean isVersionUpdate() {
        return this.isSynthetic() && this.isPriming() && this.isUpdate() && this.m_key == null && this.m_valueNew == null && this.m_valueOld == null;
    }

    public TransformationState getTransformationState() {
        return this.m_transformState;
    }

    @Override
    protected String getDescription() {
        String sDescr = super.getDescription();
        return (String)(this.isSynthetic() ? sDescr + ", synthetic" : sDescr) + (this.isPriming() ? ", priming" : "") + (this.isExpired() ? ", expired" : "");
    }

    public static enum TransformationState {
        NON_TRANSFORMABLE,
        TRANSFORMABLE,
        TRANSFORMED;

    }
}

