/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.BinaryStore;
import com.tangosol.net.cache.AbstractCacheStore;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.IterableCacheLoader;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import java.util.Iterator;

public class BinaryStoreCacheStore<K, V>
extends AbstractCacheStore<K, V>
implements CacheStore<K, V>,
IterableCacheLoader<K, V> {
    private BinaryStore m_store;
    private ClassLoader m_loader;
    private boolean m_fBinaryOnly;

    public BinaryStoreCacheStore(BinaryStore store) {
        this.setBinaryStore(store);
    }

    public BinaryStoreCacheStore(BinaryStore store, ClassLoader loader) {
        this.setClassLoader(loader);
        this.setBinaryStore(store);
    }

    public BinaryStoreCacheStore(BinaryStore store, boolean fBinaryOnly) {
        this.m_fBinaryOnly = fBinaryOnly;
        this.setBinaryStore(store);
    }

    @Override
    public V load(K key) {
        Binary bin = this.getBinaryStore().load(this.toBinary(key));
        return (V)(bin == null ? null : this.fromBinary(bin));
    }

    @Override
    public void store(K key, V value) {
        this.getBinaryStore().store(this.toBinary(key), this.toBinary(value));
    }

    @Override
    public void erase(K key) {
        this.getBinaryStore().erase(this.toBinary(key));
    }

    @Override
    public Iterator<K> keys() {
        Iterator<Binary> iter = this.getBinaryStore().keys();
        Converter conv = bin -> this.fromBinary((Binary)bin);
        return new ConverterCollections.ConverterEnumerator(iter, conv);
    }

    protected Binary toBinary(Object o) {
        return this.isBinaryOnly() ? (Binary)o : ExternalizableHelper.toBinary(o);
    }

    protected Object fromBinary(Binary bin) {
        return this.isBinaryOnly() ? bin : ExternalizableHelper.fromBinary(bin, this.getClassLoader());
    }

    public BinaryStore getBinaryStore() {
        return this.m_store;
    }

    protected void setBinaryStore(BinaryStore store) {
        this.m_store = store;
    }

    public ClassLoader getClassLoader() {
        return this.m_loader;
    }

    protected void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public boolean isBinaryOnly() {
        return this.m_fBinaryOnly;
    }
}

