/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;

public abstract class AbstractEvictionPolicy
extends Base
implements ConfigurableCacheMap.EvictionPolicy,
MapListener {
    private ConfigurableCacheMap m_cache;

    @Override
    public String getName() {
        return ClassHelper.getSimpleName(this.getClass());
    }

    public void entryInserted(MapEvent evt) {
        this.entryUpdated(this.getEntry(evt));
    }

    public void entryUpdated(MapEvent evt) {
        this.entryUpdated(this.getEntry(evt));
    }

    public void entryDeleted(MapEvent evt) {
        this.ensureCache(evt);
    }

    public abstract void entryUpdated(ConfigurableCacheMap.Entry var1);

    protected ConfigurableCacheMap ensureCache(MapEvent evt) {
        ConfigurableCacheMap cache = this.m_cache;
        if (cache == null) {
            try {
                cache = this.m_cache = (ConfigurableCacheMap)evt.getMap();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Illegal map type: " + evt.getMap().getClass().getName());
            }
        }
        return cache;
    }

    protected ConfigurableCacheMap.Entry getEntry(MapEvent evt) {
        ConfigurableCacheMap cache = this.ensureCache(evt);
        if (cache instanceof LocalCache) {
            LocalCache lc = (LocalCache)cache;
            return (ConfigurableCacheMap.Entry)((Object)lc.getEntryInternal(evt.getKey()));
        }
        try {
            return cache.getCacheEntry(evt.getKey());
        }
        catch (StackOverflowError e) {
            throw new StackOverflowError(cache.getClass().getName() + "#getCacheEntry() implementation causes an infinite recursion when used with " + this.getClass().getName() + "#getEntry() implementation (inherited from " + AbstractEvictionPolicy.class.getName() + ")");
        }
    }

    protected ConfigurableCacheMap getCache() {
        return this.m_cache;
    }
}

