/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractBundler
extends Base {
    public static int ADJUSTMENT_FREQUENCY = 128;
    private double m_dSizeThreshold;
    protected double m_dPreviousSizeThreshold;
    private int m_cThreadThreshold;
    private boolean m_fAllowAuto = true;
    private long m_lDelayMillis = 1L;
    protected List m_listBundle = new ArrayList();
    private volatile int m_iActiveBundle;
    protected AtomicInteger m_countThreads = new AtomicInteger();
    private Statistics m_stats = new Statistics();

    public AbstractBundler() {
        Bundle bundle = this.instantiateBundle();
        bundle.setMaster();
        this.m_listBundle.add(bundle);
    }

    public int getSizeThreshold() {
        return (int)this.m_dSizeThreshold;
    }

    public void setSizeThreshold(int cSize) {
        if (cSize <= 0) {
            throw new IllegalArgumentException("Negative bundle size threshold");
        }
        this.m_dSizeThreshold = cSize;
        this.m_dPreviousSizeThreshold = 0.0;
    }

    public int getThreadThreshold() {
        return this.m_cThreadThreshold;
    }

    public void setThreadThreshold(int cThreads) {
        if (cThreads <= 0) {
            throw new IllegalArgumentException("Invalid thread threshold");
        }
        this.m_cThreadThreshold = cThreads;
    }

    public long getDelayMillis() {
        return this.m_lDelayMillis;
    }

    public void setDelayMillis(long lDelay) {
        if (lDelay <= 0L) {
            throw new IllegalArgumentException("Invalid delay value");
        }
        this.m_lDelayMillis = lDelay;
    }

    public boolean isAllowAutoAdjust() {
        return this.m_fAllowAuto;
    }

    public void setAllowAutoAdjust(boolean fAutoAdjust) {
        this.m_fAllowAuto = fAutoAdjust;
    }

    protected void updateStatistics() {
        List listBundle = this.m_listBundle;
        Statistics stats = this.m_stats;
        while (true) {
            try {
                long cTotalBundles = 0L;
                long cTotalSize = 0L;
                long cTotalBurst = 0L;
                long cTotalWait = 0L;
                int c = listBundle.size();
                for (int i = 0; i < c; ++i) {
                    Bundle bundle = (Bundle)listBundle.get(i);
                    cTotalBundles += bundle.m_cTotalBundles;
                    cTotalSize += bundle.m_cTotalSize;
                    cTotalBurst += bundle.m_cTotalBurstDuration;
                    cTotalWait += bundle.m_cTotalWaitDuration;
                }
                long cDeltaBundles = cTotalBundles - stats.m_cBundleCountSnapshot;
                long cDeltaSize = cTotalSize - stats.m_cBundleSizeSnapshot;
                long cDeltaBurst = cTotalBurst - stats.m_cBurstDurationSnapshot;
                long cDeltaWait = cTotalWait - stats.m_cThreadWaitSnapshot;
                if (cDeltaBundles > 0L && cDeltaWait > 0L) {
                    stats.m_cAverageBundleSize = (int)Math.round((double)cDeltaSize / (double)cDeltaBundles);
                    stats.m_cAverageBurstDuration = (int)Math.round((double)cDeltaBurst / (double)cDeltaBundles);
                    stats.m_cAverageThreadWaitDuration = (int)Math.round((double)cDeltaWait / (double)cDeltaBundles);
                    stats.m_nAverageThroughput = (int)Math.round((double)cDeltaSize * 1000.0 / (double)cDeltaWait);
                }
                stats.m_cBundleCountSnapshot = cTotalBundles;
                stats.m_cBundleSizeSnapshot = cTotalSize;
                stats.m_cBurstDurationSnapshot = cTotalBurst;
                stats.m_cThreadWaitSnapshot = cTotalWait;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            break;
        }
    }

    public void resetStatistics() {
        List listBundle = this.m_listBundle;
        while (true) {
            try {
                int c = listBundle.size();
                for (int i = 0; i < c; ++i) {
                    Bundle bundle = (Bundle)listBundle.get(i);
                    bundle.resetStatistics();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            break;
        }
        this.m_stats.reset();
        this.m_dPreviousSizeThreshold = 0.0;
    }

    public void adjust() {
        Statistics stats = this.m_stats;
        double dSizePrev = this.m_dPreviousSizeThreshold;
        double dSizeCurr = this.m_dSizeThreshold;
        int nThruPrev = stats.m_nAverageThroughput;
        this.updateStatistics();
        int nThruCurr = stats.m_nAverageThroughput;
        if (this.isAllowAutoAdjust()) {
            double dSizeNew;
            double dDelta = 0.0;
            if (dSizePrev == 0.0) {
                dDelta = Math.max(1.0, 0.1 * dSizeCurr);
            } else if (Math.abs(nThruCurr - nThruPrev) <= Math.max(1, (nThruCurr + nThruPrev) / 100)) {
                int nRandom = AbstractBundler.getRandom().nextInt(100);
                if (nRandom < 10 || Math.abs(dSizePrev - dSizeCurr) < 0.001) {
                    dDelta = Math.max(1.0, 0.05 * dSizeCurr);
                    if (nRandom < 5) {
                        dDelta = -dDelta;
                    }
                }
            } else {
                dDelta = nThruCurr > nThruPrev ? dSizeCurr - dSizePrev : (dSizePrev - dSizeCurr) / 2.0;
            }
            if (dDelta != 0.0 && (dSizeNew = dSizeCurr + dDelta) > 1.0) {
                this.m_dPreviousSizeThreshold = dSizeCurr;
                this.m_dSizeThreshold = dSizeNew;
            }
        }
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{SizeThreshold=" + this.getSizeThreshold() + ", ThreadThreshold=" + this.getThreadThreshold() + ", DelayMillis=" + this.getDelayMillis() + ", AutoAdjust=" + (this.isAllowAutoAdjust() ? "on" : "off") + ", ActiveBundles=" + this.m_listBundle.size() + ", Statistics=" + String.valueOf(this.m_stats) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle getOpenBundle() {
        List listBundle = this.m_listBundle;
        int cBundles = listBundle.size();
        int iActiveBundle = this.m_iActiveBundle;
        try {
            for (int i = 0; i < cBundles; ++i) {
                int iBundle = (iActiveBundle + i) % cBundles;
                Bundle bundle = (Bundle)listBundle.get(iBundle);
                if (!bundle.isOpen()) continue;
                this.m_iActiveBundle = iBundle;
                return bundle;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        List list = listBundle;
        synchronized (list) {
            cBundles = listBundle.size();
            for (int i = 0; i < cBundles; ++i) {
                int iBundle = (iActiveBundle + i) % cBundles;
                Bundle bundle = (Bundle)listBundle.get(iBundle);
                if (!bundle.isOpen()) continue;
                this.m_iActiveBundle = iBundle;
                return bundle;
            }
            Bundle bundle = this.instantiateBundle();
            listBundle.add(bundle);
            this.m_iActiveBundle = cBundles;
            return bundle;
        }
    }

    protected abstract Bundle instantiateBundle();

    protected static class Statistics {
        protected int m_cAverageBurstDuration;
        protected int m_cAverageBundleSize;
        protected int m_cAverageThreadWaitDuration;
        protected int m_nAverageThroughput;
        protected long m_cBundleCountSnapshot;
        protected long m_cBundleSizeSnapshot;
        protected long m_cBurstDurationSnapshot;
        protected long m_cThreadWaitSnapshot;

        protected Statistics() {
        }

        protected void reset() {
            this.m_cBundleCountSnapshot = 0L;
            this.m_cBundleSizeSnapshot = 0L;
            this.m_cBurstDurationSnapshot = 0L;
            this.m_cThreadWaitSnapshot = 0L;
        }

        public String toString() {
            return "(AverageBundleSize=" + this.m_cAverageBundleSize + ", AverageBurstDuration=" + this.m_cAverageBurstDuration + "ms, AverageWaitDuration=" + this.m_cAverageThreadWaitDuration + "ms, AverageThroughput=" + this.m_nAverageThroughput + "/sec)";
        }
    }

    protected abstract class Bundle
    extends Base {
        public static final int STATUS_OPEN = 0;
        public static final int STATUS_PENDING = 1;
        public static final int STATUS_PROCESSED = 2;
        public static final int STATUS_EXCEPTION = 3;
        private volatile int m_iStatus = 0;
        private int m_cThreads;
        private boolean m_fMaster;
        volatile long m_cTotalBundles;
        volatile long m_cTotalSize;
        private long m_ldtStart;
        volatile long m_cTotalBurstDuration;
        volatile long m_cTotalWaitDuration;

        protected Bundle() {
        }

        protected boolean isOpen() {
            return this.m_iStatus == 0;
        }

        protected boolean isPending() {
            return this.m_iStatus == 1;
        }

        protected boolean isProcessed() {
            return this.m_iStatus == 2 || this.m_iStatus == 3;
        }

        protected boolean isException() {
            return this.m_iStatus == 3;
        }

        protected synchronized void setStatus(int iStatus) {
            if (!(switch (this.m_iStatus) {
                case 0 -> iStatus == 1 || iStatus == 3;
                case 1 -> iStatus == 2 || iStatus == 3;
                case 2, 3 -> iStatus == 0;
                default -> false;
            })) {
                throw new IllegalStateException(String.valueOf(this) + "; invalid transition to " + this.formatStatusName(iStatus));
            }
            this.m_iStatus = iStatus;
            if (iStatus == 2 || iStatus == 3) {
                this.m_cTotalWaitDuration += Math.max(0L, System.currentTimeMillis() - this.m_ldtStart);
                this.notifyAll();
            }
        }

        protected int getBundleSize() {
            return this.m_cThreads;
        }

        protected boolean isMaster() {
            return this.m_fMaster;
        }

        protected void setMaster() {
            this.m_fMaster = true;
        }

        protected abstract void ensureResults();

        protected boolean waitForResults(boolean fFirst) {
            ++this.m_cThreads;
            try {
                if (fFirst) {
                    this.m_ldtStart = System.currentTimeMillis();
                }
                if (this.getBundleSize() < AbstractBundler.this.getSizeThreshold()) {
                    if (fFirst) {
                        long lDelay = AbstractBundler.this.getDelayMillis();
                        do {
                            Blocking.wait(this, lDelay);
                            lDelay = 0L;
                        } while (this.isPending());
                    } else {
                        do {
                            Blocking.wait(this);
                        } while (!this.isProcessed());
                        return false;
                    }
                }
                if (this.isProcessed()) {
                    return false;
                }
                this.setStatus(1);
                this.m_cTotalSize += (long)this.getBundleSize();
                long cTotal = ++this.m_cTotalBundles;
                if (cTotal > 1000L && cTotal % (long)ADJUSTMENT_FREQUENCY == 0L && this.isMaster()) {
                    AbstractBundler.this.adjust();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.setStatus(3);
            }
            catch (RuntimeException e) {
                --this.m_cThreads;
                throw e;
            }
            catch (Error e) {
                --this.m_cThreads;
                throw e;
            }
            return true;
        }

        protected boolean ensureResults(boolean fBurst) {
            if (this.isException()) {
                return false;
            }
            if (fBurst) {
                try {
                    long ldtStart = System.currentTimeMillis();
                    this.ensureResults();
                    long cElapsedMillis = System.currentTimeMillis() - ldtStart;
                    if (cElapsedMillis > 0L) {
                        this.m_cTotalBurstDuration += cElapsedMillis;
                    }
                    this.setStatus(2);
                }
                catch (Throwable e) {
                    this.setStatus(3);
                    return false;
                }
            } else {
                Bundle.azzert(this.isProcessed());
            }
            return true;
        }

        protected synchronized boolean releaseThread() {
            Bundle.azzert(this.isProcessed() && this.m_cThreads > 0);
            if (--this.m_cThreads == 0) {
                this.setStatus(0);
                return true;
            }
            return false;
        }

        public void resetStatistics() {
            this.m_cTotalBundles = 0L;
            this.m_cTotalSize = 0L;
            this.m_cTotalBurstDuration = 0L;
            this.m_cTotalWaitDuration = 0L;
        }

        public String toString() {
            return "Bundle@" + this.hashCode() + "{" + this.formatStatusName(this.m_iStatus) + ", size=" + this.getBundleSize() + "}";
        }

        protected String formatStatusName(int iStatus) {
            switch (iStatus) {
                case 0: {
                    return "STATUS_OPEN";
                }
                case 1: {
                    return "STATUS_PENDING";
                }
                case 2: {
                    return "STATUS_PROCESSED";
                }
                case 3: {
                    return "STATUS_EXCEPTION";
                }
            }
            return "unknown";
        }
    }
}

