/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.base.Timeout;
import com.oracle.coherence.common.net.SSLSettings;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.MemberIdentityProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public class URLMemberIdentityProvider
implements MemberIdentityProvider {
    public static final String PROP_MACHINE = "coherence.machine.url";
    public static final String PROP_MEMBER = "coherence.member.url";
    public static final String PROP_SITE = "coherence.site.url";
    public static final String PROP_RACK = "coherence.rack.url";
    public static final String PROP_ROLE = "coherence.role.url";
    public static final String PROP_SOCKET_PROVIDER = "coherence.url.identity.socket.provider";
    public static final String PROP_RETRY_PERIOD = "coherence.url.identity.retry.period";
    public static final Duration DURATION_RETRY_PERIOD = new Duration(1, Duration.Magnitude.SECOND);
    public static final String PROP_RETRY_TIMEOUT = "coherence.url.identity.retry.timeout";
    public static final Duration DURATION_RETRY_TIMEOUT = new Duration(5, Duration.Magnitude.MINUTE);
    public static final String PROP_HTTP_TIMEOUT = "coherence.url.identity.http.timeout";
    public static final Duration DURATION_HTTP_TIMEOUT = new Duration(1, Duration.Magnitude.MINUTE);
    protected ClusterDependencies m_dependencies;
    protected volatile HttpClient m_client;

    @Override
    public String getMachineName() {
        return this.load("machine", PROP_MACHINE);
    }

    @Override
    public String getMemberName() {
        return this.load("member", PROP_MEMBER);
    }

    @Override
    public String getRackName() {
        return this.load("rack", PROP_RACK);
    }

    @Override
    public String getRoleName() {
        return this.load("role", PROP_ROLE);
    }

    @Override
    public String getSiteName() {
        return this.load("site", PROP_SITE);
    }

    @Override
    public void setDependencies(ClusterDependencies deps) {
        this.m_dependencies = deps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String load(String sName, String sProperty) {
        String sValue = Config.getProperty(sProperty);
        if (sValue == null) return null;
        if (sValue.isBlank()) return null;
        try {
            URL url;
            block12: {
                URI uri = URI.create(sValue);
                String sScheme = uri.getScheme();
                if ("http".equalsIgnoreCase(sScheme)) return this.doHttpRequest(uri);
                if ("https".equalsIgnoreCase(sScheme)) {
                    return this.doHttpRequest(uri);
                }
                try {
                    url = uri.toURL();
                }
                catch (Exception e) {
                    url = Resources.findFileOrResource(sValue, null);
                    if (url != null) break block12;
                    Logger.err("Failed to load " + sName + " name from URL " + sValue);
                    return null;
                }
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                String sLine = reader.readLine();
                if (sLine == null || sLine.isBlank()) {
                    String string = null;
                    return string;
                }
                String string = sLine.trim();
                return string;
            }
        }
        catch (Throwable t) {
            Logger.err("Failed to load " + sName + " name from URL " + sValue, t);
        }
        return null;
    }

    protected String doHttpRequest(URI uri) throws IOException {
        String string;
        block10: {
            Duration timeout = Config.getDuration(PROP_RETRY_TIMEOUT, DURATION_RETRY_TIMEOUT);
            Duration period = Config.getDuration(PROP_RETRY_PERIOD, DURATION_RETRY_PERIOD);
            long cMillis = period.as(Duration.Magnitude.MILLI);
            HttpRequest request = HttpRequest.newBuilder(uri).GET().build();
            HttpResponse.BodyHandler<String> handler = HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8);
            HttpClient client = this.ensureClient();
            Timeout ignored = Timeout.after(timeout.as(Duration.Magnitude.MILLI), TimeUnit.MILLISECONDS);
            try {
                HttpResponse<String> response = client.send(request, handler);
                int nStatus = response.statusCode();
                if (nStatus != 200) {
                    Logger.info("Received " + nStatus + " response from " + String.valueOf(uri) + " - retry every " + String.valueOf(period) + " for " + String.valueOf(timeout));
                    while (nStatus != 200) {
                        Blocking.sleep(cMillis);
                        response = client.send(request, handler);
                        nStatus = response.statusCode();
                    }
                }
                string = response.body();
                if (ignored == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw Exceptions.ensureRuntimeException(e, "timeout while making request to " + String.valueOf(uri));
                }
            }
            ignored.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpClient ensureClient() {
        if (this.m_client == null) {
            URLMemberIdentityProvider uRLMemberIdentityProvider = this;
            synchronized (uRLMemberIdentityProvider) {
                if (this.m_client == null) {
                    String sProvider;
                    HttpClient.Builder builder = HttpClient.newBuilder();
                    if (this.m_dependencies != null && (sProvider = Config.getProperty(PROP_SOCKET_PROVIDER)) != null) {
                        SSLContext sslContext;
                        SocketProvider provider;
                        SocketProviderFactory factory = this.m_dependencies.getSocketProviderFactory();
                        SSLSettings sslSettings = factory.getSSLSettings(provider = factory.getSocketProvider(sProvider));
                        SSLContext sSLContext = sslContext = sslSettings == null ? null : sslSettings.getSSLContext();
                        if (sslContext != null) {
                            builder.sslContext(sslContext);
                            builder.sslParameters(sslContext.getSupportedSSLParameters());
                        }
                    }
                    Duration timeout = Config.getDuration(PROP_HTTP_TIMEOUT, DURATION_HTTP_TIMEOUT);
                    this.m_client = builder.followRedirects(HttpClient.Redirect.ALWAYS).connectTimeout(timeout.asJavaDuration()).build();
                }
            }
        }
        return this.m_client;
    }
}

