/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.net.DatagramSocketProvider;
import com.tangosol.net.NonBlockingTcpDatagramSocket;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.TcpDatagramSocket;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;

public class TcpDatagramSocketProvider
implements DatagramSocketProvider {
    public static final TcpDatagramSocketProvider INSTANCE = new TcpDatagramSocketProvider();
    protected Dependencies m_dependencies;

    public TcpDatagramSocketProvider() {
        this(null);
    }

    public TcpDatagramSocketProvider(Dependencies deps) {
        this.m_dependencies = new DefaultDependencies(deps).validate();
    }

    @Override
    public DatagramSocket openDatagramSocket() throws IOException {
        return this.configure(this.m_dependencies.isBlocking() ? new TcpDatagramSocket(this.m_dependencies.getDelegateSocketProvider()) : new NonBlockingTcpDatagramSocket(this.m_dependencies.getDelegateSocketProvider()));
    }

    @Override
    public MulticastSocket openMulticastSocket() throws IOException {
        return new MulticastSocket(null);
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    public String toString() {
        return "TCPDatagramSocketProvider[Delegate: " + String.valueOf(this.m_dependencies.getDelegateSocketProvider()) + "]";
    }

    protected TcpDatagramSocket configure(TcpDatagramSocket socket) {
        int nAdvanceFrequency = this.m_dependencies.getAdvanceFrequency();
        if (nAdvanceFrequency > 0) {
            socket.setAdvanceFrequency(nAdvanceFrequency);
        }
        return socket;
    }

    public static interface Dependencies {
        public SocketProvider getDelegateSocketProvider();

        public boolean isBlocking();

        public int getAdvanceFrequency();
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected SocketProvider m_delegateSocketProvider = SocketProviderFactory.DEFAULT_SOCKET_PROVIDER;
        protected boolean m_fBlocking = false;
        protected int m_nAdvanceFrequency;

        public DefaultDependencies() {
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.m_delegateSocketProvider = deps.getDelegateSocketProvider();
                this.m_fBlocking = deps.isBlocking();
                this.m_nAdvanceFrequency = deps.getAdvanceFrequency();
            }
        }

        @Override
        public SocketProvider getDelegateSocketProvider() {
            return this.m_delegateSocketProvider;
        }

        public DefaultDependencies setDelegateSocketProvider(SocketProvider provider) {
            this.m_delegateSocketProvider = provider;
            return this;
        }

        @Override
        public boolean isBlocking() {
            return this.m_fBlocking;
        }

        @Injectable(value="blocking")
        public void setBlocking(boolean fBlocking) {
            this.m_fBlocking = fBlocking;
        }

        @Override
        public int getAdvanceFrequency() {
            return this.m_nAdvanceFrequency;
        }

        @Injectable(value="advance-frequency")
        public void setAdvanceFrequency(int frequency) {
            this.m_nAdvanceFrequency = frequency;
        }

        protected DefaultDependencies validate() throws IllegalArgumentException {
            DefaultDependencies.ensureArgument(this.getDelegateSocketProvider(), "DelegateSocketProvider");
            return this;
        }

        protected static void ensureArgument(Object o, String sName) {
            if (o == null) {
                throw new IllegalArgumentException(sName + " cannot be null");
            }
        }
    }
}

