/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.util.Options;
import com.tangosol.internal.net.DefaultSessionProvider;
import com.tangosol.net.Coherence;
import com.tangosol.net.Session;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.options.WithClassLoader;
import com.tangosol.net.options.WithConfiguration;
import com.tangosol.net.options.WithName;
import com.tangosol.net.options.WithScopeName;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public interface SessionProvider
extends Comparable<SessionProvider> {
    public static final int PRIORITY = 0;

    default public Optional<Session> createSession(SessionConfiguration configuration, Coherence.Mode mode) {
        return this.createSession(configuration, mode, Collections.emptyList());
    }

    default public Optional<Session> createSession(SessionConfiguration configuration, Coherence.Mode defaultMode, Iterable<? extends EventInterceptor<?>> interceptors) {
        return this.createSession(configuration, defaultMode, null, interceptors);
    }

    default public Optional<Session> createSession(SessionConfiguration configuration, Coherence.Mode defaultMode, String sScopePrefix, Iterable<? extends EventInterceptor<?>> interceptors) {
        Coherence.Mode mode = configuration.getMode().orElse(defaultMode);
        DefaultContext context = new DefaultContext(mode, DefaultSessionProvider.getBaseProvider(), interceptors, sScopePrefix);
        Context result = this.createSession(configuration, context);
        return result == null ? Optional.empty() : Optional.ofNullable(result.getSession());
    }

    public Context createSession(SessionConfiguration var1, Context var2);

    @Deprecated
    default public Session createSession(Session.Option ... options) {
        Options<Session.Option> opts = Options.from(Session.Option.class, options);
        SessionConfiguration.Builder builder = SessionConfiguration.builder();
        opts.ifPresent(WithName.class, option -> builder.named(option.getName()));
        opts.ifPresent(WithConfiguration.class, option -> builder.withConfigUri(option.getLocation()));
        opts.ifPresent(WithClassLoader.class, option -> builder.withClassLoader(option.getClassLoader()));
        opts.ifPresent(WithScopeName.class, option -> builder.withScopeName(option.getScopeName()));
        return this.createSession(builder.build(), Coherence.Mode.ClusterMember, Collections.emptyList()).orElseThrow(() -> new IllegalArgumentException("Cannot create a session from the specified options"));
    }

    default public int getPriority() {
        return 0;
    }

    default public void close() {
    }

    @Override
    default public int compareTo(SessionProvider other) {
        return Integer.compare(this.getPriority(), other.getPriority());
    }

    default public void releaseSession(Session session) {
    }

    @Deprecated
    public static SessionProvider get(Option ... options) {
        return SessionProvider.get();
    }

    public static SessionProvider get() {
        return DefaultSessionProvider.INSTANCE;
    }

    public static class DefaultContext
    implements Context {
        private final Coherence.Mode f_mode;
        private final SessionProvider f_sessionProvider;
        private final Iterable<? extends EventInterceptor<?>> f_interceptors;
        private boolean m_fComplete;
        private Session m_session;
        private final String f_sScopePrefix;

        public DefaultContext(Coherence.Mode mode, SessionProvider provider, Iterable<? extends EventInterceptor<?>> interceptors, String sScopePrefix) {
            this.f_mode = Objects.requireNonNull(mode);
            this.f_sessionProvider = Objects.requireNonNull(provider);
            this.f_interceptors = interceptors;
            this.f_sScopePrefix = sScopePrefix == null ? "" : sScopePrefix.trim();
        }

        @Override
        public Coherence.Mode getMode() {
            return this.f_mode;
        }

        @Override
        public Context complete(Session session) {
            this.m_session = session;
            this.m_fComplete = true;
            return this;
        }

        @Override
        public Context complete() {
            this.m_fComplete = true;
            return this;
        }

        @Override
        public boolean isComplete() {
            return this.m_fComplete;
        }

        @Override
        public boolean hasSession() {
            return this.m_session != null;
        }

        @Override
        public Session getSession() {
            return this.m_session;
        }

        @Override
        public SessionProvider defaultProvider() {
            return this.f_sessionProvider;
        }

        @Override
        public Iterable<? extends EventInterceptor<?>> getInterceptors() {
            return this.f_interceptors;
        }

        @Override
        public String getScopePrefix() {
            return this.f_sScopePrefix == null ? Context.super.getScopePrefix() : this.f_sScopePrefix;
        }
    }

    public static interface Context {
        public Coherence.Mode getMode();

        public Context complete(Session var1);

        public Context complete();

        public boolean isComplete();

        public boolean hasSession();

        public Session getSession();

        public SessionProvider defaultProvider();

        public Iterable<? extends EventInterceptor<?>> getInterceptors();

        default public Context createSession(SessionConfiguration configuration) {
            return this.defaultProvider().createSession(configuration, this);
        }

        default public String getScopePrefix() {
            return "";
        }
    }

    public static interface Provider {
        public Optional<SessionProvider> getSessionProvider();
    }

    @Deprecated
    public static class Providers
    extends DefaultSessionProvider {
    }

    @Deprecated
    public static interface Option {
    }
}

