/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.config.expression.ChainedParameterResolver;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.Coherence;
import com.tangosol.net.SessionProvider;
import com.tangosol.net.events.EventInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface SessionConfiguration
extends Comparable<SessionConfiguration> {
    public static final int DEFAULT_PRIORITY = 0;

    public String getName();

    public String getScopeName();

    default public Iterable<EventInterceptor<?>> getInterceptors() {
        return Collections.emptyList();
    }

    default public boolean isEnabled() {
        return true;
    }

    default public Optional<String> getConfigUri() {
        return Optional.empty();
    }

    default public Optional<ClassLoader> getClassLoader() {
        return Optional.empty();
    }

    default public int getPriority() {
        return 0;
    }

    @Override
    default public int compareTo(SessionConfiguration other) {
        return Integer.compare(this.getPriority(), other.getPriority());
    }

    default public Optional<ParameterResolver> getParameterResolver() {
        return Optional.empty();
    }

    default public Optional<Coherence.Mode> getMode() {
        return Optional.empty();
    }

    default public Optional<SessionProvider> sessionProvider() {
        return Optional.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SessionConfiguration defaultSession() {
        return SessionConfiguration.create("", "$Default$");
    }

    public static SessionConfiguration create(String sConfigURI) {
        return SessionConfiguration.create("", sConfigURI);
    }

    public static SessionConfiguration create(String sName, String sConfigURI) {
        return SessionConfiguration.builder().named(sName).withConfigUri(sConfigURI).build();
    }

    public static SessionConfiguration create(String sName, String sConfigURI, String sScopeName) {
        return SessionConfiguration.builder().named(sName).withScopeName(sScopeName).withConfigUri(sConfigURI).build();
    }

    public static class Builder {
        private String m_sName;
        private String m_sURI;
        private ClassLoader m_loader;
        private String m_sScope;
        private final List<EventInterceptor<?>> f_listInterceptor = new ArrayList();
        private int m_nPriority;
        private ParameterResolver m_parameterResolver;
        private final ResolvableParameterList m_parameterList = new ResolvableParameterList();
        private Coherence.Mode m_mode;
        private SessionProvider m_sessionProvider;

        private Builder() {
        }

        public Builder named(String sName) {
            this.m_sName = sName;
            return this;
        }

        public Builder withConfigUri(String sURI) {
            this.m_sURI = sURI;
            return this;
        }

        public Builder withClassLoader(ClassLoader loader) {
            this.m_loader = loader;
            return this;
        }

        public Builder withScopeName(String sScope) {
            this.m_sScope = sScope;
            return this;
        }

        public Builder withInterceptor(EventInterceptor<?> interceptor) {
            if (interceptor != null) {
                this.f_listInterceptor.add(interceptor);
            }
            return this;
        }

        public Builder withPriority(int nPriority) {
            this.m_nPriority = nPriority;
            return this;
        }

        public Builder withParameterResolver(ParameterResolver resolver) {
            this.m_parameterResolver = resolver;
            return this;
        }

        public Builder withParameter(String sName, Object oValue) {
            return this.withParameter(new Parameter(sName, oValue));
        }

        public Builder withParameter(String sName, Expression<?> expression) {
            return this.withParameter(new Parameter(sName, expression));
        }

        public Builder withParameter(Parameter parameter) {
            this.m_parameterList.add(parameter);
            return this;
        }

        public Builder clientRemote() {
            return this.withMode(Coherence.Mode.Client);
        }

        public Builder clientFixed() {
            return this.withMode(Coherence.Mode.ClientFixed);
        }

        public Builder clientDirect() {
            return this.withMode(Coherence.Mode.ClusterMember);
        }

        public Builder withMode(Coherence.Mode mode) {
            this.m_mode = mode;
            return this;
        }

        public Builder withSessionProvider(SessionProvider provider) {
            this.m_sessionProvider = provider;
            return this;
        }

        public SessionConfiguration build() {
            return new ConfigurableCacheFactorySessionConfig(this);
        }
    }

    public static class ConfigurableCacheFactorySessionConfig
    implements SessionConfiguration {
        private final String f_sName;
        private final String f_sURI;
        private final ClassLoader f_loader;
        private final String f_sScope;
        private final List<EventInterceptor<?>> f_listInterceptor;
        private final int f_nPriority;
        private final ParameterResolver f_parameterResolver;
        private final Coherence.Mode f_mode;
        private final SessionProvider f_sessionProvider;

        ConfigurableCacheFactorySessionConfig(Builder builder) {
            ParameterResolver resolver;
            this.f_sName = builder.m_sName == null || builder.m_sName.trim().isEmpty() ? "" : builder.m_sName;
            this.f_sURI = builder.m_sURI;
            this.f_loader = builder.m_loader;
            this.f_listInterceptor = new ArrayList(builder.f_listInterceptor);
            this.f_nPriority = builder.m_nPriority;
            this.f_sScope = builder.m_sScope == null ? "" : builder.m_sScope;
            this.f_mode = builder.m_mode;
            this.f_sessionProvider = builder.m_sessionProvider;
            if (!builder.m_parameterList.isEmpty()) {
                ResolvableParameterList list = new ResolvableParameterList();
                for (Parameter parameter : builder.m_parameterList) {
                    list.add(parameter);
                }
                resolver = builder.m_parameterResolver == null ? list : new ChainedParameterResolver(list, builder.m_parameterResolver);
            } else {
                resolver = builder.m_parameterResolver;
            }
            this.f_parameterResolver = resolver;
        }

        @Override
        public String getName() {
            return this.f_sName;
        }

        @Override
        public String getScopeName() {
            return this.f_sScope;
        }

        @Override
        public Iterable<EventInterceptor<?>> getInterceptors() {
            return Collections.unmodifiableList(this.f_listInterceptor);
        }

        @Override
        public int getPriority() {
            return this.f_nPriority;
        }

        @Override
        public Optional<ParameterResolver> getParameterResolver() {
            return Optional.ofNullable(this.f_parameterResolver);
        }

        @Override
        public Optional<String> getConfigUri() {
            return Optional.ofNullable(this.f_sURI);
        }

        @Override
        public Optional<ClassLoader> getClassLoader() {
            return Optional.ofNullable(this.f_loader);
        }

        @Override
        public Optional<Coherence.Mode> getMode() {
            String sClient;
            Parameter parameter;
            Coherence.Mode mode = this.f_mode;
            if (mode == null && this.f_parameterResolver != null && (parameter = this.f_parameterResolver.resolve("coherence.client")) != null && (sClient = (String)parameter.evaluate(this.f_parameterResolver).get()) != null) {
                mode = Coherence.Mode.fromClientName(sClient);
            }
            return Optional.ofNullable(mode);
        }

        @Override
        public Optional<SessionProvider> sessionProvider() {
            return Optional.ofNullable(this.f_sessionProvider);
        }

        public String toString() {
            return "ConfigurableCacheFactorySessionConfig(name='" + this.f_sName + "', uri='" + this.f_sURI + "', scope='" + this.f_sScope + "', mode=" + String.valueOf((Object)this.f_mode) + ")";
        }
    }
}

