/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.Coherence;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Service;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.SessionProvider;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Publisher;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.ResourceRegistry;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public interface Session
extends AutoCloseable {
    public <K, V> NamedMap<K, V> getMap(String var1, NamedMap.Option ... var2);

    public <K, V> NamedCache<K, V> getCache(String var1, NamedMap.Option ... var2);

    default public <V> NamedTopic<V> getTopic(String sName) {
        return this.getTopic(sName, new NamedCollection.Option[0]);
    }

    public <V> NamedTopic<V> getTopic(String var1, NamedCollection.Option ... var2);

    default public <V> Publisher<V> createPublisher(String sName) {
        return this.createPublisher(sName, new Publisher.Option[0]);
    }

    default public <V> Publisher<V> createPublisher(String sName, Publisher.Option ... options) {
        return this.getTopic(sName).createPublisher(options);
    }

    default public <V> Subscriber<V> createSubscriber(String sName) {
        return this.createSubscriber(sName, new Subscriber.Option[0]);
    }

    default public <V> Subscriber<V> createSubscriber(String sName, Subscriber.Option ... options) {
        return this.getTopic(sName).createSubscriber(options);
    }

    public void close(NamedCollection var1);

    public void destroy(NamedCollection var1);

    public ResourceRegistry getResourceRegistry();

    public InterceptorRegistry getInterceptorRegistry();

    public boolean isMapActive(String var1, ClassLoader var2);

    public boolean isCacheActive(String var1, ClassLoader var2);

    public boolean isTopicActive(String var1, ClassLoader var2);

    public String getName();

    public String getScopeName();

    public boolean isActive();

    public void activate();

    public Service getService(String var1);

    @Deprecated
    public static Session create(Option ... options) throws IllegalArgumentException, IllegalStateException {
        return SessionProvider.get().createSession(options);
    }

    public static Session create() {
        return Session.ensure(SessionConfiguration.defaultSession());
    }

    public static Session ensure(SessionConfiguration configuration) {
        return Session.ensure(configuration, Coherence.Mode.ClusterMember);
    }

    public static Session ensure(SessionConfiguration configuration, Coherence.Mode mode) {
        return Session.create(configuration, mode).orElseThrow(() -> new IllegalStateException("could not create a session"));
    }

    public static Optional<Session> create(SessionConfiguration configuration) {
        return Session.create(configuration, Coherence.Mode.ClusterMember);
    }

    public static Optional<Session> create(SessionConfiguration configuration, Coherence.Mode mode) {
        return Session.create(configuration, mode, Collections.emptyList());
    }

    public static Optional<Session> create(SessionConfiguration configuration, Coherence.Mode mode, Iterable<? extends EventInterceptor<?>> interceptors) {
        return SessionProvider.get().createSession(Objects.requireNonNull(configuration), Objects.requireNonNull(mode), interceptors);
    }

    @Deprecated
    public static interface Option {
    }
}

