/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.internal.util.DefaultAsyncNamedCache;
import com.tangosol.internal.util.DistributedAsyncNamedCache;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.NamedMap;
import com.tangosol.net.ViewBuilder;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Base;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;

public interface NamedCache<K, V>
extends NamedMap<K, V>,
CacheMap<K, V> {
    public String getCacheName();

    public CacheService getCacheService();

    @Override
    public V put(K var1, V var2, long var3);

    @Override
    default public void forEach(Collection<? extends K> collKeys, BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        this.getAll(collKeys).forEach(action);
    }

    default public <C extends NamedCache<K, V>> C as(Class<C> clzNamedCache) {
        Base.azzert(clzNamedCache != null, "The specified Class can't be null");
        if (clzNamedCache.isInstance(this)) {
            return (C)this;
        }
        throw new UnsupportedOperationException("The NamedCache [" + this.getCacheName() + "] doesn't implement or support [" + String.valueOf(clzNamedCache) + "]");
    }

    default public AsyncNamedCache<K, V> async() {
        return this.async(AsyncNamedMap.Option.NONE);
    }

    @Override
    default public AsyncNamedCache<K, V> async(AsyncNamedMap.Option ... options) {
        if (this.getService() instanceof DistributedCacheService) {
            return new DistributedAsyncNamedCache(this, options);
        }
        return new DefaultAsyncNamedCache(this, options);
    }

    @Override
    default public ViewBuilder<K, V> view() {
        return new ViewBuilder(this);
    }
}

