/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.internal.util.OrderedView;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.filter.AlwaysFilter;
import java.util.Comparator;
import java.util.function.Supplier;

public class MapViewBuilder<K, V> {
    protected final Supplier<NamedCache<K, V>> f_supplierNamedCache;
    protected Filter<?> m_filter;
    protected MapListener<? super K, ? super V> m_listener;
    protected ValueExtractor<? super V, ?> m_mapper;
    protected Comparator<? super V> m_comparator;
    protected boolean m_fCacheValues = true;
    protected ClassLoader m_loader;

    MapViewBuilder(NamedMap<K, V> map) {
        this(() -> (NamedCache)map);
    }

    protected MapViewBuilder(Supplier<NamedCache<K, V>> supplierNamedCache) {
        this.f_supplierNamedCache = supplierNamedCache;
    }

    public MapViewBuilder<K, V> filter(Filter<?> filter) {
        this.m_filter = filter;
        return this;
    }

    public MapViewBuilder<K, V> listener(MapListener<? super K, ? super V> listener) {
        this.m_listener = listener;
        return this;
    }

    public <U> MapViewBuilder<K, U> map(ValueExtractor<? super V, ? extends U> mapper) {
        this.m_mapper = mapper;
        return this;
    }

    public MapViewBuilder<K, V> sorted() {
        return this.sorted(null);
    }

    public MapViewBuilder<K, V> sorted(Comparator<? super V> comparator) {
        this.m_comparator = comparator == null ? SafeComparator.INSTANCE() : comparator;
        return this;
    }

    public MapViewBuilder<K, V> keys() {
        this.m_fCacheValues = false;
        return this;
    }

    public MapViewBuilder<K, V> values() {
        this.m_fCacheValues = true;
        return this;
    }

    public MapViewBuilder<K, V> withClassLoader(ClassLoader loader) {
        this.m_loader = loader;
        return this;
    }

    public NamedMap<K, V> build() {
        Filter<?> filter = this.m_filter;
        ClassLoader loader = this.m_loader;
        ContinuousQueryCache<? super K, ? super V, ? super V> view = new ContinuousQueryCache<K, V, V>(this.f_supplierNamedCache, filter == null ? AlwaysFilter.INSTANCE : filter, this.m_fCacheValues, this.m_listener, this.m_mapper, loader == null ? Base.getContextClassLoader(this) : loader);
        return this.m_comparator == null ? view : new OrderedView(view, this.m_comparator);
    }
}

