/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Reads;
import com.tangosol.net.PasswordProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public abstract class InputStreamPasswordProvider
implements PasswordProvider {
    private final boolean m_fFirstLineOnly;

    protected InputStreamPasswordProvider() {
        this(false);
    }

    protected InputStreamPasswordProvider(boolean fFirstLineOnly) {
        this.m_fFirstLineOnly = fFirstLineOnly;
    }

    public boolean isFirstLineOnly() {
        return this.m_fFirstLineOnly;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public char[] get() {
        try (InputStream in = this.getInputStream();){
            if (in == null) {
                char[] cArray = null;
                return cArray;
            }
            if (this.m_fFirstLineOnly) {
                String sLine = new BufferedReader(new InputStreamReader(in)).readLine();
                char[] cArray = sLine.toCharArray();
                return cArray;
            }
            byte[] ab = Reads.read(in);
            char[] cArray = new String(ab, StandardCharsets.UTF_8).toCharArray();
            return cArray;
        }
        catch (IOException e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    protected abstract InputStream getInputStream() throws IOException;
}

