/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.Lockable;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.util.Options;
import com.tangosol.application.Context;
import com.tangosol.coherence.config.CacheConfig;
import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.ParameterMacroExpressionParser;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.ResourceMapping;
import com.tangosol.coherence.config.ResourceMappingRegistry;
import com.tangosol.coherence.config.ServiceSchemeRegistry;
import com.tangosol.coherence.config.TopicMapping;
import com.tangosol.coherence.config.TypedResourceMapping;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.NamedCollectionBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderRegistry;
import com.tangosol.coherence.config.builder.ServiceBuilder;
import com.tangosol.coherence.config.scheme.AbstractCachingScheme;
import com.tangosol.coherence.config.scheme.AbstractCompositeScheme;
import com.tangosol.coherence.config.scheme.AbstractServiceScheme;
import com.tangosol.coherence.config.scheme.BackingMapScheme;
import com.tangosol.coherence.config.scheme.BackupMapConfig;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.ClusteredCachingScheme;
import com.tangosol.coherence.config.scheme.DistributedScheme;
import com.tangosol.coherence.config.scheme.ExternalScheme;
import com.tangosol.coherence.config.scheme.FlashJournalScheme;
import com.tangosol.coherence.config.scheme.ObservableCachingScheme;
import com.tangosol.coherence.config.scheme.PagedExternalScheme;
import com.tangosol.coherence.config.scheme.ReadWriteBackingMapScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.coherence.config.scheme.TransactionalScheme;
import com.tangosol.coherence.config.xml.CacheConfigNamespaceHandler;
import com.tangosol.config.expression.ChainedParameterResolver;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.ScopedParameterResolver;
import com.tangosol.config.expression.SystemEnvironmentParameterResolver;
import com.tangosol.config.expression.SystemPropertyParameterResolver;
import com.tangosol.config.xml.DocumentProcessor;
import com.tangosol.io.BinaryStore;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.io.nio.ByteBufferManager;
import com.tangosol.io.nio.MappedBufferManager;
import com.tangosol.net.AbstractBackingMapManager;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedMap;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Releasable;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.MapCacheStore;
import com.tangosol.net.cache.NearCache;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.net.cache.SerializationMap;
import com.tangosol.net.cache.SimpleSerializationMap;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.internal.ConfigurableCacheFactoryDispatcher;
import com.tangosol.net.events.internal.InterceptorManager;
import com.tangosol.net.events.internal.Registry;
import com.tangosol.net.internal.ScopedCacheReferenceStore;
import com.tangosol.net.internal.ScopedReferenceStore;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.options.WithClassLoader;
import com.tangosol.net.partition.ObservableSplittingBackingCache;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.Security;
import com.tangosol.net.security.StorageAccessAuthorizer;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlDocumentReference;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapSet;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleResourceRegistry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;

public class ExtensibleConfigurableCacheFactory
extends Base
implements ConfigurableCacheFactory {
    public static final String FILE_CFG_CACHE = "coherence-cache-config.xml";
    public static final String CACHE_NAME = "{cache-name}";
    public static final String CLASS_LOADER = "{class-loader}";
    public static final String MGR_CONTEXT = "{manager-context}";
    public static final String SCHEME_REF = "{scheme-ref}";
    public static final String CACHE_REF = "{cache-ref}";
    public static final String CACHE_FACTORY = "{cache-factory}";
    public static final int SCHEME_UNKNOWN = 0;
    public static final int SCHEME_REPLICATED = 1;
    public static final int SCHEME_OPTIMISTIC = 2;
    public static final int SCHEME_DISTRIBUTED = 3;
    public static final int SCHEME_NEAR = 4;
    public static final int SCHEME_VERSIONED_NEAR = 5;
    public static final int SCHEME_LOCAL = 6;
    public static final int SCHEME_OVERFLOW = 7;
    public static final int SCHEME_DISK = 8;
    public static final int SCHEME_EXTERNAL = 9;
    public static final int SCHEME_EXTERNAL_PAGED = 10;
    public static final int SCHEME_CLASS = 11;
    public static final int SCHEME_READ_WRITE_BACKING = 12;
    public static final int SCHEME_VERSIONED_BACKING = 13;
    public static final int SCHEME_INVOCATION = 14;
    public static final int SCHEME_PROXY = 15;
    public static final int SCHEME_REMOTE_CACHE = 16;
    public static final int SCHEME_REMOTE_INVOCATION = 17;
    public static final int SCHEME_TRANSACTIONAL = 18;
    public static final int SCHEME_FLASHJOURNAL = 19;
    public static final int SCHEME_RAMJOURNAL = 20;
    public static final HashMap<String, Integer> MAP_SCHEMETYPE_BY_SCHEMENAME = new HashMap<String, Integer>(){
        {
            this.put("replicated-scheme", 1);
            this.put("optimistic-scheme", 2);
            this.put("distributed-scheme", 3);
            this.put("local-scheme", 6);
            this.put("overflow-scheme", 7);
            this.put("disk-scheme", 8);
            this.put("external-scheme", 9);
            this.put("paged-external-scheme", 10);
            this.put("class-scheme", 11);
            this.put("near-scheme", 4);
            this.put("versioned-near-scheme", 5);
            this.put("read-write-backing-map-scheme", 12);
            this.put("versioned-backing-map-scheme", 13);
            this.put("invocation-scheme", 14);
            this.put("proxy-scheme", 15);
            this.put("remote-cache-scheme", 16);
            this.put("remote-invocation-scheme", 17);
            this.put("transactional-scheme", 18);
            this.put("flashjournal-scheme", 19);
            this.put("ramjournal-scheme", 20);
        }
    };
    private final CacheConfig f_cacheConfig;
    @Deprecated
    private final XmlElement f_xmlLegacyConfig;
    private final ResourceRegistry f_registry;
    protected final ScopedCacheReferenceStore f_store;
    protected final ScopedReferenceStore<NamedTopic> f_storeTopics;
    protected final ConfigurableCacheFactoryDispatcher f_dispatcher;
    private ClassLoader m_loader;
    protected Map<Service, String> m_mapServices = new WeakHashMap<Service, String>();
    protected Set<BackingMapManager> m_setManager = new MapSet(new WeakHashMap());
    protected boolean m_fActivated = false;
    protected boolean m_fDisposed = false;

    public ExtensibleConfigurableCacheFactory(Dependencies dependencies) {
        this.f_cacheConfig = dependencies.getCacheConfig();
        this.m_loader = dependencies.getContextClassLoader();
        this.f_registry = dependencies.getResourceRegistry();
        this.f_store = new ScopedCacheReferenceStore();
        this.f_storeTopics = new ScopedReferenceStore<NamedTopic>(NamedTopic.class, Releasable::isActive, NamedCollection::getName, NamedCollection::getService);
        this.m_fActivated = false;
        this.m_fDisposed = false;
        this.f_xmlLegacyConfig = (XmlElement)this.f_registry.getResource(XmlElement.class, "legacy-cache-config").clone();
        this.configure();
        this.f_dispatcher = new ConfigurableCacheFactoryDispatcher();
        EventDispatcherRegistry dispatcherReg = this.f_registry.getResource(EventDispatcherRegistry.class);
        if (dispatcherReg != null) {
            dispatcherReg.registerEventDispatcher(this.f_dispatcher);
        }
        Logger.fine("Created cache factory " + this.getClass().getName());
    }

    @Override
    public <K, V> NamedCache<K, V> ensureCache(String sCacheName, ClassLoader loader, NamedMap.Option ... options) {
        this.assertNotDisposed();
        Base.checkNotEmpty(sCacheName, "CacheName");
        return System.getSecurityManager() == null ? this.ensureCacheInternal(sCacheName, loader, options) : AccessController.doPrivileged(new DoAsAction<NamedCache>(() -> this.ensureCacheInternal(sCacheName, loader, options)));
    }

    private <K, V> NamedCache<K, V> ensureCacheInternal(String sCacheName, ClassLoader loader, NamedMap.Option ... options) {
        MapBuilder.Dependencies dependencies;
        ParameterResolver resolver;
        NamedCache cache;
        CachingScheme scheme;
        Options<NamedMap.Option> optsNamedCache = Options.from(NamedMap.Option.class, options);
        if (loader == null) {
            loader = optsNamedCache.get(WithClassLoader.class, WithClassLoader.autoDetect()).getClassLoader();
        }
        TypeAssertion assertion = optsNamedCache.get(TypeAssertion.class);
        do {
            CacheMapping mapping;
            if ((mapping = this.f_cacheConfig.getMappingRegistry().findMapping(sCacheName, CacheMapping.class)) == null) {
                throw new IllegalArgumentException("ensureCache cannot find a mapping for cache " + sCacheName);
            }
            cache = this.f_store.getCache(sCacheName, loader);
            if (cache != null && cache.isActive()) {
                ExtensibleConfigurableCacheFactory.checkPermission(cache);
                assertion.assertTypeSafety(sCacheName, mapping, false);
                return cache;
            }
            if (cache != null && !cache.isDestroyed() && !cache.isReleased()) {
                try {
                    ExtensibleConfigurableCacheFactory.checkPermission(cache);
                    assertion.assertTypeSafety(sCacheName, mapping, false);
                    return cache;
                }
                catch (IllegalStateException e) {
                    this.f_store.releaseCache(cache, loader);
                }
            }
            assertion.assertTypeSafety(sCacheName, mapping, true);
            ServiceScheme serviceScheme = this.f_cacheConfig.findSchemeBySchemeName(mapping.getSchemeName());
            if (serviceScheme == null) {
                throw new IllegalArgumentException("ensureCache cannot find service scheme " + mapping.getSchemeName() + " for cache " + sCacheName);
            }
            if (!(serviceScheme instanceof CachingScheme)) {
                throw new IllegalArgumentException("The scheme " + mapping.getSchemeName() + " for cache " + sCacheName + " is not a CachingScheme");
            }
            scheme = (CachingScheme)serviceScheme;
            this.f_store.clearInactiveCacheRefs();
            CachingScheme bldrCache = scheme;
            Base.checkNotNull(bldrCache, "NamedCacheBuilder");
            resolver = this.getParameterResolver(sCacheName, CacheMapping.class, loader, null);
            dependencies = new MapBuilder.Dependencies(this, null, loader, sCacheName, scheme.getServiceType());
            cache = bldrCache.realizeCache(resolver, dependencies);
        } while (!(scheme instanceof TransactionalScheme) && this.f_store.putCacheIfAbsent(cache, loader) != null);
        if (scheme instanceof ObservableCachingScheme) {
            ObservableCachingScheme schemeObservable = (ObservableCachingScheme)scheme;
            schemeObservable.establishMapListeners(cache, resolver, dependencies);
        }
        if (cache instanceof NearCache) {
            ((NearCache)cache).registerMBean();
        }
        return cache;
    }

    public void releaseCache(NamedCache cache) {
        this.releaseCache(cache, false);
    }

    public void destroyCache(NamedCache cache) {
        this.releaseCache(cache, true);
    }

    @Override
    public <V> NamedTopic<V> ensureTopic(String sName, ClassLoader loader, NamedCollection.Option ... options) {
        this.assertNotDisposed();
        Base.checkNotEmpty(sName, "name");
        PrivilegedAction<NamedTopic> action = () -> this.ensureCollectionInternal(sName, NamedTopic.class, loader, this.f_storeTopics, TopicMapping.class, options);
        return AccessController.doPrivileged(new DoAsAction<NamedTopic>(action));
    }

    <C extends NamedCollection, M extends TypedResourceMapping, V> C ensureCollectionInternal(String sName, Class<C> clsCollection, ClassLoader loader, ScopedReferenceStore<C> store, Class<M> clzMapping, NamedCollection.Option ... aOption) {
        Object collection;
        Options<NamedCollection.Option> options = Options.from(NamedCollection.Option.class, aOption);
        ValueTypeAssertion constraint = options.get(ValueTypeAssertion.class);
        if (loader == null) {
            loader = options.get(WithClassLoader.class, WithClassLoader.autoDetect()).getClassLoader();
        }
        loader = Classes.ensureClassLoader(loader);
        do {
            TypedResourceMapping mapping;
            if ((mapping = (TypedResourceMapping)this.f_cacheConfig.getMappingRegistry().findMapping(sName, clzMapping)) == null) {
                throw new IllegalArgumentException(String.format("Cannot find a mapping for %s", sName));
            }
            constraint.assertTypeSafety(sName, mapping);
            NamedCollection col = (NamedCollection)store.get(sName, loader);
            if (col != null && col.isActive()) {
                if (clsCollection.isAssignableFrom(col.getClass())) {
                    ExtensibleConfigurableCacheFactory.checkPermission(col);
                    return (C)col;
                }
                String sMsg = String.format("A Collection already exist for name '%s' but is of type %s when requested type is %s", sName, col.getClass(), clsCollection);
                throw new IllegalStateException(sMsg);
            }
            ServiceScheme serviceScheme = this.f_cacheConfig.findSchemeBySchemeName(mapping.getSchemeName());
            if (serviceScheme == null) {
                String sMsg = String.format("ensureCollection cannot find service scheme %s for mapping %s", mapping.getSchemeName(), sName);
                throw new IllegalArgumentException(sMsg);
            }
            Collection<Integer> colHashCode = store.clearInactiveRefs(sName);
            if (colHashCode != null) {
                for (Integer nHashCode : colHashCode) {
                    MBeanHelper.unregisterCacheMBean(sName, "tier=front,loader=" + nHashCode);
                }
            }
            NamedCollectionBuilder bldrCollection = serviceScheme.getNamedCollectionBuilder(clsCollection, options);
            Base.checkNotNull(bldrCollection, "NamedCollectionBuilder");
            if (!bldrCollection.realizes(clsCollection)) {
                String sMsg = String.format("The scheme '%s' is defined as a %s and cannot build an instance of a %s", sName, bldrCollection.getClass().getSimpleName(), clsCollection.getSimpleName());
                throw new IllegalStateException(sMsg);
            }
            ParameterResolver paramResolver = this.getParameterResolver(sName, clzMapping, loader, null);
            ResolvableParameterList resolverOpts = new ResolvableParameterList(Collections.singletonMap("options", options));
            ChainedParameterResolver resolver = new ChainedParameterResolver(paramResolver, resolverOpts);
            MapBuilder.Dependencies dependencies = new MapBuilder.Dependencies(this, null, loader, sName, serviceScheme.getServiceType());
            mapping.preConstruct(null, resolver, dependencies);
            collection = bldrCollection.realize(constraint, resolver, dependencies);
            mapping.postConstruct(null, collection, resolver, dependencies);
        } while (store.putIfAbsent(collection, loader) != null);
        return collection;
    }

    @Override
    public Service ensureService(String sServiceName) {
        this.assertNotDisposed();
        ServiceScheme scheme = this.f_cacheConfig.findSchemeByServiceName(sServiceName);
        if (scheme == null) {
            throw new IllegalArgumentException("No scheme found for service " + sServiceName);
        }
        return this.ensureService(scheme);
    }

    @Override
    public synchronized void activate() {
        if (this.m_fActivated) {
            return;
        }
        this.f_cacheConfig.validate(this.f_registry);
        this.f_dispatcher.dispatchActivating(this);
        String sScopeName = this.f_cacheConfig == null ? "<unknown scope>" : this.f_cacheConfig.getScopeName();
        CacheFactory.log("ExtensibledConfigurableCacheFactory.activate() cache config with scope " + sScopeName, 3);
        this.startServices();
        try {
            this.f_dispatcher.dispatchActivated(this);
        }
        finally {
            this.m_fActivated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() {
        if (this.m_fDisposed) {
            return;
        }
        try {
            this.f_dispatcher.dispatchDisposing(this);
        }
        finally {
            Map<Service, String> mapServices = this.m_mapServices;
            Iterator<Service> iterator = mapServices.keySet().iterator();
            while (iterator.hasNext()) {
                Service service;
                Service service2 = service = iterator.next();
                synchronized (service2) {
                    ResourceRegistry registry = service.getResourceRegistry();
                    Set setRefs = registry.getResource(Set.class, "Referrers");
                    if (setRefs == null || setRefs.remove(this) && setRefs.isEmpty()) {
                        service.shutdown();
                    }
                }
            }
            mapServices.clear();
            this.f_registry.dispose();
            this.m_fActivated = false;
            this.m_fDisposed = true;
        }
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        this.assertNotDisposed();
        return this.f_registry;
    }

    @Override
    public InterceptorRegistry getInterceptorRegistry() {
        return this.getResourceRegistry().getResource(InterceptorRegistry.class);
    }

    @Override
    public boolean isActive() {
        return this.m_fActivated;
    }

    @Override
    public String getScopeName() {
        String sScopeName = this.getResourceRegistry().getResource(String.class, "scope-name");
        return sScopeName == null ? this.f_cacheConfig.getScopeName() : sScopeName;
    }

    protected long getRequestTimeout(ServiceScheme scheme) {
        ServiceDependencies deps = null;
        if (scheme instanceof AbstractServiceScheme) {
            deps = (ServiceDependencies)((AbstractServiceScheme)scheme).getServiceDependencies();
        }
        long cWait = deps == null ? -1L : deps.getRequestTimeoutMillis();
        return cWait > 0L ? cWait : -1L;
    }

    @Override
    public boolean isDisposed() {
        return this.m_fDisposed;
    }

    protected void assertNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("This factory has been disposed and cannot be reused");
        }
    }

    protected void configure() {
        this.f_registry.getResource(InterceptorManager.class).instantiateGlobalInterceptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service ensureService(ServiceScheme scheme) {
        this.assertNotDisposed();
        ServiceBuilder bldrService = scheme.getServiceBuilder();
        ClassLoader loader = this.getConfigClassLoader();
        Cluster cluster = bldrService.isRunningClusterNeeded() ? CacheFactory.ensureCluster() : CacheFactory.getCluster();
        try (Lockable.Unlockable unlockable = ((Lockable)((Object)cluster)).exclusively();){
            final ExtensibleConfigurableCacheFactory factory = this;
            ParameterResolver factoryResolver = new ParameterResolver(){

                @Override
                public Parameter resolve(String sName) {
                    return new Parameter(ExtensibleConfigurableCacheFactory.CACHE_FACTORY, ConfigurableCacheFactory.class, factory);
                }
            };
            ChainedParameterResolver resolver = new ChainedParameterResolver(this.f_cacheConfig.getDefaultParameterResolver(), factoryResolver);
            Service service = bldrService.realizeService(resolver, loader, cluster);
            if (service.isRunning()) {
                if (service instanceof CacheService) {
                    this.validateBackingMapManager((CacheService)service);
                }
            } else {
                if (service instanceof CacheService) {
                    BackingMapManager mgr = ((CachingScheme)scheme).realizeBackingMapManager(this);
                    this.registerBackingMapManager(mgr);
                    ((CacheService)service).setBackingMapManager(mgr);
                }
                this.startService(service);
            }
            this.m_mapServices.put(service, scheme.getServiceName());
            Service service2 = service;
            synchronized (service2) {
                ResourceRegistry registry = service.getResourceRegistry();
                Set setRefs = registry.getResource(Set.class, "Referrers");
                if (setRefs == null) {
                    setRefs = Collections.newSetFromMap(new IdentityHashMap());
                    registry.registerResource(Set.class, "Referrers", setRefs);
                }
                setRefs.add(this);
            }
            service2 = service;
            return service2;
        }
    }

    public CacheConfig getCacheConfig() {
        return this.f_cacheConfig;
    }

    protected static int translateStandardSchemeType(String sScheme) {
        Integer iSchemeType = MAP_SCHEMETYPE_BY_SCHEMENAME.get(sScheme);
        return iSchemeType == null ? 0 : iSchemeType;
    }

    public void startServices() {
        CacheConfig config = this.getCacheConfig();
        ResourceMappingRegistry regMapping = config.getMappingRegistry();
        ServiceSchemeRegistry regScheme = config.getServiceSchemeRegistry();
        Set setSharedScheme = NullImplementation.getSet();
        for (ServiceScheme scheme : regScheme) {
            if (!scheme.isAutoStart() || setSharedScheme.contains(scheme.getSchemeName())) continue;
            this.ensureService(scheme);
        }
    }

    public Map<Service, String> getServiceMap() {
        return new LinkedHashMap<Service, String>(this.m_mapServices);
    }

    protected void startService(Service service) {
        service.start();
    }

    protected void setConfigClassLoader(ClassLoader loader) {
        this.m_loader = ExtensibleConfigurableCacheFactory.ensureClassLoader(loader);
    }

    public ClassLoader getConfigClassLoader() {
        return this.m_loader;
    }

    protected static void checkPermission(NamedCache cache) {
        ExtensibleConfigurableCacheFactory.checkPermission(cache.getCacheService(), cache.getCacheName());
    }

    protected static void checkPermission(NamedCollection collection) {
        ExtensibleConfigurableCacheFactory.checkPermission(collection.getService(), collection.getName());
    }

    protected static void checkPermission(Service service, String sName) {
        Security.checkPermission(service.getCluster(), service.getInfo().getServiceName(), sName, "join");
    }

    public ParameterResolver getParameterResolver(String sCacheName, ClassLoader loader, BackingMapManagerContext ctxBMM) {
        return this.getParameterResolver(sCacheName, ResourceMapping.class, loader, ctxBMM);
    }

    public <M extends ResourceMapping> ParameterResolver getParameterResolver(String sResourceName, Class<M> clzResourceMapping, ClassLoader loader, BackingMapManagerContext ctxBMM) {
        M mapping = this.f_cacheConfig.getMappingRegistry().findMapping(sResourceName, clzResourceMapping);
        ScopedParameterResolver resolver = new ScopedParameterResolver(mapping == null ? this.f_cacheConfig.getDefaultParameterResolver() : ((ResourceMapping)mapping).getParameterResolver());
        if (mapping != null) {
            resolver.add(new Parameter(((ResourceMapping)mapping).getConfigElementName(), sResourceName));
        }
        resolver.add(new Parameter("class-loader", loader));
        resolver.add(new Parameter("manager-context", ctxBMM));
        return resolver;
    }

    public ParameterResolver createParameterResolver(ClassLoader loader, BackingMapManagerContext ctxBMM) {
        ScopedParameterResolver resolver = new ScopedParameterResolver(this.f_cacheConfig.getDefaultParameterResolver());
        resolver.add(new Parameter("class-loader", loader));
        resolver.add(new Parameter("manager-context", ctxBMM));
        return resolver;
    }

    protected void registerBackingMapManager(BackingMapManager mgr) {
        this.m_setManager.add(mgr);
    }

    protected void validateBackingMapManager(CacheService service) throws IllegalStateException {
        BackingMapManager manager = service.getBackingMapManager();
        if (this.m_setManager.contains(manager)) {
            return;
        }
        if (!(manager instanceof Manager)) {
            throw new IllegalStateException("Service \"" + service.getInfo().getServiceName() + "\" has been started " + (String)(manager == null ? "without a BackingMapManager" : "with a non-compatible BackingMapManager: " + String.valueOf(manager)));
        }
        ExtensibleConfigurableCacheFactory that = ((Manager)manager).getCacheFactory();
        if (!(that instanceof ExtensibleConfigurableCacheFactory)) {
            throw new IllegalStateException("Service \"" + service.getInfo().getServiceName() + "\" has been started by an instance of \"" + that.getClass().getName() + "\" instead of \"" + this.getClass().getName() + "\"");
        }
        XmlElement xmlLegacyConfig = that.f_xmlLegacyConfig;
        if (that != this && !Base.equals(xmlLegacyConfig, this.f_xmlLegacyConfig)) {
            Logger.info("This configurable cache factory config: " + String.valueOf(this.f_xmlLegacyConfig));
            Logger.info("Other configurable cache factory config: " + String.valueOf(xmlLegacyConfig));
            throw new IllegalStateException("Service \"" + service.getInfo().getServiceName() + "\" has been started by a different configurable cache factory.");
        }
    }

    protected void release(Map map, Map mapListeners) {
        ByteBufferManager bufmgr;
        MapListener listener;
        if (map instanceof ObservableMap && mapListeners != null && (listener = (MapListener)mapListeners.get(map)) != null) {
            ((ObservableMap)map).removeMapListener(listener);
            mapListeners.remove(map);
        }
        if (map instanceof LocalCache) {
            CacheLoader loader = ((LocalCache)map).getCacheLoader();
            if (loader instanceof MapCacheStore) {
                this.release(((MapCacheStore)loader).getMap(), mapListeners);
            } else {
                this.release(loader);
            }
        } else if (map instanceof OverflowMap) {
            this.release(((OverflowMap)map).getFrontMap(), mapListeners);
            this.release(((OverflowMap)map).getBackMap(), mapListeners);
        } else if (map instanceof ReadWriteBackingMap) {
            ((ReadWriteBackingMap)map).release();
            this.release(((ReadWriteBackingMap)map).getInternalCache(), mapListeners);
        } else if (map instanceof SerializationMap) {
            this.release(((SerializationMap)map).getBinaryStore());
        } else if (map instanceof SimpleSerializationMap) {
            this.release(((SimpleSerializationMap)map).getBinaryStore());
        } else if (map instanceof BinaryMap && (bufmgr = ((BinaryMap)map).getBufferManager()) instanceof MappedBufferManager) {
            ((MappedBufferManager)bufmgr).close();
        }
        if (map instanceof Disposable) {
            ((Disposable)((Object)map)).dispose();
        }
    }

    protected void release(CacheLoader loader) {
        if (loader instanceof Disposable) {
            ((Disposable)((Object)loader)).dispose();
        } else {
            try {
                ClassHelper.invoke(loader, "close", ClassHelper.VOID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void release(BinaryStore store) {
        if (store instanceof Disposable) {
            ((Disposable)((Object)store)).dispose();
        } else {
            try {
                ClassHelper.invoke(store, "close", ClassHelper.VOID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void releaseCache(NamedCache cache, boolean fDestroy) {
        Runnable runRelease;
        String sCacheName = cache.getCacheName();
        ClassLoader loader = cache instanceof ClassLoaderAware ? ((ClassLoaderAware)((Object)cache)).getContextClassLoader() : ExtensibleConfigurableCacheFactory.getContextClassLoader();
        if (!this.f_store.releaseCache(cache, loader, runRelease = () -> {
            if (fDestroy) {
                cache.destroy();
            } else {
                cache.release();
            }
        }) && cache.isActive()) {
            throw new IllegalArgumentException("The cache " + sCacheName + " was created using a different factory; that same factory should be used to release the cache.");
        }
    }

    @Override
    public void releaseTopic(NamedTopic<?> topic) {
        this.releaseCollection(topic, false, this.f_storeTopics);
    }

    @Override
    public void destroyTopic(NamedTopic<?> topic) {
        this.releaseCollection(topic, true, this.f_storeTopics);
    }

    private void releaseCollection(NamedCollection collection, boolean fDestroy, ScopedReferenceStore store) {
        ClassLoader loader;
        String sName = collection.getName();
        ClassLoader classLoader = loader = collection instanceof ClassLoaderAware ? ((ClassLoaderAware)((Object)collection)).getContextClassLoader() : ExtensibleConfigurableCacheFactory.getContextClassLoader();
        if (store.release(collection, loader)) {
            if (fDestroy) {
                collection.destroy();
            } else {
                collection.release();
            }
        } else if (collection.isActive()) {
            throw new IllegalArgumentException("The collection " + sName + " was created using a different factory; that same factory should be used to release the collection.");
        }
    }

    @Override
    public boolean isCacheActive(String sCacheName, ClassLoader loader) {
        return this.f_store.getCache(sCacheName, ExtensibleConfigurableCacheFactory.ensureClassLoader(loader)) != null;
    }

    @Override
    public boolean isTopicActive(String sTopicName, ClassLoader loader) {
        return this.f_storeTopics.get(sTopicName, ExtensibleConfigurableCacheFactory.ensureClassLoader(loader)) != null;
    }

    private static XmlElement findXmlOverride(XmlElement xmlConfig, ClassLoader loader) {
        String sAttr;
        XmlValue xmlOverride = xmlConfig.getAttribute("xml-override");
        if (xmlOverride != null && (sAttr = xmlOverride.getString()).startsWith("{") && sAttr.endsWith("}")) {
            String sPropName;
            int ofDefault = sAttr.indexOf(32);
            int cchLength = sAttr.length();
            String sDefault = "";
            if (ofDefault < 0) {
                sPropName = sAttr.substring(1, cchLength - 1);
            } else {
                sPropName = sAttr.substring(1, ofDefault);
                sDefault = sAttr.substring(ofDefault + 1, cchLength - 1);
            }
            String sValue = Config.getProperty(sPropName, sDefault);
            if (sValue != null && !sValue.isEmpty()) {
                URL url = Resources.findFileOrResource(sValue, loader);
                if (url == null) {
                    try {
                        url = new URL((sValue.contains(":") ? "" : "file://") + sValue);
                    }
                    catch (MalformedURLException e) {
                        throw ExtensibleConfigurableCacheFactory.ensureRuntimeException(e, "The configuration URI contains illegal characters for a URL " + sValue);
                    }
                }
                return XmlHelper.loadResource(url, "cache configuration override", loader);
            }
        }
        return null;
    }

    public static interface Dependencies {
        public CacheConfig getCacheConfig();

        public ClassLoader getContextClassLoader();

        public ResourceRegistry getResourceRegistry();
    }

    public static class Manager
    extends AbstractBackingMapManager {
        private final ExtensibleConfigurableCacheFactory m_factory;
        private Map<String, Map> m_mapBackingMap;
        private Map<Map, MapListener> m_mapBackingMapListeners;

        public Manager(ExtensibleConfigurableCacheFactory factory) {
            this.m_factory = factory;
        }

        @Override
        public void init(BackingMapManagerContext context) {
            super.init(context);
            this.m_mapBackingMap = new HashMap<String, Map>();
            this.m_mapBackingMapListeners = new IdentityHashMap<Map, MapListener>();
        }

        @Override
        public Map instantiateBackingMap(String sName) {
            Map map;
            boolean fPartitioned = false;
            ParameterResolver resolver = this.getResolver(sName);
            BackingMapManagerContext context = this.getContext();
            ClassLoader loader = context.getClassLoader();
            CachingScheme scheme = this.findCachingScheme(sName);
            if (scheme == null) {
                throw new IllegalArgumentException("BackingMapManager cannot find a CachingScheme for cache " + sName);
            }
            ExtensibleConfigurableCacheFactory factory = this.getCacheFactory();
            MapBuilder.Dependencies dependencies = new MapBuilder.Dependencies(factory, context, loader, sName, context.getCacheService().getInfo().getServiceType(), this.m_mapBackingMapListeners);
            if (scheme instanceof ClusteredCachingScheme) {
                BackingMapScheme schemeBackingMap = ((ClusteredCachingScheme)((Object)scheme)).getBackingMapScheme();
                scheme = schemeBackingMap.getInnerScheme();
                fPartitioned = schemeBackingMap.isPartitioned(resolver, false);
            }
            CachingScheme bldrMap = scheme;
            Map map2 = map = fPartitioned ? this.instantiatePartitionedBackingMap(bldrMap, resolver, dependencies, scheme) : bldrMap.realizeMap(resolver, dependencies);
            if (scheme instanceof ObservableCachingScheme && map instanceof ObservableMap) {
                ObservableCachingScheme schemeObservable = (ObservableCachingScheme)scheme;
                schemeObservable.establishMapListeners(map, resolver, dependencies);
            }
            this.setBackingMap(sName, map);
            MBeanHelper.registerCacheMBean(context.getCacheService(), sName, "tier=back", map);
            return map;
        }

        protected Map instantiatePartitionedBackingMap(MapBuilder bldrMap, ParameterResolver resolver, MapBuilder.Dependencies dependencies, CachingScheme scheme) {
            ReadWriteBackingMapScheme schemeRwbm = scheme instanceof ReadWriteBackingMapScheme ? (ReadWriteBackingMapScheme)scheme : null;
            MapBuilder bldrPartition = schemeRwbm == null ? bldrMap : schemeRwbm.getInternalScheme();
            Base.checkNotNull(bldrPartition, "The BackingMapContext is missing a partition map builder");
            PartitionedBackingMapManager mgrInner = new PartitionedBackingMapManager(this.getCacheFactory(), dependencies, resolver, bldrPartition);
            mgrInner.init(this.getContext());
            String sName = dependencies.getCacheName();
            ObservableSplittingBackingCache pabm = new ObservableSplittingBackingCache(mgrInner, sName);
            if (schemeRwbm == null) {
                return pabm;
            }
            schemeRwbm.setInternalMap(pabm);
            return bldrMap.realizeMap(resolver, dependencies);
        }

        @Override
        public boolean isBackingMapPersistent(String sName) {
            DistributedScheme schemeDist = this.findDistributedScheme(sName);
            ParameterResolver resolver = this.getResolver(sName);
            return !schemeDist.getBackingMapScheme().isTransient(resolver);
        }

        @Override
        public boolean isBackingMapSlidingExpiry(String sName) {
            DistributedScheme schemeDist = this.findDistributedScheme(sName);
            ParameterResolver resolver = this.getResolver(sName);
            return schemeDist.getBackingMapScheme().isSlidingExpiry(resolver);
        }

        @Override
        public StorageAccessAuthorizer getStorageAccessAuthorizer(String sName) {
            Expression<String> exprAuthorizer;
            DistributedScheme schemeDist = this.findDistributedScheme(sName);
            BackingMapScheme schemeBackingMap = schemeDist == null ? null : schemeDist.getBackingMapScheme();
            Expression<String> expression = exprAuthorizer = schemeBackingMap == null ? null : schemeBackingMap.getStorageAccessAuthorizer();
            if (exprAuthorizer == null) {
                return null;
            }
            ParameterResolver resolver = this.getResolver(sName);
            String sAuthorizer = exprAuthorizer.evaluate(resolver);
            ClusterDependencies dependencies = CacheFactory.getCluster().getDependencies();
            ParameterizedBuilderRegistry registry = dependencies.getBuilderRegistry();
            ParameterizedBuilder<StorageAccessAuthorizer> builder = registry.getBuilder(StorageAccessAuthorizer.class, sAuthorizer);
            if (builder == null) {
                throw new IllegalArgumentException("Configuration error: backing map of scheme \"" + schemeDist.getSchemeName() + "\" references undefined storage-authorizer \"" + sAuthorizer + "\"");
            }
            try {
                return builder.realize(resolver, this.getContext().getClassLoader(), null);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Configuration error: received exception " + e.getClass().getSimpleName() + " during instantiation of storage-authorizer \"" + sAuthorizer + "\" configured within backing map of scheme \"" + schemeDist.getSchemeName() + "\"", e);
            }
        }

        @Override
        public BiFunction<Ownership, PartitionedService, Member> getReadLocator(String sName) {
            DistributedScheme schemeDist = this.findDistributedScheme(sName);
            ParameterResolver resolver = this.getResolver(sName);
            return schemeDist.getBackingMapScheme().getReadLocatorBuilder().realize(resolver, this.getContext().getClassLoader(), null);
        }

        @Override
        public void releaseBackingMap(String sName, Map map) {
            BackingMapManagerContext context = this.getContext();
            if (context != null) {
                MBeanHelper.unregisterCacheMBean(context.getCacheService(), sName, "tier=back");
            }
            this.getCacheFactory().release(map, this.m_mapBackingMapListeners);
            this.setBackingMap(sName, null);
        }

        public Map instantiateBackupMap(String sName) {
            ParameterResolver resolver = this.getResolver(sName);
            BackingMapManagerContext context = this.getContext();
            ClassLoader loader = context.getClassLoader();
            ExtensibleConfigurableCacheFactory factory = this.getCacheFactory();
            DistributedScheme schemeDist = this.findDistributedScheme(sName);
            int nType = this.getBackupMapType(schemeDist, resolver);
            if (nType == 0) {
                return new SafeHashMap();
            }
            MapBuilder.Dependencies dependencies = new MapBuilder.Dependencies(this.getCacheFactory(), context, loader, sName, context.getCacheService().getInfo().getServiceType());
            dependencies.setBackup(true);
            if (nType == 5) {
                BackingMapScheme journalScheme = schemeDist.getBackingMapScheme();
                journalScheme = journalScheme instanceof FlashJournalScheme ? journalScheme : new FlashJournalScheme();
                return ((AbstractCachingScheme)journalScheme).realizeMap(resolver, dependencies);
            }
            BackupMapConfig configBackup = schemeDist.getBackupMapConfig();
            if (configBackup == null) {
                throw new IllegalStateException("Backup map cannot be created because the backup configuration is missing");
            }
            int cbMax = (int)Math.min(Math.max((long)configBackup.getMaximumSize(resolver), 1L), 2147482624L);
            int cbInit = (int)Math.min(Math.max((long)configBackup.getInitialSize(resolver), 1L), (long)cbMax);
            return switch (nType) {
                case 3 -> {
                    ParameterizedBuilder bldrCustom = configBackup.getCustomBuilder();
                    if (bldrCustom == null) {
                        throw new IllegalArgumentException("Custom backup type specified but the class-name is missing");
                    }
                    ResolvableParameterList listArgs = new ResolvableParameterList();
                    yield (Map)bldrCustom.realize(resolver, loader, listArgs);
                }
                case 2 -> {
                    String sPath = configBackup.getDirectory(resolver);
                    File dir = sPath.length() == 0 ? null : new File(sPath);
                    yield new BinaryMap(new MappedBufferManager(cbInit, cbMax, dir));
                }
                case 4 -> {
                    String sScheme = configBackup.getBackupSchemeName(resolver);
                    Base.checkNotEmpty(sName, "Backup storage scheme name");
                    CachingScheme schemeRef = (CachingScheme)factory.getCacheConfig().findSchemeBySchemeName(sScheme);
                    Base.checkNotNull(schemeRef, "Backup map scheme");
                    yield schemeRef.realizeMap(resolver, dependencies);
                }
                default -> throw new IllegalStateException("Unknown backup storage type: " + nType);
            };
        }

        public void releaseBackupMap(String sName, Map map, Map mapListeners) {
            if (map instanceof SafeHashMap) {
                return;
            }
            try {
                DistributedScheme schemeDist = this.findDistributedScheme(sName);
                ParameterResolver resolver = this.getResolver(sName);
                int nType = this.getBackupMapType(schemeDist, resolver);
                switch (nType) {
                    case 2: {
                        map.clear();
                        try {
                            ByteBufferManager bufferMgr = ((BinaryMap)map).getBufferManager();
                            ((MappedBufferManager)bufferMgr).close();
                        }
                        catch (ClassCastException classCastException) {}
                        break;
                    }
                    case 1: {
                        map.clear();
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        try {
                            this.getCacheFactory().release(map, mapListeners);
                        }
                        catch (ClassCastException classCastException) {}
                        break;
                    }
                    case 0: 
                    case 3: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown backup storage type: " + nType);
                    }
                }
            }
            catch (Exception e) {
                Logger.warn("Failed to invalidate backing map: " + String.valueOf(e));
            }
        }

        public boolean isBackupPartitioned(String sName) {
            boolean fPartitionDefault;
            DistributedScheme schemeDist = this.findDistributedScheme(sName);
            if (schemeDist == null) {
                throw new IllegalArgumentException("BackingManager cannot find a CachingScheme for cache " + sName);
            }
            ParameterResolver resolver = this.getResolver(sName);
            int nType = this.getBackupMapType(schemeDist, resolver);
            boolean bl = fPartitionDefault = nType != 1 && nType != 2;
            if (nType == 4) {
                String sScheme = schemeDist.getBackupMapConfig().getBackupSchemeName(resolver);
                ServiceScheme schemeRef = this.getCacheFactory().getCacheConfig().findSchemeBySchemeName(sScheme);
                fPartitionDefault = !(schemeRef instanceof ExternalScheme) && !(schemeRef instanceof PagedExternalScheme);
            }
            return fPartitionDefault;
        }

        @Override
        public ExtensibleConfigurableCacheFactory getCacheFactory() {
            return this.m_factory;
        }

        protected ParameterResolver getResolver(String sName) {
            BackingMapManagerContext context = this.getContext();
            return this.getCacheFactory().getParameterResolver(sName, context.getClassLoader(), context);
        }

        protected ScopedParameterResolver getScopedResolver(String sName) {
            return new ScopedParameterResolver(this.getResolver(sName));
        }

        public Map getBackingMap(String sName) {
            return this.m_mapBackingMap == null ? null : this.m_mapBackingMap.get(sName);
        }

        protected void setBackingMap(String sName, Map map) {
            if (map != null && this.getBackingMap(sName) != null) {
                throw new IllegalArgumentException("BackingMap is not resettable: " + sName);
            }
            this.m_mapBackingMap.put(sName, map);
        }

        protected DistributedScheme findDistributedScheme(String sName) {
            CachingScheme scheme = this.findCachingScheme(sName);
            return scheme instanceof DistributedScheme ? (DistributedScheme)scheme : null;
        }

        protected CachingScheme findCachingScheme(String sName) {
            CachingScheme scheme = this.getCacheFactory().getCacheConfig().findSchemeByCacheName(sName);
            if (scheme == null) {
                return null;
            }
            return scheme instanceof AbstractCompositeScheme ? ((AbstractCompositeScheme)scheme).getBackScheme() : scheme;
        }

        private int getBackupMapType(DistributedScheme scheme, ParameterResolver resolver) {
            if (scheme == null) {
                return 0;
            }
            BackupMapConfig configBackup = scheme.getBackupMapConfig();
            CachingScheme bldrPrimaryMap = scheme.getBackingMapScheme().getInnerScheme();
            return configBackup.resolveType(resolver, bldrPrimaryMap);
        }
    }

    public static class PartitionedBackingMapManager
    extends AbstractBackingMapManager {
        private final MapBuilder m_bldrMap;
        private final ExtensibleConfigurableCacheFactory m_factory;
        private final MapBuilder.Dependencies m_dependencies;
        private final ParameterResolver m_resolver;

        protected PartitionedBackingMapManager(ExtensibleConfigurableCacheFactory factory, MapBuilder.Dependencies dependencies, ParameterResolver resolver, MapBuilder bldrMap) {
            this.m_factory = factory;
            this.m_dependencies = dependencies;
            this.m_resolver = resolver;
            this.m_bldrMap = bldrMap;
        }

        @Override
        public Map instantiateBackingMap(String sName) {
            int nPartition = this.parsePartition(sName);
            ParameterResolver resolverPartition = sParam -> "partition".equals(sParam) ? new Parameter("partition", new LiteralExpression<Integer>(nPartition)) : null;
            return this.m_bldrMap.realizeMap(new ChainedParameterResolver(resolverPartition, this.m_resolver), this.m_dependencies);
        }

        private int parsePartition(String sName) {
            int nPartition;
            String sPartition = sName.substring(sName.lastIndexOf(45) + 1);
            if (Character.isDigit(sPartition.charAt(0))) {
                try {
                    nPartition = Integer.parseInt(sPartition);
                }
                catch (NumberFormatException e) {
                    nPartition = -1;
                }
            } else {
                nPartition = -1;
            }
            return nPartition;
        }

        @Override
        public boolean isBackingMapPersistent(String sName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isBackingMapSlidingExpiry(String sName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public StorageAccessAuthorizer getStorageAccessAuthorizer(String sName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void releaseBackingMap(String sName, Map map) {
            this.getCacheFactory().release(map, null);
        }

        @Override
        public ExtensibleConfigurableCacheFactory getCacheFactory() {
            return this.m_factory;
        }
    }

    public static class DependenciesHelper {
        public static Dependencies newInstance() {
            return DependenciesHelper.newInstance(ExtensibleConfigurableCacheFactory.FILE_CFG_CACHE, null);
        }

        public static Dependencies newInstance(String sPath) {
            return DependenciesHelper.newInstance(sPath, null);
        }

        public static Dependencies newInstance(String sPath, ClassLoader contextClassLoader) {
            XmlDocument xmlConfig = XmlHelper.loadFileOrResourceOrDefault(sPath, "Cache Configuration from:" + sPath, contextClassLoader);
            return DependenciesHelper.newInstance(xmlConfig, contextClassLoader, null);
        }

        public static Dependencies newInstance(XmlElement xmlConfig) {
            return DependenciesHelper.newInstance(xmlConfig, null, null);
        }

        public static Dependencies newInstance(XmlElement xmlConfig, ClassLoader contextClassLoader) {
            return DependenciesHelper.newInstance(xmlConfig, contextClassLoader, null);
        }

        public static Dependencies newInstance(XmlElement xmlConfig, ClassLoader contextClassLoader, String sPofConfigUri) {
            return DependenciesHelper.newInstance(xmlConfig, contextClassLoader, sPofConfigUri, null);
        }

        public static Dependencies newInstance(XmlElement xmlConfig, ClassLoader loader, String sPofConfigUri, String sScopeName) {
            return DependenciesHelper.newInstance(xmlConfig, loader, sPofConfigUri, sScopeName, null, null);
        }

        public static Dependencies newInstance(XmlElement xmlConfig, ClassLoader loader, String sPofConfigUri, String sScopeName, Context context) {
            return DependenciesHelper.newInstance(xmlConfig, loader, sPofConfigUri, sScopeName, context, null);
        }

        public static Dependencies newInstance(XmlElement xmlConfig, ClassLoader loader, String sPofConfigUri, String sScopeName, Context context, final ParameterResolver resolver) {
            CacheConfig cacheConfig;
            loader = Base.ensureClassLoader(loader);
            ScopedParameterResolver resolverScoped = AccessController.doPrivileged(new PrivilegedAction<ScopedParameterResolver>(){

                @Override
                public ScopedParameterResolver run() {
                    ChainedParameterResolver resolverChain = resolver == null ? new ChainedParameterResolver(new SystemPropertyParameterResolver(), new SystemEnvironmentParameterResolver()) : new ChainedParameterResolver(resolver, new SystemPropertyParameterResolver(), new SystemEnvironmentParameterResolver());
                    return new ScopedParameterResolver(new ChainedParameterResolver(resolverChain));
                }
            });
            SimpleResourceRegistry resourceRegistry = new SimpleResourceRegistry();
            Registry eventRegistry = new Registry();
            resourceRegistry.registerResource(InterceptorRegistry.class, eventRegistry);
            resourceRegistry.registerResource(EventDispatcherRegistry.class, eventRegistry);
            if (sScopeName != null) {
                resourceRegistry.registerResource(String.class, "scope-name", sScopeName);
            }
            if (context != null) {
                resourceRegistry.registerResource(Context.class, context);
            }
            resolverScoped.add(new Parameter("pof-config-uri", sPofConfigUri));
            XmlDocumentReference docRef = new XmlDocumentReference(xmlConfig.toString());
            XmlElement xmlOverride = ExtensibleConfigurableCacheFactory.findXmlOverride(xmlConfig, loader);
            DocumentProcessor.DefaultDependencies dependencies = new DocumentProcessor.DefaultDependencies(new CacheConfigNamespaceHandler());
            dependencies.setResourceRegistry(resourceRegistry);
            dependencies.setDefaultParameterResolver(resolverScoped);
            dependencies.setExpressionParser(ParameterMacroExpressionParser.INSTANCE);
            dependencies.setClassLoader(loader);
            DocumentProcessor processor = new DocumentProcessor(dependencies);
            if (xmlOverride != null) {
                XmlDocumentReference overrideRef = new XmlDocumentReference(xmlOverride.toString());
                cacheConfig = (CacheConfig)processor.process(docRef, overrideRef);
            } else {
                cacheConfig = (CacheConfig)processor.process(docRef, new XmlDocumentReference[0]);
            }
            InterceptorManager manager = new InterceptorManager(cacheConfig, loader, resourceRegistry);
            resourceRegistry.registerResource(InterceptorManager.class, manager);
            return new DefaultDependencies(cacheConfig, loader, resourceRegistry);
        }
    }

    public static class DefaultDependencies
    implements Dependencies {
        private CacheConfig m_cacheConfig;
        private ClassLoader m_contextClassLoader;
        private ResourceRegistry m_resourceRegistry;

        public DefaultDependencies(CacheConfig cacheConfig) {
            this(cacheConfig, cacheConfig.getClass().getClassLoader(), new SimpleResourceRegistry());
        }

        public DefaultDependencies(CacheConfig cacheConfig, ClassLoader contextClassLoader, ResourceRegistry registry) {
            Base.azzert(cacheConfig != null);
            Base.azzert(contextClassLoader != null);
            Base.azzert(registry != null);
            this.m_cacheConfig = cacheConfig;
            this.m_contextClassLoader = contextClassLoader;
            this.m_resourceRegistry = registry;
        }

        @Override
        public CacheConfig getCacheConfig() {
            return this.m_cacheConfig;
        }

        @Override
        public ClassLoader getContextClassLoader() {
            return this.m_contextClassLoader;
        }

        @Override
        public ResourceRegistry getResourceRegistry() {
            return this.m_resourceRegistry;
        }
    }
}

