/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.dev.tools.CommandLineTool;
import com.tangosol.net.DatagramPacketOutputStream;
import com.tangosol.net.DatagramSocketProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.SystemDatagramSocketProvider;
import com.tangosol.net.TcpDatagramSocket;
import com.tangosol.run.xml.SimpleDocument;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSocketFactory;

public class DatagramTest {
    public static final int MB = 0x100000;
    public static final String COMMAND_ADDR_LOCAL = "local";
    public static final int DEFAULT_PORT = 9999;
    public static final String DEFAULT_IP_LOCAL = "localhost";
    public static final String DEFAULT_ADDR_LOCAL = "localhost:9999";
    public static final String COMMAND_PACKET_SIZE = "packetSize";
    public static final int DEFAULT_PACKET_SIZE = 1468;
    public static final String COMMAND_PAYLOAD = "payload";
    public static final int DEFAULT_PAYLOAD = 0;
    public static final String COMMAND_TX_RATE = "txRate";
    public static final int DEFAULT_TX_RATE = -1;
    public static final String COMMAND_PROCESS_BYTES = "processBytes";
    public static final int DEFAULT_PROCESS_BYTES = 20;
    public static final String COMMAND_TX_PACKET_BUFFER_SIZE = "txBufferSize";
    public static final int DEFAULT_TX_PACKET_BUFFER_SIZE = 32;
    public static final String COMMAND_RX_PACKET_BUFFER_SIZE = "rxBufferSize";
    public static final int DEFAULT_RX_PACKET_BUFFER_SIZE = 1428;
    public static final String COMMAND_LOG = "log";
    public static final String DEFAULT_LOG = null;
    public static final String COMMAND_REPORT_INTERVAL = "reportInterval";
    public static final int DEFAULT_REPORT_INTERVAL = 100000;
    public static final String COMMAND_LOG_INTERVAL = "logInterval";
    public static final int DEFAULT_LOG_INTERVAL = 100000;
    public static final String COMMAND_TICK_INTERVAL = "tickInterval";
    public static final int DEFAULT_TICK_INTERVAL = 1000;
    public static final String COMMAND_TX_ITERATIONS = "txIterations";
    public static final int DEFAULT_TX_ITERATIONS = -1;
    public static final String COMMAND_TX_DURATION_MS = "txDurationMs";
    public static final long DEFAULT_TX_DURATION_MS = -1L;
    public static final String COMMAND_RX_TIMEOUT_MS = "rxTimeoutMs";
    public static final int DEFAULT_RX_TIMEOUT_MS = 1000;
    public static final String COMMAND_PROVIDER = "provider";
    public static final String DEFAULT_PROVIDER = "system";
    public static final String COMMAND_OPTIONS = "options";
    public static final String DEFAULT_OPTIONS = null;
    public static final String[] VALID_COMMANDS = new String[]{"local", "packetSize", "payload", "txRate", "processBytes", "txBufferSize", "rxBufferSize", "reportInterval", "log", "logInterval", "tickInterval", "txIterations", "txDurationMs", "rxTimeoutMs", "provider", "options"};
    public static final String SWITCH_HELP = "?";
    public static final String SWITCH_POLITE = "polite";
    public static final String SWITCH_RAND = "rand";
    public static final String[] VALID_SWITCHES = new String[]{"?", "polite", "rand"};
    public static final long s_ldtStart = System.currentTimeMillis();
    public static Method s_methodNano;
    public static final int MAGIC = 1952805748;
    public static final int MAGIC_MASK = -16;
    public static final boolean s_fSplitSocket;

    public static void main(String[] asArg) throws Exception {
        ArrayList<String> lArg = new ArrayList<String>(Arrays.asList(asArg));
        List lSwitches = DatagramTest.extractSwitches(lArg, VALID_SWITCHES);
        asArg = lArg.toArray(new String[lArg.size()]);
        if (lSwitches.contains(SWITCH_HELP)) {
            DatagramTest.showInstructions();
            return;
        }
        ListMap mapCmd = CommandLineTool.parseArguments(asArg, VALID_COMMANDS, true);
        List<InetSocketAddress> listBind = DatagramTest.parseAddresses((String)DatagramTest.processCommand(mapCmd, COMMAND_ADDR_LOCAL, DEFAULT_ADDR_LOCAL));
        for (InetSocketAddress addrLocal : listBind) {
            int cTimeoutMs;
            DatagramSocketProvider datagramSocketProvider;
            StartFlag startFlag = null;
            PublisherConfig pConfig = null;
            ListenerConfig lConfig = new ListenerConfig();
            try {
                Object sAddrValue;
                String sProvider = (String)DatagramTest.processCommand(mapCmd, COMMAND_PROVIDER, DEFAULT_PROVIDER);
                XmlDocument xml = new SimpleDocument("socket-provider");
                if (sProvider.equals("ssl")) {
                    String[] asCiphers;
                    XmlElement xmlCiphers = xml.addElement("ssl").addElement("cipher-suites");
                    for (String s : asCiphers = ((SSLSocketFactory)SSLSocketFactory.getDefault()).getSupportedCipherSuites()) {
                        xmlCiphers.addElement("name").setString(s);
                    }
                } else if (sProvider.startsWith("file:")) {
                    xml = XmlHelper.loadXml(new URL(sProvider));
                } else {
                    xml.addElement(sProvider);
                }
                int nMTU = InetAddressHelper.getLocalMTU(addrLocal.getAddress());
                if (nMTU == 0) {
                    nMTU = 1500;
                }
                int cbPacket = DatagramTest.processIntCommand(mapCmd, COMMAND_PACKET_SIZE, nMTU - ((datagramSocketProvider = new SocketProviderFactory().getDatagramSocketProvider(xml, 1)) instanceof SystemDatagramSocketProvider ? 48 : 68));
                lConfig.setPacketSize(cbPacket);
                lConfig.setPayload(DatagramTest.processIntCommand(mapCmd, COMMAND_PAYLOAD, 0));
                lConfig.setProcessPacketBytes(DatagramTest.processIntCommand(mapCmd, COMMAND_PROCESS_BYTES, 20));
                lConfig.setReportInterval(DatagramTest.processIntCommand(mapCmd, COMMAND_REPORT_INTERVAL, 100000));
                lConfig.setTickInterval(DatagramTest.processIntCommand(mapCmd, COMMAND_TICK_INTERVAL, 1000));
                lConfig.setBufferPackets(DatagramTest.processIntCommand(mapCmd, COMMAND_RX_PACKET_BUFFER_SIZE, 1428));
                String sLog = (String)DatagramTest.processCommand(mapCmd, COMMAND_LOG, DEFAULT_LOG);
                if (sLog != null) {
                    if (listBind.size() > 1) {
                        lConfig.setLog(addrLocal.getPort() + "-" + sLog);
                    } else {
                        lConfig.setLog(sLog);
                    }
                }
                lConfig.setLogInterval(DatagramTest.processIntCommand(mapCmd, COMMAND_LOG_INTERVAL, 100000));
                cTimeoutMs = DatagramTest.processIntCommand(mapCmd, COMMAND_RX_TIMEOUT_MS, 1000);
                ArrayList<InetSocketAddress> lAddrPeer = null;
                int i = 0;
                while ((sAddrValue = (String)mapCmd.get(i)) != null) {
                    if (lAddrPeer == null) {
                        lAddrPeer = new ArrayList<InetSocketAddress>();
                    }
                    lAddrPeer.addAll(DatagramTest.parseAddresses((String)sAddrValue));
                    ++i;
                }
                HashMap<InetSocketAddress, AtomicLong> mapAcks = new HashMap<InetSocketAddress, AtomicLong>();
                lConfig.setAckMap(mapAcks);
                if (lAddrPeer != null) {
                    sAddrValue = lAddrPeer.iterator();
                    while (sAddrValue.hasNext()) {
                        InetSocketAddress addr = (InetSocketAddress)sAddrValue.next();
                        mapAcks.put(addr, new AtomicLong(-1L));
                    }
                }
                if (lAddrPeer != null) {
                    pConfig = new PublisherConfig();
                    pConfig.setAckMap(mapAcks);
                    pConfig.setReturnPort(addrLocal.getPort());
                    pConfig.setAddrPeers(lAddrPeer.toArray(new InetSocketAddress[lAddrPeer.size()]));
                    pConfig.setPacketSize(cbPacket);
                    pConfig.setPayload(DatagramTest.processIntCommand(mapCmd, COMMAND_PAYLOAD, 0));
                    pConfig.setProcessPacketBytes(DatagramTest.processIntCommand(mapCmd, COMMAND_PROCESS_BYTES, 20));
                    pConfig.setReportInterval(DatagramTest.processIntCommand(mapCmd, COMMAND_REPORT_INTERVAL, 100000));
                    pConfig.setTickInterval(DatagramTest.processIntCommand(mapCmd, COMMAND_TICK_INTERVAL, 1000));
                    pConfig.setBufferPackets(DatagramTest.processIntCommand(mapCmd, COMMAND_TX_PACKET_BUFFER_SIZE, 32));
                    int cmbs = DatagramTest.processIntCommand(mapCmd, COMMAND_TX_RATE, -1);
                    pConfig.setRate(cmbs <= 0 ? 0 : Math.max(1, cmbs / listBind.size()));
                    pConfig.setIterationLimit(DatagramTest.processIntCommand(mapCmd, COMMAND_TX_ITERATIONS, -1));
                    pConfig.setDurationLimitMs(DatagramTest.processLongCommand(mapCmd, COMMAND_TX_DURATION_MS, -1L));
                    if (lSwitches.contains(SWITCH_POLITE)) {
                        startFlag = new StartFlag();
                    }
                }
                if (lSwitches.contains(SWITCH_RAND)) {
                    lConfig.setPayload(-lConfig.getPayload());
                    pConfig.setPayload(-pConfig.getPayload());
                }
                if (mapCmd.isEmpty()) {
                    DatagramTest.showInstructions();
                    Base.out();
                    Base.out("running with all default values...");
                    Base.out();
                }
            }
            catch (Throwable e) {
                Base.err();
                Base.err(e);
                Base.err();
                DatagramTest.showInstructions();
                return;
            }
            if (!DatagramTest.checkUnicast(addrLocal) || !lConfig.check() || pConfig != null && !pConfig.check()) {
                DatagramTest.showInstructions();
                return;
            }
            try {
                DatagramSocket sockSend;
                String sOptions;
                SocketOptions options;
                Base.out("creating datagram socket using provider: " + String.valueOf(datagramSocketProvider));
                final DatagramSocket socket = datagramSocketProvider.openDatagramSocket();
                if (socket instanceof TcpDatagramSocket) {
                    ((TcpDatagramSocket)socket).setPacketMagic(1952805748, -16);
                }
                SocketOptions socketOptions = options = (sOptions = (String)DatagramTest.processCommand(mapCmd, COMMAND_OPTIONS, DEFAULT_OPTIONS)) == null ? null : SocketOptions.load(XmlHelper.loadXml(new URL(sOptions)));
                if (options != null) {
                    Base.out("using socket options: " + String.valueOf(options));
                    SocketOptions.apply((java.net.SocketOptions)options, socket);
                }
                socket.bind(addrLocal);
                if (cTimeoutMs != 0) {
                    socket.setSoTimeout(cTimeoutMs);
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        socket.close();
                        System.out.println();
                    }
                });
                DatagramListener listener = new DatagramListener(socket, startFlag, lConfig);
                Thread thListener = Base.makeThread(null, listener, "TestListener:" + String.valueOf(addrLocal));
                thListener.setDaemon(pConfig != null);
                thListener.start();
                if (pConfig == null) continue;
                if (s_fSplitSocket) {
                    sockSend = datagramSocketProvider.openDatagramSocket();
                    if (sockSend instanceof TcpDatagramSocket) {
                        ((TcpDatagramSocket)sockSend).setPacketMagic(1952805748, -16);
                    }
                    SocketOptions.apply((java.net.SocketOptions)options, socket);
                    sockSend.bind(new InetSocketAddress(addrLocal.getAddress(), 0));
                } else {
                    sockSend = socket;
                }
                DatagramPublisher publisher = new DatagramPublisher(sockSend, startFlag, pConfig);
                Thread thPublisher = Base.makeThread(null, publisher, "TestPublisher:" + String.valueOf(addrLocal));
                long cDurationLimitMs = pConfig.getDurationLimitMs();
                thPublisher.setDaemon(cDurationLimitMs > 0L);
                thPublisher.start();
                if (cDurationLimitMs <= 0L) continue;
                if (startFlag != null) {
                    startFlag.waitForGo();
                }
                thPublisher.join(cDurationLimitMs);
            }
            catch (Exception e) {
                Base.err("[" + Base.formatDateTime(System.currentTimeMillis()) + "] An exception occurred while executing the DatagramTest:");
                Base.err(e);
            }
        }
    }

    public static List<InetSocketAddress> parseAddresses(String sAddrs) throws UnknownHostException {
        ArrayList<InetSocketAddress> listAddr = new ArrayList<InetSocketAddress>();
        StringTokenizer tok = new StringTokenizer(sAddrs);
        while (tok.hasMoreElements()) {
            int nPortEnd;
            String sTok = tok.nextToken();
            int of = sTok.indexOf("..");
            if (of == -1) {
                listAddr.add(InetAddressHelper.getSocketAddress(sTok, 9999));
                continue;
            }
            String sName = sTok.substring(0, of);
            int ofPort = Math.max(sName.lastIndexOf(46), sName.lastIndexOf(58));
            String sPrefix = sName.substring(0, ofPort + 1);
            int nPort = Integer.parseInt(sName.substring(ofPort + 1));
            if (nPort < (nPortEnd = Integer.parseInt(sTok.substring(of + 2)))) {
                while (nPort <= nPortEnd) {
                    listAddr.add(InetAddressHelper.getSocketAddress(sPrefix + nPort, 9999));
                    ++nPort;
                }
                continue;
            }
            while (nPort >= nPortEnd) {
                listAddr.add(InetAddressHelper.getSocketAddress(sPrefix + nPort, 9999));
                --nPort;
            }
        }
        return listAddr;
    }

    public static long nanoTime() {
        Method methodNano = s_methodNano;
        if (methodNano == null) {
            return (System.currentTimeMillis() - s_ldtStart) * 1000000L;
        }
        try {
            return (Long)methodNano.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected static List extractSwitches(Collection colArg, String[] asValidSwitch) {
        LinkedList<String> lResult = new LinkedList<String>();
        int c = asValidSwitch.length;
        for (int i = 0; i < c; ++i) {
            String sSwitch = "-" + asValidSwitch[i];
            Iterator iter = colArg.iterator();
            while (iter.hasNext()) {
                String sArg = (String)iter.next();
                if (!sArg.equals(sSwitch)) continue;
                lResult.add(asValidSwitch[i]);
                iter.remove();
            }
        }
        return lResult;
    }

    protected static Object processCommand(Map mapCommands, String sName) throws UnsupportedOperationException {
        Object value = mapCommands.get(sName);
        if (value == null) {
            throw new UnsupportedOperationException("-" + sName + " must be specified.");
        }
        return value;
    }

    protected static Object processCommand(Map mapCommands, String sName, Object oDefault) throws UnsupportedOperationException {
        Object value = mapCommands.get(sName);
        return value == null ? oDefault : value;
    }

    protected static int processIntCommand(Map mapCommands, String sName, int iDefault) throws UnsupportedOperationException {
        Object value = mapCommands.get(sName);
        return value == null ? iDefault : Integer.parseInt((String)value);
    }

    protected static int processIntCommand(Map mapCommands, String sName) throws UnsupportedOperationException {
        Object value = DatagramTest.processCommand(mapCommands, sName);
        return Integer.parseInt((String)value);
    }

    protected static long processLongCommand(Map mapCommands, String sName, long lDefault) throws UnsupportedOperationException {
        Object value = mapCommands.get(sName);
        return value == null ? lDefault : Long.parseLong((String)value);
    }

    public static boolean checkProcessPacketBytes(int cbPacket, int cProcessPacketBytes) {
        if (cProcessPacketBytes < 20 || cProcessPacketBytes % 4 != 0 || cProcessPacketBytes > cbPacket) {
            Base.err("processPacketBytes must be between 20 and the packet size, in multiples of 4.");
            return false;
        }
        return true;
    }

    private static boolean checkUnicast(InetSocketAddress addr) {
        InetAddress iAddr = addr.getAddress();
        if (iAddr != null && iAddr.isMulticastAddress()) {
            Base.err("Interface address " + String.valueOf(addr) + " is multi-cast; it must be an IP address bound to a physical interface");
            return false;
        }
        return true;
    }

    private static boolean checkUnicast(InetSocketAddress[] aAddr) {
        int c = aAddr.length;
        for (int i = 0; i < c; ++i) {
            if (DatagramTest.checkUnicast(aAddr[i])) continue;
            return false;
        }
        return true;
    }

    public static String computeThroughputMBPerSec(long cBytes, long lDurationMs) {
        if (lDurationMs == 0L) {
            return "NaN";
        }
        float flMBs = (float)cBytes / 1048576.0f;
        int iThpt = Math.round(flMBs / (float)lDurationMs * 1000.0f);
        return Integer.toString(iThpt) + " MB/sec";
    }

    public static String computeThroughputPacketsPerSec(long cPackets, long lDurationMs) {
        if (lDurationMs == 0L) {
            return "NaN";
        }
        int iThpt = Math.round((float)cPackets / (float)lDurationMs * 1000.0f);
        return Integer.toString(iThpt) + " packets/sec";
    }

    protected static void showInstructions() {
        Base.out();
        Base.out("java com.tangosol.net.DatagramTest <-local addr:port> [commands ...] [addr:port ...]");
        Base.out();
        Base.out("command option descriptions:");
        Base.out("\t-local          (optional) the local address to bind to, specified as addr:port[..port], default localhost:9999");
        Base.out("\t-packetSize     (optional) the size of packet to work with, specified in bytes, default based on local MTU and provider");
        Base.out("\t-payload        (optional) the amount of data to include in each packet, 0 to match packet size, default 0");
        Base.out("\t-processBytes   (optional) the number of bytes (in multiples of 4) of each packet to process, default 20");
        Base.out("\t-rxBufferSize   (optional) the size of the receive buffer, specified in packets, default 1428");
        Base.out("\t-rxTimeoutMs    (optional) the duration of inactivity before a connection is closed, default 1000");
        Base.out("\t-txBufferSize   (optional) the size of the transmit buffer, specified in packets, default 32");
        Base.out("\t-txRate         (optional) the rate at which to transmit data, specified in megabytes, default unlimited");
        Base.out("\t-txIterations   (optional) specifies the number of packets to publish before exiting, default unlimited");
        Base.out("\t-txDurationMs   (optional) specifies how long to publish before exiting, default unlimited");
        Base.out("\t-reportInterval (optional) the interval at which to output a report, specified in packets, default 100000");
        Base.out("\t-tickInterval   (optional) the interval at which to output tick marks, default 1000");
        Base.out("\t-log            (optional) the name of a file to save a tabular report of measured performance, default none");
        Base.out("\t-logInterval    (optional) the interval at which to output a measurement to the log, default 100000");
        Base.out("\t-polite         (optional) switch indicating if the publisher should wait for the listener to be contacted before publishing.");
        Base.out("\t-provider       (optional) the socket provider to use (system, tcp, ssl, file:xxx.xml), default system");
        Base.out("\targuments       (optional) space separated list of addresses to publish to, specified as addr:port[..port]");
        Base.out();
        Base.out("examples:");
        Base.out("java com.tangosol.net.DatagramTest -local box1:9999 -polite box2:9999");
        Base.out("java com.tangosol.net.DatagramTest -local box2:9999 box1:9000..9004");
    }

    static {
        try {
            s_methodNano = System.class.getMethod("nanoTime", new Class[0]);
        }
        catch (Exception e) {
            s_methodNano = null;
        }
        s_fSplitSocket = Boolean.parseBoolean(System.getProperty("tangosol.coherence.datagram.splitsocket", "true"));
    }

    public static class ListenerConfig
    extends TestConfiguration {
        protected String m_sLog;
        protected int m_cLogInterval;

        @Override
        public String toString() {
            return new StringBuffer(super.toString()).append('\n').append("        log: ").append(this.m_sLog).append('\n').append("     log on: ").append((long)this.m_cLogInterval * (long)this.m_cbPacket / 0x100000L).append(" MBs").toString();
        }

        public String getLog() {
            return this.m_sLog;
        }

        public void setLog(String sLog) {
            this.m_sLog = sLog;
        }

        public int getLogInterval() {
            return this.m_cLogInterval;
        }

        public void setLogInterval(int cLogInterval) {
            this.m_cLogInterval = cLogInterval;
        }
    }

    public static class PublisherConfig
    extends TestConfiguration {
        protected int m_nPortReturn;
        protected InetSocketAddress[] m_aAddrPeer;
        protected Map<InetSocketAddress, AtomicLong> m_mapAcks;
        protected int m_cRate;
        protected int m_cIterationLimit;
        protected long m_cDurationLimitMs;

        @Override
        public String toString() {
            return new StringBuffer(super.toString()).append('\n').append("      peers: ").append(this.m_aAddrPeer.length).append('\n').append("       rate: ").append(this.m_cRate > 0 ? Integer.toString(this.m_cRate) : "no limit").toString();
        }

        @Override
        public boolean check() {
            return super.check() & DatagramTest.checkUnicast(this.m_aAddrPeer);
        }

        public int getReturnPort() {
            return this.m_nPortReturn;
        }

        public void setReturnPort(int nPort) {
            this.m_nPortReturn = nPort;
        }

        public InetSocketAddress[] getAddrPeers() {
            return this.m_aAddrPeer;
        }

        public void setAddrPeers(InetSocketAddress[] aAddrPeer) {
            this.m_aAddrPeer = aAddrPeer;
        }

        public Map<InetSocketAddress, AtomicLong> getAckMap() {
            return this.m_mapAcks;
        }

        @Override
        public void setAckMap(Map<InetSocketAddress, AtomicLong> mapAcks) {
            this.m_mapAcks = mapAcks;
        }

        public int getRate() {
            return this.m_cRate;
        }

        public void setRate(int cRate) {
            this.m_cRate = cRate;
        }

        public int getIterationLimit() {
            return this.m_cIterationLimit;
        }

        public void setIterationLimit(int cIterations) {
            this.m_cIterationLimit = cIterations;
        }

        public long getDurationLimitMs() {
            return this.m_cDurationLimitMs;
        }

        public void setDurationLimitMs(long cDurationMs) {
            this.m_cDurationLimitMs = cDurationMs;
        }
    }

    protected static class StartFlag {
        protected volatile boolean m_fGo;

        protected StartFlag() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go() {
            StartFlag startFlag = this;
            synchronized (startFlag) {
                this.m_fGo = true;
                this.notifyAll();
            }
        }

        public void stop() {
            this.m_fGo = false;
        }

        public boolean isStopped() {
            return !this.m_fGo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForGo() throws InterruptedException {
            StartFlag startFlag = this;
            synchronized (startFlag) {
                while (!this.m_fGo) {
                    Blocking.wait(this);
                }
            }
        }
    }

    public static class DatagramListener
    implements Runnable {
        protected DatagramSocket m_socket;
        protected StartFlag m_startFlag;
        protected ListenerConfig m_config;
        protected PrintStream m_pstreamLog;

        public DatagramListener(DatagramSocket socket, StartFlag startFlag, ListenerConfig config) throws IOException {
            int cbBufferSize = config.m_cbPacket * config.m_cBufferPackets;
            socket.setReceiveBufferSize(cbBufferSize);
            int iRcvSize = socket.getReceiveBufferSize();
            if (iRcvSize < cbBufferSize) {
                throw new IllegalArgumentException("Receive buffer size setting was not accepted by the OS, the buffer is only " + iRcvSize + " bytes, or " + iRcvSize / config.m_cbPacket + " packets,  please increase your OS socket buffer limits or use the  -rxBufferSize test parameter to request a smaller buffer.");
            }
            String sLog = config.m_sLog;
            if (sLog != null) {
                if (sLog.equals("stdout")) {
                    this.m_pstreamLog = System.out;
                    this.logHeader();
                } else if (sLog.equals("stderr")) {
                    this.m_pstreamLog = System.err;
                    this.logHeader();
                } else {
                    File fLog = new File(sLog);
                    boolean fNewFile = !fLog.exists();
                    this.m_pstreamLog = new PrintStream(new FileOutputStream(fLog, true));
                    if (fNewFile) {
                        this.logHeader();
                    }
                }
            }
            this.m_config = config;
            this.m_startFlag = startFlag;
            this.m_socket = socket;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            socket = this.m_socket;
            cProcessPacketBytes = this.m_config.m_cProcessPacketBytes;
            cReportInterval = this.m_config.m_cReportInterval;
            cbPacket = this.m_config.m_cbPacket;
            cbPayload = this.m_config.m_cbPayload;
            mapAcks = this.m_config.m_mapAcks;
            fLifetime = System.getProperty("tangosol.datagramtest.lifetime", "true").equals("true");
            Base.out("starting listener: at " + String.valueOf(socket.getLocalSocketAddress()));
            Base.out(this.m_config);
            Base.out();
            try {
                cTickInterval = this.m_config.m_cTickInterval;
                cBigTickInterval = cTickInterval * 10;
                packet = new DatagramPacket(new byte[cbPacket], 0, cbPacket);
                startFlag = this.m_startFlag;
                bStream = new ByteArrayInputStream(packet.getData());
                stream = new DataInputStream(bStream);
                cRxPackets = 0;
                mapLifeTracker = new HashMap<InetSocketAddress, PacketTracker>();
                mapNowTracker = new HashMap<InetSocketAddress, PacketTracker>();
                cLogInterval = this.m_config.getLogInterval();
                block4: while (true) {
                    try {
                        socket.receive(packet);
                    }
                    catch (InterruptedIOException e) {
                        if (mapLifeTracker.size() <= 0) continue;
                        Base.out("\nClients have stopped.");
                        PacketTracker.generateReport("Lifetime:", mapLifeTracker);
                        this.log(mapLifeTracker);
                        mapLifeTracker.clear();
                        mapNowTracker.clear();
                        cRxPackets = 0;
                        startFlag = this.m_startFlag;
                        if (startFlag == null) continue;
                        startFlag.stop();
                        continue;
                    }
                    ++cRxPackets;
                    bStream.reset();
                    if (startFlag != null) {
                        startFlag.go();
                        startFlag = null;
                    }
                    addrSender = (InetSocketAddress)packet.getSocketAddress();
                    nMagic = stream.readInt();
                    if (nMagic != 1952805748) {
                        Base.out("the packet contains a corrupted header: " + nMagic);
                        continue;
                    }
                    nReturnPort = stream.readInt();
                    lifeTracker = (PacketTracker)mapLifeTracker.get(addrSender);
                    nowTracker = (PacketTracker)mapNowTracker.get(addrSender);
                    if (lifeTracker == null) {
                        addrReturn = new InetSocketAddress(addrSender.getAddress(), nReturnPort);
                        addrBind = (InetSocketAddress)socket.getLocalSocketAddress();
                        lifeTracker = new PacketTracker(addrBind, addrReturn, (AtomicLong)mapAcks.get(addrReturn));
                        nowTracker = new PacketTracker(addrBind, addrReturn, (AtomicLong)mapAcks.get(addrReturn));
                        mapLifeTracker.put(addrSender, lifeTracker);
                        mapNowTracker.put(addrSender, nowTracker);
                        Base.out("\n" + String.valueOf(addrBind) + " receiving data from " + mapLifeTracker.size() + " publisher(s).");
                    }
                    ldtSentNanos = stream.readLong();
                    ldtAckNanos = stream.readLong();
                    nCurrent = stream.readLong();
                    nBytes = cbPayload < 0 ? packet.getLength() : Math.min(cbPayload, packet.getLength());
                    lifeTracker.trackArrival(nCurrent, ldtSentNanos, ldtAckNanos, nBytes);
                    nowTracker.trackArrival(nCurrent, ldtSentNanos, ldtAckNanos, nBytes);
                    nProcess = cProcessPacketBytes < nBytes ? cProcessPacketBytes : nBytes;
                    c = nProcess / 4;
                    for (i = 7; i < c; ++i) {
                        n = stream.readLong();
                        if (n == nCurrent) continue;
                        if (n == 0L) {
                            if (cRxPackets % 10000 != 0) break;
                            Base.out("the packet is not full, configure publisher to process the same number of bytes");
                            break;
                        }
                        Base.err("corrupted packet from " + String.valueOf(addrSender) + " at i=" + i + ", n=" + n + ", nCurrent=" + nCurrent);
                        break;
                    }
                    if (cTickInterval != 0 && cRxPackets % cTickInterval == 0) {
                        System.out.print(cRxPackets % cBigTickInterval == 0 ? 'I' : 'i');
                        System.out.flush();
                    }
                    if (cLogInterval != 0 && cRxPackets % cLogInterval == 0) {
                        this.log(mapNowTracker);
                    }
                    if (cReportInterval == 0 || cRxPackets % cReportInterval != 0) continue;
                    if (fLifetime) {
                        PacketTracker.generateReport("Lifetime:", mapLifeTracker);
                    }
                    PacketTracker.generateReport("Now:", mapNowTracker);
                    iter = mapNowTracker.values().iterator();
                    while (true) {
                        if (iter.hasNext()) ** break;
                        continue block4;
                        ((PacketTracker)iter.next()).reset(System.currentTimeMillis());
                    }
                    break;
                }
            }
            catch (Exception e) {
                Base.err("[" + Base.formatDateTime(System.currentTimeMillis()) + "] test encountered exception:");
                Base.err(e);
                return;
            }
        }

        protected void logHeader() {
            this.m_pstreamLog.println(PacketTracker.getTabularReportHeader());
        }

        protected void log(Map mapTracker) {
            Iterator iter = mapTracker.values().iterator();
            while (iter.hasNext()) {
                this.log((PacketTracker)iter.next());
            }
        }

        protected void log(PacketTracker tracker) {
            if (this.m_pstreamLog != null) {
                this.m_pstreamLog.println(tracker.getTabularReport());
            }
        }
    }

    public static class DatagramPublisher
    implements Runnable {
        protected DatagramSocket m_socket;
        protected PublisherConfig m_config;
        protected StartFlag m_startFlag;

        public DatagramPublisher(DatagramSocket socket, StartFlag startFlag, PublisherConfig config) throws IOException {
            socket.setSendBufferSize(config.getPacketSize() * config.getBufferPackets());
            this.m_config = config;
            this.m_socket = socket;
            this.m_startFlag = startFlag;
        }

        public static void writeLong(byte[] aBytes, long lValue, int i) {
            int n = (int)(lValue >>> 32);
            aBytes[i++] = (byte)(n >>> 24);
            aBytes[i++] = (byte)(n >>> 16);
            aBytes[i++] = (byte)(n >>> 8);
            aBytes[i++] = (byte)n;
            n = (int)lValue;
            aBytes[i++] = (byte)(n >>> 24);
            aBytes[i++] = (byte)(n >>> 16);
            aBytes[i++] = (byte)(n >>> 8);
            aBytes[i++] = (byte)n;
        }

        @Override
        public void run() {
            InetSocketAddress[] aAddrPeer = this.m_config.getAddrPeers();
            AtomicLong[] aAtomicAcks = new AtomicLong[aAddrPeer.length];
            int cPeer = aAddrPeer.length;
            int cbPacket = this.m_config.getPacketSize();
            int cbPayload = this.m_config.getPayload();
            int cReportInterval = this.m_config.getReportInterval();
            int cProcessPacketBytes = this.m_config.getProcessPacketBytes();
            int cRate = this.m_config.getRate();
            StartFlag startFlag = this.m_startFlag;
            DatagramSocket socket = this.m_socket;
            int nReturnPort = this.m_config.getReturnPort();
            StringBuffer sbAddrs = new StringBuffer();
            for (int i = 0; i < cPeer; ++i) {
                if (i > 0) {
                    sbAddrs.append(", ");
                }
                sbAddrs.append(aAddrPeer[i].toString());
                aAtomicAcks[i] = this.m_config.getAckMap().get(aAddrPeer[i]);
            }
            Base.out("starting publisher: at " + String.valueOf(socket.getLocalSocketAddress()) + " sending to " + String.valueOf(sbAddrs));
            Base.out(this.m_config);
            Base.out();
            int cRateBytes = cRate * 0x100000;
            int cAvgPacket = cbPayload < 0 ? cbPacket + cbPayload / 2 : cbPayload;
            int iPktsPerSecond = Math.round((float)cRateBytes / (float)cAvgPacket);
            int iBurstPackets = iPktsPerSecond / 100;
            if (cRateBytes > 0) {
                Base.out("setting packet burst to " + iBurstPackets);
            } else {
                Base.out("no packet burst limit");
            }
            byte[] aBytes = new byte[cbPacket];
            DatagramPacket packet = new DatagramPacket(aBytes, 0, cbPacket);
            DatagramPacketOutputStream streamPacket = new DatagramPacketOutputStream(packet);
            try {
                DataOutputStream stream = new DataOutputStream(streamPacket);
                try {
                    long lStart;
                    long cTxPackets = 0L;
                    long cTxBytes = 0L;
                    long cTickInterval = this.m_config.getTickInterval();
                    long cBigTickInterval = cTickInterval * 10L;
                    long lLastRateCheckTime = lStart = System.currentTimeMillis();
                    long lLastReportTime = lStart;
                    long cThisReportTxBytes = 0L;
                    long cThisReportTxPackets = 0L;
                    int cIterationLimit = this.m_config.getIterationLimit();
                    Random random = new Random();
                    int cInts = cbPacket / 4;
                    for (int i = 0; i < cInts; ++i) {
                        stream.writeInt(i);
                    }
                    stream.flush();
                    streamPacket.reset();
                    int iIter = 1;
                    while (true) {
                        int nBytes;
                        if (startFlag != null && startFlag.isStopped()) {
                            Base.out("waiting for listener to be contacted before publishing");
                            try {
                                this.m_startFlag.waitForGo();
                            }
                            catch (InterruptedException e) {
                                Base.err("Interrupted while waiting to start publishing");
                                stream.close();
                                return;
                            }
                        }
                        if (cIterationLimit > 0 && iIter % cIterationLimit == 0) {
                            Base.out("iteration limit reached");
                            return;
                        }
                        stream.writeInt(1952805748);
                        stream.writeInt(nReturnPort);
                        cInts = cProcessPacketBytes / 4;
                        for (int i = 0; i < cInts; ++i) {
                            stream.writeInt(iIter);
                        }
                        stream.flush();
                        if (cbPayload < 0) {
                            nBytes = cbPacket - random.nextInt(-cbPayload);
                            packet.setLength(nBytes);
                        } else {
                            nBytes = cbPayload;
                            packet.setLength(cbPacket);
                        }
                        for (int i = 0; i < cPeer; ++i) {
                            long lNow;
                            packet.setAddress(aAddrPeer[i].getAddress());
                            packet.setPort(aAddrPeer[i].getPort());
                            DatagramPublisher.writeLong(aBytes, DatagramTest.nanoTime(), 8);
                            DatagramPublisher.writeLong(aBytes, aAtomicAcks[i].getAndSet(-1L), 16);
                            socket.send(packet);
                            ++cThisReportTxPackets;
                            cTxBytes += (long)nBytes;
                            cThisReportTxBytes += (long)nBytes;
                            if (cTickInterval != 0L && ++cTxPackets % cTickInterval == 0L) {
                                System.out.print(cTxPackets % cBigTickInterval == 0L ? (char)'O' : 'o');
                                System.out.flush();
                            }
                            if (cReportInterval != 0 && cTxPackets % (long)cReportInterval == 0L) {
                                lNow = System.currentTimeMillis();
                                long lDuration = lNow - lStart;
                                long lLastDuration = lNow - lLastReportTime;
                                StringBuffer sbReport = new StringBuffer();
                                sbReport.append("\nTx summary for ").append(this.m_socket.getLocalAddress()).append(":").append(this.m_config.getReturnPort()).append(" to ").append(cPeer).append(" peers:").append("\n   life: ").append(DatagramTest.computeThroughputMBPerSec(cTxBytes, lDuration)).append(", ").append(DatagramTest.computeThroughputPacketsPerSec(cTxPackets, lDuration)).append("\n    now: ").append(DatagramTest.computeThroughputMBPerSec(cThisReportTxBytes, lLastDuration)).append(", ").append(DatagramTest.computeThroughputPacketsPerSec(cThisReportTxPackets, lLastDuration)).append("\n     duration: ").append(lDuration).append("ms").append("\n    completed: ").append(Base.formatDateTime(lNow));
                                if (cRateBytes > 0) {
                                    sbReport.append(", packets/burst: ").append(iBurstPackets).append(", bursts/second: ").append((float)iPktsPerSecond / (float)iBurstPackets);
                                }
                                Base.out(sbReport.toString());
                                lLastReportTime = lNow;
                                cThisReportTxPackets = 0L;
                                cThisReportTxBytes = 0L;
                            }
                            if (cRateBytes <= 0) continue;
                            if (cTxPackets % (long)iBurstPackets == 0L) {
                                try {
                                    Blocking.sleep(1L);
                                    int c = aAtomicAcks.length;
                                    for (int j = 0; j < c; ++j) {
                                        aAtomicAcks[j].set(-1L);
                                    }
                                }
                                catch (InterruptedException j) {
                                    // empty catch block
                                }
                            }
                            if (cTxPackets % (long)iPktsPerSecond != 0L) continue;
                            lNow = System.currentTimeMillis();
                            long lDelta = lNow - lLastRateCheckTime;
                            lLastRateCheckTime = lNow;
                            float flPct = (float)lDelta / 1000.0f;
                            iBurstPackets = Math.round((float)iBurstPackets * flPct);
                        }
                        streamPacket.reset();
                        ++iIter;
                    }
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
            catch (Exception e) {
                Base.out("[" + Base.formatDateTime(System.currentTimeMillis()) + "] test encountered exception:");
                Base.out(e);
                return;
            }
        }
    }

    protected static class PacketTracker {
        protected SocketAddress m_addrBind;
        protected SocketAddress m_addrSender;
        protected AtomicLong m_atomicAckOut;
        protected long m_cPacketsRcvd;
        protected long m_lStartTime;
        protected long m_lLastPacketArrivalTime;
        protected long m_nMin;
        protected long m_nMax;
        protected long m_nNext;
        protected int m_cOutOfOrder;
        protected int m_cTotalOutOfOrderOffset;
        protected long m_cBytesReceived;
        protected long m_cGaps;
        protected long m_cGapPackets;
        protected long m_cGapMillis;
        protected long m_lDeltaRttNanos;
        protected long m_cAcksIn;

        public PacketTracker(InetSocketAddress addrBind, InetSocketAddress addrSender, AtomicLong atomicAckOut) {
            this.m_addrBind = addrBind;
            this.m_addrSender = addrSender;
            this.m_atomicAckOut = atomicAckOut;
            this.reset(System.currentTimeMillis());
        }

        public void trackArrival(long nCurrent, long ldtSentNanos, long ldtAckNanos, int cBytes) {
            long ldtNow = System.currentTimeMillis();
            AtomicLong atomicAckOut = this.m_atomicAckOut;
            if (atomicAckOut != null) {
                atomicAckOut.set(ldtSentNanos);
                if (ldtAckNanos != -1L) {
                    this.m_lDeltaRttNanos += DatagramTest.nanoTime() - ldtAckNanos;
                    ++this.m_cAcksIn;
                }
            }
            ++this.m_cPacketsRcvd;
            if (this.m_cPacketsRcvd == 1L) {
                this.m_nMin = this.m_nMax = nCurrent;
            } else if (nCurrent > this.m_nMax) {
                this.m_nMax = nCurrent;
            } else if (nCurrent < this.m_nMin) {
                this.m_nMin = nCurrent;
            }
            if (this.m_cPacketsRcvd > 1L) {
                if (nCurrent < this.m_nNext) {
                    ++this.m_cOutOfOrder;
                    this.m_cTotalOutOfOrderOffset = (int)((long)this.m_cTotalOutOfOrderOffset + Math.abs(this.m_cPacketsRcvd - (nCurrent - this.m_nMin + 1L)));
                } else if (nCurrent > this.m_nNext) {
                    ++this.m_cGaps;
                    this.m_cGapPackets += nCurrent - this.m_nNext;
                    this.m_cGapMillis += ldtNow - this.m_lLastPacketArrivalTime;
                }
            }
            this.m_lLastPacketArrivalTime = ldtNow;
            this.m_nNext = this.m_nMax + 1L;
            this.m_cBytesReceived += (long)cBytes;
        }

        public void reset(long lTimeMs) {
            this.m_cPacketsRcvd = 0L;
            this.m_lStartTime = lTimeMs;
            this.m_lLastPacketArrivalTime = lTimeMs;
            this.m_nMin = 0L;
            this.m_nMax = -1L;
            this.m_nNext = 0L;
            this.m_cOutOfOrder = 0;
            this.m_cTotalOutOfOrderOffset = 0;
            this.m_cBytesReceived = 0L;
            this.m_cGaps = 0L;
            this.m_cGapPackets = 0L;
            this.m_cGapMillis = 0L;
            this.m_lDeltaRttNanos = 0L;
            this.m_cAcksIn = 0L;
        }

        public long computeDurationMillis() {
            return this.m_lLastPacketArrivalTime - this.m_lStartTime;
        }

        public long computeRttNanos() {
            long cAcksIn = this.m_cAcksIn;
            return cAcksIn == 0L ? -1L : this.m_lDeltaRttNanos / cAcksIn;
        }

        public long computeSentPackets() {
            return this.m_nMax - this.m_nMin + 1L;
        }

        public long computeMissingPackets() {
            return this.computeSentPackets() - this.m_cPacketsRcvd;
        }

        public long computeAverageOutOfOrderOffset() {
            return this.m_cOutOfOrder == 0 ? 0 : this.m_cTotalOutOfOrderOffset / this.m_cOutOfOrder;
        }

        public float computeSuccessRate() {
            long cSent = this.computeSentPackets();
            if (cSent == 0L) {
                return 0.0f;
            }
            return (float)this.m_cPacketsRcvd / (float)this.computeSentPackets();
        }

        public int computeThroughputMBPerSec() {
            long lDuration = this.computeDurationMillis();
            if (lDuration == 0L) {
                return -1;
            }
            float flMBs = (float)this.m_cBytesReceived / 1048576.0f;
            return Math.round(flMBs / (float)lDuration * 1000.0f);
        }

        public int computeThroughputPacketsPerSec() {
            long lDuration = this.computeDurationMillis();
            if (lDuration == 0L) {
                return -1;
            }
            return Math.round((float)this.m_cPacketsRcvd / (float)lDuration * 1000.0f);
        }

        public int computeAveragePacketSize() {
            if (this.m_cPacketsRcvd == 0L) {
                return 0;
            }
            return (int)(this.m_cBytesReceived / this.m_cPacketsRcvd);
        }

        public static String getTabularReportHeader() {
            return new StringBuffer().append("publisher\t").append("duration ms\t").append("packet size\t").append("throughput mb/sec\t").append("throughput packets/sec\t").append("sent packets\t").append("received packets\t").append("missing packets\t").append("success rate\t").append("out of order\t").append("avg out of order offset\t").append("gaps\t").append("avg gap size\t").append("avg gap time ms\t").append("avg ack ms").toString();
        }

        public String getTabularReport() {
            return new StringBuffer().append(this.m_addrSender).append('\t').append(this.computeDurationMillis()).append('\t').append(this.computeAveragePacketSize()).append('\t').append(this.computeThroughputMBPerSec()).append('\t').append(this.computeThroughputPacketsPerSec()).append('\t').append(this.computeSentPackets()).append('\t').append(this.m_cPacketsRcvd).append('\t').append(this.computeMissingPackets()).append('\t').append(this.computeSuccessRate()).append('\t').append(this.m_cOutOfOrder).append('\t').append(this.computeAverageOutOfOrderOffset()).append('\t').append(this.m_cGaps).append('\t').append(this.m_cGapPackets / Math.max(1L, this.m_cGaps)).append('\t').append(this.m_cGapMillis / Math.max(1L, this.m_cGaps)).append('\t').append((double)this.computeRttNanos() / 1000000.0).append('\t').toString();
        }

        public String toString() {
            long lDurationMs = this.computeDurationMillis();
            long cSent = this.computeSentPackets();
            long cRttNanos = this.computeRttNanos();
            return new StringBuffer().append("Rx from publisher: ").append(this.m_addrSender).append("\n\t to listener: ").append(this.m_addrBind).append("\n\t     elapsed: ").append(lDurationMs).append("ms").append("\n\t packet size: ").append(this.computeAveragePacketSize()).append("\n\t  throughput: ").append(DatagramTest.computeThroughputMBPerSec(this.m_cBytesReceived, lDurationMs)).append("\n\t              ").append(DatagramTest.computeThroughputPacketsPerSec(this.m_cPacketsRcvd, lDurationMs)).append("\n\t    received: ").append(this.m_cPacketsRcvd).append(" of ").append(cSent).append("\n\t     missing: ").append(this.computeMissingPackets()).append("\n\tsuccess rate: ").append(this.computeSuccessRate()).append("\n\tout of order: ").append(this.m_cOutOfOrder).append("\n\t  avg offset: ").append(this.computeAverageOutOfOrderOffset()).append("\n\t        gaps: ").append(this.m_cGaps).append("\n\tavg gap size: ").append(this.m_cGapPackets / Math.max(1L, this.m_cGaps)).append("\n\tavg gap time: ").append(this.m_cGapMillis / Math.max(1L, this.m_cGaps)).append("ms").append("\n\tavg ack time: ").append((double)cRttNanos / 1000000.0).append("ms; acks ").append(this.m_cAcksIn).toString();
        }

        public static String toString(PacketTracker[] aTracker) {
            long lStartTime = Long.MAX_VALUE;
            long lLastTime = 0L;
            long cBytes = 0L;
            int cOutOfOrder = 0;
            int cTotalOutOfOrderOffset = 0;
            long cRcvd = 0L;
            long cSent = 0L;
            long cGaps = 0L;
            int cGapPackets = 0;
            int cGapMillis = 0;
            long cAcks = 0L;
            long lDeltaRttNanos = 0L;
            int c = aTracker.length;
            for (int i = 0; i < c; ++i) {
                PacketTracker tracker = aTracker[i];
                if (tracker.m_lStartTime < lStartTime) {
                    lStartTime = tracker.m_lStartTime;
                }
                if (tracker.m_lLastPacketArrivalTime > lLastTime) {
                    lLastTime = tracker.m_lLastPacketArrivalTime;
                }
                cSent += tracker.m_nMax - tracker.m_nMin + 1L;
                cRcvd += tracker.m_cPacketsRcvd;
                cBytes += tracker.m_cBytesReceived;
                cOutOfOrder += tracker.m_cOutOfOrder;
                cTotalOutOfOrderOffset += tracker.m_cTotalOutOfOrderOffset;
                cGaps += tracker.m_cGaps;
                cGapPackets = (int)((long)cGapPackets + tracker.m_cGapPackets);
                cGapMillis = (int)((long)cGapMillis + tracker.m_cGapMillis);
                cAcks += tracker.m_cAcksIn;
                lDeltaRttNanos += tracker.m_lDeltaRttNanos;
            }
            long lDurationMs = lLastTime - lStartTime;
            long iAvgOffset = (long)cTotalOutOfOrderOffset / cRcvd;
            String sThptMB = DatagramTest.computeThroughputMBPerSec(cBytes, lDurationMs);
            String sThptPk = DatagramTest.computeThroughputPacketsPerSec(cRcvd, lDurationMs);
            long cRttNanos = cAcks == 0L ? -1L : lDeltaRttNanos / cAcks;
            return new StringBuffer().append("Rx Summary from " + aTracker.length + " publisher(s): ").append("\n\t     elapsed: ").append(lDurationMs).append("ms").append("\n\t  throughput: ").append(sThptMB).append("\n\t              ").append(sThptPk).append("\n\t    received: ").append(cRcvd).append(" of ").append(cSent).append("\n\t     missing: ").append(cSent - cRcvd).append("\n\tsuccess rate: ").append((float)cRcvd / (float)cSent).append("\n\tout of order: ").append(cOutOfOrder).append("\n\t  avg offset: ").append(iAvgOffset).append("\n\t        gaps: ").append(cGaps).append("\n\tavg gap size: ").append((long)cGapPackets / Math.max(1L, cGaps)).append("\n\tavg gap time: ").append((long)cGapMillis / Math.max(1L, cGaps)).append("ms").append("\n\tavg ack time: ").append((double)cRttNanos / 1000000.0).append("ms; acks ").append(cAcks).append("\n\t   completed: ").append(Base.formatDateTime(System.currentTimeMillis())).toString();
        }

        public static void generateReport(String sPeriod, Map mapTracker) {
            Base.out();
            Base.out(sPeriod);
            for (Map.Entry entry : mapTracker.entrySet()) {
                Base.out(String.valueOf(entry.getValue()) + "\n");
            }
            if (mapTracker.size() > 1) {
                Base.out(PacketTracker.toString(mapTracker.values().toArray(new PacketTracker[0])));
            }
            Base.out("\n completed: " + Base.formatDateTime(System.currentTimeMillis()));
        }
    }

    public static class TestConfiguration {
        protected int m_cReportInterval;
        protected int m_cTickInterval;
        protected int m_cbPacket;
        protected int m_cbPayload;
        protected int m_cProcessPacketBytes;
        protected int m_cBufferPackets;
        protected Map<InetSocketAddress, AtomicLong> m_mapAcks;

        public String toString() {
            return new StringBuffer().append("packet size: ").append(this.m_cbPacket).append(" bytes").append('\n').append("buffer size: ").append(this.m_cBufferPackets).append(" packets").append('\n').append("  report on: ").append(this.m_cReportInterval).append(" packets, ").append((long)this.m_cReportInterval * (long)this.m_cbPacket / 0x100000L).append(" MBs").append('\n').append("    process: ").append(this.m_cProcessPacketBytes).append(" bytes/packet").toString();
        }

        public boolean check() {
            return DatagramTest.checkProcessPacketBytes(this.m_cbPacket, this.m_cProcessPacketBytes);
        }

        public int getReportInterval() {
            return this.m_cReportInterval;
        }

        public void setReportInterval(int cReportInterval) {
            this.m_cReportInterval = cReportInterval;
        }

        public int getTickInterval() {
            return this.m_cTickInterval;
        }

        public void setTickInterval(int cTickInterval) {
            this.m_cTickInterval = cTickInterval;
        }

        public int getPacketSize() {
            return this.m_cbPacket;
        }

        public void setPacketSize(int cbPacket) {
            this.m_cbPacket = cbPacket;
        }

        public int getPayload() {
            return this.m_cbPayload;
        }

        public void setPayload(int cbPayload) {
            if (cbPayload == 0) {
                cbPayload = this.m_cbPacket;
            } else if (cbPayload > this.m_cbPacket) {
                throw new IllegalArgumentException("Payload cannot exceed packet size.");
            }
            this.m_cbPayload = cbPayload;
        }

        public int getProcessPacketBytes() {
            return this.m_cProcessPacketBytes;
        }

        public void setProcessPacketBytes(int cProcessPacketBytes) {
            this.m_cProcessPacketBytes = cProcessPacketBytes;
        }

        public int getBufferPackets() {
            return this.m_cBufferPackets;
        }

        public void setBufferPackets(int cBufferPackets) {
            this.m_cBufferPackets = cBufferPackets;
        }

        public void setAckMap(Map<InetSocketAddress, AtomicLong> mapAcks) {
            this.m_mapAcks = mapAcks;
        }
    }
}

