/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.DescribableAddressProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.RefreshableAddressProvider;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ConfigurableAddressProvider
extends AbstractSet
implements DescribableAddressProvider {
    protected List<AddressHolder> m_listHolders;
    protected Iterator<InetSocketAddress> m_iterAddr;
    protected int m_iLast = -1;
    protected boolean m_fSafe;
    @Deprecated
    public boolean m_fResolve;

    @Deprecated
    public ConfigurableAddressProvider(XmlElement xmlConfig) {
        this(xmlConfig, true);
    }

    public ConfigurableAddressProvider(Iterable<AddressHolder> addressHolders, boolean fSafe) {
        ArrayList<AddressHolder> listHolders = new ArrayList<AddressHolder>();
        for (AddressHolder holder : addressHolders) {
            String sHost = holder.getHost();
            if (sHost.contains(",")) {
                Arrays.stream(sHost.split(",")).map(String::trim).forEach(s -> listHolders.add(new AddressHolder((String)s, holder.getPort())));
                continue;
            }
            listHolders.add(holder);
        }
        this.m_fSafe = fSafe;
        this.m_listHolders = this.sortHolders(listHolders);
    }

    @Deprecated
    public ConfigurableAddressProvider(XmlElement xmlConfig, boolean fSafe) {
        this.configure(xmlConfig);
        this.m_fSafe = fSafe;
    }

    @Deprecated
    public static AddressProvider makeProvider(XmlElement xmlConfig) {
        ConfigurableAddressProvider ap = new ConfigurableAddressProvider(xmlConfig);
        return ap.m_fResolve ? new RefreshableAddressProvider(ap) : ap;
    }

    @Override
    public synchronized InetSocketAddress getNextAddress() {
        InetSocketAddress address;
        List<AddressHolder> list = this.m_listHolders;
        int cItems = list.size();
        if (cItems == 0) {
            return null;
        }
        Iterator<InetSocketAddress> iterAddr = this.m_iterAddr;
        int iLast = this.m_iLast;
        boolean fSafe = this.m_fSafe;
        AddressHolder holder = null;
        while (true) {
            if (iterAddr == null || !iterAddr.hasNext()) {
                this.m_iLast = (iLast + 1) % cItems;
                holder = list.get(iLast = this.m_iLast);
                if (holder.isPending()) {
                    this.reset();
                    return null;
                }
                holder.setPending(true);
                iterAddr = this.m_iterAddr = this.resolveAddress(holder.getHost(), holder.getPort());
                continue;
            }
            address = iterAddr.next();
            if (fSafe && address.isUnresolved()) {
                if (holder != null && !holder.isReported()) {
                    holder.setReported(true);
                    Base.log("The ConfigurableAddressProvider is skipping the unresolvable address \"" + String.valueOf(address) + "\".");
                }
                address = null;
            }
            if (address != null) break;
        }
        return address;
    }

    @Override
    public void accept() {
        this.reset(this.m_iLast);
    }

    @Override
    public void reject(Throwable eCause) {
    }

    @Override
    public int size() {
        return this.m_listHolders.size();
    }

    @Override
    public Iterator iterator() {
        return new Iterator<InetSocketAddress>(){
            private final Iterator<AddressHolder> f_iterHolder;
            private Iterator<InetSocketAddress> m_iterAddr;
            {
                this.f_iterHolder = ConfigurableAddressProvider.this.m_listHolders.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.m_iterAddr != null && this.m_iterAddr.hasNext() || this.f_iterHolder.hasNext();
            }

            @Override
            public InetSocketAddress next() {
                Iterator<InetSocketAddress> iterAddr = this.m_iterAddr;
                if (iterAddr != null && iterAddr.hasNext()) {
                    return iterAddr.next();
                }
                AddressHolder holder = this.f_iterHolder.next();
                iterAddr = this.m_iterAddr = ConfigurableAddressProvider.this.resolveAddress(holder.getHost(), holder.getPort());
                return iterAddr.next();
            }

            @Override
            public void remove() {
                this.f_iterHolder.remove();
                this.m_iterAddr = null;
            }
        };
    }

    protected void reset() {
        this.reset(-1);
    }

    protected synchronized void reset(int iLast) {
        List<AddressHolder> list = this.m_listHolders;
        int c = list.size();
        for (int i = 0; i < c; ++i) {
            list.get(i).setPending(false);
        }
        this.m_iterAddr = null;
        this.m_iLast = iLast;
    }

    @Deprecated
    protected void configure(XmlElement xmlConfig) {
        ArrayList<AddressHolder> list = new ArrayList<AddressHolder>();
        block11: for (XmlElement xmlAddr : xmlConfig.getElementList()) {
            String[] saAddresses;
            int nPort;
            String sAddr;
            switch (xmlAddr.getName()) {
                case "socket-address": {
                    if (xmlConfig.getName().equalsIgnoreCase("well-known-addresses")) {
                        Logger.warn("The use of <socket-address> for the <well-known-addresses> element is deprecated and the <port> value is ignored. Use <address> instead.");
                    }
                    sAddr = xmlAddr.getSafeElement("address").getString().trim();
                    nPort = xmlAddr.getSafeElement("port").getInt();
                    break;
                }
                case "host-address": 
                case "address": {
                    sAddr = xmlAddr.getString().trim();
                    nPort = 0;
                    break;
                }
                default: {
                    continue block11;
                }
            }
            for (String sAddress : saAddresses = (String[])Arrays.stream(sAddr.split(",")).map(String::trim).toArray(String[]::new)) {
                if (sAddress.isEmpty()) continue;
                this.m_fResolve |= InetAddressHelper.isHostName(sAddress);
                try {
                    list.add(new AddressHolder(sAddress, nPort).validate());
                }
                catch (RuntimeException e) {
                    throw Base.ensureRuntimeException(e, "Invalid configuration element: " + String.valueOf(xmlAddr));
                }
            }
        }
        this.m_listHolders = this.sortHolders(list);
    }

    protected List sortHolders(List list) {
        return Base.randomize(list);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ConfigurableAddressProvider)) {
            return false;
        }
        ConfigurableAddressProvider that = (ConfigurableAddressProvider)o;
        List<AddressHolder> listThis = this.m_listHolders;
        List<AddressHolder> listThat = that.m_listHolders;
        if (listThat.size() != listThis.size()) {
            return false;
        }
        Iterator<AddressHolder> iter = listThis.iterator();
        while (iter.hasNext()) {
            if (listThat.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int nHash = 0;
        for (AddressHolder h : this.m_listHolders) {
            nHash += Objects.hash(h);
        }
        return nHash;
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer().append('[');
        Iterator<AddressHolder> iter = this.m_listHolders.iterator();
        while (iter.hasNext()) {
            AddressHolder holder = iter.next();
            sb.append(holder.getHost()).append(':').append(holder.getPort());
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public synchronized String[] getAddressDescriptions() {
        List<AddressHolder> holders = this.m_listHolders;
        String[] asAddr = new String[holders.size()];
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (AddressHolder holder : holders) {
            sb.append(holder.getHost()).append(':').append(holder.getPort());
            asAddr[i++] = sb.toString();
            sb.setLength(0);
        }
        return asAddr;
    }

    protected synchronized Iterator<InetSocketAddress> resolveAddress(final String sHost, final int nPort) {
        try {
            return new Iterator<InetSocketAddress>(){
                final InetAddress[] f_aAddr;
                int m_iAddr;
                {
                    InetAddress[] inetAddressArray;
                    if ("localhost".equals(sHost)) {
                        InetAddress[] inetAddressArray2 = new InetAddress[1];
                        inetAddressArray = inetAddressArray2;
                        inetAddressArray2[0] = InetAddressHelper.getLocalAddress(sHost);
                    } else {
                        inetAddressArray = (InetAddress[])Base.randomize(InetAddress.getAllByName(sHost));
                    }
                    this.f_aAddr = inetAddressArray;
                }

                @Override
                public boolean hasNext() {
                    return this.m_iAddr < this.f_aAddr.length;
                }

                @Override
                public InetSocketAddress next() {
                    if (this.hasNext()) {
                        return new InetSocketAddress(this.f_aAddr[this.m_iAddr++], nPort);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (UnknownHostException e) {
            return Collections.singleton(new InetSocketAddress(sHost, nPort)).iterator();
        }
    }

    public static class AddressHolder {
        protected String m_sHost;
        protected int m_nPort;
        private boolean m_fPending;
        private boolean m_fReported;

        public AddressHolder(String sHost, int nPort) {
            this.m_sHost = sHost;
            this.m_nPort = nPort;
        }

        public AddressHolder validate() {
            if (this.m_sHost == null) {
                throw new IllegalArgumentException("host may not be null");
            }
            if (this.m_nPort < 0 || this.m_nPort > 65535) {
                throw new IllegalArgumentException("port " + this.m_nPort + " out of range of 0 to 65535");
            }
            return this;
        }

        protected boolean isPending() {
            return this.m_fPending;
        }

        protected void setPending(boolean fPending) {
            this.m_fPending = fPending;
        }

        protected boolean isReported() {
            return this.m_fReported;
        }

        protected void setReported(boolean fReported) {
            this.m_fReported = fReported;
        }

        protected String getHost() {
            return this.m_sHost;
        }

        protected int getPort() {
            return this.m_nPort;
        }

        public boolean equals(Object o) {
            if (o instanceof AddressHolder) {
                AddressHolder that = (AddressHolder)o;
                return this.m_nPort == that.m_nPort && Base.equals(this.m_sHost, that.m_sHost);
            }
            return false;
        }

        public int hashCode() {
            return Base.hashCode(this.m_sHost) ^ this.m_nPort;
        }
    }
}

