/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.internal.SocketAddressHelper;
import com.tangosol.util.ClassHelper;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.LinkedList;

public class CompositeSocketAddressProvider
implements SocketAddressProvider {
    private final LinkedList<SocketAddressProvider> m_listProviders = new LinkedList();
    private Iterator<SocketAddressProvider> m_iterInternal;
    private SocketAddressProvider m_currentProvider;

    public CompositeSocketAddressProvider(SocketAddress address) {
        this.addAddress(address);
    }

    public CompositeSocketAddressProvider(SocketAddressProvider provider) {
        this.addProvider(provider);
    }

    public void addAddress(SocketAddress address) {
        this.m_listProviders.add(new SingleAddressProvider(address));
    }

    public void addProvider(SocketAddressProvider provider) {
        this.m_listProviders.add(provider);
    }

    private SocketAddressProvider getCurrentProvider() {
        SocketAddressProvider provider = this.m_currentProvider;
        if (provider == null) {
            provider = this.m_currentProvider = this.getNextProvider();
        }
        return provider;
    }

    private SocketAddressProvider getNextProvider() {
        SocketAddressProvider provider;
        Iterator<SocketAddressProvider> iter = this.m_iterInternal;
        if (iter == null) {
            iter = this.m_listProviders.iterator();
        }
        if ((provider = (this.m_currentProvider = iter.hasNext() ? iter.next() : null)) == null) {
            iter = null;
        }
        this.m_iterInternal = iter;
        return provider;
    }

    @Override
    public void accept() {
        SocketAddressProvider provider = this.getCurrentProvider();
        if (provider != null) {
            provider.accept();
        }
    }

    @Override
    public void reject(Throwable eCause) {
        SocketAddressProvider provider = this.getCurrentProvider();
        if (provider != null) {
            provider.reject(eCause);
        }
    }

    @Override
    public SocketAddress getNextAddress() {
        SocketAddressProvider provider = this.getCurrentProvider();
        while (provider != null) {
            SocketAddress address = provider.getNextAddress();
            if (address != null) {
                return address;
            }
            provider = this.getNextProvider();
        }
        return null;
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{Providers=" + String.valueOf(this.m_listProviders) + "}";
    }

    private class SingleAddressProvider
    implements SocketAddressProvider {
        private SocketAddress m_Address;
        private boolean m_fAddressGiven;

        public SingleAddressProvider(SocketAddress address) {
            this.m_Address = address;
            this.m_fAddressGiven = false;
        }

        @Override
        public void accept() {
        }

        @Override
        public SocketAddress getNextAddress() {
            this.m_fAddressGiven = !this.m_fAddressGiven;
            return this.m_fAddressGiven ? this.m_Address : null;
        }

        @Override
        public void reject(Throwable eCause) {
        }

        public String toString() {
            return "Address=" + SocketAddressHelper.toString(this.m_Address);
        }
    }
}

