/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.application.Context;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.events.EventInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;

public interface CoherenceConfiguration {
    public static Builder builder() {
        return new Builder().discoverSessions();
    }

    public static CoherenceConfiguration create() {
        return CoherenceConfiguration.builder().withSession(SessionConfiguration.defaultSession()).discoverSessions().build();
    }

    public String getName();

    public Map<String, SessionConfiguration> getSessionConfigurations();

    public Iterable<EventInterceptor<?>> getInterceptors();

    default public Optional<Context> getApplicationContext() {
        return Optional.empty();
    }

    default public String getDefaultSessionName() {
        return "";
    }

    public static class Builder {
        private String m_sName;
        private String m_sDefaultSession = "";
        private boolean m_fDiscoverSessions = true;
        private final Map<String, SessionConfiguration> f_mapConfig = new HashMap<String, SessionConfiguration>();
        private final List<EventInterceptor<?>> f_listInterceptor = new ArrayList();
        private Context m_context;

        public Builder named(String sName) {
            this.m_sName = sName;
            return this;
        }

        public Builder withDefaultSession(String sName) {
            if (sName != null) {
                if (!sName.equals("") && !this.f_mapConfig.containsKey(sName)) {
                    throw new IllegalArgumentException("A Session with the name " + sName + " has not been added to this configuration");
                }
                this.m_sDefaultSession = sName;
            }
            return this;
        }

        public Builder discoverSessions() {
            return this.discoverSessions(true);
        }

        public Builder discoverSessions(boolean f) {
            this.m_fDiscoverSessions = f;
            return this;
        }

        public Builder withSession(SessionConfiguration config) {
            this.withSession(config, this.f_mapConfig);
            return this;
        }

        private void withSession(SessionConfiguration config, Map<String, SessionConfiguration> map) {
            if (config != null && config.isEnabled()) {
                String sName = config.getName();
                if (sName == null) {
                    throw new IllegalArgumentException("A session configuration must provide a non-null name");
                }
                map.put(sName, config);
            }
        }

        public Builder withSessions(Iterable<? extends SessionConfiguration> configs) {
            for (SessionConfiguration sessionConfiguration : configs) {
                this.withSession(sessionConfiguration);
            }
            return this;
        }

        public Builder withSessions(SessionConfiguration ... configs) {
            for (SessionConfiguration configuration : configs) {
                this.withSession(configuration);
            }
            return this;
        }

        public Builder withEventInterceptor(EventInterceptor<?> interceptor) {
            this.f_listInterceptor.add(interceptor);
            return this;
        }

        public Builder withEventInterceptors(EventInterceptor<?> ... interceptors) {
            Collections.addAll(this.f_listInterceptor, interceptors);
            return this;
        }

        public Builder withEventInterceptors(Iterable<? extends EventInterceptor<?>> interceptors) {
            for (EventInterceptor<?> interceptor : interceptors) {
                this.f_listInterceptor.add(interceptor);
            }
            return this;
        }

        public Builder withApplicationContext(Context context) {
            this.m_context = context;
            return this;
        }

        public CoherenceConfiguration build() {
            HashMap<String, SessionConfiguration> mapConfig = new HashMap<String, SessionConfiguration>();
            if (this.m_fDiscoverSessions) {
                for (SessionConfiguration configuration : ServiceLoader.load(SessionConfiguration.class)) {
                    this.withSession(configuration, mapConfig);
                }
            }
            mapConfig.putAll(this.f_mapConfig);
            if (mapConfig.isEmpty()) {
                SessionConfiguration cfgDefault = SessionConfiguration.defaultSession();
                mapConfig.put(cfgDefault.getName(), cfgDefault);
            }
            return new SimpleConfig(this, mapConfig);
        }
    }

    public static class SimpleConfig
    implements CoherenceConfiguration {
        private final String f_sName;
        private final Map<String, SessionConfiguration> f_mapConfig;
        private final List<EventInterceptor<?>> f_listInterceptor;
        private final Context f_context;
        private final String f_sDefaultSession;

        private SimpleConfig(Builder builder, Map<String, SessionConfiguration> mapConfig) {
            this.f_sName = builder.m_sName == null || builder.m_sName.trim().isEmpty() ? "" : builder.m_sName.trim();
            this.f_mapConfig = Collections.unmodifiableMap(new HashMap<String, SessionConfiguration>(mapConfig));
            this.f_listInterceptor = Collections.unmodifiableList(new ArrayList(builder.f_listInterceptor));
            this.f_context = builder.m_context;
            this.f_sDefaultSession = builder.m_sDefaultSession == null ? "" : builder.m_sDefaultSession;
        }

        @Override
        public String getName() {
            return this.f_sName;
        }

        @Override
        public Map<String, SessionConfiguration> getSessionConfigurations() {
            return this.f_mapConfig;
        }

        @Override
        public Iterable<EventInterceptor<?>> getInterceptors() {
            return this.f_listInterceptor;
        }

        @Override
        public Optional<Context> getApplicationContext() {
            return Optional.ofNullable(this.f_context);
        }

        @Override
        public String getDefaultSessionName() {
            return this.f_sDefaultSession;
        }
    }
}

