/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.base.Timeout;
import com.oracle.coherence.common.collections.ConcurrentHashMap;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.application.ContainerContext;
import com.tangosol.application.Context;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.internal.health.HealthCheckWrapper;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.internal.net.SystemSessionConfiguration;
import com.tangosol.internal.net.metrics.MetricsHttpHelper;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheFactoryBuilder;
import com.tangosol.net.Cluster;
import com.tangosol.net.CoherenceConfiguration;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultCacheServer;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceMonitor;
import com.tangosol.net.Session;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.SessionProvider;
import com.tangosol.net.SimpleServiceMonitor;
import com.tangosol.net.events.CoherenceDispatcher;
import com.tangosol.net.events.CoherenceLifecycleEvent;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.internal.CoherenceEventDispatcher;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.CopyOnWriteMap;
import com.tangosol.util.HealthCheck;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SimpleResourceRegistry;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Coherence
implements AutoCloseable {
    public static final String SYS_CCF_URI = "coherence-system-config.xml";
    public static final String SYSTEM_SCOPE = "$SYS";
    public static final String SYSTEM_SESSION = "$SYS";
    public static final String DEFAULT_SCOPE = "";
    public static final String DEFAULT_NAME = "";
    public static final String PROP_START_TIMEOUT = "coherence.startup.timeout";
    public static final Duration DEFAULT_START_TIMEOUT = new Duration(5, Duration.Magnitude.MINUTE);
    private static final Map<ClassLoader, Map<String, Coherence>> s_mapByLoader = new CopyOnWriteMap<ClassLoader, Map<String, Coherence>>(WeakHashMap.class);
    private static final Lock s_instanceLock = new ReentrantLock();
    private static final Lock s_globalSystemSessionLock = new ReentrantLock();
    private static Optional<ConfigurableCacheFactorySession> s_systemSession;
    private static ServiceMonitor s_systemServiceMonitor;
    private final Lock m_localSystemSessionLock = new ReentrantLock();
    private SessionConfiguration m_localSystemSessionConfig;
    private Optional<ConfigurableCacheFactorySession> m_localSystemSession;
    private ServiceMonitor m_localSystemServiceMonitor;
    private static Boolean s_fEnsuredCluster;
    private final String f_sName;
    private final ResourceRegistry f_registry;
    private final CoherenceEventDispatcher f_dispatcher;
    private final CoherenceConfiguration f_config;
    private final Map<String, SessionConfiguration> f_mapAdditionalSessionConfig = new ConcurrentHashMap<String, SessionConfiguration>();
    private final Map<String, PriorityHolder> f_mapServer = new HashMap<String, PriorityHolder>();
    private final Map<String, Session> f_mapSession = new CopyOnWriteMap<String, Session>(new HashMap());
    private final HealthCheckWrapper f_health;
    private volatile boolean m_fStarted = false;
    private volatile boolean m_fClosed = false;
    private final CompletableFuture<Coherence> f_futureStarted = new CompletableFuture();
    private final CompletableFuture<Void> f_futureClosed = new CompletableFuture();
    private final Mode f_mode;
    private final ReentrantLock f_lockMetrics = new ReentrantLock();
    private MetricsServiceMonitor m_metricsMonitor;

    private Coherence(CoherenceConfiguration config, Mode mode) {
        this.f_config = Objects.requireNonNull(config);
        this.f_mode = mode;
        this.f_sName = config.getName();
        this.f_registry = new SimpleResourceRegistry();
        this.f_dispatcher = new CoherenceEventDispatcher(this);
        this.f_health = new HealthCheckWrapper(new CoherenceHealth(), "Coherence");
        com.tangosol.net.events.internal.Registry eventRegistry = new com.tangosol.net.events.internal.Registry();
        this.f_registry.registerResource(InterceptorRegistry.class, eventRegistry);
        this.f_registry.registerResource(EventDispatcherRegistry.class, eventRegistry);
        eventRegistry.registerEventDispatcher(this.f_dispatcher);
        for (EventInterceptor<?> interceptor : this.f_config.getInterceptors()) {
            eventRegistry.registerEventInterceptor(interceptor);
        }
        for (LifecycleListener listener : ServiceLoader.load(LifecycleListener.class)) {
            eventRegistry.registerEventInterceptor(listener);
        }
    }

    public static Coherence create() {
        return Coherence.builder(CoherenceConfiguration.create(), Mode.ClusterMember).build(true);
    }

    public static Coherence create(CoherenceConfiguration config) {
        return Coherence.create(config, Mode.ClusterMember);
    }

    public static Coherence create(CoherenceConfiguration config, Mode mode) {
        return Coherence.create(config, mode, null);
    }

    public static Coherence create(CoherenceConfiguration config, Mode mode, ClassLoader loader) {
        return Coherence.builder(config, mode).build(loader);
    }

    public static Builder builder(CoherenceConfiguration config) {
        return Coherence.clusterMemberBuilder(config);
    }

    public static Builder builder(CoherenceConfiguration config, Mode mode) {
        return new Builder(config, mode);
    }

    public static Coherence clusterMember() {
        return Coherence.clusterMemberBuilder(CoherenceConfiguration.create()).build(true);
    }

    public static Coherence clusterMember(CoherenceConfiguration config) {
        return Coherence.clusterMemberBuilder(config).build();
    }

    public static Coherence client() {
        return Coherence.clientBuilder(CoherenceConfiguration.create()).build(true);
    }

    public static Coherence client(Mode mode) {
        return Coherence.clientBuilder(CoherenceConfiguration.create(), mode).build(true);
    }

    public static Coherence client(CoherenceConfiguration config) {
        return Coherence.clientBuilder(config).build();
    }

    public static Coherence fixedClient() {
        return Coherence.fixedClientBuilder(CoherenceConfiguration.create()).build(true);
    }

    public static Coherence fixedClient(CoherenceConfiguration config) {
        return Coherence.fixedClientBuilder(config).build();
    }

    public static Builder clusterMemberBuilder(CoherenceConfiguration config) {
        return new Builder(config, Mode.ClusterMember);
    }

    public static Builder clientBuilder(CoherenceConfiguration config) {
        Mode mode = Mode.Client;
        String sClient = Config.getProperty("coherence.client");
        try {
            mode = Mode.fromClientName(sClient);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Coherence.clientBuilder(config, mode);
    }

    public static Builder clientBuilder(CoherenceConfiguration config, Mode mode) {
        return new Builder(config, mode);
    }

    public static Builder fixedClientBuilder(CoherenceConfiguration config) {
        return new Builder(config, Mode.ClientFixed);
    }

    public static Collection<Coherence> getInstances() {
        return Coherence.getInstances(Classes.ensureClassLoader(null));
    }

    public static Collection<Coherence> getInstances(ClassLoader loader) {
        Map<String, Coherence> map = Coherence.getInstanceMap(loader);
        return map == null ? Collections.emptyList() : Collections.unmodifiableCollection(new ArrayList<Coherence>(map.values()));
    }

    private static Map<String, Coherence> getInstanceMap() {
        return Coherence.getInstanceMap(null);
    }

    private static Map<String, Coherence> getInstanceMap(ClassLoader loader) {
        Map<String, Coherence> mapInstances;
        ClassLoader loaderSearch = Classes.ensureClassLoader(loader);
        Map<ClassLoader, Map<String, Coherence>> map = s_mapByLoader;
        while ((mapInstances = map.get(loaderSearch)) == null && (loaderSearch = loaderSearch.getParent()) != null) {
        }
        if (mapInstances == null) {
            mapInstances = map.get(Coherence.class.getClassLoader());
        }
        return mapInstances;
    }

    private static Map<String, Coherence> ensureInstanceMap(ClassLoader loader) {
        Map mapInstance = Coherence.getInstanceMap(loader = Classes.ensureClassLoader(loader));
        if (mapInstance == null) {
            s_instanceLock.lock();
            try {
                mapInstance = Coherence.getInstanceMap(loader);
                if (mapInstance == null) {
                    mapInstance = s_mapByLoader.computeIfAbsent(loader, l -> new LinkedHashMap());
                }
            }
            finally {
                s_instanceLock.unlock();
            }
        }
        return mapInstance;
    }

    protected static void removeInstance(String sName) {
        Coherence.removeInstance(sName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeInstance(String sName, ClassLoader loader) {
        s_instanceLock.lock();
        try {
            Map<String, Coherence> mapInstance;
            ClassLoader loaderSearch = Classes.ensureClassLoader(loader);
            Map<ClassLoader, Map<String, Coherence>> map = s_mapByLoader;
            while ((mapInstance = map.get(loaderSearch)) == null && (loaderSearch = loaderSearch.getParent()) != null) {
            }
            if (mapInstance != null) {
                mapInstance.remove(sName);
                if (mapInstance.isEmpty()) {
                    map.remove(loaderSearch);
                }
            }
        }
        finally {
            s_instanceLock.unlock();
        }
    }

    public static Coherence getInstance(String sName) {
        return Coherence.getInstance(sName, null);
    }

    public static Coherence getInstance(String sName, ClassLoader loader) {
        Map<String, Coherence> map = Coherence.getInstanceMap(loader);
        return sName == null || map == null ? null : map.get(sName);
    }

    public static Coherence getInstance() {
        return Coherence.getInstance((ClassLoader)null);
    }

    public static Coherence getInstance(ClassLoader loader) {
        Map<String, Coherence> map = Coherence.getInstanceMap(loader);
        if (map == null) {
            return null;
        }
        Coherence coherence = map.get("");
        if (coherence != null) {
            return coherence;
        }
        return map.entrySet().stream().findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public static Optional<Session> findSession(String sName) {
        Map<String, Coherence> map = Coherence.getInstanceMap();
        if (map != null) {
            for (Coherence coherence : map.values()) {
                Session session;
                if (!coherence.hasSession(sName) || (session = coherence.getSession(sName)) == null) continue;
                return Optional.of(session);
            }
        }
        return Optional.empty();
    }

    public static Collection<Session> findSessionsByScope(String sScope) {
        Collection<Object> col = null;
        if ("$SYS".equals(sScope)) {
            col = s_systemSession.map(Session.class::cast).map(Collections::singleton).orElse(null);
        }
        if (col == null) {
            Map<String, Coherence> map = Coherence.getInstanceMap();
            col = map != null ? (Collection)map.values().stream().flatMap(coh -> coh.getSessionsWithScope(sScope).stream()).collect(Collectors.toList()) : Collections.emptyList();
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Logger.info("Stopping all Coherence instances");
        Map<String, Coherence> map = Coherence.getInstanceMap();
        if (map != null) {
            ArrayList<Coherence> list = new ArrayList<Coherence>(map.values());
            list.forEach(Coherence::close);
            list.clear();
        }
        if (s_systemServiceMonitor != null) {
            s_systemServiceMonitor.close();
        }
        if (s_systemSession != null && s_systemSession.isPresent()) {
            ConfigurableCacheFactorySession session = s_systemSession.get();
            CacheFactoryBuilder builder = CacheFactory.getCacheFactoryBuilder();
            ConfigurableCacheFactory ccf = session.getConfigurableCacheFactory();
            try {
                session.close();
            }
            catch (Exception e) {
                Logger.err(e);
            }
            finally {
                builder.release(ccf);
                ccf.dispose();
            }
        }
        Logger.info("All Coherence instances stopped");
        s_systemServiceMonitor = null;
        s_systemSession = null;
        if (s_fEnsuredCluster != null && s_fEnsuredCluster.booleanValue()) {
            CacheFactory.shutdown();
        }
        s_fEnsuredCluster = null;
    }

    public String getName() {
        return this.f_sName;
    }

    public Mode getMode() {
        return this.f_mode;
    }

    public CoherenceConfiguration getConfiguration() {
        return this.f_config;
    }

    public boolean hasSession(String sName) {
        if ("$SYS".equals(sName)) {
            return this.m_localSystemSession != null && this.m_localSystemSession.isPresent();
        }
        SessionConfiguration configuration = this.getSessionConfiguration(sName);
        return configuration != null && configuration.isEnabled();
    }

    public Set<String> getSessionNames() {
        return Collections.unmodifiableSet(this.f_mapSession.keySet());
    }

    public Set<String> getSessionScopeNames() {
        return this.f_mapSession.values().stream().map(Session::getScopeName).collect(Collectors.toSet());
    }

    public Session getSession() {
        return this.getSession("");
    }

    public Optional<Session> getSessionIfPresent(String sName) {
        this.assertNotClosed();
        return this.getSessionInternal(sName);
    }

    public Session getSession(String sName) {
        this.assertNotClosed();
        String sSessionName = sName == null ? "" : sName;
        return this.getSessionInternal(sName).orElseThrow(() -> new IllegalArgumentException("No Session has been configured with the name " + sSessionName));
    }

    public synchronized Coherence addSession(SessionConfiguration config) {
        this.assertNotClosed();
        String sName = config.getName();
        if (this.hasSession(sName)) {
            throw new IllegalStateException("A Session with the name '" + sName + "' already exists in this Coherence instance '" + this.getName() + "'");
        }
        return this.addSessionInternal(config);
    }

    public Coherence addSessionIfAbsent(SessionConfiguration config) {
        return this.addSessionIfAbsent(config.getName(), () -> config);
    }

    public synchronized Coherence addSessionIfAbsent(String sName, Supplier<SessionConfiguration> supplier) {
        this.assertNotClosed();
        if (this.hasSession(sName)) {
            return this;
        }
        SessionConfiguration config = supplier.get();
        if (!Objects.equals(sName, config.getName())) {
            throw new IllegalArgumentException("The configuration name '" + config.getName() + "' does not match the name argument '" + sName + "'");
        }
        return this.addSessionInternal(config);
    }

    private Coherence addSessionInternal(SessionConfiguration config) {
        Coherence.validate(config);
        this.f_mapAdditionalSessionConfig.put(config.getName(), config);
        if (this.isStarted()) {
            Iterable<EventInterceptor<?>> globalInterceptors = this.f_config.getInterceptors();
            this.startSession(config, globalInterceptors);
        }
        return this;
    }

    public Collection<Session> getSessionsWithScope(String sScope) {
        this.assertNotClosed();
        String sScopeName = sScope == null || "".equals(sScope) ? this.f_config.getApplicationContext().map(Context::getDefaultScope).orElse("") : sScope;
        if (this.m_localSystemSession.isPresent()) {
            Session session = this.m_localSystemSession.get();
            if ("$SYS".equals(sScope) || session.getScopeName().equals(sScope)) {
                return Collections.singletonList(session);
            }
        }
        return this.getSessionConfigurations().filter(cfg -> sScopeName.equals(cfg.getScopeName())).map(SessionConfiguration::getName).map(this::getSession).collect(Collectors.toList());
    }

    public CompletableFuture<Coherence> whenStarted() {
        return this.f_futureStarted;
    }

    public CompletableFuture<Void> whenClosed() {
        return this.f_futureClosed;
    }

    public boolean isStarted() {
        return this.m_fStarted && !this.m_fClosed;
    }

    public boolean isClosed() {
        return this.m_fClosed;
    }

    public Coherence startAndWait() throws InterruptedException {
        return this.startAndWait(DEFAULT_START_TIMEOUT);
    }

    public Coherence startAndWait(Duration timeout) throws InterruptedException {
        long cMillis = timeout == null ? DEFAULT_START_TIMEOUT.as(Duration.Magnitude.MILLI) : Math.max(1L, timeout.as(Duration.Magnitude.MILLI));
        try (Timeout ignored = Timeout.after(cMillis);){
            this.start(true);
        }
        return this;
    }

    public CompletableFuture<Coherence> start() {
        return this.start(false);
    }

    public void startOnCallingThread() {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Coherence> start(boolean fRunOnCallingThread) {
        this.assertNotClosed();
        if (this.m_fStarted) {
            return this.f_futureStarted;
        }
        Coherence coherence = this;
        synchronized (coherence) {
            this.assertNotClosed();
            if (this.m_fStarted) {
                return this.f_futureStarted;
            }
            this.f_dispatcher.dispatchStarting();
            try {
                Runnable runnable = () -> {
                    ContainerContext context = this.f_config.getApplicationContext().map(Context::getContainerContext).orElse(null);
                    if (context != null) {
                        ContainerContext contextCurrent = context.getCurrentThreadContext();
                        if (contextCurrent == null || !contextCurrent.getDomainPartition().equals(context.getDomainPartition())) {
                            throw new IllegalStateException("start() called out of context");
                        }
                        if (!context.isGlobalDomainPartition()) {
                            context = context.getGlobalContext();
                            context.setCurrentThreadContext();
                        } else {
                            context = null;
                        }
                    }
                    try {
                        if (this.f_mapServer.isEmpty()) {
                            this.startInternal();
                        }
                        this.f_mapServer.values().forEach(holder -> holder.getServer().waitForServiceStart());
                        this.m_fStarted = true;
                        this.f_futureStarted.complete(this);
                        this.f_dispatcher.dispatchStarted();
                    }
                    catch (Throwable thrown) {
                        Logger.err(thrown);
                        this.f_futureStarted.completeExceptionally(thrown);
                    }
                    finally {
                        if (context != null) {
                            context.resetCurrentThreadContext();
                        }
                    }
                };
                if (fRunOnCallingThread) {
                    runnable.run();
                } else {
                    Thread t = Base.makeThread(null, runnable, (String)(this.isDefaultInstance() ? "Coherence" : "Coherence:" + this.f_sName));
                    t.setDaemon(true);
                    t.start();
                }
            }
            catch (Throwable thrown) {
                this.f_futureStarted.completeExceptionally(thrown);
            }
        }
        return this.f_futureStarted;
    }

    public boolean isActive() {
        return this.m_fStarted && !this.m_fClosed;
    }

    @Override
    public synchronized void close() {
        if (this.m_fClosed) {
            return;
        }
        this.f_dispatcher.dispatchStopping();
        this.m_fClosed = true;
        try {
            Coherence.removeInstance(this.f_sName);
            if (this.m_fStarted) {
                this.m_fStarted = false;
                this.f_mapServer.values().stream().sorted(Comparator.reverseOrder()).map(PriorityHolder::getServer).forEach(this::stopServer);
                this.f_mapServer.clear();
                this.getSessionConfigurations().sorted(Comparator.reverseOrder()).forEach(cfg -> {
                    Session session = this.f_mapSession.get(cfg.getName());
                    if (session != null) {
                        try {
                            session.close();
                            if (this.isNotGarSession((SessionConfiguration)cfg)) {
                                ConfigurableCacheFactory ccf;
                                cfg.sessionProvider().ifPresent(p -> p.releaseSession(session));
                                if (session instanceof ConfigurableCacheFactorySession && (ccf = ((ConfigurableCacheFactorySession)session).getConfigurableCacheFactory()).isActive()) {
                                    ccf.dispose();
                                }
                            }
                        }
                        catch (Throwable t) {
                            Logger.err("Error closing session " + session.getName(), t);
                        }
                    }
                });
                if (this.f_mode == Mode.Gar) {
                    this.m_localSystemServiceMonitor.close();
                    if (this.m_localSystemSession.isPresent()) {
                        try {
                            ConfigurableCacheFactorySession session = this.m_localSystemSession.get();
                            session.getConfigurableCacheFactory().dispose();
                            session.close();
                            SessionProvider provider = this.m_localSystemSessionConfig.sessionProvider().orElseGet(SessionProvider::get);
                            provider.releaseSession(session);
                        }
                        catch (Exception e) {
                            Logger.err(e);
                        }
                    }
                }
                this.m_localSystemSession = null;
                this.m_localSystemServiceMonitor = null;
            }
            this.getCluster().getManagement().unregister(this.f_health);
            this.f_futureClosed.complete(null);
        }
        catch (Throwable thrown) {
            Logger.err(thrown);
            this.f_futureClosed.completeExceptionally(thrown);
        }
        this.stopMetrics();
        this.f_dispatcher.dispatchStopped();
        this.f_registry.dispose();
    }

    private boolean isNotGarSession(SessionConfiguration configuration) {
        return this.f_mode != Mode.Gar || !configuration.getName().equals(this.f_sName);
    }

    public ResourceRegistry getResourceRegistry() {
        return this.f_registry;
    }

    public InterceptorRegistry getInterceptorRegistry() {
        return this.f_registry.getResource(InterceptorRegistry.class);
    }

    public Cluster getCluster() {
        return CacheFactory.getCluster();
    }

    public Registry getManagement() {
        return this.getCluster().getManagement();
    }

    public static void main(String[] args) {
        boolean fShowVersion = false;
        for (String sArg : args) {
            if ("--version".equals(sArg)) {
                fShowVersion = true;
                continue;
            }
            if (sArg.endsWith(".xml")) {
                CacheFactory.getCacheFactoryBuilder().setCacheConfiguration(null, XmlHelper.loadFileOrResource(sArg, "cache configuration", null));
                continue;
            }
            if (sArg.endsWith(".gar") || sArg.contains(File.separator) || ".".equals(sArg)) {
                throw new IllegalArgumentException("Invalid argument " + sArg + " running a GAR is not supported in CE");
            }
            if (!Pattern.matches("[0-9]*", sArg)) continue;
        }
        if (fShowVersion) {
            System.out.println(CacheFactory.VERSION);
            if (args.length == 1) {
                System.exit(0);
            }
        }
        String sClient = Config.getProperty("coherence.client");
        Mode mode = null;
        try {
            mode = Mode.fromClientName(sClient);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Coherence coherence = mode == null ? Coherence.clusterMember() : Coherence.builder(CoherenceConfiguration.create(), mode).build();
        coherence.start();
        coherence.whenClosed().join();
    }

    public String toString() {
        return "Coherence{name='" + this.f_sName + "', mode='" + String.valueOf((Object)this.f_mode) + "', started='" + this.m_fStarted + "', closed='" + this.m_fClosed + "', sessions=[" + this.getSessionConfigurations().map(s -> "{name='" + s.getName() + "', scope='" + s.getScopeName() + "'}").collect(Collectors.joining(",")) + "]}";
    }

    private boolean isDefaultInstance() {
        return "".equals(this.f_sName);
    }

    private void assertNotClosed() {
        if (this.m_fClosed) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " instance has been closed");
        }
    }

    private Optional<Session> getSessionInternal(String sName) {
        SessionConfiguration configuration;
        String sSessionName;
        if ("$SYS".equals(sName)) {
            return Optional.ofNullable(this.initializeSystemSession(Collections.emptyList()));
        }
        String string = sSessionName = sName == null ? "" : sName;
        if ("".equals(sSessionName)) {
            sSessionName = this.f_config.getDefaultSessionName();
        }
        if ((configuration = this.getSessionConfiguration(sSessionName)) == null || !configuration.isEnabled()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.f_mapSession.get(sSessionName));
    }

    private synchronized void startInternal() {
        Iterable<EventInterceptor<?>> globalInterceptors = this.f_config.getInterceptors();
        Cluster cluster = CacheFactory.getCluster();
        if (s_fEnsuredCluster == null) {
            s_fEnsuredCluster = !cluster.isRunning();
        }
        this.initializeSystemSession(globalInterceptors);
        Logger.info(() -> this.isDefaultInstance() ? "Starting default Coherence instance mode=" + String.valueOf((Object)this.f_mode) : "Starting Coherence instance " + this.f_sName + " mode=" + String.valueOf((Object)this.f_mode));
        cluster.getManagement().register(this.f_health);
        try {
            this.getSessionConfigurations().sorted(Comparator.reverseOrder()).forEach(configuration -> this.startSession((SessionConfiguration)configuration, globalInterceptors));
        }
        catch (Throwable t) {
            Logger.err("Failed to start Coherence instance " + this.f_sName + " mode=" + String.valueOf((Object)this.f_mode), t);
            this.close();
        }
        if (this.f_mode.isClusterMember()) {
            Logger.info(() -> "Started Coherence server " + this.f_sName + " mode=" + String.valueOf((Object)this.f_mode) + CacheFactory.getCluster().getServiceBanner());
        } else {
            this.ensureMetrics();
            Logger.info(() -> "Started Coherence client " + this.f_sName + " mode=" + String.valueOf((Object)this.f_mode));
        }
    }

    private void startSession(SessionConfiguration configuration, Iterable<EventInterceptor<?>> globalInterceptors) {
        if (this.m_fClosed) {
            return;
        }
        if (configuration.isEnabled()) {
            String sName = configuration.getName();
            Mode mode = configuration.getMode().orElse(this.f_mode);
            if ("".equals(sName)) {
                Logger.info("Starting default Session mode=" + String.valueOf((Object)mode));
            } else {
                Logger.info("Starting Session \"" + sName + "\" mode=" + String.valueOf((Object)mode));
            }
            Iterable<? extends EventInterceptor<?>> interceptors = Coherence.join(globalInterceptors, configuration.getInterceptors());
            Optional<Session> optional = Coherence.ensureSessionInternal(configuration, this.f_mode, this.getScopePrefix(), interceptors);
            if (optional.isPresent()) {
                Session session = optional.get();
                session.activate();
                this.f_mapSession.put(sName, session);
                if (session instanceof ConfigurableCacheFactorySession) {
                    ConfigurableCacheFactorySession supplier = (ConfigurableCacheFactorySession)session;
                    ConfigurableCacheFactory ccf = supplier.getConfigurableCacheFactory();
                    if (mode.isClusterMember()) {
                        if (ccf.isActive()) {
                            DefaultCacheServer dcs = new DefaultCacheServer(ccf);
                            dcs.reportStarted(((ExtensibleConfigurableCacheFactory)ccf).getServiceMap().keySet());
                        } else {
                            ccf.activate();
                            DefaultCacheServer dcs = this.startCCF(sName, ccf);
                            this.f_mapServer.put(sName, new PriorityHolder(configuration.getPriority(), dcs));
                        }
                    }
                }
            } else {
                Logger.warn("Skipping Session " + configuration.getName() + " Session provider returned null");
            }
        }
    }

    private SessionConfiguration getSessionConfiguration(String sName) {
        SessionConfiguration configuration = this.f_config.getSessionConfigurations().get(sName);
        if (configuration == null) {
            configuration = this.f_mapAdditionalSessionConfig.get(sName);
        }
        return configuration;
    }

    private Stream<SessionConfiguration> getSessionConfigurations() {
        return Stream.concat(this.f_config.getSessionConfigurations().values().stream(), this.f_mapAdditionalSessionConfig.values().stream());
    }

    private static Iterable<? extends EventInterceptor<?>> join(Iterable<? extends EventInterceptor<?>> one, Iterable<? extends EventInterceptor<?>> two) {
        if (one == null && two == null) {
            return Collections.emptyList();
        }
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        Stream<? extends EventInterceptor<?>> s1 = StreamSupport.stream(one.spliterator(), false);
        Stream<? extends EventInterceptor<?>> s2 = StreamSupport.stream(two.spliterator(), false);
        return Stream.concat(s1, s2).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Optional<Session> ensureSessionInternal(SessionConfiguration configuration, Mode mode, String sScopePrefix, Iterable<? extends EventInterceptor<?>> interceptors) {
        SessionProvider provider = configuration.sessionProvider().orElseGet(SessionProvider::get);
        Optional<Session> optional = provider.createSession(configuration, mode, sScopePrefix, interceptors);
        if (optional.isPresent()) {
            String sName = configuration.getName();
            if (sName == null || "".equals(sName)) {
                sName = "$Default$";
            }
            Logger.info("Created Session " + sName + " mode=" + String.valueOf((Object)configuration.getMode().orElse(mode)));
        }
        return optional;
    }

    private static void registerInterceptors(Session session, Iterable<? extends EventInterceptor<?>> interceptors) {
        InterceptorRegistry registry = session.getInterceptorRegistry();
        for (EventInterceptor<?> interceptor : interceptors) {
            registry.registerEventInterceptor(interceptor, RegistrationBehavior.FAIL);
        }
    }

    private DefaultCacheServer startCCF(String sName, ConfigurableCacheFactory ccf) {
        this.displayStartBanner(sName, ccf);
        DefaultCacheServer dcs = new DefaultCacheServer(ccf);
        dcs.startDaemon(5000L);
        return dcs;
    }

    private ServiceMonitor startSystemCCF(String sName, ExtensibleConfigurableCacheFactory ccf) {
        this.displayStartBanner(sName, ccf);
        SimpleServiceMonitor monitor = new SimpleServiceMonitor(5000L);
        monitor.setConfigurableCacheFactory(ccf);
        ccf.activate();
        monitor.registerServices(ccf.getServiceMap());
        monitor.getThread().setName(sName + ":" + monitor.getThread().getName());
        return monitor;
    }

    private void displayStartBanner(String sName, ConfigurableCacheFactory ccf) {
        String sScopeName = ccf.getScopeName();
        boolean fHasScope = sScopeName != null && !sScopeName.isEmpty();
        Logger.info(() -> (String)(sName == null || sName.isEmpty() ? "Starting default session" : "Starting session " + sName) + (String)(fHasScope ? " with scope name " + sScopeName : ""));
    }

    private void stopServer(DefaultCacheServer dcs) {
        try {
            dcs.stop();
        }
        catch (Throwable thrown) {
            Logger.err(thrown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Session initializeSystemSession(Iterable<? extends EventInterceptor<?>> interceptors) {
        fCreated = false;
        if (this.f_mode == Mode.Gar) {
            if (this.m_localSystemSession == null) {
                this.m_localSystemSessionLock.lock();
                try {
                    if (this.m_localSystemSession == null) {
                        this.createSystemSession(interceptors);
                        fCreated = true;
                    }
                }
                finally {
                    this.m_localSystemSessionLock.unlock();
                }
            }
            if (!fCreated) {
                this.m_localSystemSession.ifPresent((Consumer<ConfigurableCacheFactorySession>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$initializeSystemSession$15(java.lang.Iterable com.tangosol.internal.net.ConfigurableCacheFactorySession ), (Lcom/tangosol/internal/net/ConfigurableCacheFactorySession;)V)(interceptors));
            }
        } else {
            if (Coherence.s_systemSession == null) {
                Coherence.s_globalSystemSessionLock.lock();
                try {
                    if (Coherence.s_systemSession != null) ** GOTO lbl30
                    Coherence.s_systemSession = this.createSystemSession(interceptors);
                    Coherence.s_systemServiceMonitor = this.m_localSystemServiceMonitor;
                    fCreated = true;
                }
                finally {
                    Coherence.s_globalSystemSessionLock.unlock();
                }
            } else {
                this.m_localSystemSession = Coherence.s_systemSession;
            }
lbl30:
            // 3 sources

            if (!fCreated) {
                Coherence.s_systemSession.ifPresent((Consumer<ConfigurableCacheFactorySession>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$initializeSystemSession$16(java.lang.Iterable com.tangosol.internal.net.ConfigurableCacheFactorySession ), (Lcom/tangosol/internal/net/ConfigurableCacheFactorySession;)V)(interceptors));
            }
        }
        return this.m_localSystemSession.orElse(null);
    }

    private Optional<ConfigurableCacheFactorySession> createSystemSession(Iterable<? extends EventInterceptor<?>> interceptors) {
        SystemSessionConfiguration configuration = new SystemSessionConfiguration(this.f_mode);
        String sScopePrefix = this.getScopePrefix();
        Iterable<? extends EventInterceptor<?>> allInterceptors = Coherence.join(interceptors, configuration.getInterceptors());
        Optional<ConfigurableCacheFactorySession> optional = Coherence.ensureSessionInternal(configuration, this.f_mode, sScopePrefix, allInterceptors).map(ConfigurableCacheFactorySession.class::cast);
        if (optional.isPresent() && (Mode.ClusterMember == this.f_mode || Mode.Gar == this.f_mode)) {
            ConfigurableCacheFactorySession session = optional.get();
            ExtensibleConfigurableCacheFactory ccfSystem = (ExtensibleConfigurableCacheFactory)session.getConfigurableCacheFactory();
            this.m_localSystemServiceMonitor = this.startSystemCCF(configuration.getScopeName(), ccfSystem);
            session.activate();
        }
        this.registerHealthChecks();
        this.m_localSystemSessionConfig = configuration;
        this.m_localSystemSession = optional;
        return optional;
    }

    static void setSystemSession(Optional<ConfigurableCacheFactorySession> optional) {
        s_systemSession = Objects.requireNonNull(optional);
    }

    private void registerHealthChecks() {
        ServiceLoader<HealthCheck> loader = ServiceLoader.load(HealthCheck.class);
        Registry registry = this.getCluster().getManagement();
        for (HealthCheck healthCheck : loader) {
            Logger.info("Registering discovered HealthCheck: " + healthCheck.getName());
            registry.register(healthCheck);
        }
    }

    private void ensureMetrics() {
        if (this.f_mode.isClusterMember()) {
            return;
        }
        if (this.m_metricsMonitor == null) {
            this.f_lockMetrics.lock();
            try {
                if (this.m_metricsMonitor == null) {
                    HashMap<Service, String> mapService = new HashMap<Service, String>();
                    MetricsHttpHelper.ensureMetricsService(mapService);
                    MetricsServiceMonitor monitor = new MetricsServiceMonitor();
                    monitor.registerServices(mapService);
                    monitor.start();
                    this.m_metricsMonitor = monitor;
                }
            }
            finally {
                this.f_lockMetrics.unlock();
            }
        }
    }

    private void stopMetrics() {
        if (this.f_mode.isClusterMember()) {
            return;
        }
        if (this.m_metricsMonitor != null) {
            this.f_lockMetrics.lock();
            try {
                if (this.m_metricsMonitor != null) {
                    this.m_metricsMonitor.unregisterAll();
                    this.m_metricsMonitor = null;
                }
            }
            finally {
                this.f_lockMetrics.unlock();
            }
        }
    }

    private static void validate(CoherenceConfiguration configuration) {
        Collection<SessionConfiguration> sessions = configuration.getSessionConfigurations().values();
        HashSet<String> setName = new HashSet<String>();
        for (SessionConfiguration sessionConfiguration : sessions) {
            Coherence.validate(sessionConfiguration);
            String sName = sessionConfiguration.getName();
            if (setName.add(sName)) continue;
            throw new IllegalStateException("A Session with the name '" + sName + "' already exists in this Coherence configuration");
        }
    }

    private static void validate(SessionConfiguration configuration) {
        String sName = configuration.getName();
        if (sName == null) {
            throw new IllegalArgumentException("A session configuration must provide a non-null name");
        }
    }

    private String getScopePrefix() {
        if (this.f_mode == Mode.Gar) {
            return this.f_config.getApplicationContext().map(a -> {
                String sScope = a.getDefaultScope();
                return ServiceScheme.getScopePrefix(sScope, a.getContainerContext());
            }).orElse(this.getName());
        }
        return "";
    }

    private static /* synthetic */ void lambda$initializeSystemSession$16(Iterable interceptors, ConfigurableCacheFactorySession session) {
        Coherence.registerInterceptors(session, interceptors);
    }

    private static /* synthetic */ void lambda$initializeSystemSession$15(Iterable interceptors, ConfigurableCacheFactorySession session) {
        Coherence.registerInterceptors(session, interceptors);
    }

    static {
        s_fEnsuredCluster = null;
    }

    public static enum Mode {
        Client("remote", false),
        ClientFixed("remote-fixed", false),
        ClusterMember("direct", true),
        Grpc("grpc", false),
        GrpcFixed("grpc-fixed", false),
        Gar("direct", true);

        private final String f_sClient;
        private final boolean f_fClusterMember;

        private Mode(String sClient, boolean fClusterMember) {
            this.f_sClient = sClient;
            this.f_fClusterMember = fClusterMember;
        }

        public String getClient() {
            return this.f_sClient;
        }

        public boolean isClusterMember() {
            return this.f_fClusterMember;
        }

        public static Mode fromClientName(String sClient) {
            for (Mode mode : Mode.values()) {
                if (!mode.getClient().equals(sClient)) continue;
                return mode;
            }
            throw new IllegalArgumentException("No Mode exists with a client name \"" + sClient + "\"");
        }
    }

    private class CoherenceHealth
    implements HealthCheck {
        private CoherenceHealth() {
        }

        @Override
        public String getName() {
            if (Coherence.this.isDefaultInstance()) {
                return "Default";
            }
            return Coherence.this.getName();
        }

        @Override
        public boolean isMemberHealthCheck() {
            return true;
        }

        @Override
        public boolean isReady() {
            return Coherence.this.isStarted();
        }

        @Override
        public boolean isLive() {
            return Coherence.this.isStarted();
        }

        @Override
        public boolean isStarted() {
            return Coherence.this.isStarted();
        }

        @Override
        public boolean isSafe() {
            return Coherence.this.isStarted();
        }
    }

    public static interface LifecycleListener
    extends EventDispatcherAwareInterceptor<CoherenceLifecycleEvent> {
        @Override
        public void onEvent(CoherenceLifecycleEvent var1);

        @Override
        default public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
            if (dispatcher instanceof CoherenceDispatcher) {
                dispatcher.addEventInterceptor(sIdentifier, this);
            }
        }
    }

    public static class Builder {
        private final CoherenceConfiguration f_config;
        private final Mode f_mode;

        private Builder(CoherenceConfiguration config, Mode mode) {
            this.f_config = config;
            this.f_mode = mode == null ? Mode.ClusterMember : mode;
        }

        public Coherence build() {
            return this.build(null);
        }

        public Coherence build(ClassLoader loader) {
            Coherence.validate(this.f_config);
            return this.build(loader, false);
        }

        protected Coherence build(boolean fAllowDuplicate) {
            return this.build(null, fAllowDuplicate);
        }

        protected Coherence build(ClassLoader loader, boolean fAllowDuplicate) {
            Coherence coherence = new Coherence(this.f_config, this.f_mode);
            Map<String, Coherence> map = Coherence.ensureInstanceMap(loader);
            Coherence prev = map.putIfAbsent(this.f_config.getName(), coherence);
            if (prev != null) {
                if (!fAllowDuplicate) {
                    throw new IllegalStateException("A Coherence instance with the name " + this.f_config.getName() + " already exists");
                }
                return prev;
            }
            return coherence;
        }
    }

    private static class PriorityHolder
    implements Comparable<PriorityHolder> {
        private final int f_nPriority;
        private final DefaultCacheServer f_server;

        public PriorityHolder(int nPriority, DefaultCacheServer server) {
            this.f_nPriority = nPriority;
            this.f_server = server;
        }

        public int getPriority() {
            return this.f_nPriority;
        }

        public DefaultCacheServer getServer() {
            return this.f_server;
        }

        @Override
        public int compareTo(PriorityHolder o) {
            return Integer.compare(this.f_nPriority, o.f_nPriority);
        }
    }

    private static class MetricsServiceMonitor
    extends SimpleServiceMonitor {
        private MetricsServiceMonitor() {
        }

        public void unregisterAll() {
            HashSet<Service> set = new HashSet<Service>(this.m_mapServices.keySet());
            this.unregisterServices(set);
        }
    }
}

