/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.internal.util.DistributedAsyncNamedCache;
import com.tangosol.internal.util.VersionHelper;
import com.tangosol.internal.util.processor.CacheProcessors;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface AsyncNamedCache<K, V>
extends AsyncNamedMap<K, V> {
    public NamedCache<K, V> getNamedCache();

    default public CompletableFuture<Void> put(K key, V value, long cMillis) {
        return this.invoke(key, CacheProcessors.put(value, cMillis));
    }

    default public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> map, long cMillis) {
        if (this.getNamedCache().getCacheService().isVersionCompatible(DistributedAsyncNamedCache.IS_BINARY_PROCESSOR_COMPATIBLE)) {
            return this.invokeAll(map.keySet(), CacheProcessors.putAll(map, cMillis)).thenAccept(nil -> {});
        }
        CacheService service = this.getNamedCache().getService();
        int nVersion = service.getMinimumServiceVersion();
        throw new UnsupportedOperationException("the whole cluster is not running a compatible version to execute this method (version=\"" + VersionHelper.toVersionString(nVersion, true) + "\" encoded=" + nVersion + ")");
    }
}

